/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PpmModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.ui.EqTypeListCellRenderer;
import cerent.cms.ui.MutablePortsPane;
import cerent.cms.ui.helper.PluggableHelper;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.GridBagPanel;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class MutablePortCreationDialog
extends UDialog
implements ActionListener {
    public static final String TITLE = "Create Port";
    private JButton okButton;
    private JButton cancelButton;
    protected JComboBox portNumCB;
    protected JComboBox portTypeCB;
    protected IPortContainer[] containers;
    private static final SDebug db = new SDebug("MutablePortCreationDialog");
    static /* synthetic */ Class class$cerent$cms$ui$MutablePortCreationDialog;

    public static MutablePortCreationDialog instance(MutablePortsPane mutablePortsPane, IPortContainer[] iPortContainerArray) {
        Frame frame = JOptionPane.getFrameForComponent((Component)((Object)mutablePortsPane));
        MutablePortCreationDialog mutablePortCreationDialog = (MutablePortCreationDialog)MutablePortCreationDialog.getRecycledDialog((Frame)frame, (String)TITLE, (Class)(class$cerent$cms$ui$MutablePortCreationDialog == null ? (class$cerent$cms$ui$MutablePortCreationDialog = MutablePortCreationDialog.class$("cerent.cms.ui.MutablePortCreationDialog")) : class$cerent$cms$ui$MutablePortCreationDialog), (Object)iPortContainerArray);
        if (mutablePortCreationDialog == null) {
            mutablePortCreationDialog = new MutablePortCreationDialog(frame, iPortContainerArray);
        }
        return mutablePortCreationDialog;
    }

    private MutablePortCreationDialog(Frame frame, Object object) {
        super(frame, TITLE, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        Object[] objectArray = (Object[])object;
        this.containers = (IPortContainer[])objectArray;
        jPanel.add((Component)this.getCreatePanel(), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
    }

    public void dispose() {
        this.containers = null;
        super.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            try {
                this.apply();
                this.dispose();
            }
            catch (Exception exception) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_CHANGES, exception.toString());
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else if (object == this.portNumCB) {
            this.portTypeCB.setEnabled(false);
            this.portTypeCB.removeAllItems();
            PortId portId = (PortId)this.portNumCB.getSelectedItem();
            Iterator iterator = this.getPortTypeList(portId.getContainer(), portId.getPortPosInParent()).iterator();
            while (iterator.hasNext()) {
                this.portTypeCB.addItem(iterator.next());
            }
            this.portTypeCB.setEnabled(true);
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    protected void apply() throws Exception {
        this.applyChangesToModel();
    }

    private JPanel getCreatePanel() {
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.fillHorizontal();
        if (this.containers != null) {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            for (int i = 0; i < this.containers.length; ++i) {
                arrayList.addAll(this.getAvailablePorts(this.containers[i]));
            }
            PortId[] portIdArray = arrayList.toArray(new PortId[arrayList.size()]);
            Arrays.sort(portIdArray, new PortIdComparator());
            this.portNumCB = new JComboBox<PortId>(portIdArray);
            PortId portId = (PortId)this.portNumCB.getSelectedItem();
            this.portTypeCB = this.getPortTypeCB(portId.getContainer(), portId.getPortPosInParent());
            this.portNumCB.addActionListener(this);
        }
        gridBagPanel.add("Port", 0, 0);
        gridBagPanel.add((Component)this.portNumCB, 1, 0);
        gridBagPanel.add("Port Type ", 0, 1);
        gridBagPanel.add((Component)this.portTypeCB, 1, 1);
        return gridBagPanel;
    }

    private JComboBox getPortTypeCB(IPortContainer iPortContainer, int n) {
        JComboBox jComboBox = null;
        ArrayList arrayList = this.getPortTypeList(iPortContainer, n);
        jComboBox = new JComboBox(arrayList.toArray((T[])new eEqType[arrayList.size()][2]));
        jComboBox.setRenderer(new EqTypeListCellRenderer((NodeModelDelegate)iPortContainer.getNodeModel()));
        return jComboBox;
    }

    private ArrayList getPortTypeList(IPortContainer iPortContainer, int n) {
        ArrayList<eEqType[]> arrayList;
        block5: {
            eEqType eEqType2 = ((ModuleModel)iPortContainer.getModuleModel()).getEqTypeEnum();
            arrayList = new ArrayList<eEqType[]>();
            try {
                eEqType[] eEqTypeArray = iPortContainer.getPortTypeList(n);
                if (eEqTypeArray == null || eEqTypeArray.length == 0) {
                    arrayList.add(new eEqType[]{eEqType.INVALID, eEqType2});
                } else {
                    for (int i = 0; i < eEqTypeArray.length; ++i) {
                        arrayList.add(new eEqType[]{eEqTypeArray[i], eEqType2});
                    }
                }
            }
            catch (Exception exception) {
                db.fine("Exception while calling getPortTypeList()");
                if (!db.on()) break block5;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return arrayList;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    private List getAvailablePorts(IPortContainer iPortContainer) {
        List list = iPortContainer.getAvailablePortNumbers();
        ArrayList<PortId> arrayList = new ArrayList<PortId>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = iPortContainer instanceof PpmModel ? PluggableHelper.getHierarchyNumString(((PpmModel)iPortContainer).getHierarchyNums(), '-') + '-' : "";
            arrayList.add(new PortId(iPortContainer, string + iterator.next().toString()));
        }
        return arrayList;
    }

    public void applyChangesToModel() {
        Object object = this.portTypeCB.getSelectedItem();
        PortId portId = (PortId)this.portNumCB.getSelectedItem();
        IPortContainer iPortContainer = portId.getContainer();
        int n = portId.getPortPosInParent();
        db.fine("applyChangesToModel, FOUND port = " + n);
        EntityTableModel entityTableModel = ((NodeModelDelegate)iPortContainer.getNodeModel()).getEntityTableModel();
        try {
            if (object instanceof eEqType) {
                if (((eEqType)object).equals(eEqType.INVALID)) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_APPLY_CHANGES);
                } else {
                    entityTableModel.provisionPort(iPortContainer, n, (eEqType)object);
                }
            } else {
                eEqType[] eEqTypeArray = (eEqType[])object;
                entityTableModel.provisionPort(iPortContainer, n, eEqTypeArray[0]);
            }
        }
        catch (ProvisionError provisionError) {
            EID eID = provisionError.getEID();
            if (eID != null) {
                ErrorMsg.displayError((Component)((Object)this), (EID)eID, (Object[])provisionError.getEIDParams());
            } else {
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_CHANGES, provisionError.getPrettyMessage());
            }
        }
        catch (ResourceInUse resourceInUse) {
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_CHANGES, resourceInUse.toString());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class PortIdComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object instanceof PortId) {
                if (object2 instanceof PortId) {
                    PortId portId = (PortId)object;
                    PortId portId2 = (PortId)object2;
                    return portId.toString().compareTo(portId2.toString());
                }
                return 1;
            }
            return -1;
        }

        public boolean equals(Object object) {
            return object instanceof PortIdComparator;
        }
    }

    private class PortId {
        private IPortContainer _container;
        private String _portNum;

        public PortId(IPortContainer iPortContainer, String string) {
            this._container = iPortContainer;
            this._portNum = string;
        }

        public String getPortNum() {
            return this._portNum;
        }

        public IPortContainer getContainer() {
            return this._container;
        }

        public String toString() {
            return this._portNum;
        }

        public int getPortPosInParent() {
            int n = this._portNum.lastIndexOf(45) + 1;
            return Integer.parseInt(this._portNum.substring(n));
        }
    }
}

