/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.model.event.IAlarmStore;
import cerent.cms.ui.SoftMaintDataSource;
import cerent.util.BuildInfo;
import cerent.util.SDebug;
import cerent.util.job.IJobProgressControl;
import cerent.util.job.JobController;
import cerent.util.job.JobStatus;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.StringHolder;

public class NodeVersionInfo
implements IJobProgressControl,
Observer {
    private static final String DOWNLOADING = "downloading";
    private static final String DOWNLOAD_IN_PROGRESS = "transfer in progress";
    private static final String UNKNOWN = " ";
    private String nodeName = " ";
    private String workingVersion = " ";
    private String protectVersion = " ";
    private String neType = " ";
    private String statusString = "";
    private String progressText = "";
    private String alarmSeverity = "";
    private SoftMaintDataSource dataSource;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy h:mm a");
    private int progressPercent = -1;
    private JobStatus jobStatus = new JobStatus();
    private boolean inProgress = false;
    private INodeModel nodeModel;
    private IAlarmStore alarmStore = null;
    private static final SDebug db = new SDebug("NodeVersionInfo");
    private JobController jc;
    private static final String[] alarmSeverities = new String[]{" ", "Minor Alarm", "Major Alarm", "Critical Alarm"};

    NodeVersionInfo(INodeModel iNodeModel, SoftMaintDataSource softMaintDataSource) {
        this.nodeModel = iNodeModel;
        this.dataSource = softMaintDataSource;
        iNodeModel.addObserver((Observer)this);
        iNodeModel.getConnectionNotifier().addObserver((Observer)this);
        new Thread(new Runnable(){

            public void run() {
                NodeVersionInfo.this.refreshData();
            }
        }).start();
    }

    private void refreshData() {
        this.receiveAlarmStoreUpdate();
        this.refreshFromModel();
        this.dataSource.update();
    }

    public String getNodeName() {
        try {
            this.nodeName = this.nodeModel.getName();
        }
        catch (Exception exception) {
            db.finer("Exception in getNodeName() " + exception);
        }
        return this.nodeName;
    }

    public String toString() {
        return this.getNodeName() + " - Working Version: " + this.workingVersion;
    }

    public JobStatus getJobStatus() {
        return this.jobStatus;
    }

    public void setJobStatus(JobStatus jobStatus) {
        if (jobStatus == null) {
            return;
        }
        this.jobStatus = jobStatus;
        if (NodeVersionInfo.db.on) {
            db.println("setJobStatus: jobStatus=" + jobStatus.getStatusString());
        }
        if (jobStatus.value() == 2 || jobStatus.value() == 3 || jobStatus.value() == 4) {
            this.setPercentCompleted(-1);
            this.setProgressText("");
            this.statusString = jobStatus.getStatusString() + " - " + this.dateFormat.format(new Date());
        } else if (jobStatus.value() == 0) {
            this.statusString = jobStatus.getStatusString();
        } else if (jobStatus.value() == 1) {
            this.statusString = this.progressPercent >= 0 && this.progressPercent <= 100 ? this.getProgressText() : jobStatus.getStatusString();
        }
        this.dataSource.update();
    }

    public String getStatusString() {
        return this.statusString;
    }

    public void setStatusString(String string) {
        if (string != null) {
            this.statusString = string;
            this.dataSource.update();
        }
    }

    public INodeModel getNodeModel() {
        return this.nodeModel;
    }

    public String getNeType() {
        return this.neType;
    }

    public String getWorkingVersion() {
        return this.workingVersion;
    }

    public String getProtectVersion() {
        return this.protectVersion;
    }

    public String getAlarmSeverityString() {
        return this.alarmSeverity;
    }

    public void setJobController(JobController jobController) {
        this.jc = jobController;
    }

    public JobController getJobController() {
        return this.jc;
    }

    public boolean canDownload() {
        return !this.inProgress && this.nodeModel.isInited() && this.jobStatus.value() != 0 && this.jobStatus.value() != 1;
    }

    private String getAlarmSeverity(IAlarmStatus iAlarmStatus) {
        return alarmSeverities[iAlarmStatus.getHighestSeverity()];
    }

    private void receiveAlarmStoreUpdate() {
        String string;
        IAlarmStore iAlarmStore;
        if (NodeVersionInfo.db.on) {
            db.println("received update from AlarmStore");
        }
        if ((iAlarmStore = this.getAlarmStore()) != null && !(string = this.getAlarmSeverity(iAlarmStore.getAlarmStatus())).equals(this.alarmSeverity)) {
            this.alarmSeverity = string;
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof ArrayList) {
            if (NodeVersionInfo.db.on) {
                db.println("received update from AlarmStatusObservable");
            }
        } else if (observable instanceof INodeModel.AbstractConnectionNotifier) {
            if (NodeVersionInfo.db.on) {
                db.println("received update from AbstractConnectionNotifier");
            }
        } else if (observable instanceof INodeModel) {
            if (object == ModelUpdateType.DELETED) {
                if (NodeVersionInfo.db.on) {
                    db.println("receive deletion update from the node");
                }
                this.dataSource.deleteNode(this);
                return;
            }
            if (NodeVersionInfo.db.on) {
                db.println("received update from the node");
            }
        } else if (NodeVersionInfo.db.on) {
            db.println("update: Observable=" + observable + " Object=" + object);
        }
        this.refreshData();
    }

    private void setDefaults() {
        if (NodeVersionInfo.db.on) {
            db.println("setDefaults: entering");
        }
        this.alarmSeverity = "Disconnected";
        this.workingVersion = UNKNOWN;
        this.protectVersion = UNKNOWN;
        if (this.jobStatus.value() != 2 && this.jobStatus.value() != 3 && this.jobStatus.value() != 4) {
            this.statusString = UNKNOWN;
        }
    }

    private void refreshFromModel() {
        if (NodeVersionInfo.db.on) {
            db.println("refreshFromModel: entering");
        }
        try {
            IAlarmStore iAlarmStore = this.getAlarmStore();
            if (iAlarmStore != null) {
                this.alarmSeverity = this.getAlarmSeverity(iAlarmStore.getAlarmStatus());
            }
            this.neType = this.nodeModel.getNeType();
            if (this.nodeModel.isInited()) {
                if (NodeVersionInfo.db.on) {
                    db.println("refreshFromModel: node=" + this.nodeModel.getHostName() + " - retrieving software version");
                }
                this.getVersions();
            } else {
                if (NodeVersionInfo.db.on) {
                    db.println("refreshFromModel: node=" + this.nodeModel.getHostName() + " - not inited");
                }
                this.setDefaults();
            }
        }
        catch (Exception exception) {
            this.setDefaults();
        }
    }

    private IAlarmStore getAlarmStore() {
        IAlarmStore iAlarmStore = null;
        if (this.nodeModel.isInited() && this.nodeModel.getConnectionState()) {
            iAlarmStore = this.nodeModel.getElementAlarmStore();
        }
        if (iAlarmStore != null) {
            if (this.alarmStore == null) {
                iAlarmStore.addObserver((Observer)this);
                this.alarmStore = iAlarmStore;
            }
        } else if (this.alarmStore != null) {
            this.alarmStore.deleteObserver((Observer)this);
            this.alarmStore = null;
        }
        return iAlarmStore;
    }

    private void getVersions() {
        try {
            StringHolder[] stringHolderArray = new StringHolder[]{new StringHolder(), new StringHolder()};
            short s = this.nodeModel.queryCodeVol(stringHolderArray[0], stringHolderArray[1]);
            if (NodeVersionInfo.db.on) {
                db.println("getVersions(): flashVol=" + s + ", flVers[0] = " + stringHolderArray[0].value + ", flVers[1] = " + stringHolderArray[1].value);
            }
            switch (s) {
                case 0: 
                case 1: {
                    this.workingVersion = BuildInfo.sanitize(stringHolderArray[s].value);
                    this.protectVersion = BuildInfo.sanitize(stringHolderArray[1 - s].value);
                    if (this.statusString.equals(DOWNLOAD_IN_PROGRESS)) {
                        this.statusString = "";
                    }
                    this.inProgress = false;
                    break;
                }
                case 2: {
                    if (this.workingVersion.equals(UNKNOWN)) {
                        String string = BuildInfo.sanitize(stringHolderArray[0].value);
                        String string2 = BuildInfo.sanitize(stringHolderArray[1].value);
                        this.workingVersion = string.equals("none") ? string2 : string;
                    }
                    this.protectVersion = UNKNOWN;
                    if (this.jobStatus.value() != 1 && this.jobStatus.value() != 0 && !this.nodeModel.getNeType().equals("15600")) {
                        this.statusString = DOWNLOAD_IN_PROGRESS;
                    }
                    this.inProgress = true;
                }
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (NodeVersionInfo.db.on) {
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
            this.workingVersion = UNKNOWN;
            this.protectVersion = UNKNOWN;
        }
    }

    public void dispose() {
        if (NodeVersionInfo.db.on) {
            db.println("disposing");
        }
        try {
            if (this.alarmStore != null) {
                this.alarmStore.deleteObserver((Observer)this);
                this.alarmStore = null;
            }
            this.nodeModel.getConnectionNotifier().deleteObserver((Observer)this);
            this.nodeModel.deleteObserver((Observer)this);
        }
        catch (Exception exception) {
            db.finest("Exception in dispose() " + exception);
        }
    }

    public void setPercentCompleted(int n) {
        if (this.progressPercent != n) {
            this.progressPercent = n;
            this.statusString = this.getProgressText();
            this.dataSource.update();
        }
    }

    private String getProgressText() {
        String string = "";
        if (this.progressPercent >= 0 && this.progressPercent <= 100) {
            string = this.progressText.length() > 0 ? this.progressPercent + "% - " + this.progressText : this.progressPercent + "% - " + DOWNLOADING;
        }
        if (db.on()) {
            db.println("GetProgressText -- percent = " + this.progressPercent + ", text = " + this.progressText);
        }
        return string;
    }

    public void setProgressText(String string) {
        this.progressText = string;
    }
}

