/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ans;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EntityModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.ParserIfName;
import cerent.cms.model.PortModel;
import cerent.cms.ui.ans.AnsCardPortRenderer;
import cerent.cms.ui.ans.AnsConnDataSource;
import cerent.cms.ui.ans.AnsConnTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class AnsPathCreateDialog
extends JDialog
implements ActionListener,
ItemListener,
Observer {
    private static final String TITLE = "Create Optical Link";
    private static final String TITLE_EDIT = "Edit Optical Link";
    public static final String OK = "OK";
    public static final String CANCEL = "Cancel";
    public static final String CHECK = "Bidirectional";
    public static final int MARGIN = 5;
    private static final String SLOT = "Slot: ";
    private static final String PORT = "Port: ";
    private static String ALL = "All";
    private static final int FROM = 0;
    private static final int TO = 1;
    private static final SDebug db = new SDebug("OnsPathCreateDialog");
    private ArrayList onsTypeList;
    private JButton okButton;
    private JButton cancelButton;
    private JCheckBox bidiCheck;
    private AnsConnTableModel dataModel;
    private NodeModelDelegate nodeModel;
    private JComboBox[] slotCB = new JComboBox[2];
    private JComboBox[] portCB = new JComboBox[2];
    private ArrayList westModelList = new ArrayList(0);
    private ArrayList eastModelList = new ArrayList(0);
    private TDMTerminology terms = null;
    private boolean isedit = false;
    private int from_edit = 0;
    private int to_edit = 0;

    public AnsPathCreateDialog(Frame frame, Model model, AnsConnTableModel ansConnTableModel) {
        super(frame, TITLE, true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AnsPathCreateDialog.this.dispose();
            }
        });
        if (!(model instanceof NodeModelDelegate)) {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_NOT_BAROLO_CARD);
            return;
        }
        this.nodeModel = (NodeModelDelegate)model;
        this.terms = this.nodeModel.getTDMTerminology();
        this.dataModel = ansConnTableModel;
        this.setSize(300, 250);
        this.initMainPane(frame);
        this.setVisible(true);
    }

    public AnsPathCreateDialog(Frame frame, Model model, AnsConnTableModel ansConnTableModel, int n, int n2) {
        super(frame, TITLE_EDIT, true);
        this.isedit = true;
        this.from_edit = n;
        this.to_edit = n2;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AnsPathCreateDialog.this.dispose();
            }
        });
        if (!(model instanceof NodeModelDelegate)) {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_NOT_BAROLO_CARD);
            return;
        }
        this.nodeModel = (NodeModelDelegate)model;
        this.terms = this.nodeModel.getTDMTerminology();
        this.dataModel = ansConnTableModel;
        this.setSize(300, 250);
        this.initMainPane(frame);
        this.initCombosEdit(n, n2);
        this.bidiCheck.setSelected(false);
        this.bidiCheck.setEnabled(false);
        this.setVisible(true);
    }

    private void initCombosEdit(int n, int n2) {
        try {
            OpticsPortModel opticsPortModel = (OpticsPortModel)this.nodeModel.getEntityTable().getEntityModelByIndex(n);
            ModuleModel moduleModel = (ModuleModel)opticsPortModel.getParent();
            this.slotCB[0].setSelectedItem(moduleModel);
            this.portCB[0].setSelectedItem(opticsPortModel);
            OpticsPortModel opticsPortModel2 = (OpticsPortModel)this.nodeModel.getEntityTable().getEntityModelByIndex(n2);
            ModuleModel moduleModel2 = (ModuleModel)opticsPortModel2.getParent();
            this.slotCB[1].setSelectedItem(moduleModel2);
            this.portCB[1].setSelectedItem(opticsPortModel2);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initMainPane(Frame frame) {
        Container container = this.getContentPane();
        container.setLayout(new GridLayout(0, 1));
        container.add(this.initCBPane(0, "From"));
        container.add(this.initCBPane(1, "To"));
        container.add(this.initButtonPanel());
        this.setLocationRelativeTo(frame);
        this.slotCB[0].setSelectedIndex(-1);
        this.slotCB[1].setSelectedIndex(-1);
        if (this.slotCB[0].getModel().getSize() > 0) {
            this.slotCB[0].setSelectedIndex(0);
        }
        if (this.slotCB[1].getModel().getSize() > 0) {
            this.slotCB[1].setSelectedIndex(0);
        }
    }

    private JPanel initCBPane(int n, String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        jPanel.add(new JLabel(SLOT));
        jPanel.add(new JLabel(PORT));
        this.findAllInterestedCards();
        this.slotCB[n] = this.initSlotCombo();
        this.slotCB[n].setRenderer(new OnsCardRenderer());
        this.slotCB[n].addItemListener(this);
        this.portCB[n] = new JComboBox();
        this.portCB[n].setRenderer(new AnsCardPortRenderer());
        this.portCB[n].setEnabled(false);
        this.portCB[n].addItemListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1));
        jPanel2.add(this.slotCB[n]);
        jPanel2.add(this.portCB[n]);
        JPanel jPanel3 = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
        jPanel3.setBorder(titledBorder);
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel, "West");
        jPanel3.add((Component)jPanel2, "Center");
        return jPanel3;
    }

    private JPanel initButtonPanel() {
        this.okButton = new JButton(OK);
        this.okButton.addActionListener(this);
        this.okButton.setEnabled(false);
        this.cancelButton = new JButton(CANCEL);
        this.cancelButton.addActionListener(this);
        this.bidiCheck = new JCheckBox(CHECK);
        this.bidiCheck.setSelected(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        jPanel.add((Component)this.bidiCheck, 0);
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    public void dispose() {
        super.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            if (this.test(false)) {
                this.apply();
                this.dispose();
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.slotCB[0]) {
            this.initLater(0);
        } else if (object == this.slotCB[1]) {
            this.initLater(1);
        } else if (object == this.portCB[0]) {
            this.initLater(1);
        }
        this.okButton.setEnabled(this.test(true));
    }

    private void initLater(int n) {
        Runnable runnable = null;
        runnable = n == 0 ? new Runnable(){

            public void run() {
                AnsPathCreateDialog.this.initPortCombo(0);
            }
        } : new Runnable(){

            public void run() {
                AnsPathCreateDialog.this.initPortCombo(1);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = (Integer)object;
            switch (n) {
                case 0: {
                    ((ModuleModel)((Object)observable)).deleteObserver(this);
                    this.slotCB[0] = this.initSlotCombo();
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    }

    private void findAllInterestedCards() {
        ModuleModel moduleModel = null;
        EntityModel entityModel = (EntityModel)this.nodeModel.getChassis();
        List list = entityModel.getChildrenOfType(eClass.BACKPLANE);
        List list2 = ((EntityModel)list.get(0)).getChildren();
        for (int i = 0; i < list2.size(); ++i) {
            int n;
            EntityModel entityModel2 = (EntityModel)list2.get(i);
            List list3 = entityModel2.getChildren();
            if (list3.size() <= 0 || (n = (moduleModel = (ModuleModel)list3.get(0)).getEqType()) < 131 || n > 138) continue;
            if (moduleModel.getSlot() <= list2.size() / 2) {
                this.westModelList.add(moduleModel);
                continue;
            }
            this.eastModelList.add(moduleModel);
        }
    }

    private JComboBox initSlotCombo() {
        JComboBox jComboBox = new JComboBox();
        EntityModel entityModel = (EntityModel)this.nodeModel.getChassis();
        List list = entityModel.getChildrenOfType(eClass.BACKPLANE);
        List list2 = ((EntityModel)list.get(0)).getChildren();
        for (int i = 0; i < list2.size(); ++i) {
            int n;
            Object e;
            EntityModel entityModel2 = (EntityModel)list2.get(i);
            List list3 = entityModel2.getChildren();
            if (list3.size() <= 0 || !((e = list3.get(0)) instanceof ModuleModel) || !this.isPatchcordCard(n = ((ModuleModel)e).getEqType())) continue;
            jComboBox.addItem(e);
        }
        return jComboBox;
    }

    private boolean isPatchcordCard(int n) {
        boolean bl = false;
        switch (n) {
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 191: 
            case 192: 
            case 196: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    private void initPortCombo(int n) {
        if (this.slotCB[n].getSelectedIndex() >= 0) {
            ModuleModel moduleModel = (ModuleModel)this.slotCB[n].getSelectedItem();
            List list = moduleModel.getChildren();
            if (this.portCB[n].getItemCount() > 0) {
                this.portCB[n].removeAllItems();
            }
            switch (n) {
                case 0: {
                    if (this.portCB[1].getItemCount() > 0) {
                        this.portCB[1].removeAllItems();
                    }
                    this.bidiCheck.setEnabled(moduleModel.getEqType() != 129);
                    this.bidiCheck.setSelected(moduleModel.getEqType() != 129);
                    for (int i = 0; i < list.size(); ++i) {
                        OpticsPortModel opticsPortModel;
                        ParserIfName parserIfName;
                        if (!(list.get(i) instanceof OpticsPortModel) || (parserIfName = new ParserIfName((opticsPortModel = (OpticsPortModel)list.get(i)).getEntityIndex())).getDirId() != 2) continue;
                        this.portCB[n].addItem(opticsPortModel);
                    }
                    break;
                }
                case 1: {
                    OpticsPortModel opticsPortModel = (OpticsPortModel)this.portCB[0].getSelectedItem();
                    if (opticsPortModel == null) {
                        return;
                    }
                    ModuleModel moduleModel2 = (ModuleModel)this.slotCB[0].getSelectedItem();
                    if (moduleModel2 != null && moduleModel2.getEqType() != 129) {
                        this.bidiCheck.setEnabled(moduleModel.getEqType() != 129);
                        this.bidiCheck.setSelected(moduleModel.getEqType() != 129);
                    }
                    ParserIfName parserIfName = new ParserIfName(opticsPortModel.getEntityIndex());
                    int n2 = parserIfName.getDirId();
                    int n3 = parserIfName.getEntityTypeVal();
                    for (int i = 0; i < list.size(); ++i) {
                        if (!(list.get(i) instanceof OpticsPortModel) || (parserIfName = new ParserIfName((opticsPortModel = (OpticsPortModel)list.get(i)).getEntityIndex())).getDirId() == n2 || parserIfName.getEntityTypeVal() != n3) continue;
                        this.portCB[n].addItem(opticsPortModel);
                    }
                    break;
                }
            }
            this.portCB[n].setEnabled(this.portCB[n].getItemCount() > 0);
            if (this.portCB[n].getItemCount() > 0) {
                this.portCB[n].setSelectedIndex(0);
            }
        }
    }

    private boolean test(boolean bl) {
        boolean bl2 = false;
        boolean[] blArray = new boolean[4];
        String string = "";
        blArray[0] = this.slotCB[0].getSelectedIndex() >= 0;
        blArray[1] = this.portCB[0].getSelectedIndex() >= 0;
        blArray[2] = this.slotCB[1].getSelectedIndex() >= 0;
        boolean bl3 = blArray[3] = this.portCB[1].getSelectedIndex() >= 0;
        if (!blArray[0] || !blArray[2]) {
            if (!bl) {
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_NOT_SELECTED_PARAM_1, (Object)"slot");
            }
            return false;
        }
        if (!blArray[1] || !blArray[3]) {
            if (!bl) {
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_NOT_SELECTED_PARAM_1, (Object)"port");
            }
            return false;
        }
        return true;
    }

    private int getBoardIndex(int n) {
        if (this.portCB[n].getSelectedItem() instanceof OpticsPortModel) {
            OpticsPortModel opticsPortModel = (OpticsPortModel)this.portCB[n].getSelectedItem();
            return opticsPortModel.getEntityIndex();
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getBidiBoardIndex(int n) throws Exception {
        int n2 = 0;
        ModuleModel moduleModel = null;
        Object object = this.portCB[n].getSelectedItem();
        if (!(object instanceof OpticsPortModel)) return n2;
        OpticsPortModel opticsPortModel = (OpticsPortModel)object;
        moduleModel = (ModuleModel)opticsPortModel.getParent();
        if (moduleModel.getEqType() == 131 || moduleModel.getEqType() == 132 || moduleModel.getEqType() == 192) {
            OpticsPortModel opticsPortModel2 = this.getNextMux(opticsPortModel);
            if (opticsPortModel2 == null) throw new Exception("");
            return opticsPortModel2.getEntityIndex();
        }
        ParserIfName parserIfName = new ParserIfName(opticsPortModel.getEntityIndex());
        return this.getIdByDir(parserIfName.getDirId(), opticsPortModel.getEntityIndex());
    }

    private int getIdByDir(int n, int n2) {
        if (n == 1) {
            ++n2;
        } else if (n == 2) {
            --n2;
        }
        return n2;
    }

    private OpticsPortModel getNextMux(OpticsPortModel opticsPortModel) {
        int[] nArray = new int[]{-1, -1};
        OpticsPortModel opticsPortModel2 = opticsPortModel;
        if (((ModuleModel)opticsPortModel2.getParent()).getEqType() == 131) {
            nArray[0] = 132;
            nArray[1] = 192;
        } else {
            nArray[0] = 131;
        }
        ArrayList<OpticsPortModel> arrayList = new ArrayList<OpticsPortModel>();
        EntityModel entityModel = (EntityModel)this.nodeModel.getChassis();
        List list = entityModel.getChildrenOfType(eClass.BACKPLANE);
        List list2 = ((EntityModel)list.get(0)).getChildren();
        for (int i = 0; i < list2.size(); ++i) {
            Object e;
            EntityModel entityModel2 = (EntityModel)list2.get(i);
            List list3 = entityModel2.getChildren();
            if (list3.size() <= 0 || !((e = list3.get(0)) instanceof ModuleModel)) continue;
            int n = ((ModuleModel)e).getEqType();
            block3: for (int j = 0; j < 2; ++j) {
                if (n != nArray[j]) continue;
                List list4 = ((ModuleModel)e).getChildren();
                Iterator iterator = list4.iterator();
                while (iterator.hasNext()) {
                    OpticsPortModel opticsPortModel3 = (OpticsPortModel)iterator.next();
                    if (opticsPortModel3.getPort() != opticsPortModel2.getPort()) continue;
                    try {
                        if (opticsPortModel3.getOpticsLineModel().getRingDirection() == opticsPortModel.getOpticsLineModel().getRingDirection()) continue;
                        arrayList.add(opticsPortModel3);
                        continue block3;
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
        if (arrayList.size() > 1 || arrayList.size() == 0) {
            return null;
        }
        return (OpticsPortModel)arrayList.get(0);
    }

    private int getMuxEntityId(OpticsPortModel opticsPortModel, EntityModel entityModel) {
        int n = ((PortModel)entityModel).getPort();
        List list = opticsPortModel.getChildren();
        if (list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                OpticsPortModel opticsPortModel2 = (OpticsPortModel)iterator.next();
                if (opticsPortModel2.getPort() != n) continue;
                return opticsPortModel2.getEntityIndex();
            }
        }
        return 0;
    }

    private boolean apply() {
        AnsConnDataSource ansConnDataSource = (AnsConnDataSource)this.dataModel.getDataSource();
        if (this.isedit) {
            ansConnDataSource.deleteLocalOptLink(this.from_edit, this.to_edit);
            ansConnDataSource.createDummyOptLink(this.getBoardIndex(1), this.getBoardIndex(0));
            return true;
        }
        ansConnDataSource.createDummyOptLink(this.getBoardIndex(1), this.getBoardIndex(0));
        if (this.bidiCheck.isSelected()) {
            try {
                ansConnDataSource.createDummyOptLink(this.getBidiBoardIndex(0), this.getBidiBoardIndex(1));
            }
            catch (Exception exception) {
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_FAIL_CREATE_BIDI_OPTICAL_LINK);
            }
        }
        return true;
    }

    private int getIfIndex(int n, int n2) {
        return n * 4096 + 1 + n2;
    }

    class OnsCardRenderer
    extends JLabel
    implements ListCellRenderer {
        public OnsCardRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ModuleModel moduleModel = (ModuleModel)object;
            try {
                this.setText(moduleModel.getSlot() + " " + EntityModel.eqType2Name(AnsPathCreateDialog.this.terms, moduleModel.getEqType()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setBackground(bl ? jList.getSelectionBackground() : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            return this;
        }
    }
}

