/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ctx;

import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds3LineUpdate;
import cerent.cms.model.Ec1LineUpdate;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.Pane;
import cerent.cms.ui.ProtCardDualPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ds1.Ds1PmPane;
import cerent.cms.ui.ds3e.Ds3ePerformancePane;
import cerent.cms.ui.ec1.Ec1PmPane;
import cerent.cms.ui.sonet.TdmPmPane;
import cerent.util.SDebug;
import java.awt.Component;

public class CtxPmPane
extends AbstractSubTabbedPane
implements ITabName {
    protected Ds123LineModel[] ds3Lines;
    protected TdmLineModel[] ec1Lines;
    protected TdmLineModel[] ocnLines;
    protected Ds123LineModel[] ds1Lines;
    private static final SDebug dbg = new SDebug("CtxPmPane");

    public CtxPmPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray, Ds123LineModel[] ds123LineModelArray2, TdmLineModel[] tdmLineModelArray, TdmLineModel[] tdmLineModelArray2) {
        super(string, tabbedView);
        this.ds1Lines = ds123LineModelArray;
        this.ds3Lines = ds123LineModelArray2;
        this.ec1Lines = tdmLineModelArray;
        this.ocnLines = tdmLineModelArray2;
        this.registerWithModel();
    }

    protected void createSubTabs() {
        if (dbg.on()) {
            dbg.info("Creating SubTabs");
        }
        this.subTabs.addTab("DS1", (Component)this.getDs1Tab(this.ds1Lines));
        this.subTabs.addTab("DS3", (Component)this.getDs3Tab(this.ds3Lines));
        this.subTabs.addTab("EC1", (Component)this.getEc1Tab(this.ec1Lines));
        this.subTabs.addTab("Optical", (Component)this.getOpticalTab(this.ocnLines));
    }

    private Pane getDs1Tab(Ds123LineModel[] ds123LineModelArray) {
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new Ds1PmPane("DS1", this.subTabs, this.ds1Lines));
    }

    private Pane getDs3Tab(Ds123LineModel[] ds123LineModelArray) {
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new Ds3ePerformancePane("DS3", this.subTabs, this.ds3Lines));
    }

    private Pane getEc1Tab(TdmLineModel[] tdmLineModelArray) {
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new Ec1PmPane("EC1", this.subTabs, this.ec1Lines));
    }

    private Pane getOpticalTab(TdmLineModel[] tdmLineModelArray) {
        return new TdmPmPane("Optical", this.subTabs, this.ocnLines);
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof Ds3LineUpdate) {
            if (dbg.on()) {
                dbg.info("Received Ds3LineUpdate..");
            }
            this.ds3Lines = (Ds123LineModel[])((Ds3LineUpdate)object).getModels();
        } else if (object instanceof Ec1LineUpdate) {
            if (dbg.on()) {
                dbg.info("Received Ec1LineUpdate...");
            }
            this.ec1Lines = (TdmLineModel[])((Ec1LineUpdate)object).getModels();
        } else if (object instanceof OcnLineUpdate) {
            if (dbg.on()) {
                dbg.info("Received OcnLineUpdate...");
            }
            this.ocnLines = (TdmLineModel[])((OcnLineUpdate)object).getModels();
        } else if (dbg.on()) {
            dbg.println("refreshMyLines received " + object);
        }
    }
}

