/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds1;

import cerent.cms.IPlatform;
import cerent.cms.model.Attribute;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds1LineModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ds1.Ds1LineTableModel;
import cerent.cms.ui.ds123.Ds123LineProvPane;
import cerent.cms.ui.ds123.Ds123LineTableModel;
import javax.swing.table.TableColumn;

public class Ds1LineProvPane
extends Ds123LineProvPane {
    public Ds1LineProvPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray, CSHelpID cSHelpID) {
        super(string, tabbedView, ds123LineModelArray, cSHelpID);
        IPlatform iPlatform = ((ModuleModel)this.getUiModel()).getNodeModelDelegate().getPlatform();
        if (!iPlatform.isDs1TimingSupported()) {
            TableColumn tableColumn = this.table.getColumn(Ds1LineTableModel.ds1ColumnNames[14]);
            this.table.removeColumn(tableColumn);
            tableColumn = this.table.getColumn(Ds1LineTableModel.ds1ColumnNames[15]);
            this.table.removeColumn(tableColumn);
            tableColumn = this.table.getColumn(Ds1LineTableModel.ds1ColumnNames[16]);
            this.table.removeColumn(tableColumn);
            tableColumn = this.table.getColumn(Ds1LineTableModel.ds1ColumnNames[17]);
            this.table.removeColumn(tableColumn);
        }
    }

    protected Ds123LineTableModel getDataModel(Ds123LineModel[] ds123LineModelArray) {
        return new Ds1LineTableModel(this.node, ds123LineModelArray);
    }

    protected Attribute[] getAttributeArray(Class clazz) {
        return this.getAttributeMap().getAttributeArray("DS1_LINE_CARD." + clazz.getName());
    }

    protected Attribute[] getAttributeArray(String string) {
        return this.getAttributeMap().getAttributeArray("DS1_LINE_CARD." + string);
    }

    protected void applyToLine(int n) throws Exception {
        super.applyToLine(n);
        if (this.dataModel.isDirty(n, 15) || this.dataModel.isDirty(n, 16)) {
            ((Ds1LineModel)this.lineModels[n]).setSyncConfig(((Ds1LineTableModel)this.dataModel).getSyncConfig(n));
        }
        if (this.dataModel.isDirty(n, 17)) {
            ((Ds1LineModel)this.lineModels[n]).setDs1RetimingEnabled(((Ds1LineTableModel)this.dataModel).getRetimingEnabled(n));
        }
    }

    protected boolean needToRemoveAutoProvision() {
        return !this.pci.supportsDs1AutoProvision();
    }

    protected boolean needToRemoveDetectedLineType() {
        return !this.pci.supportsDs1DetectedLineType();
    }

    protected Attribute[] getDetectedAttributeArray(Class clazz) {
        return this.getAttributeMap().getAttributeArray("DS1_LINE_CARD." + clazz.getName() + ".detected");
    }

    protected Attribute[] getDetectedAttributeArray(String string) {
        return this.getAttributeMap().getAttributeArray("DS1_LINE_CARD." + string + ".detected");
    }
}

