/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.DwdmCliLineModel;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.GfpLineModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRmonModel;
import cerent.cms.model.ISupportsRMON;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.MrSlot;
import cerent.cms.model.PpmModel;
import cerent.cms.model.RmonLineUpdate;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.CardInventoryPane;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.Pane;
import cerent.cms.ui.PluggableCardTabbedView;
import cerent.cms.ui.SoakMaintenancePane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.dwdm.DwdmInfoMaintenancePane;
import cerent.cms.ui.dwdm.DwdmLineMaintenancePane;
import cerent.cms.ui.dwdm.DwdmPerfPane;
import cerent.cms.ui.dwdm.DwdmProvPane;
import cerent.cms.ui.dwdm.NxpAlsPane;
import cerent.cms.ui.event.IEventPanelController;
import cerent.util.SDebug;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeMap;

public class DwdmCardTabbedView
extends PluggableCardTabbedView
implements ITabName {
    private Map _payloadToClientModels;
    private List _rmonModels;
    private List _gfpModels;
    private List _trunkPayloadModels;
    private DwdmTrkLineModel[] _trunkModels;

    public DwdmCardTabbedView(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        super(moduleModel, iEventPanelController, iUiToolkit);
        moduleModel.addObserver(this);
    }

    protected void init() {
        DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
        DwdmCliLineModel[] dwdmCliLineModelArray = dwdmModuleModel.getDwdmCliLineModels();
        int n = dwdmCliLineModelArray == null ? 0 : dwdmCliLineModelArray.length;
        this._payloadToClientModels = Collections.synchronizedMap(new TreeMap());
        this._interfaceContainers = Collections.synchronizedMap(new TreeMap());
        for (int i = 0; i < n; ++i) {
            InterfaceModel interfaceModel = dwdmCliLineModelArray[i].getPayloadModel();
            if (interfaceModel != null) {
                this.getOM().addObservable((Observable)((Object)interfaceModel));
                this._payloadToClientModels.put(interfaceModel, dwdmCliLineModelArray[i]);
                this.addContainerMap(interfaceModel);
                continue;
            }
            db.println("Payload cannot be determined from Client!!");
            if (!db.on()) continue;
            SDebug.printStackTrace((Throwable)new Exception());
        }
        GfpLineModel[] gfpLineModelArray = dwdmModuleModel.getGfpLineModels();
        this._gfpModels = new ArrayList<GfpLineModel>(Arrays.asList(gfpLineModelArray));
        this.getOM().addObservable((Observable[])gfpLineModelArray);
        this._rmonModels = new ArrayList<IRmonModel>(Arrays.asList(dwdmModuleModel.getRmonModels()));
        this._trunkModels = dwdmModuleModel.getDwdmTrkLineModels();
        this.getOM().addObservable((Observable[])this._trunkModels);
        int n2 = this._trunkModels == null ? 0 : this._trunkModels.length;
        this._trunkPayloadModels = new ArrayList();
        for (int i = 0; i < n2; ++i) {
            InterfaceModel interfaceModel = this._trunkModels[i].getPayloadModel();
            if (interfaceModel != null) {
                this.getOM().addObservable((Observable)((Object)interfaceModel));
                this._trunkPayloadModels.add(interfaceModel);
                continue;
            }
            db.println("Payload cannot be determined from Trunk!!");
            if (!db.on()) continue;
            SDebug.printStackTrace((Throwable)new Exception());
        }
        this.getOM().addObservable((Observable)((Object)dwdmModuleModel.getMrSlot()));
        if (db.on()) {
            db.println("<init> found clientModels = " + n + "\n" + "<init> found trunkModels = " + this._trunkModels.length);
        }
        super.init();
    }

    private InterfaceModel[] getPayloadLinesArray() {
        ArrayList arrayList = new ArrayList(this._payloadToClientModels.keySet());
        arrayList.addAll(this._trunkPayloadModels);
        return arrayList.toArray(new InterfaceModel[arrayList.size()]);
    }

    private DwdmCliLineModel[] getCliLinesArray() {
        return this._payloadToClientModels.values().toArray(new DwdmCliLineModel[this._payloadToClientModels.size()]);
    }

    private GfpLineModel[] getGfpLinesArray() {
        return this._gfpModels.toArray(new GfpLineModel[this._gfpModels.size()]);
    }

    private IRmonModel[] getRmonModelsArray() {
        return this._rmonModels.toArray(new IRmonModel[this._rmonModels.size()]);
    }

    protected List addModel(Observable observable) {
        IRmonModel[] iRmonModelArray;
        Object object;
        DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
        List list = super.addModel(observable);
        IPortContainer iPortContainer = null;
        InterfaceModel interfaceModel = null;
        Object object2 = null;
        boolean bl = false;
        int n = 0;
        if (observable instanceof DwdmModuleModel) {
            object = dwdmModuleModel.getDwdmCliLineModels();
            int n2 = n = object == null ? 0 : ((DwdmCliLineModel[])object).length;
            if (n > this._payloadToClientModels.size()) {
                for (int i = 0; i < n; ++i) {
                    if (!this._payloadToClientModels.containsValue(object[i])) {
                        object2 = object[i];
                        if (db.on()) {
                            db.println("Found new client = " + object2);
                        }
                        interfaceModel = ((AbstractDwdmLineModel)object2).getPayloadModel();
                        if (db.on()) {
                            db.println("Found payload = " + interfaceModel);
                        }
                        if (interfaceModel != null) {
                            try {
                                IPortModel iPortModel = interfaceModel.getPortModel();
                                IEntityModel iEntityModel = iPortModel.getParent();
                                if (iEntityModel instanceof IPortContainer) {
                                    iPortContainer = (IPortContainer)iEntityModel;
                                    if (db.on()) {
                                        db.println("Found pc = " + iPortContainer);
                                    }
                                    bl = true;
                                    this.getOM().addObservable((Observable)((Object)interfaceModel));
                                    this._payloadToClientModels.put(interfaceModel, object2);
                                    this.addContainerMap(interfaceModel, iPortContainer);
                                    continue;
                                }
                                if (!db.on()) continue;
                                db.println("PortModel is " + iPortModel);
                                db.println("EntityModel is not a PortContainer! Found " + iEntityModel);
                            }
                            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                                db.println("Caught NoSuchEntity in addModel!");
                                if (!db.on()) continue;
                                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                            }
                            continue;
                        }
                        if (!db.on()) continue;
                        db.println("Payload not found");
                        continue;
                    }
                    if (!db.on()) continue;
                    db.println("Found known client");
                }
            }
        } else if (observable instanceof PpmModel || observable instanceof MrSlot) {
            iPortContainer = (IPortContainer)((Object)observable);
            if (db.on()) {
                db.println("Found pc = " + iPortContainer);
            }
            object = iPortContainer.getContainedPorts().iterator();
            while (object.hasNext()) {
                interfaceModel = (InterfaceModel)((IPortModel)object.next()).getInterfaceModel();
                if (interfaceModel != null && !this._payloadToClientModels.containsKey(interfaceModel)) {
                    InterfaceModel[] interfaceModelArray;
                    if (db.on()) {
                        db.println("Found new payload = " + interfaceModel);
                    }
                    if ((interfaceModelArray = interfaceModel.getLowerLayerModels()).length > 0 && interfaceModelArray[0] instanceof DwdmCliLineModel) {
                        object2 = (DwdmCliLineModel)interfaceModelArray[0];
                        if (db.on()) {
                            db.println("Found client = " + object2);
                        }
                        bl = true;
                        this.getOM().addObservable((Observable)((Object)interfaceModel));
                        this._payloadToClientModels.put(interfaceModel, object2);
                        this.addContainerMap(interfaceModel, iPortContainer);
                        continue;
                    }
                    if (!db.on()) continue;
                    db.println("No client for payload yet");
                    continue;
                }
                if (!db.on()) continue;
                db.println("Found known (or null) client payload");
            }
        } else if (observable instanceof DwdmTrkLineModel) {
            object = ((DwdmTrkLineModel)((Object)observable)).getPayloadModel();
            if (object != null) {
                bl = true;
                this.getOM().addObservable((Observable)object);
                this._trunkPayloadModels.add(object);
                if (db.on()) {
                    db.println("Found trunk payload for " + observable);
                }
            } else if (db.on()) {
                db.println("Found known (or null) Trunk payload.");
            }
        }
        if (bl) {
            if (DwdmCardTabbedView.db.on) {
                db.println("Sending DwdmLineUpdate...");
            }
            list.add(new DwdmLineUpdate(this.getCliLinesArray(), this.getPayloadLinesArray(), this._trunkModels, iPortContainer));
        }
        int n3 = n = (object = dwdmModuleModel.getGfpLineModels()) == null ? 0 : ((Object)object).length;
        if (n > this._gfpModels.size()) {
            this._gfpModels = new ArrayList(Arrays.asList(object));
            this.getOM().addObservable((Observable[])object);
            if (DwdmCardTabbedView.db.on) {
                db.println("gfpModel.size = " + this._gfpModels.size());
            }
        }
        int n4 = n = (iRmonModelArray = dwdmModuleModel.getRmonModels()) == null ? 0 : iRmonModelArray.length;
        if (n > this._rmonModels.size()) {
            this._rmonModels = new ArrayList<IRmonModel>(Arrays.asList(iRmonModelArray));
            list.add(new RmonLineUpdate(iRmonModelArray));
            if (DwdmCardTabbedView.db.on) {
                db.println("rmonModels.size = " + this._rmonModels.size());
            }
        }
        return list;
    }

    protected List removeModel(Observable observable) {
        List list = super.removeModel(observable);
        IPortContainer iPortContainer = null;
        this.getOM().removeObservable(observable);
        if (observable instanceof InterfaceModel) {
            iPortContainer = (IPortContainer)this.removeContainerMap((IInterfaceModel)observable);
            this._gfpModels.remove(observable);
            this._trunkPayloadModels.remove(observable);
        }
        if (iPortContainer != null) {
            this._payloadToClientModels.remove(observable);
            list.add(new DwdmLineUpdate(this.getCliLinesArray(), this.getPayloadLinesArray(), this._trunkModels, iPortContainer));
        }
        if (observable instanceof ISupportsRMON) {
            this._rmonModels.remove(((ISupportsRMON)((Object)observable)).getRmonModel());
            list.add(new RmonLineUpdate(this.getRmonModelsArray()));
        }
        return list;
    }

    public void showTabs() {
        this.addTab("Alarms", (Component)this.getAlarmTab());
        this.addTab("Conditions", (Component)this.getConditionsTab());
        this.addTab("History", (Component)this.getEventTab());
        this.addTab("Provisioning", (Component)this.getProvTab());
        this.addTab("Maintenance", (Component)this.getMaintenanceTab());
        this.addTab("Performance", (Component)this.getPerformanceTab());
    }

    public Pane getMaintenanceTab() {
        return new AbstractSubTabbedPane("Maintenance", (TabbedView)this){

            public void createSubTabs() {
                DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
                DwdmCliLineModel[] dwdmCliLineModelArray = DwdmCardTabbedView.this.getCliLinesArray();
                int n = dwdmCliLineModelArray.length;
                int n2 = DwdmCardTabbedView.this._trunkModels.length;
                InterfaceModel[] interfaceModelArray = new AbstractDwdmLineModel[n + n2];
                System.arraycopy(dwdmCliLineModelArray, 0, interfaceModelArray, 0, n);
                System.arraycopy(DwdmCardTabbedView.this._trunkModels, 0, interfaceModelArray, n, n2);
                this.subTabs.addTab("Loopback", (Component)((Object)new DwdmLineMaintenancePane("Loopback", this.subTabs, (AbstractDwdmLineModel[])interfaceModelArray)));
                this.subTabs.addTab("ALS", (Component)((Object)new NxpAlsPane("ALS", this.subTabs, interfaceModelArray)));
                this.subTabs.addTab("Info", (Component)((Object)new DwdmInfoMaintenancePane("Info", this.subTabs)));
                this.subTabs.addTab("AINS Soak", (Component)this.getSoakPane(DwdmModuleModel.getTdmDwdmLineModels((AbstractDwdmLineModel[])interfaceModelArray), !dwdmModuleModel.isMxpMr25G()));
                this.subTabs.addTab("Protection", (Component)CardTabbedView.getProtectionPane(this.subTabs));
            }

            private Pane getSoakPane(AbstractDwdmLineModel[] abstractDwdmLineModelArray, boolean bl) {
                return new SoakMaintenancePane(this, "AINS Soak", this.subTabs, abstractDwdmLineModelArray, bl){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    protected void refreshMyLines(Object object) {
                        if (object instanceof DwdmLineUpdate) {
                            this.dataModel.refreshMyLines(((DwdmLineUpdate)object).getTdmDwdmLineModels());
                        }
                    }
                };
            }
        };
    }

    public Pane getPerformanceTab() {
        return new DwdmPerfPane("Performance", this);
    }

    public Pane getProvTab() {
        return new DwdmProvPane("Provisioning", this);
    }

    public Pane getInventoryTab() {
        return new CardInventoryPane("Inventory", this);
    }

    public void destroy() {
        this._payloadToClientModels.clear();
        this._gfpModels.clear();
        this._rmonModels.clear();
        this.getUiModel().deleteObserver((Observer)this);
        this._trunkModels = null;
        super.destroy();
    }
}

