/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Dwdm.sOpticsPmStats;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.IOpticsPmModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NoSuchSampleIndex;
import cerent.cms.model.NoSuchStatsId;
import cerent.cms.model.NoSuchStatsSeries;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmRendererOpticStat;
import cerent.cms.ui.dwdm.OpticsPmHistPane;
import cerent.cms.ui.dwdm.OpticsPmTableModel;
import cerent.util.Debug;
import cerent.util.IAsyncObserver;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.IFixedColumnsTableModel;
import cerent.util.job.JobStatus;
import java.awt.Component;
import java.awt.Frame;

public class OpticsPmHistTableModel
extends OpticsPmTableModel
implements IFixedColumnsTableModel,
Runnable {
    public static final int FIXED_COLUMNS = 1;
    private static final int PARM_INDEX = 0;
    private static final String[] PARM_NAMES = new String[]{"Laser Bias (Min,%)", "Laser Bias (Avg,%)", "Laser Bias (Max,%)", "RX Optical Pwr (Min,dBm)", "RX Optical Pwr (Avg,dBm)", "RX Optical Pwr (Max,dBm)", "TX Optical Pwr (Min,dBm)", "TX Optical Pwr (Avg,dBm)", "TX Optical Pwr (Max,dBm)"};
    private static final int LASER_BIAS_MIN_INDEX = 0;
    private static final int LASER_BIAS_AVG_INDEX = 1;
    private static final int LASER_BIAS_MAX_INDEX = 2;
    private static final int RX_POWER_MIN_INDEX = 3;
    private static final int RX_POWER_AVG_INDEX = 4;
    private static final int RX_POWER_MAX_INDEX = 5;
    private static final int TX_POWER_MIN_INDEX = 6;
    private static final int TX_POWER_AVG_INDEX = 7;
    private static final int TX_POWER_MAX_INDEX = 8;
    private static final int TX_POWER_START = 6;
    protected int numCols;
    protected boolean refresh;
    protected sOpticsPmStats[] lineStats;
    protected IOpticsPmModel opticsModel;
    private String[] colNames;
    private final OpticsPmHistPane parent;
    private eIntervalType intervalType = eIntervalType.INTERVAL_15_MIN;
    private IAsyncObserver jobObserver;
    private boolean jobInProgress = false;
    private ElementModelsDelegate elementModel;
    private static final Debug db = new Debug("OpticsPmHistTableModel");
    static /* synthetic */ Class class$java$lang$String;

    public OpticsPmHistTableModel(OpticsPmHistPane opticsPmHistPane, NodeModelDelegate nodeModelDelegate) {
        this.parent = opticsPmHistPane;
        this.refresh = false;
        this.colNames = nodeModelDelegate.getPlatform().getPmColumnNames();
        NodeModelDelegate nodeModelDelegate2 = (NodeModelDelegate)nodeModelDelegate.getNodeModel();
        this.elementModel = nodeModelDelegate2.getElementModelsDelegate();
    }

    public void setIntervalType(eIntervalType eIntervalType2) {
        this.intervalType = eIntervalType2;
    }

    public void refreshMyLines(IOpticsPmModel[] iOpticsPmModelArray) {
    }

    public void refresh(IOpticsPmModel iOpticsPmModel, IAsyncObserver iAsyncObserver) throws NoSuchStatsSeries, NoSuchStatsId, NoSuchInterface, NoSuchSampleIndex, InternalCommError {
        this.opticsModel = iOpticsPmModel;
        if (this.jobInProgress) {
            if (iAsyncObserver != null) {
                iAsyncObserver.asyncUpdate(null, null);
            }
        } else {
            this.jobInProgress = true;
            this.jobObserver = iAsyncObserver;
            new Thread((Runnable)this, "OpticsPmHistTableModel retrieve PM").start();
        }
    }

    public void clear(IOpticsPmModel iOpticsPmModel, IAsyncObserver iAsyncObserver) throws Exception {
        if (CerentDialog.yesNoDialog((Component)this.getFrame(), (String)("Proceeding will clear these statistics on the card\nand cannot be undone. Do you really want to initialize\nall " + (this.intervalType.value() == 0 ? "15-minute" : (this.intervalType.value() == 1 ? "1-day" : "!ERROR!")) + " registers in the Curr column to zero?"), (String)"Zero Data")) {
            try {
                iOpticsPmModel.clearOpticsStats(this.intervalType);
                this.refresh(iOpticsPmModel, iAsyncObserver);
            }
            catch (NoSuchInterface noSuchInterface) {
                throw noSuchInterface;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                throw wrongInterfaceType;
            }
            catch (InternalCommError internalCommError) {
                throw internalCommError;
            }
            catch (NoSuchStatsSeries noSuchStatsSeries) {
                throw noSuchStatsSeries;
            }
            catch (NoSuchStatsId noSuchStatsId) {
                throw noSuchStatsId;
            }
            catch (NoSuchSampleIndex noSuchSampleIndex) {
                throw noSuchSampleIndex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.refresh = false;
        try {
            try {
                this.refreshStats();
                this.refresh = true;
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("Caught " + exception + " in refreshNow!");
                    Debug.printStackTrace((Throwable)exception);
                }
                Object var3_2 = null;
                this.refreshCols();
                this.jobInProgress = false;
                if (this.jobObserver == null) return;
                this.jobObserver.asyncUpdate(null, JobStatus.JOB_COMPLETE);
                this.jobObserver = null;
                return;
            }
            Object var3_1 = null;
            this.refreshCols();
            this.jobInProgress = false;
            if (this.jobObserver == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.refreshCols();
            this.jobInProgress = false;
            if (this.jobObserver == null) throw throwable;
            this.jobObserver.asyncUpdate(null, JobStatus.JOB_COMPLETE);
            this.jobObserver = null;
            throw throwable;
        }
        this.jobObserver.asyncUpdate(null, JobStatus.JOB_COMPLETE);
        this.jobObserver = null;
    }

    protected void updateRetrieveLabel(String string) {
        if (this.jobObserver != null) {
            this.jobObserver.asyncUpdate((Object)string, new JobStatus(1));
        }
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return PARM_NAMES[n];
        }
        if (!this.opticsModel.supportsTxPower() && n >= 6) {
            return "N/A";
        }
        if (this.refresh && n2 < this.lineStats.length + 1) {
            return this.getStats(n2 - 1, n);
        }
        return "";
    }

    private Object getStats(int n, int n2) {
        if (this.lineStats[n] != null) {
            switch (n2) {
                case 0: {
                    return new PmRendererOpticStat(1, this.lineStats[n].laserBias.min);
                }
                case 1: {
                    return new PmRendererOpticStat(1, this.lineStats[n].laserBias.avg);
                }
                case 2: {
                    return new PmRendererOpticStat(1, this.lineStats[n].laserBias.max);
                }
                case 3: {
                    return new PmRendererOpticStat(0, this.lineStats[n].rxPower.min);
                }
                case 4: {
                    return new PmRendererOpticStat(0, this.lineStats[n].rxPower.avg);
                }
                case 5: {
                    return new PmRendererOpticStat(0, this.lineStats[n].rxPower.max);
                }
                case 6: {
                    return new PmRendererOpticStat(0, this.lineStats[n].txPower.min);
                }
                case 7: {
                    return new PmRendererOpticStat(0, this.lineStats[n].txPower.avg);
                }
                case 8: {
                    return new PmRendererOpticStat(0, this.lineStats[n].txPower.max);
                }
            }
            db.println("WARNING: PmLayerDwdmOptics.getPmValue needs updating, unknown value " + n2);
        }
        return null;
    }

    public void refreshCols() {
        this.setDisplayCols();
        this.fireTableStructureChanged();
        this.parent.fixedUpColumn();
    }

    protected void refreshStats() throws NoSuchStatsSeries, NoSuchStatsId, NoSuchInterface, WrongInterfaceType, NoSuchSampleIndex, InternalCommError {
        this.numCols = this.getStatsColCount(this.opticsModel);
        this.setDisplayCols();
        this.lineStats = new sOpticsPmStats[this.numCols];
        for (int i = 0; i < this.numCols; ++i) {
            this.updateRetrieveLabel("data for interval " + this.getColumnName(i + 1));
            this.lineStats[i] = this.opticsModel.getOpticsStats(this.intervalType, (short)i);
        }
    }

    private void setDisplayCols() {
        this.numCols = this.getStatsColCount(this.opticsModel);
    }

    protected int getStatsColCount(IOpticsPmModel iOpticsPmModel) {
        switch (this.intervalType.value()) {
            case 1: {
                return 2;
            }
        }
        return 33;
    }

    public Class getColumnClass(int n) {
        return class$java$lang$String == null ? (class$java$lang$String = OpticsPmHistTableModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public int getColumnCount() {
        return 1 + this.numCols;
    }

    public String getColumnName(int n) {
        return this.colNames[n];
    }

    public int getRowCount() {
        return PARM_NAMES.length;
    }

    public int getFixedColumnCount() {
        return 1;
    }

    public void dispose() {
        this.jobInProgress = false;
    }

    private Frame getFrame() {
        return this.elementModel.getNodeModel().getUiToolkit().getApplicationFrame();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

