/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.fcmr;

import cerent.cms.model.FcmrLineModel;
import cerent.cms.model.FcmrModuleModel;
import cerent.cms.model.FcmrPortModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.CardInventoryPane;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.Pane;
import cerent.cms.ui.event.IEventPanelController;
import cerent.cms.ui.fcmr.FcmrMaintenancePane;
import cerent.cms.ui.fcmr.FcmrPmPane;
import cerent.cms.ui.fcmr.FcmrProvPane;
import java.awt.Component;

public class FcmrCardTabbedView
extends CardTabbedView {
    private FcmrPortModel[] portModels;
    private FcmrLineModel[] lineModels;

    public FcmrCardTabbedView(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        super(moduleModel, iEventPanelController, iUiToolkit);
        this.init();
    }

    public void init() {
        ModuleModel moduleModel = (ModuleModel)this.getUiModel();
        this.portModels = (FcmrPortModel[])moduleModel.getPortModels();
        this.lineModels = (FcmrLineModel[])moduleModel.getLineModels();
        this.showTabs();
    }

    public void showTabs() {
        this.addTab("Alarms", (Component)this.getAlarmTab());
        this.addTab("Conditions", (Component)this.getConditionsTab());
        this.addTab("History", (Component)this.getEventTab());
        this.addTab("Circuits", (Component)this.getCircuitTab());
        this.addTab("Provisioning", (Component)this.getProvTab());
        this.addTab("Inventory", (Component)this.getInventoryTab());
        this.addTab("Maintenance", (Component)this.getMaintenanceTab());
        this.addTab("Performance", (Component)this.getPerformanceTab());
    }

    public Pane getMaintenanceTab() {
        return new FcmrMaintenancePane("FcmrMaintPane", this, (FcmrModuleModel)this.getUiModel(), this.portModels, this.lineModels);
    }

    public Pane getPerformanceTab() {
        return new FcmrPmPane("Performance ", this, this.lineModels);
    }

    public Pane getProvTab() {
        return new FcmrProvPane("FcmrProvPane", this, (FcmrModuleModel)this.getUiModel(), this.portModels, this.lineModels);
    }

    public Pane getInventoryTab() {
        return new CardInventoryPane("Inventory", this);
    }
}

