/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.l2sc;

import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.L2scModuleModel;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.IOSConfigDialog;
import cerent.cms.ui.TabbedView;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.IOSTelnetFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CliLaunchPane
extends AbstractPane
implements ActionListener {
    private JButton openButton;
    private JButton configButton;
    private static final SDebug db = new SDebug("CliLaunchPane");

    public CliLaunchPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setLayout(new BorderLayout());
        this.add(this.getPane(), "North");
        this.add(this.getBottomPane(), "South");
        this.registerWithModel();
        this.toggleButton();
    }

    private JPanel getPane() {
        JPanel jPanel = CliLaunchPane.createVerticalPanel(null);
        this.add(jPanel);
        JLabel jLabel = new JLabel("IOS Command Line Interface (CLI) should be used for " + this.getName().toLowerCase() + " information");
        jLabel.setAlignmentX(0.5f);
        jPanel.add(jLabel);
        jPanel.add(Box.createVerticalStrut(10));
        this.openButton = new JButton("Open IOS Command Line Interface (CLI)...");
        this.openButton.addActionListener(this);
        this.openButton.setAlignmentX(0.5f);
        jPanel.add(this.openButton);
        jPanel.add(Box.createHorizontalStrut(10));
        jPanel.add(Box.createVerticalStrut(10));
        this.configButton = new JButton("IOS Startup Config...");
        this.configButton.addActionListener(this);
        this.configButton.setAlignmentX(0.5f);
        jPanel.add(this.configButton);
        jPanel.add(Box.createVerticalGlue());
        return jPanel;
    }

    private JPanel getBottomPane() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 5, 5));
        jPanel.add(new CSHelpButton(CSHelpConst.CliLaunchPane));
        return jPanel;
    }

    public void update(Observable observable, Object object) {
        this.toggleButton();
    }

    private synchronized void toggleButton() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (CliLaunchPane.this.openButton != null && (CliLaunchPane.this.getUiModel() instanceof L2scModuleModel || CliLaunchPane.this.getUiModel() instanceof ML2ModuleModel)) {
                    eEqState eEqState2 = ((ModuleModel)CliLaunchPane.this.getUiModel()).getState();
                    boolean bl = eEqState2.value() == 5 || eEqState2.value() == 4;
                    boolean bl2 = AbstractPane.isUserAuthorized(CliLaunchPane.this.getUiModel(), SecurityLevel.PROVISIONING);
                    CliLaunchPane.this.openButton.setEnabled(bl && bl2);
                    CliLaunchPane.this.configButton.setEnabled(bl2);
                }
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        IModel iModel = this.getUiModel();
        if (actionEvent.getSource() == this.openButton) {
            if (null != iModel) {
                if (iModel instanceof L2scModuleModel || iModel instanceof ML2ModuleModel) {
                    IModuleModel iModuleModel = (IModuleModel)iModel;
                    IOSTelnetFrame iOSTelnetFrame = IOSTelnetFrame.instance((IModuleModel)iModuleModel);
                    iOSTelnetFrame.pack();
                    iOSTelnetFrame.setVisible(true);
                } else {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_CARD_TYPE);
                }
            } else if (CliLaunchPane.db.on) {
                db.println("getUiModel() returned null!");
            }
        } else if (actionEvent.getSource() == this.configButton) {
            if (null != iModel) {
                if (iModel instanceof L2scModuleModel || iModel instanceof ML2ModuleModel) {
                    IModuleModel iModuleModel = (IModuleModel)iModel;
                    IOSConfigDialog iOSConfigDialog = IOSConfigDialog.instance((Component)((Object)this), iModuleModel);
                    iOSConfigDialog.pack();
                    iOSConfigDialog.setVisible(true);
                } else {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_CARD_TYPE);
                }
            } else if (CliLaunchPane.db.on) {
                db.println("getUiModel() returned null!");
            }
        }
    }

    public void leavingPage() throws Exception {
    }

    public void enteringPage() throws Exception {
    }

    public void refresh() throws Exception {
    }
}

