/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.l2sc;

import cerent.cms.model.EtherLineModel;
import cerent.cms.model.L2scModuleModel;
import cerent.cms.model.L2scPortModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.l2sc.L2scPosPortInfoTableModel;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import cerent.util.gui.UTable;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class L2scPosPortInfoPane
extends NodeProvPane
implements TableModelListener {
    private L2scPosPortInfoTableModel dataModel = null;
    private L2scPortModel[] portModels = null;
    private EtherLineModel[] lineModels = null;
    private int numLines = 0;
    private int numPorts = 0;
    private static final SDebug db = new SDebug("L2scPosPortInfoPane");

    public L2scPosPortInfoPane(String string, TabbedView tabbedView, L2scPortModel[] l2scPortModelArray, EtherLineModel[] etherLineModelArray) {
        super(string, tabbedView);
        Object var5_5 = null;
        Object var6_6 = null;
        L2scModuleModel l2scModuleModel = null;
        this.portModels = l2scPortModelArray;
        this.lineModels = etherLineModelArray;
        this.numPorts = l2scPortModelArray == null ? 0 : l2scPortModelArray.length;
        int n = this.numLines = etherLineModelArray == null ? 0 : etherLineModelArray.length;
        if (this.getParentView().getUiModel() instanceof L2scModuleModel) {
            l2scModuleModel = (L2scModuleModel)this.getParentView().getUiModel();
        } else if (db.on()) {
            db.println("Equipment Model is not L2scModuleModel");
        }
        this.dataModel = new L2scPosPortInfoTableModel(l2scModuleModel, l2scPortModelArray, etherLineModelArray);
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        this.table.sizeColumnsToFit(-1);
        this.registerForUpdates();
        this.add(jScrollPane);
    }

    private void registerForUpdates() {
        this.registerWithModel();
        if (this.lineModels == null) {
            return;
        }
        for (int i = 0; i < this.numLines; ++i) {
            if (null != this.lineModels[i]) {
                this.lineModels[i].addObserver((Observer)((Object)this));
                if (!L2scPosPortInfoPane.db.on) continue;
                db.finest("L2scPosPortInfoPane added as observer for lineModel: " + this.lineModels[i]);
                continue;
            }
            db.println("Could not add observer for line=" + i + " because the lineModel is null!");
        }
    }

    public void update(Observable observable, Object object) {
        if (L2scPosPortInfoPane.db.on) {
            db.finest("ob:" + observable + ", o:" + object);
        }
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                L2scPosPortInfoPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else {
            this.dataModel.refresh();
            if (db.on()) {
                db.println("Do full refresh on table");
            }
        }
    }

    public void destroy() {
        if (this.lineModels != null) {
            for (int i = 0; i < this.numLines; ++i) {
                this.lineModels[i].deleteObserver((Observer)((Object)this));
                if (!L2scPosPortInfoPane.db.on) continue;
                db.finest("L2scPosPortInfoPane deleted as observer for lineModel: " + this.lineModels[i]);
            }
            this.lineModels = null;
        }
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
            this.dataModel.destroy();
            this.dataModel = null;
        }
        super.destroy();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.numPorts == 0) {
            return;
        }
        int n = tableModelEvent.getLastRow() > this.numPorts ? this.numPorts - 1 : tableModelEvent.getLastRow();
        for (int i = tableModelEvent.getFirstRow(); i <= n; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            this.setDirty();
            return;
        }
        this.resetDirty();
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    public void applyChangesToModel() throws AnnotatedException {
        this.dataModel.applyToModels();
        this.dataModel.resetRowDirty();
        this.setDirty(false);
    }

    public void refreshFromModel() throws Exception {
        this.dataModel.refresh();
        this.dataModel.resetRowDirty();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.L2scPosPortInfoPane;
    }
}

