/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.l2sc;

import cerent.cms.idl.EtherMedia.ePosFramingType;
import cerent.cms.idl.EtherMedia.sL2scPosPortInfo;
import cerent.cms.model.Attribute;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.L2scModuleModel;
import cerent.cms.model.L2scPortModel;
import cerent.cms.model.L2scPosPortModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.enum.EtherEnumStrings;
import cerent.cms.ui.AbstractPane;
import cerent.util.SDebug;
import javax.swing.table.AbstractTableModel;

public class L2scPosPortInfoTableModel
extends AbstractTableModel {
    private L2scModuleModel eqpmtModel = null;
    private L2scPortModel[] portModels = null;
    private EtherLineModel[] lineModels = null;
    private boolean[] rowDirty = null;
    private int numLines = 0;
    private int numPorts = 0;
    private sL2scPosPortInfo[] l2scPosPortInfo = null;
    private String[] portName = null;
    public String[] columnNames = new String[]{"Port", "Port Name", "Admin State", "Link State", "MTU", "Framing Type"};
    public static final int PORT_NUMBER_INDEX = 0;
    public static final int PORT_NAME_INDEX = 1;
    public static final int ADMIN_STATE_INDEX = 2;
    public static final int LINK_STATE_INDEX = 3;
    public static final int MTU_INDEX = 4;
    public static final int FRAMING_TYPE_INDEX = 5;
    private static final SDebug db = new SDebug("L2scPosPortInfoTableModel");
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$cerent$cms$idl$EtherMedia$ePosFramingType;

    public L2scPosPortInfoTableModel(L2scModuleModel l2scModuleModel, L2scPortModel[] l2scPortModelArray, EtherLineModel[] etherLineModelArray) {
        this.portModels = l2scPortModelArray;
        this.lineModels = etherLineModelArray;
        this.numPorts = l2scPortModelArray == null ? 0 : l2scPortModelArray.length;
        this.numLines = etherLineModelArray == null ? 0 : etherLineModelArray.length;
        this.eqpmtModel = l2scModuleModel;
        this.rowDirty = new boolean[this.numPorts];
        this.l2scPosPortInfo = new sL2scPosPortInfo[this.numPorts];
        this.portName = new String[this.numPorts];
        this.resetRowDirty();
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        if (n2 == 1) {
            bl = AbstractPane.isUserAuthorized(this.eqpmtModel, SecurityLevel.PROVISIONING);
        }
        return bl;
    }

    public boolean isRowDirty(int n) {
        return this.rowDirty[n];
    }

    public sL2scPosPortInfo getL2scPosPortInfo(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.l2scPosPortInfo[n] == null && this.portModels[n] instanceof L2scPosPortModel) {
            L2scPosPortModel l2scPosPortModel = (L2scPosPortModel)this.portModels[n];
            this.l2scPosPortInfo[n] = l2scPosPortModel.getL2scPosPortInfo();
        }
        if (L2scPosPortInfoTableModel.db.on) {
            db.finest("\ngetL2scPosPortInfo(" + n + ") was called.");
            db.finest("   adminState:" + this.l2scPosPortInfo[n].adminState);
            db.finest("   linkProtocolState:" + this.l2scPosPortInfo[n].linkProtocolState);
            db.finest("   mtu:" + this.l2scPosPortInfo[n].mtu);
        }
        return this.l2scPosPortInfo[n];
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    private String getLineNumberFor(int n) {
        try {
            L2scPortModel l2scPortModel = this.portModels[n];
            return String.valueOf(l2scPortModel.getPort());
        }
        catch (Exception exception) {
            if (L2scPosPortInfoTableModel.db.on) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return "unknown";
        }
    }

    public int getRowCount() {
        return this.numPorts;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 1: {
                return class$java$lang$String == null ? (class$java$lang$String = L2scPosPortInfoTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = L2scPosPortInfoTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    private String getPortName(int n) {
        String string = "";
        if (this.portName[n] == null) {
            if (null == this.lineModels[n]) {
                string = "lineModels is null";
            } else {
                try {
                    this.portName[n] = string = this.lineModels[n].getAlias();
                }
                catch (Exception exception) {
                    if (L2scPosPortInfoTableModel.db.on) {
                        db.println("Exception caught accessing port name: " + exception);
                    }
                    string = exception.toString();
                }
            }
        }
        return this.portName[n];
    }

    private void setPortName(int n, String string) {
        this.getPortName(n);
        try {
            if (null != this.lineModels[n] && null != string) {
                this.portName[n] = string;
                this.rowDirty[n] = true;
            }
        }
        catch (Exception exception) {
            if (L2scPosPortInfoTableModel.db.on) {
                db.println("Exception caught setting port name: " + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    private String getAdminState(int n) {
        String string = "";
        try {
            this.getL2scPosPortInfo(n);
            boolean bl = this.l2scPosPortInfo[n].adminState;
            string = bl ? "Up" : "Down";
        }
        catch (Exception exception) {
            if (L2scPosPortInfoTableModel.db.on) {
                db.println("Exception caught accessing admin state: " + exception);
            }
            string = exception.toString();
        }
        return string;
    }

    private String getLinkState(int n) {
        String string = "";
        try {
            this.getL2scPosPortInfo(n);
            boolean bl = this.l2scPosPortInfo[n].linkProtocolState;
            string = bl ? "Up" : "Down";
        }
        catch (Exception exception) {
            if (L2scPosPortInfoTableModel.db.on) {
                db.println("Exception caught accessing link state: " + exception);
            }
            string = exception.toString();
        }
        return string;
    }

    private String getMTU(int n) {
        String string = "";
        try {
            this.getL2scPosPortInfo(n);
            string = new Integer(this.l2scPosPortInfo[n].mtu).toString();
        }
        catch (Exception exception) {
            if (L2scPosPortInfoTableModel.db.on) {
                db.println("Exception caught accessing mtu: " + exception);
            }
            string = exception.toString();
        }
        return string;
    }

    private Attribute getFramingType(int n) {
        Attribute attribute;
        block2: {
            attribute = null;
            try {
                this.getL2scPosPortInfo(n);
                ePosFramingType ePosFramingType2 = this.l2scPosPortInfo[n].framingType;
                attribute = EtherEnumStrings.get(class$cerent$cms$idl$EtherMedia$ePosFramingType == null ? (class$cerent$cms$idl$EtherMedia$ePosFramingType = L2scPosPortInfoTableModel.class$("cerent.cms.idl.EtherMedia.ePosFramingType")) : class$cerent$cms$idl$EtherMedia$ePosFramingType, ePosFramingType2.value());
            }
            catch (Exception exception) {
                if (!L2scPosPortInfoTableModel.db.on) break block2;
                db.println("Exception caught accessing framingType: " + exception);
            }
        }
        return attribute;
    }

    public Object getValueAt(int n, int n2) {
        String string;
        block10: {
            string = "";
            try {
                switch (n2) {
                    case 0: {
                        return this.getLineNumberFor(n);
                    }
                    case 1: {
                        return this.getPortName(n);
                    }
                    case 2: {
                        return this.getAdminState(n);
                    }
                    case 3: {
                        return this.getLinkState(n);
                    }
                    case 4: {
                        return this.getMTU(n);
                    }
                    case 5: {
                        return this.getFramingType(n);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block10;
                db.println("Error in getValueAt in L2scPosPortInfoTableModel " + exception);
                SDebug.printStackTrace((Throwable)exception);
                string = exception.toString();
            }
        }
        return string;
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                return;
            }
            case 1: {
                if (!(object instanceof String)) break;
                String string = (String)object;
                this.setPortName(n, string);
                break;
            }
            case 2: {
                return;
            }
            case 3: {
                return;
            }
            case 4: {
                return;
            }
            case 5: {
                return;
            }
            default: {
                return;
            }
        }
        this.rowDirty[n] = true;
        this.fireTableCellUpdated(n, n2);
    }

    public void resetRowDirty() {
        for (int i = 0; i < this.numPorts; ++i) {
            this.rowDirty[i] = false;
        }
    }

    public void refreshLineFromModel(int n) {
        this.l2scPosPortInfo[n] = null;
        this.portName[n] = null;
        this.fireTableRowsUpdated(n, n);
    }

    public void applyToModels() {
        for (int i = 0; i < this.portModels.length; ++i) {
            if (!this.rowDirty[i]) continue;
            try {
                this.lineModels[i].setAlias(this.portName[i]);
                continue;
            }
            catch (Exception exception) {
                if (L2scPosPortInfoTableModel.db.on) {
                    db.println("Exception caught trying to set port name : " + exception);
                }
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.resetRowDirty();
    }

    public void refresh() {
        for (int i = 0; i < this.numLines; ++i) {
            this.l2scPosPortInfo[i] = null;
            this.portName[i] = null;
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void destroy() {
        this.portModels = null;
        this.lineModels = null;
        this.eqpmtModel = null;
        this.rowDirty = null;
        for (int i = 0; i < this.l2scPosPortInfo.length; ++i) {
            this.l2scPosPortInfo[i] = null;
            this.portName[i] = null;
        }
        this.l2scPosPortInfo = null;
        this.portName = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

