/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.EtherMedia.sML2EtherLineInfo;
import cerent.cms.model.Attribute;
import cerent.cms.model.ML2EtherLineModel;
import cerent.cms.model.ML2EtherPortModel;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.enum.ComEnumStrings;
import cerent.cms.model.enum.EtherEnumStrings;
import cerent.cms.ui.AbstractPane;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.table.AbstractTableModel;

public class ML2LxEtherPortTableModel
extends AbstractTableModel
implements Observer {
    public static final int PORT_NUMBER_INDEX = 0;
    public static final int PORT_NAME_INDEX = 1;
    public static final int ADMIN_STATE_INDEX = 2;
    public static final int LINK_STATE_INDEX = 3;
    public static final int OPERATING_SPEED_INDEX = 4;
    public static final int OPERATING_DUPLEX_INDEX = 5;
    public static final int FLOW_CTRL_INDEX = 6;
    private String[] columnNames = new String[]{"Port", "Port Name", "Admin State", "Link State", "Operating Speed", "Operating Duplex", "Flow Control"};
    private ML2ModuleModel eqpmtModel = null;
    private ML2EtherPortModel[] portModels = null;
    private ML2EtherLineModel[] lineModels = null;
    private sML2EtherLineInfo[] etherLineInfo = null;
    private boolean[] rowDirty = null;
    private String[] portName = null;
    private int numLines = 0;
    private static final SDebug db = new SDebug("ML2LxEtherPortTableModel");
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$cerent$cms$idl$EtherMedia$eEtherSpeed;
    static /* synthetic */ Class class$cerent$cms$idl$EtherMedia$eEtherDuplex;
    static /* synthetic */ Class class$cerent$cms$idl$EtherMedia$eFlowControlNegotiated;
    static /* synthetic */ Class class$cerent$cms$idl$Common$eAdminState;

    public ML2LxEtherPortTableModel(ML2ModuleModel mL2ModuleModel, ML2EtherPortModel[] mL2EtherPortModelArray, ML2EtherLineModel[] mL2EtherLineModelArray) {
        if (mL2ModuleModel == null || mL2EtherPortModelArray == null || mL2EtherLineModelArray == null || mL2EtherPortModelArray.length != mL2EtherLineModelArray.length) {
            if (db.on()) {
                db.println("Error during initialization");
                db.println("eqpmtModel=" + mL2ModuleModel + " portModels=" + mL2EtherPortModelArray + " lineModels=" + mL2EtherLineModelArray);
            }
            return;
        }
        this.eqpmtModel = mL2ModuleModel;
        this.portModels = mL2EtherPortModelArray;
        this.lineModels = mL2EtherLineModelArray;
        this.numLines = mL2EtherLineModelArray.length;
        this.rowDirty = new boolean[this.numLines];
        this.etherLineInfo = new sML2EtherLineInfo[this.numLines];
        this.portName = new String[this.numLines];
        this.resetDirty();
        this.registerWithLineModels();
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        if (n2 == 1) {
            bl = AbstractPane.isUserAuthorized(this.eqpmtModel, SecurityLevel.PROVISIONING);
        }
        return bl;
    }

    public boolean isDirty(int n) {
        return this.rowDirty[n];
    }

    public sML2EtherLineInfo getEtherLineInfoFromModel(int n) throws NoSuchInterface, WrongInterfaceType {
        sML2EtherLineInfo sML2EtherLineInfo2 = this.lineModels[n].getML2EtherLineInfo();
        if (ML2LxEtherPortTableModel.db.on) {
            db.finest("ML2EtherLineInfo: row=" + n);
            db.finest("   adminState:" + sML2EtherLineInfo2.adminState);
            db.finest("   linkUp:" + sML2EtherLineInfo2.linkUp);
            db.finest("   duplex:" + sML2EtherLineInfo2.duplex.value());
            db.finest("   flowControlNegotiated:" + sML2EtherLineInfo2.flowControlNegotiated.value());
        }
        return sML2EtherLineInfo2;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        if (n >= 0 && n < this.columnNames.length) {
            return this.columnNames[n];
        }
        return null;
    }

    private String getLineNumber(int n) {
        try {
            ML2EtherPortModel mL2EtherPortModel = this.portModels[n];
            return String.valueOf(mL2EtherPortModel.getPort());
        }
        catch (Exception exception) {
            if (ML2LxEtherPortTableModel.db.on) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return "unknown";
        }
    }

    public int getRowCount() {
        return this.numLines;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 1: {
                return class$java$lang$String == null ? (class$java$lang$String = ML2LxEtherPortTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = ML2LxEtherPortTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    private String getPortNameFromModel(int n) {
        String string;
        block2: {
            string = "";
            try {
                string = this.lineModels[n].getAlias();
            }
            catch (Exception exception) {
                if (!ML2LxEtherPortTableModel.db.on) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    private String getLinkState(int n) {
        try {
            return this.etherLineInfo[n].linkUp ? "Up" : "Down";
        }
        catch (Exception exception) {
            if (ML2LxEtherPortTableModel.db.on) {
                db.println("Exception caught accessing link state: " + exception);
            }
            return exception.toString();
        }
    }

    public String getAdminState(int n) {
        return this.etherLineInfo[n].adminState == eAdminState.ADMIN_IS ? "Up" : "Down";
    }

    public Attribute getOperatingEtherSpeed(int n) {
        return EtherEnumStrings.get(class$cerent$cms$idl$EtherMedia$eEtherSpeed == null ? (class$cerent$cms$idl$EtherMedia$eEtherSpeed = ML2LxEtherPortTableModel.class$("cerent.cms.idl.EtherMedia.eEtherSpeed")) : class$cerent$cms$idl$EtherMedia$eEtherSpeed, this.etherLineInfo[n].speed.value());
    }

    public Attribute getOperatingEtherDuplex(int n) {
        return EtherEnumStrings.get(class$cerent$cms$idl$EtherMedia$eEtherDuplex == null ? (class$cerent$cms$idl$EtherMedia$eEtherDuplex = ML2LxEtherPortTableModel.class$("cerent.cms.idl.EtherMedia.eEtherDuplex")) : class$cerent$cms$idl$EtherMedia$eEtherDuplex, this.etherLineInfo[n].duplex.value());
    }

    public Attribute getFlowControlStatus(int n) {
        return EtherEnumStrings.get(class$cerent$cms$idl$EtherMedia$eFlowControlNegotiated == null ? (class$cerent$cms$idl$EtherMedia$eFlowControlNegotiated = ML2LxEtherPortTableModel.class$("cerent.cms.idl.EtherMedia.eFlowControlNegotiated")) : class$cerent$cms$idl$EtherMedia$eFlowControlNegotiated, this.etherLineInfo[n].flowControlNegotiated.value());
    }

    public Object getValueAt(int n, int n2) {
        String string;
        block11: {
            string = "";
            try {
                switch (n2) {
                    case 0: {
                        return this.getLineNumber(n);
                    }
                    case 1: {
                        return this.portName[n];
                    }
                    case 2: {
                        return this.getAdminState(n);
                    }
                    case 3: {
                        return this.getLinkState(n);
                    }
                    case 4: {
                        return this.getOperatingEtherSpeed(n);
                    }
                    case 5: {
                        return this.getOperatingEtherDuplex(n);
                    }
                    case 6: {
                        return this.getFlowControlStatus(n);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block11;
                db.println("Error in getValueAt " + exception);
                SDebug.printStackTrace((Throwable)exception);
                string = exception.toString();
            }
        }
        return string;
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                return;
            }
            case 1: {
                if (!(object instanceof String)) break;
                String string = (String)object;
                if (string != null) {
                    this.portName[n] = string;
                }
                this.rowDirty[n] = true;
                this.fireTableCellUpdated(n, n2);
                break;
            }
            case 2: {
                return;
            }
            case 3: {
                return;
            }
            case 4: {
                return;
            }
            case 5: {
                return;
            }
            case 6: {
                return;
            }
            default: {
                return;
            }
        }
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.rowDirty[i]) continue;
            return true;
        }
        return false;
    }

    public void resetDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            this.rowDirty[i] = false;
        }
    }

    public void refreshLineFromModel(int n) {
        block2: {
            try {
                this.resetLineCache(n);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.fireTableRowsUpdated(n, n);
    }

    public void applyToModels() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.rowDirty[i]) continue;
            try {
                this.lineModels[i].setAlias(this.portName[i]);
                continue;
            }
            catch (Exception exception) {
                if (ML2LxEtherPortTableModel.db.on) {
                    db.println("Exception caught trying to set port name : " + exception);
                }
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.resetDirty();
    }

    public void refreshFromModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    private void resetLineCache(int n) throws Exception {
        this.etherLineInfo[n] = this.getEtherLineInfoFromModel(n);
        this.portName[n] = this.getPortNameFromModel(n);
        this.rowDirty[n] = false;
    }

    public Attribute[] getAdminStateAttrs() {
        return ComEnumStrings.get(class$cerent$cms$idl$Common$eAdminState == null ? (class$cerent$cms$idl$Common$eAdminState = ML2LxEtherPortTableModel.class$("cerent.cms.idl.Common.eAdminState")) : class$cerent$cms$idl$Common$eAdminState, ComEnumStrings.G1000_ADMIN_STATE);
    }

    public Attribute[] getFlowControlAttrs() {
        return EtherEnumStrings.get(class$cerent$cms$idl$EtherMedia$eFlowControlNegotiated == null ? (class$cerent$cms$idl$EtherMedia$eFlowControlNegotiated = ML2LxEtherPortTableModel.class$("cerent.cms.idl.EtherMedia.eFlowControlNegotiated")) : class$cerent$cms$idl$EtherMedia$eFlowControlNegotiated, EtherEnumStrings.ML2_FLOW_CONTROL);
    }

    private void registerWithLineModels() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver(this);
        }
    }

    private void unRegisterWithLineModels() {
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.lineModels[i].deleteObserver(this);
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            int n;
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            if ((n = Arrays.asList(this.lineModels).indexOf(observable)) != -1) {
                this.refreshLineFromModel(n);
            }
        }
    }

    public void dispose() {
        this.unRegisterWithLineModels();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

