/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ml2.ML2PosPortUsageTableModel;
import cerent.cms.ui.ml2.ML2SonetPoolUsageTableModel;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ML2PosPortUsagePane
extends AbstractPane
implements ActionListener {
    private static SDebug db = new SDebug("ML2PosPortUsagePane");
    private JButton refreshButton;
    private ML2PosPortUsageTableModel lDataModel;
    private ML2SonetPoolUsageTableModel rDataModel;
    private UTable lTable;
    private UTable rTable;
    private JLabel refreshLabel;

    public ML2PosPortUsagePane(String string, TabbedView tabbedView, ML2ModuleModel mL2ModuleModel) {
        super(string, null, tabbedView);
        this.setLayout(new BorderLayout());
        this.setDefaultPrivilegeLevel(SecurityLevel.RETRIEVE);
        this.add(this.createDualPanels(), "Center");
        this.add(this.createButtonPane(), "South");
    }

    private JPanel createDualPanels() {
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        JPanel jPanel2 = ML2PosPortUsagePane.createVerticalPanel("POS Port Map");
        JPanel jPanel3 = ML2PosPortUsagePane.createVerticalPanel("Pool Utilization");
        this.lDataModel = new ML2PosPortUsageTableModel(this.getModuleModel());
        this.rDataModel = new ML2SonetPoolUsageTableModel(this.getModuleModel());
        this.lTable = new UTable((TableModel)this.lDataModel);
        jPanel2.add((Component)new UScrollPane((Component)this.lTable));
        this.rTable = new UTable((TableModel)this.rDataModel);
        jPanel3.add((Component)new UScrollPane((Component)this.rTable));
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        this.customizePane();
        return jPanel;
    }

    protected void customizePane() {
        TableColumn tableColumn = null;
        ListSelectionModel listSelectionModel = this.lTable.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        listSelectionModel = this.rTable.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        tableColumn = this.lTable.getColumn((Object)this.lDataModel.getColumnName(0));
        tableColumn.setPreferredWidth(120);
        tableColumn = this.lTable.getColumn((Object)this.lDataModel.getColumnName(1));
        tableColumn.setPreferredWidth(155);
        tableColumn = this.lTable.getColumn((Object)this.lDataModel.getColumnName(2));
        tableColumn.setPreferredWidth(100);
        tableColumn = this.rTable.getColumn((Object)this.rDataModel.getColumnName(0));
        tableColumn.setPreferredWidth(45);
        tableColumn = this.rTable.getColumn((Object)this.rDataModel.getColumnName(1));
        tableColumn.setPreferredWidth(65);
        tableColumn = this.rTable.getColumn((Object)this.rDataModel.getColumnName(2));
        tableColumn.setPreferredWidth(100);
        tableColumn = this.rTable.getColumn((Object)this.rDataModel.getColumnName(3));
        tableColumn.setPreferredWidth(85);
        tableColumn = this.rTable.getColumn((Object)this.rDataModel.getColumnName(4));
        tableColumn.setPreferredWidth(80);
    }

    private JPanel createButtonPane() {
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.ML2PosPortUsagePane);
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.addActionListener(this);
        this.refreshLabel = new JLabel(" ");
        cSHelpButtonPane.addLeft(this.refreshButton);
        cSHelpButtonPane.addRight(this.refreshLabel);
        return cSHelpButtonPane;
    }

    private ML2ModuleModel getModuleModel() {
        return (ML2ModuleModel)this.getUiModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        try {
            this.uiToolkit.setCursor(3);
            if (object == this.refreshButton) {
                this.refresh();
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        finally {
            this.uiToolkit.setCursor(0);
        }
    }

    public void enteringPage() throws Exception {
        TablePropertyMgr.getColumnPrefs((JTable)this.lTable, "ML2PosPortUsagePane");
        TablePropertyMgr.getColumnPrefs((JTable)this.rTable, "ML2SonetPoolUsagePane");
        this.refresh();
    }

    private void saveTablePref() {
        TablePropertyMgr.setColumnPrefs((JTable)this.lTable, "ML2PosPortUsagePane");
        TablePropertyMgr.setColumnPrefs((JTable)this.rTable, "ML2SonetPoolUagePane");
    }

    public void leavingPage() throws Exception {
        this.saveTablePref();
    }

    public void refresh() {
        try {
            this.lDataModel.refreshFromModel();
            this.rDataModel.refreshFromModel();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        String string = "Refreshed:" + ML2PosPortUsagePane.getFormattedDateTime(new Date());
        this.refreshLabel.setText(string);
    }

    public void destroy() {
        this.saveTablePref();
        super.destroy();
    }
}

