/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.muxdemux;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.Pane;
import cerent.cms.ui.event.IEventPanelController;
import cerent.cms.ui.muxdemux.MuxDmuxInventoryPane;
import cerent.cms.ui.muxdemux.MuxDmuxMaintenancePane;
import cerent.cms.ui.muxdemux.MuxDmuxPerfPane;
import cerent.cms.ui.muxdemux.MuxDmuxProvPane;
import cerent.util.SDebug;
import java.awt.Component;

public class MuxDmuxCardTabbedView
extends CardTabbedView
implements ITabName {
    ModuleModel module = null;
    NodeModelDelegate node = null;
    private static final SDebug db = new SDebug("MuxDmuxCardTabbedView");

    public MuxDmuxCardTabbedView(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        super(moduleModel, iEventPanelController, iUiToolkit);
        this.init();
    }

    public void showTabs() {
        this.addTab("Alarms", (Component)this.getAlarmTab());
        this.addTab("Conditions", (Component)this.getConditionsTab());
        this.addTab("History", (Component)this.getEventTab());
        this.addTab("Circuits", (Component)this.getCircuitTab());
        this.addTab("Provisioning", (Component)this.getProvTab());
        this.addTab("Maintenance", (Component)this.getMaintenanceTab());
        this.addTab("Inventory", (Component)this.getInventoryTab());
        this.addTab("Performance", (Component)this.getPerformanceTab());
    }

    private void init() {
        this.module = (ModuleModel)this.getUiModel();
        this.node = ((ModuleModel)this.getUiModel()).getNodeModelDelegate();
        this.showTabs();
    }

    public void initialize() {
        super.initialize();
    }

    public Pane getMaintenanceTab() {
        MuxDmuxMaintenancePane muxDmuxMaintenancePane = null;
        if (eEqType.WSS_32_CARD.equals(this.module.getEqTypeEnum())) {
            OpticsModuleModel opticsModuleModel = (OpticsModuleModel)this.getUiModel();
            AbstractOpticsLineModel[] abstractOpticsLineModelArray = opticsModuleModel.getOpticsChannelModels();
            muxDmuxMaintenancePane = new MuxDmuxMaintenancePane("Maintenance", this, abstractOpticsLineModelArray);
        }
        return muxDmuxMaintenancePane;
    }

    public Pane getPerformanceTab() {
        return new MuxDmuxPerfPane("Performance", this, this.module);
    }

    public Pane getProvTab() {
        return new MuxDmuxProvPane("Provisioning", this, this.module);
    }

    public Pane getInventoryTab() {
        return new MuxDmuxInventoryPane("Inventory", this);
    }
}

