/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nedefaults;

import cerent.cms.idl.Security.NotAuthenticated;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.nedefaults.DefaultsNode;
import cerent.cms.model.nedefaults.IDefaultsElement;
import cerent.cms.model.nedefaults.IDefaultsNode;
import cerent.cms.ui.DataSourceControl;
import cerent.cms.ui.nedefaults.DefaultsHelper;
import cerent.cms.ui.nedefaults.DefaultsTableModel;
import cerent.cms.ui.shelf.SppDefaultsEditorPane;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeMap;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DefaultsController
implements DataSourceControl,
Observer,
Runnable {
    private static final String PROP_PREF = "ctc.defaults";
    private static final String PROP_SCOPE = "scope";
    private IObservableManager om = new ObservableManager(this, true);
    private static final DefaultsNode LOADING_DNODE = new DefaultsNode("Loading Defaults...");
    private static final DefaultMutableTreeNode LOADING_TREE_NODE = new DefaultMutableTreeNode(LOADING_DNODE);
    private static final String NODE_DEFAULTS_SOURCE = "Node Defaults";
    static DefaultsNode ERROR_DNODE = new DefaultsNode("Error Loading Defaults");
    static DefaultMutableTreeNode ERROR_TREE_NODE = new DefaultMutableTreeNode(ERROR_DNODE);
    private IDefaultsNode droot;
    private DefaultTreeModel treeModel;
    private DefaultsTableModel tableModel;
    private boolean disposed = false;
    private DefaultsHelper dfh;
    private SDebug dbg;
    private SppDefaultsEditorPane pane;
    private boolean dirty;
    private NodeModelDelegate nmd;

    public DefaultsController(SppDefaultsEditorPane sppDefaultsEditorPane, NodeModelDelegate nodeModelDelegate, SDebug sDebug) {
        this.nmd = nodeModelDelegate;
        this.dfh = new DefaultsHelper((Component)((Object)sppDefaultsEditorPane), this.nmd);
        this.treeModel = new DefaultTreeModel(LOADING_TREE_NODE);
        this.tableModel = new DefaultsTableModel(this);
        this.dfh = this.dfh;
        this.dbg = sDebug;
        this.pane = sppDefaultsEditorPane;
    }

    public DefaultsTableModel getTableModel() {
        return this.tableModel;
    }

    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    public void importDefaults() {
        String string = this.dfh.importDefaults();
        if (string != null) {
            this.dbg.info("Import successful, refreshing pane for " + string);
            if (this.droot.isDirty()) {
                this.dbg.info("Root shows something is dirty for " + string);
                this.refreshPane(string);
                this.pane.setDirty();
            } else {
                this.refreshPane(NODE_DEFAULTS_SOURCE);
            }
        }
    }

    public void setShellPassword(String string) {
        this.nmd.getDefaultsManager().setPassword(string);
    }

    public void setResQuality(String string) {
        this.nmd.getDefaultsManager().setResQuality(string);
    }

    private void refreshPane(String string) {
        this.tableModel.fireTableDataChanged();
        this.refreshTree((DefaultMutableTreeNode)this.treeModel.getRoot());
        this.pane.updateLabel(string);
    }

    private void refreshTree(TreeNode treeNode) {
        this.treeModel.nodeChanged(treeNode);
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            this.refreshTree(treeNode.getChildAt(i));
        }
    }

    public void exportDefaults() {
        String string = this.dfh.exportDefaults();
        if (string != null) {
            this.pane.updateLabel(string);
        }
    }

    final Component getParentComponent() {
        return this.pane;
    }

    public boolean validateData() {
        return true;
    }

    public void applyToModel() throws Exception {
        try {
            this.applyToNode(this.droot);
            this.droot.resetDirty();
            this.refreshPane(NODE_DEFAULTS_SOURCE);
        }
        catch (NotAuthenticated notAuthenticated) {
            throw new AnnotatedException(ErrorMsg.getString((EID)EMC.EID_AUTH_ERROR), (Exception)((Object)notAuthenticated));
        }
        catch (Exception exception) {
            throw new AnnotatedException(ErrorMsg.getString((EID)EMC.EID_PROVISION_ERROR), exception);
        }
    }

    private void getSideEffects(IDefaultsNode iDefaultsNode, SideEffects[] sideEffectsArray) {
        IDefaultsNode[] iDefaultsNodeArray = iDefaultsNode.getChildren();
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            if (iDefaultsNodeArray[i] instanceof IDefaultsElement) {
                IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
                this.dbg.fine("Side effects check on  element " + iDefaultsElement.getFullName());
                if (!iDefaultsElement.isDirty()) continue;
                if (iDefaultsElement.causesReboot()) {
                    this.dbg.fine("element " + iDefaultsElement.getFullName() + " reboots");
                    sideEffectsArray[3].increment(iDefaultsElement.getFullName());
                    continue;
                }
                if (iDefaultsElement.disconnects()) {
                    this.dbg.fine("element " + iDefaultsElement.getFullName() + " disconnects");
                    sideEffectsArray[2].increment(iDefaultsElement.getFullName());
                    continue;
                }
                if (iDefaultsElement.reprovisions()) {
                    this.dbg.fine("element " + iDefaultsElement.getFullName() + " reprovisions");
                    sideEffectsArray[1].increment();
                    continue;
                }
                sideEffectsArray[0].increment();
                continue;
            }
            this.dbg.fine("Side effects check on  node " + iDefaultsNodeArray[i].getName());
            this.getSideEffects(iDefaultsNodeArray[i], sideEffectsArray);
        }
    }

    private SideEffects[] getSideEffects(IDefaultsNode iDefaultsNode) {
        SideEffects[] sideEffectsArray = new SideEffects[8];
        for (int i = 0; i < sideEffectsArray.length; ++i) {
            sideEffectsArray[i] = new SideEffects();
        }
        this.getSideEffects(iDefaultsNode, sideEffectsArray);
        return sideEffectsArray;
    }

    private void applyToNode(IDefaultsNode iDefaultsNode) throws Exception {
        if (iDefaultsNode != null) {
            SideEffects[] sideEffectsArray = this.getSideEffects(iDefaultsNode);
            boolean bl = false;
            String string = this.nmd.getPlatform().getReprovisioningScopeForDefaults();
            String string2 = "Changing default values for some node level attributes overrides the current provisioning. \n" + string + "\n";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            int n = 0;
            if (sideEffectsArray[1].whether()) {
                bl = true;
            }
            if (sideEffectsArray[2].whether()) {
                string3 = "Changing default values for " + sideEffectsArray[2].effectors() + " may cause CTC to disconnect.\n";
                n += sideEffectsArray[2].howMany();
                bl = true;
            }
            if (sideEffectsArray[3].whether()) {
                string4 = "Changing default values for " + sideEffectsArray[3].effectors() + " will even cause the node to reboot.\n ";
                n += sideEffectsArray[3].howMany();
                bl = true;
            }
            if (n > 1) {
                string5 = "Because more than one of the defaults changed may cause a loss of connection or a reboot, \nnot all of the changes requested may be applied.\n";
            }
            if (bl && !CerentDialog.yesNoDialog((Component)((Object)this.pane), (String)(string2 + string3 + string4 + string5 + "\nDo you want to continue?"), (String)"Apply Defaults to Node")) {
                throw new Exception("Apply cancelled by user");
            }
            this.nmd.getDefaultsManager().applyToNode(iDefaultsNode);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public void refreshFromModel() throws Exception {
        String string = this.getTreeSelection();
        Preferences.instance().setProperty(PROP_PREF, PROP_SCOPE, string);
        this.setEditorContent(LOADING_TREE_NODE);
        new Thread((Runnable)this, "NE Defaults loader for " + this.nmd.getName()).start();
    }

    public void refreshFromModel(int n) throws Exception {
        this.refreshFromModel();
    }

    public void disposeDataSource() {
        this.disposed = true;
    }

    public IObservableManager getObservableManager() {
        return this.om;
    }

    public void update(Observable observable, Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!this.disposed) {
            this.pane.clearLabel();
            this.pane.enableButtons(false);
            try {
                this.droot = this.dfh.getDefaultsRoot(true);
                DefaultMutableTreeNode defaultMutableTreeNode = this.createTree(this.droot);
                this.treeModel.setRoot(defaultMutableTreeNode);
                String string = Preferences.instance().getProperty(PROP_PREF, PROP_SCOPE, null);
                DefaultMutableTreeNode defaultMutableTreeNode2 = null;
                if (string != null) {
                    defaultMutableTreeNode2 = this.getTreeRoot(defaultMutableTreeNode, string);
                }
                if (defaultMutableTreeNode2 == null) {
                    defaultMutableTreeNode2 = defaultMutableTreeNode;
                }
                this.pane.getTreeSelectionModel().setSelectionPath(new TreePath(defaultMutableTreeNode2.getPath()));
                this.pane.updateLabel(NODE_DEFAULTS_SOURCE);
            }
            catch (Exception exception) {
                this.setEditorContent(ERROR_TREE_NODE);
                String string = "No reason available";
                if (exception.getMessage() != null) {
                    string = exception.toString();
                }
                if (this.dbg.isSevereEnabled()) {
                    this.dbg.severe(string);
                    SDebug.printStackTrace((Throwable)exception);
                }
                ErrorMsg.displayError((Component)((Object)this.pane), (EID)EMC.EID_RTRV_DEFAULTS_PARAM_1, (Object)string);
            }
            finally {
                this.pane.enableButtons(true);
            }
        }
    }

    public void setTableContent(TreePath treePath) {
        if (treePath != null) {
            IDefaultsNode iDefaultsNode = this.getDefaultsNode(treePath);
            TreeMap treeMap = new TreeMap();
            this.dfh.fillMap(treeMap, iDefaultsNode);
            this.tableModel.setScope(this.pane.getTable(), treeMap);
        }
    }

    public void setEditorContent(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.droot = (DefaultsNode)defaultMutableTreeNode.getUserObject();
        this.treeModel.setRoot(defaultMutableTreeNode);
        this.pane.getTreeSelectionModel().clearSelection();
        this.pane.getTreeSelectionModel().setSelectionPath(new TreePath(defaultMutableTreeNode));
    }

    public void setDirty(IDefaultsElement iDefaultsElement) {
        this.pane.setDirty();
        this.updateTreeModel((DefaultMutableTreeNode)this.treeModel.getRoot(), iDefaultsElement.getFullName());
    }

    private void updateTreeModel(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        this.treeModel.nodeChanged(defaultMutableTreeNode);
        int n = string.indexOf(46);
        if (n < 0) {
            return;
        }
        String string2 = string.substring(0, n);
        string = string.substring(n + 1);
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            IDefaultsNode iDefaultsNode = (IDefaultsNode)defaultMutableTreeNode3.getUserObject();
            if (!iDefaultsNode.getName().equals(string2)) continue;
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
            break;
        }
        if (defaultMutableTreeNode2 != null) {
            this.updateTreeModel(defaultMutableTreeNode2, string);
        }
    }

    private String getTreeSelection() {
        TreePath treePath = this.pane.getTreeSelectionModel().getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            return ((IDefaultsNode)defaultMutableTreeNode.getUserObject()).getFullName();
        }
        return "";
    }

    private DefaultMutableTreeNode getTreeRoot(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        String string2;
        int n = string.indexOf(46);
        if (n < 0) {
            string2 = string;
            string = null;
        } else {
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            IDefaultsNode iDefaultsNode = (IDefaultsNode)defaultMutableTreeNode3.getUserObject();
            if (!iDefaultsNode.getName().equals(string2)) continue;
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
            break;
        }
        if (defaultMutableTreeNode2 != null && string != null) {
            return this.getTreeRoot(defaultMutableTreeNode2, string);
        }
        return defaultMutableTreeNode2;
    }

    boolean isAuthorized() {
        return this.nmd.isUserAuthorized(SecurityLevel.SUPERUSER);
    }

    private DefaultMutableTreeNode createTree(IDefaultsNode iDefaultsNode) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(iDefaultsNode);
        IDefaultsNode[] iDefaultsNodeArray = iDefaultsNode.getChildren();
        for (int i = 0; i < iDefaultsNodeArray.length && !(iDefaultsNodeArray[i] instanceof IDefaultsElement); ++i) {
            defaultMutableTreeNode.add(this.createTree(iDefaultsNodeArray[i]));
        }
        return defaultMutableTreeNode;
    }

    private IDefaultsNode getDefaultsNode(TreePath treePath) {
        Object var2_2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return (IDefaultsNode)defaultMutableTreeNode.getUserObject();
    }

    private class SideEffects {
        private String concatenation = null;
        private int count = 0;

        SideEffects() {
        }

        private void increment(String string) {
            this.concatenation = this.concatenation == null ? string : new StringBuffer(this.concatenation.length() + string.length() + 5).append(this.concatenation).append(", ").append(string).toString();
            ++this.count;
        }

        private void increment() {
            ++this.count;
        }

        private boolean whether() {
            return this.count > 0;
        }

        private int howMany() {
            return this.count;
        }

        private String effectors() {
            return this.concatenation;
        }
    }
}

