/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nedefaults;

import cerent.cms.model.Attribute;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.nedefaults.IDefaultsElement;
import cerent.cms.ui.nedefaults.DefaultsController;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class DefaultsTableModel
extends AbstractTableModel {
    private IDefaultsElement[] rows = null;
    private DefaultsController dfc;
    private static final String[] COL_NAMES = new String[]{"Default Name", "Default Value"};

    public DefaultsTableModel(DefaultsController defaultsController) {
        this.dfc = defaultsController;
    }

    public synchronized int getRowCount() {
        if (this.rows != null) {
            return this.rows.length;
        }
        return 0;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int n) {
        return COL_NAMES[n];
    }

    public synchronized Object getValueAt(int n, int n2) {
        try {
            return this.rows[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        String string = null;
        String string2 = null;
        try {
            if (object instanceof String) {
                string = (String)object;
                string2 = this.rows[n].getValue();
                if (this.setsValueForIP(this.rows[n].getName())) {
                    int n3 = InetUtil.parseDottedString(string);
                }
                this.rows[n].setValue(string);
                if (this.rows[n].isDirty()) {
                    if (this.rows[n].getName().equals("EnableShellPassword") && string.equals("FALSE")) {
                        Object object2 = CerentDialog.inputPasswordDialog((Component)this.dfc.getParentComponent(), (String)"Turn off enforce shell password, please enter the current shell password.", (String)"Disable Shell Password");
                        if (object2 != null) {
                            this.dfc.setShellPassword((String)object2);
                        } else {
                            this.rows[n].setValue(string2);
                            this.rows[n].makeClean();
                        }
                    }
                    if (string.indexOf("Generation") >= 0) {
                        this.dfc.setResQuality(string);
                    }
                }
            } else if (object instanceof Attribute) {
                Attribute attribute = (Attribute)object;
                this.rows[n].setValue(attribute.toString());
            }
            if (this.rows[n].isDirty()) {
                this.dfc.setDirty(this.rows[n]);
                this.fireTableRowsUpdated(n, n);
            }
        }
        catch (ProvisionError provisionError) {
            ErrorMsg.displayError((Component)this.dfc.getParentComponent(), (EID)EMC.EID_PROVISIONING_PARAM_1, (Object)provisionError.getMessage());
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMsg.displayError((Component)this.dfc.getParentComponent(), (EID)EMC.EID_PROVISIONING_PARAM_1, (Object)numberFormatException.getMessage());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            ErrorMsg.displayDetailed(this.dfc.getParentComponent(), EMC.EID_GENERIC_PROV_ERROR, arrayIndexOutOfBoundsException.getMessage());
        }
    }

    private boolean setsValueForIP(String string) {
        return string.equals("NodeIPAddress") || string.equals("DefaultRouterIPAddress") || string.equals("BackplaneIP");
    }

    public synchronized void setScope(JTable jTable, Map map) {
        jTable.setRowHeight(jTable.getRowHeight());
        this.rows = map.values().toArray(new IDefaultsElement[0]);
        this.fireTableDataChanged();
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl = true;
        if (this.dfc.isAuthorized()) {
            if (this.rows[n].getName().equals("SecureModeLocked")) {
                String string = this.rows[n].getValue();
                bl = string.equals("FALSE");
            } else {
                bl = this.rows[n].getName().equals("DefaultTCCEthernetIP") || this.rows[n].getName().equals("DefaultTCCEthernetIPNetmask") ? false : (!this.rows[n].isSupported() ? false : n2 == 1);
            }
        } else {
            bl = false;
        }
        return bl;
    }
}

