/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.oadm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Optics.PM_OPTICS_UNDEFINED;
import cerent.cms.idl.Optics.sOpticsAlmThresholds;
import cerent.cms.idl.Optics.sOpticsTCAThresholds;
import cerent.cms.idl.Optics.xFeatureUnsupported;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.ConfigError;
import cerent.cms.model.IPortModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.ui.oadm.OpticalTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;

public class OadmOpticalThresholdTableModel
extends OpticalTableModel
implements PM_OPTICS_UNDEFINED {
    public static final String[] columnNames = new String[]{"Port", "opwrMax (dBm)", "opwrMin (dBm)", "Power Failure Low (dBm)", "VOA High (dBm)", "VOA Low (dBm)", "Power Degrade High (dBm)", "Power Degrade Low (dBm)", "VOA Degrade High (dB)", "VOA Degrade Low (dB)", "VOA Failure Low (dB)"};
    public static final int LINENUMBER_INDEX = 0;
    public static final int POWER_HIGH_INDEX = 1;
    public static final int POWER_LOW_INDEX = 2;
    public static final int POWER_FAILURE_LOW_INDEX = 3;
    public static final int VOA_HIGH_INDEX = 4;
    public static final int VOA_LOW_INDEX = 5;
    public static final int POWER_DEGRADE_HIGH_INDEX = 6;
    public static final int POWER_DEGRADE_LOW_INDEX = 7;
    public static final int VOA_DEGRADE_HIGH_INDEX = 8;
    public static final int VOA_DEGRADE_LOW_INDEX = 9;
    public static final int VOA_FAILURE_LOW_INDEX = 10;
    public static final int NA_VALUE = -1000000;
    protected int thresholdLayer;
    protected sOpticsTCAThresholds[] thresholdsVal;
    protected sOpticsAlmThresholds[] AlmThresholdsVal;
    private boolean[][] isDirty = new boolean[this.numLines][this.getColumnCount()];
    private boolean[] Flg_FeatureUnsupported = new boolean[this.numLines];
    private String[] PowerH;
    private String[] PowerL;
    private String[] PowerFailureL;
    private int numChars = 0;
    private static final SDebug db = new SDebug("OpticalThresholdTableModel");
    static /* synthetic */ Class class$java$lang$Object;

    public OadmOpticalThresholdTableModel(AbstractOpticsLineModel[] abstractOpticsLineModelArray, int n) {
        super(db, abstractOpticsLineModelArray);
        this.thresholdLayer = n;
        this.thresholdsVal = new sOpticsTCAThresholds[this.numLines];
        this.AlmThresholdsVal = new sOpticsAlmThresholds[this.numLines];
        this.PowerL = new String[this.numLines];
        this.PowerH = new String[this.numLines];
        this.PowerFailureL = new String[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.thresholdsVal[i] = null;
            this.AlmThresholdsVal[i] = null;
            this.PowerH[i] = null;
            this.PowerL[i] = null;
            this.PowerFailureL[i] = null;
            this.Flg_FeatureUnsupported[i] = true;
        }
        this.resetDirtyBits();
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            default: 
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = OadmOpticalThresholdTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public boolean isCellEditable(int n, int n2) {
        if (!this.isUserAuthorized(SecurityLevel.PROVISIONING)) {
            return false;
        }
        if (n2 == 2 || n2 == 1 || n2 == 3) {
            return this.Flg_FeatureUnsupported[n];
        }
        return false;
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isRowDirty(i)) continue;
            return true;
        }
        return false;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescription(n);
                }
                case 1: {
                    return this.getPowerHigh(n);
                }
                case 2: {
                    return this.getPowerLow(n);
                }
                case 3: {
                    return this.getFailureLow(n);
                }
                case 6: {
                    return this.getPowerDegradeH(n);
                }
                case 7: {
                    return this.getPowerDegradeL(n);
                }
                case 8: {
                    return this.getVOADegradeH(n);
                }
                case 9: {
                    return this.getVOADegradeL(n);
                }
                case 10: {
                    return this.getVOAFailureL(n);
                }
            }
            return "";
        }
        catch (Exception exception) {
            db.severe("OadmOpticalThresholdTableModel: error in getValueAt() " + exception);
            return null;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        db.info("Change in value " + n + " " + n2);
        boolean bl = false;
        try {
            switch (n2) {
                case 1: {
                    String string = (String)object;
                    this.PowerH[n] = (String)object;
                    if (OadmOpticalThresholdTableModel.isValidNumber(string, "Power High")) {
                        int n3 = OadmOpticalThresholdTableModel.ValPerTen(string);
                        if (this.thresholdsVal[n] != null) {
                            this.thresholdsVal[n].opticalPowerPMTh.high = n3;
                            break;
                        }
                        this.isDirty[n][n2] = false;
                        return;
                    }
                    this.PowerH[n] = null;
                    this.getPowerHigh(n);
                    this.fireTableRowsUpdated(0, this.numLines - 1);
                    return;
                }
                case 2: {
                    String string = (String)object;
                    this.PowerL[n] = (String)object;
                    if (OadmOpticalThresholdTableModel.isValidNumber(string, "Power Low")) {
                        int n4 = OadmOpticalThresholdTableModel.ValPerTen(string);
                        if (this.thresholdsVal[n] != null) {
                            this.thresholdsVal[n].opticalPowerPMTh.low = n4;
                            break;
                        }
                        this.isDirty[n][n2] = false;
                        return;
                    }
                    this.PowerL[n] = null;
                    this.getPowerLow(n);
                    this.fireTableRowsUpdated(0, this.numLines - 1);
                    return;
                }
                case 3: {
                    String string = (String)object;
                    this.PowerFailureL[n] = (String)object;
                    if (OadmOpticalThresholdTableModel.isValidNumber(string, "Power failure Low")) {
                        int n5 = OadmOpticalThresholdTableModel.ValPerTen(string);
                        if (this.AlmThresholdsVal[n] != null) {
                            this.AlmThresholdsVal[n].opticalPowerAlmTh.fail.low = n5;
                            break;
                        }
                        this.isDirty[n][n2] = false;
                        return;
                    }
                    this.PowerFailureL[n] = null;
                    this.getFailureLow(n);
                    this.fireTableRowsUpdated(0, this.numLines - 1);
                    return;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (ClassCastException classCastException) {
            db.severe(classCastException.toString());
            return;
        }
        this.isDirty[n][n2] = bl ? !this.isDirty[n][n2] : true;
        this.fireTableCellUpdated(n, n2);
    }

    protected String getPortDescription(int n) throws AbstractCmsNoSuchEntityException {
        String string;
        Object object;
        try {
            object = this.model[n].getPortModel();
            string = PortHelper.getPortNumString((IPortModel)object);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            db.info("Anticipated exception in getPortDescription: " + (Object)((Object)abstractCmsNoSuchEntityException));
            string = String.valueOf(n + 1);
        }
        object = this.model[n].getParserName().getPortName();
        String string2 = this.model[n].getParserName().getSlotNum();
        String string3 = ((String)object).startsWith("FAC") ? ((String)object).substring(0, 4) + string2 + "-" + ((String)object).substring(4, ((String)object).length()) : ((String)object).substring(0, 5) + string2 + "-" + ((String)object).substring(5, ((String)object).length());
        return string + " " + string3 + this.getPortDescriptionFor(n).substring(string.length());
    }

    protected String getPowerHigh(int n) {
        int n2 = -1000000;
        this.refreshThresholds(n);
        this.refreshAlarmThresholds(n);
        if (this.PowerH[n] == null) {
            this.Flg_FeatureUnsupported[n] = true;
            try {
                switch (this.thresholdLayer) {
                    case 0: {
                        n2 = this.model[n].getOpticsTCAPowerHigh(eIntervalType.INTERVAL_15_MIN);
                        break;
                    }
                    case 1: {
                        n2 = this.model[n].getOpticsTCAPowerHigh(eIntervalType.INTERVAL_DAY);
                    }
                }
                this.PowerH[n] = new Integer(n2).toString();
                if (n2 == -1000000) {
                    this.PowerH[n] = "N/A";
                    this.Flg_FeatureUnsupported[n] = false;
                    return this.PowerH[n];
                }
                this.numChars = this.PowerH[n].startsWith("-") ? 2 : 1;
                this.PowerH[n] = this.PowerH[n].length() > this.numChars ? this.PowerH[n].substring(0, this.PowerH[n].length() - 1) + "." + this.PowerH[n].substring(this.PowerH[n].length() - 1) : (this.numChars == 2 ? this.PowerH[n].substring(0, 1) + "0." + this.PowerH[n].substring(1, this.PowerH[n].length()) : "0." + this.PowerH[n]);
            }
            catch (Exception exception) {
                this.PowerH[n] = "N/A";
                this.Flg_FeatureUnsupported[n] = false;
                return "N/A";
            }
        }
        return this.PowerH[n];
    }

    protected String getPowerLow(int n) {
        int n2 = 0;
        this.refreshThresholds(n);
        this.refreshAlarmThresholds(n);
        if (this.PowerL[n] == null) {
            this.Flg_FeatureUnsupported[n] = true;
            try {
                switch (this.thresholdLayer) {
                    case 0: {
                        n2 = this.model[n].getOpticsTCAPowerLow(eIntervalType.INTERVAL_15_MIN);
                        break;
                    }
                    case 1: {
                        n2 = this.model[n].getOpticsTCAPowerLow(eIntervalType.INTERVAL_DAY);
                    }
                }
                this.PowerL[n] = new Integer(n2).toString();
                if (n2 == -1000000) {
                    this.PowerL[n] = "N/A";
                    this.Flg_FeatureUnsupported[n] = false;
                    return this.PowerL[n];
                }
                this.numChars = this.PowerL[n].startsWith("-") ? 2 : 1;
                this.PowerL[n] = this.PowerL[n].length() > this.numChars ? this.PowerL[n].substring(0, this.PowerL[n].length() - 1) + "." + this.PowerL[n].substring(this.PowerL[n].length() - 1) : (this.numChars == 2 ? this.PowerL[n].substring(0, 1) + "0." + this.PowerL[n].substring(1, this.PowerL[n].length()) : "0." + this.PowerL[n]);
            }
            catch (Exception exception) {
                this.PowerL[n] = "N/A";
                this.Flg_FeatureUnsupported[n] = false;
                return "N/A";
            }
        }
        return this.PowerL[n];
    }

    protected String getFailureLow(int n) {
        this.refreshThresholds(n);
        this.refreshAlarmThresholds(n);
        if (this.PowerFailureL[n] == null) {
            this.Flg_FeatureUnsupported[n] = true;
            try {
                int n2 = this.model[n].getOpticsAlmPowerThresholdFailLow();
                this.PowerFailureL[n] = new Integer(n2).toString();
                if (n2 == -1000000) {
                    this.PowerFailureL[n] = "N/A";
                    this.Flg_FeatureUnsupported[n] = false;
                    return this.PowerFailureL[n];
                }
                this.numChars = this.PowerFailureL[n].startsWith("-") ? 2 : 1;
                this.PowerFailureL[n] = this.PowerFailureL[n].length() > this.numChars ? this.PowerFailureL[n].substring(0, this.PowerFailureL[n].length() - 1) + "." + this.PowerFailureL[n].substring(this.PowerFailureL[n].length() - 1) : (this.numChars == 2 ? this.PowerFailureL[n].substring(0, 1) + "0." + this.PowerFailureL[n].substring(1, this.PowerFailureL[n].length()) : "0." + this.PowerFailureL[n]);
            }
            catch (Exception exception) {
                this.PowerFailureL[n] = "N/A";
                this.Flg_FeatureUnsupported[n] = false;
                return "N/A";
            }
        }
        return this.PowerFailureL[n];
    }

    protected String getPowerDegradeH(int n) {
        try {
            int n2 = this.model[n].getOpticsAlmPowerThresholdDegradeHigh();
            String string = new Integer(n2).toString();
            if (n2 == -1000000) {
                return "N/A";
            }
            this.numChars = string.startsWith("-") ? 2 : 1;
            string = string.length() > this.numChars ? string.substring(0, string.length() - 1) + "." + string.substring(string.length() - 1) : (this.numChars == 2 ? string.substring(0, 1) + "0." + string.substring(1, string.length()) : "0." + string);
            return string;
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    protected String getPowerDegradeL(int n) {
        try {
            int n2 = this.model[n].getOpticsAlmPowerThresholdDegradeLow();
            String string = new Integer(n2).toString();
            if (n2 == -1000000) {
                return "N/A";
            }
            this.numChars = string.startsWith("-") ? 2 : 1;
            string = string.length() > this.numChars ? string.substring(0, string.length() - 1) + "." + string.substring(string.length() - 1) : (this.numChars == 2 ? string.substring(0, 1) + "0." + string.substring(1, string.length()) : "0." + string);
            return string;
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    protected String getVOADegradeH(int n) {
        try {
            int n2 = this.model[n].getOpticsAlmVOAThresholdDegradeHigh();
            String string = new Integer(n2).toString();
            if (n2 == -1000000) {
                return "N/A";
            }
            this.numChars = string.startsWith("-") ? 2 : 1;
            string = string.length() > this.numChars ? string.substring(0, string.length() - 1) + "." + string.substring(string.length() - 1) : (this.numChars == 2 ? string.substring(0, 1) + "0." + string.substring(1, string.length()) : "0." + string);
            return string;
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    protected String getVOADegradeL(int n) {
        try {
            String string = new Integer(this.model[n].getOpticsAlmVOAThresholdDegradeLow()).toString();
            int n2 = this.model[n].getOpticsAlmVOAThresholdDegradeLow();
            string = new Integer(n2).toString();
            if (n2 == -1000000) {
                return "N/A";
            }
            this.numChars = string.startsWith("-") ? 2 : 1;
            string = string.length() > this.numChars ? string.substring(0, string.length() - 1) + "." + string.substring(string.length() - 1) : (this.numChars == 2 ? string.substring(0, 1) + "0." + string.substring(1, string.length()) : "0." + string);
            return string;
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    protected String getVOAFailureL(int n) {
        try {
            String string = new Integer(this.model[n].getOpticsAlmVOAThresholdFailLow()).toString();
            int n2 = this.model[n].getOpticsAlmVOAThresholdFailLow();
            string = new Integer(n2).toString();
            if (n2 == -1000000) {
                return "N/A";
            }
            this.numChars = string.startsWith("-") ? 2 : 1;
            string = string.length() > this.numChars ? string.substring(0, string.length() - 1) + "." + string.substring(string.length() - 1) : (this.numChars == 2 ? string.substring(0, 1) + "0." + string.substring(1, string.length()) : "0." + string);
            return string;
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    protected void refreshThresholds(int n) {
        if (this.thresholdsVal[n] == null) {
            try {
                switch (this.thresholdLayer) {
                    case 0: {
                        this.thresholdsVal[n] = this.model[n].getOpticsTCAThresholds(eIntervalType.INTERVAL_15_MIN);
                        break;
                    }
                    case 1: {
                        this.thresholdsVal[n] = this.model[n].getOpticsTCAThresholds(eIntervalType.INTERVAL_DAY);
                    }
                }
                db.info("Thresholds val got for line " + n);
            }
            catch (Exception exception) {
                db.info("Anticipated exception in refreshThresholds, line " + n + ": " + exception);
            }
        }
    }

    protected void refreshAlarmThresholds(int n) {
        if (this.AlmThresholdsVal[n] == null) {
            try {
                this.AlmThresholdsVal[n] = this.model[n].getOpticsAlmThresholds();
                if (db.on()) {
                    db.info("Alarm Thresholds val got for line " + n);
                }
            }
            catch (Exception exception) {
                db.info("Anticipated Exception in refreshAlarmThresholds, line " + n + ": " + exception);
            }
        }
    }

    private int getIndexOf(Object object, Object[] objectArray) {
        List<Object> list = Arrays.asList(objectArray);
        return list.indexOf(object);
    }

    private int unsignedShortToInt(short s) {
        int n = s & 0xFFFF;
        return n;
    }

    private void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshFromModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            this.refreshLineFromModel(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshLineFromModel(int n) throws Exception, xFeatureUnsupported {
        if (n > this.numLines || n < 0) {
            db.severe("Invalid lineNo for refresh " + n);
            return;
        }
        this.resetLineCache(n);
        try {
            switch (this.thresholdLayer) {
                case 0: {
                    this.thresholdsVal[n] = this.model[n].getOpticsTCAThresholds(eIntervalType.INTERVAL_15_MIN);
                    break;
                }
                case 1: {
                    this.thresholdsVal[n] = this.model[n].getOpticsTCAThresholds(eIntervalType.INTERVAL_DAY);
                    break;
                }
                case 2: {
                    this.AlmThresholdsVal[n] = this.model[n].getOpticsAlmThresholds();
                }
            }
        }
        catch (Exception exception) {
            db.info("Anticipated exception, line " + n + ": " + exception);
        }
        this.fireTableRowsUpdated(n, n);
    }

    protected void resetLineCache(int n) {
        this.portNames[n] = null;
        this.thresholdsVal[n] = null;
        this.AlmThresholdsVal[n] = null;
        this.PowerH[n] = null;
        this.PowerL[n] = null;
        this.PowerFailureL[n] = null;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public void applyToModel() throws Exception {
        db.info("applyToModel");
        int n = 0;
        try {
            if (CerentDialog.yesNoDialog((Component)this.getFrame(), (String)"Selected operation could be service affecting. Apply changes anyway?", (String)"Confirmation Dialog")) {
                block8: for (n = 0; n < this.numLines; ++n) {
                    if (!this.isRowDirty(n)) continue;
                    switch (this.thresholdLayer) {
                        case 0: {
                            this.model[n].setOpticsTCAThresholds(this.thresholdsVal[n], eIntervalType.INTERVAL_15_MIN);
                            continue block8;
                        }
                        case 1: {
                            this.model[n].setOpticsTCAThresholds(this.thresholdsVal[n], eIntervalType.INTERVAL_DAY);
                            continue block8;
                        }
                        case 2: {
                            this.model[n].setOpticsAlmThresholds(this.AlmThresholdsVal[n]);
                        }
                    }
                }
            }
            this.resetDirtyBits();
        }
        catch (ConfigError configError) {
            ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_ACTION_NOTALLOWED);
            this.refreshFromModel();
        }
        catch (Exception exception) {
            this.refreshFromModel();
        }
    }

    public static boolean isValidNumber(String string, String string2) {
        try {
            Float.valueOf(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static int ValPerTen(String string) {
        float f = Float.parseFloat(string);
        int n = (int)(f *= 10.0f);
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

