/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.oadm;

import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsAmplifiedLineModel;
import cerent.cms.model.OpticsChannelModel;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsMultiplexSectionModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.oadm.OadmOCHPmPane;
import cerent.cms.ui.oadm.OadmOMSPmPane;
import cerent.cms.ui.oadm.OadmOTSPmPane;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.GridLayout;

public class OadmPerfPane
extends AbstractPane
implements ITabName {
    ModuleModel eqpmtModel = null;
    private OpticsModuleModel model;
    private OpticsAmplifiedLineModel[] ampLineModels;
    private OpticsChannelModel[] chModels;
    private OpticsMultiplexSectionModel[] omsModels;
    private OpticsLineModel[] otsModels;
    private static final SDebug db = new SDebug("OadmPerfPane");

    public OadmPerfPane(String string, TabbedView tabbedView, ModuleModel moduleModel) {
        super(string, tabbedView);
        this.eqpmtModel = moduleModel;
        this.model = (OpticsModuleModel)this.getUiModel();
        this.ampLineModels = this.model.getOpticsAmplifiedLineModels();
        this.chModels = this.model.getOpticsChannelModels();
        this.omsModels = this.model.getOpticsOMSModels();
        this.otsModels = this.model.getOpticsLineModels();
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.model.getNodeModel();
        this.subTabs = new SubTabbedView(moduleModel, tabbedView);
        this.subTabs.addTab("Optical Line", (Component)this.getOptOtsPMTab(this.otsModels));
        if (134 == moduleModel.getEqType() || 135 == moduleModel.getEqType() || 136 == moduleModel.getEqType()) {
            this.subTabs.addTab("Optical Chn", (Component)this.getOptOchPMTab(this.chModels));
        } else {
            this.subTabs.addTab("Optical Band", (Component)this.getOptOmsPMTab(this.omsModels));
        }
        this.subTabs.setTabPlacement(2);
        this.setLayout(new GridLayout(1, 1));
        this.add((Component)this.subTabs);
    }

    protected Pane getPmOtsTabs(TabbedView tabbedView, OpticsLineModel[] opticsLineModelArray) {
        return new OadmOtsPmPane(tabbedView, opticsLineModelArray);
    }

    protected Pane getPmOchTabs(TabbedView tabbedView, OpticsChannelModel[] opticsChannelModelArray) {
        return new OadmOchPmPane(tabbedView, opticsChannelModelArray);
    }

    protected Pane getPmOmsTabs(TabbedView tabbedView, OpticsMultiplexSectionModel[] opticsMultiplexSectionModelArray) {
        return new OadmOmsPmPane(tabbedView, opticsMultiplexSectionModelArray);
    }

    protected Pane getOptOtsPMTab(OpticsLineModel[] opticsLineModelArray) {
        return new OadmOTSPmPane("Optics PM", this.getParentView());
    }

    protected Pane getOptOchPMTab(OpticsChannelModel[] opticsChannelModelArray) {
        return new OadmOCHPmPane("Optics PM", this.getParentView());
    }

    protected Pane getOptOmsPMTab(OpticsMultiplexSectionModel[] opticsMultiplexSectionModelArray) {
        return new OadmOMSPmPane("Optics PM", this.getParentView());
    }

    public boolean hasSubTabs() {
        return true;
    }

    public void refresh() {
    }

    public void enteringPage() throws Exception {
    }

    public void leavingPage() throws Exception {
    }

    private class OadmOmsPmPane
    extends AbstractPane {
        public OadmOmsPmPane(TabbedView tabbedView, OpticsMultiplexSectionModel[] opticsMultiplexSectionModelArray) {
            super("OadmOMSPmPane", tabbedView);
            this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
            this.subTabs.addTab("Optics PM", (Component)OadmPerfPane.this.getOptOmsPMTab(opticsMultiplexSectionModelArray));
            this.setLayout(new GridLayout(1, 1));
            this.add((Component)this.subTabs);
        }

        public boolean hasSubTabs() {
            return true;
        }

        public void refresh() {
        }

        public void enteringPage() throws Exception {
        }

        public void leavingPage() throws Exception {
        }
    }

    private class OadmOchPmPane
    extends AbstractPane {
        public OadmOchPmPane(TabbedView tabbedView, OpticsChannelModel[] opticsChannelModelArray) {
            super("OadmOCHPmPane", tabbedView);
            this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
            this.subTabs.addTab("Optics PM", (Component)OadmPerfPane.this.getOptOchPMTab(opticsChannelModelArray));
            this.setLayout(new GridLayout(1, 1));
            this.add((Component)this.subTabs);
        }

        public boolean hasSubTabs() {
            return true;
        }

        public void refresh() {
        }

        public void enteringPage() throws Exception {
        }

        public void leavingPage() throws Exception {
        }
    }

    private class OadmOtsPmPane
    extends AbstractPane {
        public OadmOtsPmPane(TabbedView tabbedView, OpticsLineModel[] opticsLineModelArray) {
            super("OadmOTSPmPane", tabbedView);
            this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
            this.subTabs.addTab("Optics PM", (Component)OadmPerfPane.this.getOptOtsPMTab(opticsLineModelArray));
            this.setLayout(new GridLayout(1, 1));
            this.add((Component)this.subTabs);
        }

        public boolean hasSubTabs() {
            return true;
        }

        public void refresh() {
        }

        public void enteringPage() throws Exception {
        }

        public void leavingPage() throws Exception {
        }
    }
}

