/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.oadm;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.Frame;
import javax.swing.table.AbstractTableModel;

public abstract class OpticalTableModel
extends AbstractTableModel {
    protected AbstractOpticsLineModel[] model;
    protected int numLines;
    protected EntityCellRenderer myPortRenderer;
    protected String[] portNames;
    protected ModuleModel eqpmtModel;
    protected final String[] statusStrings;
    private TDMTerminology _terms;
    private final SDebug db;

    protected OpticalTableModel(SDebug sDebug, AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        this.db = sDebug;
        this.model = abstractOpticsLineModelArray;
        this.numLines = abstractOpticsLineModelArray.length;
        this.myPortRenderer = new EntityCellRenderer(false);
        this.portNames = new String[this.numLines];
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)abstractOpticsLineModelArray[0].getNodeModel();
        this._terms = nodeModelDelegate.getTDMTerminology();
        this.statusStrings = new String[]{AdminState.getAdminTermIS(this._terms), AdminState.getAdminTermDSBLD(this._terms), AdminState.getAdminTermMT(this._terms), AdminState.getAdminTermAINS(this._terms)};
        try {
            this.eqpmtModel = abstractOpticsLineModelArray[0].getModuleModel();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    protected Frame getFrame() {
        return this.eqpmtModel.getNodeModel().getUiToolkit().getApplicationFrame();
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        IPortModel iPortModel = this.model[n].getPortModel();
        return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
    }

    protected Attribute getAttributeFor(String string, int n) {
        return ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeForVal(string, n);
    }

    protected String getPortName(int n) {
        if (this.portNames[n] == null) {
            try {
                this.portNames[n] = this.model[n].getAlias();
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return this.portNames[n];
    }

    protected boolean isUserAuthorized(SecurityLevel securityLevel) {
        return this.model != null && this.numLines > 0 && AbstractPane.isUserAuthorized(this.model[0], securityLevel);
    }

    protected TDMTerminology getTerms() {
        return this._terms;
    }

    public String[] getStatusStrings() {
        return this.statusStrings;
    }
}

