/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.pm;

import cerent.cms.idl.Common.sPmStat;
import cerent.cms.idl.Common.sPmStatRatio;
import cerent.cms.idl.SonetMedia.sLineStats;
import cerent.cms.idl.SonetMedia.sSectionStats;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmLineStats;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmRendererStat;
import cerent.cms.ui.PmRendererStatRatio;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.pm.PmLayer;

public class PmLayerE4Line
extends PmLayer {
    protected sLineStats[] lineStatsVal;
    protected TdmLineModel model = null;
    protected int numParms;
    protected int numRegisters;
    protected sSectionStats[] sectionStatsVal;
    public static String[] parmNames = new String[]{"E4 L-ES", "E4 L-ESR", "E4 L-SES", "E4 L-SESR", "E4 L-BBE", "E4 L-BBER", "E4 L-UAS", "E4 L-CV"};
    public static final int E4_ES_L_INDEX = 0;
    public static final int E4_ESR_L_INDEX = 1;
    public static final int E4_SES_L_INDEX = 2;
    public static final int E4_SESR_L_INDEX = 3;
    public static final int E4_BBE_L_INDEX = 4;
    public static final int E4_BBER_L_INDEX = 5;
    public static final int E4_UAS_L_INDEX = 6;
    public static final int E4_CV_L_INDEX = 7;
    private static final sSectionStats _defaultSectionStats = new sSectionStats(PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID);
    private static final sLineStats _defaultLineStats = new sLineStats(PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID);

    public PmLayerE4Line(PmTableModel pmTableModel, TdmLineModel tdmLineModel, int n, boolean bl) {
        super(pmTableModel, tdmLineModel, bl);
        this.model = tdmLineModel;
        this.numRegisters = n;
        this.numParms = parmNames.length;
        this.sectionStatsVal = new sSectionStats[n];
        this.lineStatsVal = new sLineStats[n];
        for (int i = 0; i < n; ++i) {
            this.sectionStatsVal[i] = null;
            this.lineStatsVal[i] = null;
        }
    }

    public PmLayerE4Line(PmTableModel pmTableModel, TdmLineModel tdmLineModel, int n) {
        this(pmTableModel, tdmLineModel, n, true);
    }

    public void clearStats() {
        try {
            this.model.clearStats(this.nearEnd, this.intervalType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException);
        }
        catch (InternalCommError internalCommError) {
            System.err.println((Object)internalCommError);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public String layerLabel() {
        String string = "E4";
        return string;
    }

    public void tossData() {
        for (int i = 0; i < this.numRegisters; ++i) {
            this.sectionStatsVal[i] = null;
            this.lineStatsVal[i] = null;
        }
    }

    public String parmName(int n) {
        return parmNames[n];
    }

    public int parmCount() {
        return parmNames.length;
    }

    public Object getPmValue(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        sPmStat sPmStat2 = PM_STATS_INVALID;
        sPmStatRatio sPmStatRatio2 = PM_STATS_RATIO_INVALID;
        boolean bl = false;
        this.refreshPmStats(n2);
        switch (n) {
            case 0: {
                if (!this.nearEnd) break;
                sPmStat2 = this.lineStatsVal[n2].es;
                break;
            }
            case 1: {
                if (!this.nearEnd) break;
                bl = true;
                sPmStatRatio2 = this.lineStatsVal[n2].esr;
                break;
            }
            case 2: {
                if (!this.nearEnd) break;
                sPmStat2 = this.lineStatsVal[n2].ses;
                break;
            }
            case 3: {
                if (!this.nearEnd) break;
                bl = true;
                sPmStatRatio2 = this.lineStatsVal[n2].sesr;
                break;
            }
            case 4: {
                if (!this.nearEnd) break;
                sPmStat2 = this.lineStatsVal[n2].bbe;
                break;
            }
            case 5: {
                if (!this.nearEnd) break;
                bl = true;
                sPmStatRatio2 = this.lineStatsVal[n2].bber;
                break;
            }
            case 6: {
                if (!this.nearEnd) break;
                sPmStat2 = this.lineStatsVal[n2].uas;
                break;
            }
            case 7: {
                if (!this.nearEnd) break;
                sPmStat2 = this.lineStatsVal[n2].cv;
                break;
            }
        }
        if (bl) {
            if (sPmStatRatio2.cnt == -1) {
                return null;
            }
            return new PmRendererStatRatio(sPmStatRatio2);
        }
        if (sPmStat2.cnt == -1) {
            return null;
        }
        return new PmRendererStat(sPmStat2);
    }

    public void setModel(InterfaceModel interfaceModel) {
        this.model = (TdmLineModel)interfaceModel;
    }

    public void refreshPmStats(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        if (this.sectionStatsVal[n] == null || this.lineStatsVal[n] == null || this.sectionStatsVal[n] == _defaultSectionStats || this.lineStatsVal[n] == _defaultLineStats) {
            this.sectionStatsVal[n] = _defaultSectionStats;
            this.lineStatsVal[n] = _defaultLineStats;
            TdmLineStats tdmLineStats = this.model.getStats(this.nearEnd, this.intervalType, (short)n);
            this.sectionStatsVal[n] = tdmLineStats.sectionStats;
            this.lineStatsVal[n] = tdmLineStats.lineStats;
        }
    }
}

