/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.rmon;

import cerent.cms.idl.Rmon.sTimedStatsPair;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EventUtilities;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IRmonModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NoSuchStatsSeries;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.rmon.RmonPmUtilPane;
import cerent.util.SDebug;
import cerent.util.gui.IFixedColumnsTableModel;
import cerent.util.gui.TransmitReceive;
import javax.swing.table.AbstractTableModel;

public class RmonPmUtilTableModel
extends AbstractTableModel
implements IFixedColumnsTableModel {
    protected IRmonModel[] rmonModels;
    protected ModuleModel eqpmtModel;
    private int numLines;
    private boolean[] refresh;
    private int nCols;
    private sTimedStatsPair[][] txRxTimedStats;
    private RmonPmUtilPane parent;
    private String lastIntervalTimeStamp;
    private int fixedColumns;
    private EventUtilities eventUtilities;
    private boolean isG1000;
    private static final SDebug db = new SDebug("RmonPmUtilTableModel");
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$cerent$util$gui$TransmitReceive;

    public RmonPmUtilTableModel(RmonPmUtilPane rmonPmUtilPane, ModuleModel moduleModel, IRmonModel[] iRmonModelArray) {
        this.eqpmtModel = moduleModel;
        this.rmonModels = iRmonModelArray;
        this.parent = rmonPmUtilPane;
        int n = this.numLines = iRmonModelArray == null ? 0 : iRmonModelArray.length;
        if (moduleModel.getEqType() == 14 || moduleModel.getEqType() == 15) {
            this.fixedColumns = 2;
            this.isG1000 = false;
        } else {
            this.fixedColumns = 1;
            this.isG1000 = true;
        }
        this.refresh = new boolean[this.numLines];
        this.nCols = 0;
        this.lastIntervalTimeStamp = "";
        this.eventUtilities = EventUtilities.getInstance(moduleModel.getNodeModelDelegate());
    }

    public void refreshMyLines(IRmonModel[] iRmonModelArray) {
        this.rmonModels = iRmonModelArray;
        this.numLines = iRmonModelArray.length;
        this.refresh = new boolean[this.numLines];
        this.fireTableDataChanged();
    }

    public Object getValueAt(int n, int n2) {
        try {
            if (n2 < this.fixedColumns) {
                if (n2 == 0) {
                    return this.getPortName(this.rmonModels[n]);
                }
            } else if (this.refresh[n] && n2 < this.txRxTimedStats[n].length + this.fixedColumns) {
                return new TransmitReceive(this.txRxTimedStats[n][n2 - this.fixedColumns]);
            }
            return "";
        }
        catch (Exception exception) {
            db.println("Caught exception in getValueAt");
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    private String getPortName(IRmonModel iRmonModel) {
        String string = "?????";
        try {
            EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
            return entityCellRenderer.getPortString((IEntityModel)iRmonModel.getInterfaceModel().getPortModel(), false);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return string;
        }
    }

    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.fireTableRowsUpdated(n, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refresh(short s) throws NoSuchInterface, WrongInterfaceType, InternalCommError, NoSuchStatsSeries {
        block8: {
            int n;
            for (n = 0; n < this.rmonModels.length; ++n) {
                this.refresh[n] = false;
            }
            n = 0;
            if (this.nCols != ElementDefaults.getMaxBuckets(s)) {
                this.nCols = ElementDefaults.getMaxBuckets(s);
                n = 1;
            }
            this.txRxTimedStats = new sTimedStatsPair[this.rmonModels.length][];
            this.lastIntervalTimeStamp = "";
            try {
                for (int i = 0; i < this.rmonModels.length; ++i) {
                    try {
                        this.txRxTimedStats[i] = this.rmonModels[i].getTxRxUtilizationSeries(s);
                        this.refresh[i] = true;
                        if (this.lastIntervalTimeStamp.length() != 0 || this.txRxTimedStats[i].length <= 0) continue;
                        this.lastIntervalTimeStamp = this.eventUtilities.convertSecondsToLongDateFormat(this.txRxTimedStats[i][0].txStat.timeStamp);
                        continue;
                    }
                    catch (WrongInterfaceType wrongInterfaceType) {
                        // empty catch block
                    }
                }
                Object var6_5 = null;
                if (n == 0) break block8;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (n != 0) {
                    this.fireTableStructureChanged();
                    this.parent.fixedUpColumn();
                    throw throwable;
                }
                this.fireTableDataChanged();
                throw throwable;
            }
            this.fireTableStructureChanged();
            this.parent.fixedUpColumn();
            return;
        }
        this.fireTableDataChanged();
    }

    public String getLastIntervalTimeStamp() {
        return this.lastIntervalTimeStamp;
    }

    private sTimedStatsPair[] getTxRxLineUtilSeries(short s, int n) throws NoSuchStatsSeries, NoSuchInterface, WrongInterfaceType, InternalCommError {
        return this.rmonModels[n].getTxRxUtilizationSeries(s);
    }

    public Class getColumnClass(int n) {
        if (n <= 1) {
            if (!this.isG1000) {
                return class$java$lang$String == null ? (class$java$lang$String = RmonPmUtilTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
            if (n < 1) {
                return class$java$lang$String == null ? (class$java$lang$String = RmonPmUtilTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
            return class$cerent$util$gui$TransmitReceive == null ? (class$cerent$util$gui$TransmitReceive = RmonPmUtilTableModel.class$("cerent.util.gui.TransmitReceive")) : class$cerent$util$gui$TransmitReceive;
        }
        return class$cerent$util$gui$TransmitReceive == null ? (class$cerent$util$gui$TransmitReceive = RmonPmUtilTableModel.class$("cerent.util.gui.TransmitReceive")) : class$cerent$util$gui$TransmitReceive;
    }

    public int getColumnCount() {
        return this.getFixedColumnCount() + this.nCols;
    }

    public String getColumnName(int n) {
        if (n < this.fixedColumns) {
            return n == 0 ? "Port" : "Mode";
        }
        return ElementDefaults.PREV_60_COLUMN_NAMES[n - this.fixedColumns];
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getFixedColumnCount() {
        return this.fixedColumns;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

