/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IProgressManager;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.CardTabbedViewFactory;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.ShelfViewController;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.CardPanel;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public abstract class AbstractShelfLayout
extends JPanel {
    protected JPanel labelsPanel;
    protected JLabel[] labels;
    protected JPanel slotsPanel;
    protected CardPanel[] cards;
    protected CardPanel selectedCard = null;
    protected IUiToolkit uiToolkit = null;
    private int currentSelectionIndex;
    protected NodeModelDelegate nodeModel;
    protected ShelfViewController shelfVC;
    protected MouseClickProcessor mouseListener = new MouseClickProcessor();
    protected static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder();
    protected static final Border THIN_BORDER = BorderFactory.createLineBorder(Color.black, 1);
    protected static final Border SELECTED_BORDER = BorderFactory.createLineBorder(Color.black, 3);
    protected static final Color SELECTED_FOREGROUND_COLOR = Color.white;
    protected static final Color SELECTED_BACKGROUND_COLOR;
    protected static final Color UNSELECTED_FOREGROUND_COLOR;
    protected int chassisType;
    public static final SDebug db;

    public AbstractShelfLayout(NodeModelDelegate nodeModelDelegate, ShelfViewController shelfViewController, IUiToolkit iUiToolkit) {
        super(new GridBagLayout());
        this.nodeModel = nodeModelDelegate;
        this.shelfVC = shelfViewController;
        this.uiToolkit = iUiToolkit;
        this.chassisType = ((EntityModel)nodeModelDelegate.getChassis()).getEqType();
        this.cards = new CardPanel[this.getShelfSlotCount()];
        this.populateShelf();
        this.configSpecialModule();
    }

    protected abstract void addLabels();

    protected abstract void removeLabels();

    protected abstract void createLabels();

    protected abstract void createSlotsPanel();

    protected void createFanPanel() {
    }

    protected abstract void addPanels();

    protected abstract int getShelfSlotCount();

    protected abstract Font getTextFont();

    public void populateShelf() {
        EntityModel entityModel;
        Object object;
        Object object2;
        this.createLabels();
        this.createSlotsPanel();
        this.createFanPanel();
        this.addPanels();
        this.setBorder(BorderFactory.createLineBorder(Color.black, 2));
        for (int i = 0; i < this.cards.length; ++i) {
            object2 = this.cards[i].getIcon();
            object = new Dimension(object2.getIconWidth(), object2.getIconHeight());
            this.cards[i].setPreferredSize((Dimension)object);
            this.cards[i].setMinimumSize((Dimension)object);
            this.cards[i].setBorder(THIN_BORDER);
            this.cards[i].setFont(this.getTextFont());
            this.labels[i].setForeground(UNSELECTED_FOREGROUND_COLOR);
        }
        this.addLabels();
        if (this.selectedCard != null) {
            this.selectedCard.setBorder(SELECTED_BORDER);
        } else {
            AbstractViewController.setActiveObject(null);
        }
        if (db.on()) {
            db.println("fetching chassis");
        }
        if ((entityModel = (EntityModel)this.nodeModel.getChassis()) == null && db.on()) {
            db.println("no chassis found");
        }
        if (db.on()) {
            db.println("fetching backplanes");
        }
        if ((object2 = entityModel.getChildrenOfType(eClass.BACKPLANE)) == null && db.on()) {
            db.println("no backplanes found");
        }
        object = null;
        if (object2 != null && object2.size() > 0) {
            object = (EntityModel)object2.get(0);
        }
        if (object == null && db.on()) {
            db.println("no backplane found");
        }
        List list = null;
        if (object != null) {
            list = ((EntityModel)object).getChildren();
        }
        if (list == null && db.on()) {
            db.println("no slots found");
        }
        int n = list != null ? list.size() : this.getShelfSlotCount();
        IProgressManager iProgressManager = this.nodeModel.getProgressManager();
        iProgressManager.startStep("Slot Initialization");
        String string = " ";
        EntityModel entityModel2 = null;
        for (int i = 1; i <= n; ++i) {
            String string2 = "Empty";
            if (i == 10) {
                string = "";
            }
            if (list != null) {
                Object object3;
                List list2;
                if (db.on()) {
                    db.println("model exists for slot " + i);
                }
                if ((list2 = (entityModel2 = (EntityModel)list.get(i - 1)).getChildren()).size() > 0 && (object3 = list2.get(0)) instanceof ModuleModel) {
                    ModuleModel moduleModel = (ModuleModel)object3;
                    string2 = moduleModel.getEqTypeName();
                }
                if (db.on()) {
                    db.println("creating card for slot " + i);
                }
                object3 = this.nodeModel.getPlatform().createCard(entityModel2, this);
                this.addCard(i, (CardGraphic)object3, entityModel2);
            }
            iProgressManager.addStepInfo("Slot " + string + i + " --> " + string2);
        }
        this.repaint();
    }

    public void addCard(int n, CardGraphic cardGraphic, EntityModel entityModel) {
        if (this.validCardNumber(n)) {
            if (db.on()) {
                db.println("card number " + n + " card " + cardGraphic);
            }
            this.cards[--n].setEntityM(entityModel);
            this.cards[n].setIcon(cardGraphic);
            this.cards[n].repaint();
        }
    }

    public void removeCard(int n) {
        if (this.validCardNumber(n)) {
            this.cards[n - 1].setIcon(null);
        }
    }

    protected int getFirstRowSlotCount() {
        return this.cards.length;
    }

    private boolean validCardNumber(int n) {
        boolean bl;
        boolean bl2 = bl = n > 0 && n <= this.getShelfSlotCount();
        if (!bl && db.on()) {
            db.println("Invalid card ignored: " + n);
        }
        return bl;
    }

    public void refresh() {
        for (int i = 0; i < this.cards.length; ++i) {
            this.cards[i].repaint();
        }
        this.repaint();
    }

    public static JLabel formatLabel(JLabel jLabel) {
        if (jLabel != null) {
            jLabel.setForeground(Color.black);
        }
        return jLabel;
    }

    private void mousePressed(CardPanel cardPanel) {
        if (this.selectedCard != null) {
            this.selectedCard.setBorder(THIN_BORDER);
            this.labels[this.currentSelectionIndex].setOpaque(false);
            this.labels[this.currentSelectionIndex].setForeground(UNSELECTED_FOREGROUND_COLOR);
            this.labels[this.currentSelectionIndex].repaint();
        }
        this.currentSelectionIndex = 0;
        while (this.currentSelectionIndex < this.cards.length) {
            if (this.cards[this.currentSelectionIndex] == cardPanel) {
                this.selectedCard = cardPanel;
                this.selectedCard.setBorder(SELECTED_BORDER);
                this.selectedCard.repaint();
                this.labels[this.currentSelectionIndex].setOpaque(true);
                this.labels[this.currentSelectionIndex].setBackground(SELECTED_BACKGROUND_COLOR);
                this.labels[this.currentSelectionIndex].setForeground(SELECTED_FOREGROUND_COLOR);
                this.labels[this.currentSelectionIndex].repaint();
                EntityModel entityModel = cardPanel.getEntityModel();
                ModuleModel moduleModel = null;
                entityModel = this.cards[this.currentSelectionIndex].getEntityModel();
                if (entityModel.getChildren().size() > 0) {
                    moduleModel = (ModuleModel)entityModel.getChildren().get(0);
                }
                if (moduleModel != null) {
                    if (CardTabbedViewFactory.isCardViewAvailable(moduleModel)) {
                        AbstractViewController.setActiveObject((Object)cardPanel);
                    } else {
                        AbstractViewController.setActiveObject(null);
                    }
                } else {
                    AbstractViewController.setActiveObject(null);
                }
                return;
            }
            ++this.currentSelectionIndex;
        }
        this.currentSelectionIndex = 0;
        this.selectedCard = null;
    }

    public void destroy() {
        if (this.cards != null) {
            for (int i = 0; i < this.cards.length; ++i) {
                if (this.cards[i] == null) continue;
                this.cards[i].removeMouseListener(this.mouseListener);
                this.cards[i].destroy();
                this.cards[i] = null;
            }
            this.cards = null;
        }
        this.mouseListener = null;
        this.removeAll();
        if (this.selectedCard != null) {
            this.labels[this.currentSelectionIndex].setOpaque(false);
        }
        this.shelfVC = null;
        this.slotsPanel = null;
        this.uiToolkit = null;
        this.nodeModel = null;
    }

    public CardPanel getSelectedCard() {
        return this.selectedCard;
    }

    public ShelfViewController getViewController() {
        return this.shelfVC;
    }

    protected void configSpecialModule() {
        int n;
        for (int i = 0; i < this.cards.length; i += n) {
            CardPanel cardPanel = this.cards[i];
            cardPanel.setVisible(true);
            if (db.on()) {
                db.println("   slot#" + (i + 1) + " set visible true");
            }
            n = 1;
            if (!(cardPanel.getIcon() instanceof CardGraphic)) continue;
            n = ((CardGraphic)cardPanel.getIcon()).getSlotsOccupied();
            if (db.on() && n > 1) {
                db.println("   slot#" + (i + 1) + " width=" + n);
            }
            for (int j = 1; j < n; ++j) {
                this.cards[i + j].setVisible(false);
                if (!db.on()) continue;
                db.println("   slot#" + (i + j + 1) + " set visible false");
            }
        }
        this.repaint();
    }

    static {
        UNSELECTED_FOREGROUND_COLOR = SELECTED_BACKGROUND_COLOR = Color.black;
        db = new SDebug("ShelfLayout");
    }

    private class MouseClickProcessor
    extends MouseAdapter {
        private MouseClickProcessor() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() instanceof CardPanel) {
                AbstractShelfLayout.this.mousePressed((CardPanel)mouseEvent.getSource());
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object instanceof CardPanel) {
                Icon icon = ((CardPanel)object).getIcon();
                if ((mouseEvent.getModifiers() & 4) != 0) {
                    if (icon instanceof CardGraphic) {
                        ((CardGraphic)icon).rightMouseClicked(mouseEvent.getPoint(), (CardPanel)object);
                    }
                } else if ((mouseEvent.getModifiers() & 0x10) != 0 && mouseEvent.getClickCount() == 2 && icon instanceof CardGraphic) {
                    ((CardGraphic)icon).openCard();
                }
            }
        }
    }
}

