/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfMaintenancePane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.SuffixAwareFileFilter;
import cerent.util.gui.UFileChooser;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobListener;
import cerent.util.job.IJobProgressControl;
import cerent.util.job.JobController;
import cerent.util.job.JobControllerFactory;
import cerent.util.job.JobGroup;
import cerent.util.job.JobProgressDialog;
import cerent.util.job.JobStatus;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public abstract class AbstractSmpDiagnosticPane
extends AbstractPane
implements ActionListener,
IJobListener {
    protected static File oldDir = null;
    protected static final String DIAGNOSTIC_TT = "Request a diagnostic file from the ";
    protected JButton diagnosticButton;
    protected JobProgressDialog progressDlg;
    protected static final SDebug db = new SDebug((KDebug)AbstractShelfMaintenancePane.db, "SmpDiagnosticPane");
    protected NodeModelDelegate nodeModel;

    public AbstractSmpDiagnosticPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.MAINTENANCE);
        this.nodeModel = (NodeModelDelegate)this.getUiModel();
    }

    protected void init() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        UFileChooser uFileChooser = new UFileChooser();
        SuffixAwareFileFilter suffixAwareFileFilter = new SuffixAwareFileFilter("Tech Support Logs", "ctc");
        uFileChooser.setAcceptAllFileFilterUsed(false);
        uFileChooser.setFileFilter((FileFilter)suffixAwareFileFilter);
        uFileChooser.setDialogTitle("Save");
        if (oldDir != null) {
            uFileChooser.setCurrentDirectory(oldDir);
        }
        if ((n = uFileChooser.showSaveDialog((Component)((Object)this))) != 0) {
            uFileChooser.dispose();
            return;
        }
        oldDir = uFileChooser.getCurrentDirectory();
        File file = new File(oldDir.getAbsolutePath(), uFileChooser.getName(uFileChooser.getSelectedFile()));
        String string = file.getAbsolutePath();
        if (db.on()) {
            db.println("diagFile.exists(): " + file.exists());
        }
        if (file.exists() && !CerentDialog.yesNoDialog((Component)((Object)this), (String)("The file " + string + " already exists.\nDo you want to replace it?"), (String)"Retrieving Tech Support Log")) {
            uFileChooser.dispose();
            return;
        }
        uFileChooser.dispose();
        this.getDiagnostics(this.nodeModel, string);
    }

    private void getDiagnostics(NodeModelDelegate nodeModelDelegate, String string) {
        block2: {
            this.diagnosticButton.setEnabled(false);
            try {
                this.progressDlg = new JobProgressDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), "Retrieve Tech Support Log", "Retrieving log...", false, true);
                JobController jobController = JobControllerFactory.createJC((int)1);
                IJobControl iJobControl = nodeModelDelegate.createDataTransferJob(string, 6, (IJobProgressControl)this.progressDlg);
                this.progressDlg.setJob(iJobControl);
                this.progressDlg.setProgressText(nodeModelDelegate.getName() + ": Retrieving log...");
                jobController.submitJob(new JobGroup(iJobControl, (IJobListener)this, (Object)jobController));
            }
            catch (Exception exception) {
                this.enableComponent(this.diagnosticButton);
                if (!AbstractSmpDiagnosticPane.db.on) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void jobWaiting(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
    }

    public void jobRunning(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
    }

    public void jobFinished(JobGroup jobGroup, IJobControl iJobControl, final JobStatus jobStatus, final Object object) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AbstractSmpDiagnosticPane.this.finishJob(jobStatus, (JobController)object);
            }
        });
    }

    private void finishJob(JobStatus jobStatus, JobController jobController) {
        String string = this.progressDlg.getTitle();
        this.progressDlg.dispose();
        this.progressDlg = null;
        if (jobStatus.value() == 3) {
            CerentDialog.infoDialog((Component)((Object)this), (String)(string + " aborted"), (String)string);
        } else if (jobStatus.value() == 2) {
            Exception exception = (Exception)jobStatus.getResult();
            if (exception != null) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_JOB_FAIL_EXCEPTION_PARAM_1, (Object)exception.getClass().getName());
            }
        } else {
            CerentDialog.infoDialog((Component)((Object)this), (String)(string + " complete"), (String)string);
        }
        this.enableComponent(this.diagnosticButton);
        if (jobController != null && jobController.isIdle()) {
            JobControllerFactory.disposeJC((JobController)jobController);
        }
    }

    public void enteringPage() {
    }

    public void leavingPage() throws Exception {
    }

    public void refresh() {
    }
}

