/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractTermConnectionModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.Busy;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOhTermModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InvalidLoopbackProvision;
import cerent.cms.model.InvalidState;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoLanAccess;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OhTermModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SyncProvError;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.shelf.AbstractTermCreationDialog;
import cerent.util.AnnotatedException;
import cerent.util.ComparisonUtil;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.IpSubnet;
import cerent.util.PluralisationUtil;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DetailedDialog;
import cerent.util.gui.UDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.UTableSorter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public abstract class AbstractTermPane
extends AbstractPane
implements ActionListener,
ListSelectionListener,
TableModelListener {
    protected static final String SDCC_TERM = "SDCC";
    protected static final String LDCC_TERM = "LDCC";
    protected static final String GCC_TERM = "GCC";
    protected static final String OSC_TERM = "OSC";
    protected JButton createPB;
    protected JButton deletePB;
    protected JButton editPB;
    protected AbstractTermConnectionModel connTableModel;
    protected OhTermTableModel tableModel;
    protected UTableSorter tableSorter;
    protected ArrayList tableDataList;
    protected static final EntityCellRenderer entityCellRenderer = new EntityCellRenderer("slot ");
    protected final Comparator termComparator;
    private boolean inited = false;
    private final String ohTermType;
    private HashMap lineModels;
    private HashMap protectLineModels;
    protected TDMTerminology terms;
    protected static final String CK_IMG_PATH = "/images/check_blue.gif";
    protected final ImageIcon CK_IMG = new ImageIcon(this.getClass().getResource("/images/check_blue.gif"));
    protected final SDebug db;

    protected AbstractTermPane(String string, AbstractTermConnectionModel abstractTermConnectionModel, SDebug sDebug) {
        super(string, abstractTermConnectionModel, null);
        this.db = sDebug;
        this.termComparator = this.createComparator();
        this.connTableModel = abstractTermConnectionModel;
        this.ohTermType = this.getOhTermType();
        this.terms = abstractTermConnectionModel.getNodeModel().getTDMTerminology();
        this.lineModels = new HashMap();
        this.protectLineModels = new HashMap();
    }

    protected abstract AbstractTermCreationDialog getOhTermCreationDialog();

    protected abstract String getOhTermType();

    protected void prepareColumns() {
        OhTermPaneRenderer ohTermPaneRenderer = new OhTermPaneRenderer();
        TableColumn tableColumn = null;
        block8: for (int i = 0; i < this.tableSorter.getColumnCount(); ++i) {
            tableColumn = this.table.getColumn(this.tableSorter.getColumnName(i));
            tableColumn.setCellRenderer(ohTermPaneRenderer);
            switch (i) {
                case 0: {
                    tableColumn.setPreferredWidth(160);
                    continue block8;
                }
                case 1: {
                    tableColumn.setPreferredWidth(140);
                    continue block8;
                }
                case 2: {
                    tableColumn.setPreferredWidth(50);
                    continue block8;
                }
                case 3: {
                    tableColumn.setPreferredWidth(110);
                    continue block8;
                }
                case 4: {
                    tableColumn.setPreferredWidth(270);
                    continue block8;
                }
                case 5: {
                    tableColumn.setPreferredWidth(80);
                }
            }
        }
    }

    protected Comparator createComparator() {
        return new OhTermComparator();
    }

    protected OhTermTableModel createTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new OhTermTableModel();
        }
        return this.tableModel;
    }

    protected void registerWithModels() {
        if (this.tableDataList != null) {
            Iterator iterator = this.tableDataList.iterator();
            while (iterator.hasNext()) {
                this.registerWithModel((OhTermModel)iterator.next());
            }
        }
    }

    protected void deregisterWithModels() {
        if (this.tableDataList != null) {
            Iterator iterator = this.tableDataList.iterator();
            while (iterator.hasNext()) {
                this.deregisterWithModel((OhTermModel)iterator.next());
            }
        }
    }

    protected void registerWithModel(OhTermModel ohTermModel) {
        if (ohTermModel != null) {
            ohTermModel.addObserver((Observer)((Object)this));
            PortModel portModel = (PortModel)ohTermModel.getOpticalPortModel();
            if (portModel != null) {
                InterfaceModel interfaceModel;
                PortModel portModel2;
                InterfaceModel interfaceModel2 = (InterfaceModel)portModel.getInterfaceModel();
                if (interfaceModel2 != null) {
                    interfaceModel2.addObserver((Observer)((Object)this));
                    this.lineModels.put(ohTermModel, interfaceModel2);
                }
                if ((portModel2 = AbstractTermPane.getProtectPort(portModel, this.db)) != null && (interfaceModel = (InterfaceModel)portModel2.getInterfaceModel()) != null) {
                    interfaceModel.addObserver((Observer)((Object)this));
                    this.protectLineModels.put(interfaceModel2, interfaceModel);
                }
            }
        }
    }

    protected void deregisterWithModel(OhTermModel ohTermModel) {
        if (ohTermModel != null) {
            ohTermModel.deleteObserver((Observer)((Object)this));
            InterfaceModel interfaceModel = (InterfaceModel)this.lineModels.remove(ohTermModel);
            if (interfaceModel != null) {
                interfaceModel.deleteObserver((Observer)((Object)this));
                InterfaceModel interfaceModel2 = (InterfaceModel)this.protectLineModels.remove(interfaceModel);
                if (interfaceModel2 != null) {
                    interfaceModel2.deleteObserver((Observer)((Object)this));
                }
            }
        }
    }

    protected void localDelete(OhTermModel ohTermModel) {
        int n = this.tableDataList.indexOf(ohTermModel);
        if (n != -1) {
            this.tableDataList.remove(n);
            this.tableSorter.fireTableRowsDeleted(n, n);
        }
        this.deregisterWithModel(ohTermModel);
        this.refreshTable();
    }

    protected void init() {
        this.setBorder(BorderFactory.createTitledBorder(this.ohTermType + " Terminations"));
        this.setLayout(new BorderLayout());
        this.tableDataList = new ArrayList();
        this.tableSorter = new UTableSorter((TableModel)this.createTableModel());
        this.table = new UTable((TableModel)this.tableSorter);
        this.tableSorter.setTableHeader(this.table.getTableHeader());
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(2);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.prepareColumns();
        this.tableSorter.addTableModelListener((TableModelListener)this);
        this.add((Component)new UScrollPane((Component)this.table), "Center");
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.add(this.getButtonBar(), "South");
        this.setEditDeleteEnabled(false);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        if (this.connTableModel != null) {
            this.connTableModel.addObserver((Observer)((Object)this));
        }
        this.inited = true;
    }

    public void dispose() {
        if (this.connTableModel != null) {
            this.connTableModel.deleteObserver((Observer)((Object)this));
        }
        this.deregisterWithModels();
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    protected JPanel getButtonBar() {
        INodeModel iNodeModel = this.connTableModel != null ? this.connTableModel.getNodeModel() : null;
        this.createPB = new JButton("Create...");
        this.createPB.addActionListener(this);
        this.enableComponent(this.createPB, (IModel)iNodeModel);
        this.editPB = new JButton("Edit...");
        this.editPB.addActionListener(this);
        this.enableComponent(this.editPB, (IModel)iNodeModel);
        this.deletePB = new JButton("Delete...");
        this.deletePB.addActionListener(this);
        this.enableComponent(this.deletePB, (IModel)iNodeModel);
        JPanel jPanel = AbstractTermPane.createHorizontalPanel(null);
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(this.getHelpID());
        cSHelpButtonPane.addLeft(this.createPB);
        cSHelpButtonPane.addLeft(this.editPB);
        cSHelpButtonPane.addLeft(this.deletePB);
        jPanel.add(cSHelpButtonPane);
        return jPanel;
    }

    protected void clearTableSelection() {
        if (this.table != null && !this.tableDataList.isEmpty()) {
            this.table.removeRowSelectionInterval(0, this.tableDataList.size() - 1);
        }
    }

    protected void setEditDeleteEnabled(boolean bl) {
        if (!bl) {
            this.clearTableSelection();
        } else if (!this.isUserAuthorized()) {
            bl = false;
        }
        int n = this.table.getSelectedRowCount();
        if (this.hasDuplicatedDcc()) {
            this.editPB.setEnabled(false);
            if (n == 1) {
                this.deletePB.setEnabled(bl);
                ErrorMsg.displayWarning((Component)((Object)this), (EID)EMC.WID_LDCC_SDCC_ON_SAME_PORT_PARAM_1, "Please remove one before edit.");
            } else {
                this.deletePB.setEnabled(false);
                ErrorMsg.displayWarning((Component)((Object)this), (EID)EMC.WID_LDCC_SDCC_ON_SAME_PORT_PARAM_1, "Please edit or remove one at a time.");
            }
        } else {
            this.deletePB.setEnabled(bl && n > 0);
            this.editPB.setEnabled(bl && n == 1);
        }
    }

    public void update(Observable observable, Object object) {
        super.update(observable, object);
        if (observable instanceof AbstractTermConnectionModel) {
            if (((Integer)object).equals(ModelUpdateType.ADDED)) {
                this.refresh();
            }
        } else if (observable instanceof OhTermModel) {
            if (((Integer)object).equals(ModelUpdateType.DELETED)) {
                this.localDelete((OhTermModel)((Object)observable));
            } else if (((Integer)object).equals(ModelUpdateType.CHANGED)) {
                this.refreshTable();
            }
        } else if (observable instanceof InterfaceModel && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            this.refreshTable();
        }
    }

    public void enteringPage() {
        if (!this.inited) {
            this.init();
        }
        this.refresh();
    }

    public void leavingPage() throws Exception {
    }

    public void refresh() {
        this.deregisterWithModels();
        IConnectionModel[] iConnectionModelArray = this.connTableModel.getTermModels();
        Arrays.sort(iConnectionModelArray, this.termComparator);
        this.tableDataList = new ArrayList<IConnectionModel>(Arrays.asList(iConnectionModelArray));
        this.registerWithModels();
        this.refreshTable();
    }

    protected void refreshTable() {
        this.tableSorter.fireTableDataChanged();
        int n = this.table.getSelectedRow();
        if (n < 0 || n > this.tableSorter.getRowCount()) {
            this.setEditDeleteEnabled(false);
        }
    }

    private boolean hasDuplicatedDcc() {
        int[] nArray = this.table.getSelectedRows();
        OhTermModel ohTermModel = null;
        EntityModel entityModel = null;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n >= this.tableDataList.size()) {
                return false;
            }
            ohTermModel = (OhTermModel)this.tableDataList.get(n);
            entityModel = (EntityModel)ohTermModel.getOpticalPortModel();
            if (!this.hasSdcc(entityModel) || !this.hasLdcc(entityModel)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSdcc(EntityModel entityModel) {
        return entityModel.getNodeModelDelegate().getDccTermConnectionModel().entityExistsInTerminations((IEntityModel)entityModel);
    }

    private boolean hasLdcc(EntityModel entityModel) {
        return entityModel.getNodeModelDelegate().getLdccTermConnectionModel().entityExistsInTerminations((IEntityModel)entityModel);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 0) {
            try {
                int n = this.tableSorter.getRowCount();
                boolean bl = n == 0;
                int n2 = this.table.getSelectedRow();
                if (n2 < 0 || n2 >= n) {
                    bl = true;
                }
                this.setEditDeleteEnabled(bl);
            }
            catch (Exception exception) {
                this.setEditDeleteEnabled(false);
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        this.setEditDeleteEnabled(!listSelectionModel.isSelectionEmpty());
    }

    protected static void maybeSetAdminState(PortModel portModel, int n, ArrayList arrayList, EntityCellRenderer entityCellRenderer, SDebug sDebug) {
        if (n != -1) {
            PortModel[] portModelArray = new PortModel[]{portModel, AbstractTermPane.getProtectPort(portModel, sDebug)};
            for (int i = 0; i < portModelArray.length && portModelArray[i] != null; ++i) {
                try {
                    boolean bl = portModelArray[i].maybeSetAdminState(n, 1, 0);
                    if (bl) continue;
                    AbstractTermPane.addFailureReason(EMC.EID_CANNOT_TRANSITION_STATE_INDIRECTLY, portModelArray[i], entityCellRenderer, arrayList);
                    continue;
                }
                catch (NoSuchInterface noSuchInterface) {
                    AbstractTermPane.addFailureReason(EMC.EID_NO_SUCHINTERFACE, portModel, entityCellRenderer, arrayList);
                    continue;
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    AbstractTermPane.addFailureReason(EMC.EID_UNSUPPORTED_OPERATION, portModel, entityCellRenderer, arrayList);
                    continue;
                }
                catch (InvalidLoopbackProvision invalidLoopbackProvision) {
                    AbstractTermPane.addFailureReason(EMC.EID_CANNOT_TRANSITION_STATE_WITH_LOOPBACK, portModel, entityCellRenderer, arrayList);
                    continue;
                }
                catch (SyncProvError syncProvError) {
                    AbstractTermPane.addFailureReason(EMC.EID_CANNOT_TRANSITION_STATE_WITH_SYNC, portModel, entityCellRenderer, arrayList);
                    continue;
                }
                catch (InvalidState invalidState) {
                    AbstractTermPane.addFailureReason(EMC.EID_CHANGE_ADMIN_STATE_NOTALLOWED, portModel, entityCellRenderer, arrayList);
                }
            }
        }
    }

    private void deleteTerms(OhTermModel[] ohTermModelArray) {
        if (ohTermModelArray == null || ohTermModelArray.length == 0) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_NO_TERM_TYPE_SELECTED_PARAM_1, (Object)this.ohTermType);
            return;
        }
        this.db.info("Deleting " + ohTermModelArray.length + " terms");
        ArrayList<OhTermModel> arrayList = new ArrayList<OhTermModel>();
        ArrayList arrayList2 = new ArrayList();
        EntityCellRenderer entityCellRenderer = new EntityCellRenderer("slot ");
        boolean bl = false;
        for (int i = 0; i < ohTermModelArray.length; ++i) {
            OhTermModel ohTermModel = ohTermModelArray[i];
            PortModel portModel = (PortModel)ohTermModel.getOpticalPortModel();
            try {
                this.connTableModel.deleteTermination(ohTermModel);
                arrayList.add(ohTermModel);
                continue;
            }
            catch (Busy busy) {
                AbstractTermPane.addFailureReason(EMC.EID_TERM_TYPE_IN_USE_PARAM_1, this.ohTermType, portModel, entityCellRenderer, arrayList2);
                bl = true;
                continue;
            }
            catch (NoLanAccess noLanAccess) {
                AbstractTermPane.addFailureReason(EMC.EID_FAIL_DELETE_LAST_DCC_PARAM_1, this.ohTermType, portModel, entityCellRenderer, arrayList2);
                bl = true;
                continue;
            }
            catch (Exception exception) {
                AbstractTermPane.addFailureReason(EMC.EID_TERM_TYPE_DELETE_FAIL_PARAM_2, this.ohTermType, AnnotatedException.getString((Exception)exception), portModel, entityCellRenderer, arrayList2);
                bl = true;
            }
        }
        if (bl) {
            this.refresh();
        }
        this.db.info("Handling " + arrayList2.size() + " term deletion failures (" + arrayList.size() + " successes)");
        AbstractTermPane.handleFailures((Component)((Object)this), this.ohTermType, "delete", arrayList, arrayList2, null, entityCellRenderer);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.createPB) {
            this.getOhTermCreationDialog().show();
        } else if (object == this.editPB) {
            if (this.table.getSelectedRowCount() == 1) {
                int n = this.table.getSelectedRow();
                if (n >= 0 || n < this.tableDataList.size()) {
                    new OhTermEditDialog(this, JOptionPane.getFrameForComponent((Component)((Object)this)), (OhTermModel)this.tableDataList.get(n)).show();
                }
            } else if (this.db.on()) {
                this.db.println("selected row count != 1 for edit!");
            }
        } else if (object == this.deletePB) {
            int[] nArray = this.table.getSelectedRows();
            Object[] objectArray = new OhTermModel[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (n >= this.tableDataList.size()) continue;
                objectArray[i] = (OhTermModel)this.tableDataList.get(n);
            }
            OhTermConfirmDialog ohTermConfirmDialog = new OhTermConfirmDialog(objectArray);
            ohTermConfirmDialog.show();
            if (ohTermConfirmDialog.isOk()) {
                this.deleteTerms((OhTermModel[])objectArray);
            }
        }
    }

    private sIpAddr asIp(String string) {
        return IpAddrFactory.getIpAddr(InetUtil.makeIpAddr(string));
    }

    private String asString(sIpAddr sIpAddr2) {
        return InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(sIpAddr2));
    }

    private String getFarEndIpAddress(OhTermModel ohTermModel) {
        String string;
        block3: {
            string = "";
            try {
                if (ohTermModel.isFarEndForeign()) {
                    string = this.asString(ohTermModel.getFarEndIpAddress());
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
        }
        return string;
    }

    protected static void addFailureReason(EID eID, IEntityModel iEntityModel, EntityCellRenderer entityCellRenderer, ArrayList arrayList) {
        if (arrayList != null) {
            String string = entityCellRenderer.getString(iEntityModel, "slot ");
            arrayList.add(string + ": " + ErrorMsg.getString((EID)eID));
        }
    }

    protected static void addFailureReason(EID eID, String string, IEntityModel iEntityModel, EntityCellRenderer entityCellRenderer, ArrayList arrayList) {
        if (arrayList != null) {
            String string2 = entityCellRenderer.getString(iEntityModel, "slot ");
            arrayList.add(string2 + ": " + ErrorMsg.getString((EID)eID, (Object)string));
        }
    }

    protected static void addFailureReason(EID eID, String string, String string2, IEntityModel iEntityModel, EntityCellRenderer entityCellRenderer, ArrayList arrayList) {
        if (arrayList != null) {
            String string3 = entityCellRenderer.getString(iEntityModel, "slot ");
            arrayList.add(string3 + ": " + ErrorMsg.getString((EID)eID, (Object)string, (Object)string2));
        }
    }

    protected static void handleFailures(Component component, String string, String string2, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, EntityCellRenderer entityCellRenderer) {
        if (arrayList2.size() > 0 || arrayList3 != null && arrayList3.size() > 0) {
            int n;
            int n2;
            ImageIcon imageIcon = CerentDialog.WARNING_ICON;
            String string3 = "";
            String string4 = "";
            if (arrayList2.size() > 0) {
                n2 = arrayList2.size();
                imageIcon = CerentDialog.FATAL_ICON;
                string4 = string4 + n2 + " " + string + " " + PluralisationUtil.s("termination", n2) + " " + PluralisationUtil.s("was", n2) + " not " + string2 + "d, as follows:\n";
                for (n = 0; n < arrayList2.size(); ++n) {
                    string4 = string4 + (String)arrayList2.get(n) + "\n";
                }
            } else {
                string4 = "All " + string + " terminations were " + string2 + "d successfully\n";
            }
            string4 = string4 + "\n";
            if (arrayList3 != null) {
                if (arrayList3.size() > 0) {
                    string3 = string3 + "Some port states were not able to be changed.\n";
                    n2 = arrayList3.size();
                    string4 = string4 + n2 + " port " + PluralisationUtil.s("state", n2) + " " + PluralisationUtil.s("was", n2) + " not set, as follows:\n";
                    for (n = 0; n < arrayList3.size(); ++n) {
                        string4 = string4 + (String)arrayList3.get(n) + "\n";
                    }
                    string4 = string4 + "\n";
                } else {
                    string3 = string3 + "All port states were able to be changed for the new " + string + "s.\n";
                }
            }
            if (arrayList2.size() > 0 && arrayList.size() > 0) {
                n2 = arrayList.size();
                string4 = string4 + n2 + " " + string + " " + PluralisationUtil.s("termination", n2) + " " + PluralisationUtil.s("was", n2) + " " + string2 + "d as follows:\n";
                for (n = 0; n < arrayList.size(); ++n) {
                    EntityModel entityModel = (EntityModel)arrayList.get(n);
                    String string5 = entityCellRenderer.getString(entityModel, "slot ");
                    string4 = string4 + string5 + "\n";
                }
            }
            DetailedDialog detailedDialog = DetailedDialog.instance((Frame)JOptionPane.getFrameForComponent(component), (String)("Error Processing " + string + " Termination"));
            if (arrayList2.size() > 0) {
                detailedDialog.setText(ErrorMsg.getString((EID)EMC.EID_TERM_PROCESS, (Object)string, (Object)string2, (Object)string3), imageIcon);
            } else {
                detailedDialog.setText(ErrorMsg.getString((EID)EMC.WID_TERM_PROCESS, (Object)string, (Object)string2, (Object)string3), imageIcon);
            }
            detailedDialog.append(string4);
            detailedDialog.setSize(500, detailedDialog.getHeight());
            detailedDialog.show();
        }
    }

    protected static PortModel getProtectPort(PortModel portModel, SDebug sDebug) {
        PortModel portModel2 = null;
        int n = -1;
        if (portModel instanceof TdmPortModel) {
            n = ((TdmPortModel)portModel).getOnePlusOneProtectEntityIndex();
        } else if (portModel instanceof DwdmPortModel) {
            n = ((DwdmPortModel)portModel).getYCableProtectEntityIndex();
        }
        if (n > 0 & n != portModel.getEntityIndex()) {
            sDebug.info("Protect entity " + Integer.toHexString(n) + " exists");
            try {
                portModel2 = (PortModel)portModel.getNodeModelDelegate().getEntityTableModel().getEntityModelByIndex(n);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                sDebug.severe("Failed to get protectPort " + Integer.toHexString(n));
            }
        }
        return portModel2;
    }

    private static class OhTermComparator
    implements Comparator {
        private OhTermComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            return ComparisonUtil.compare(((IOhTermModel)object).getOpticalPortIndex(), ((IOhTermModel)object2).getOpticalPortIndex());
        }
    }

    protected class OhTermConfirmDialog {
        protected boolean ok = false;
        protected Object[] termsToDelete;

        public OhTermConfirmDialog(Object[] objectArray) {
            this.termsToDelete = objectArray;
        }

        public boolean isOk() {
            return this.ok;
        }

        public void show() {
            String string = "Really delete selected " + AbstractTermPane.this.ohTermType + " " + PluralisationUtil.s("Termination", this.termsToDelete.length) + "?";
            if (CerentDialog.yesNoDialog((Component)((Object)AbstractTermPane.this), (String)string, (String)("Delete " + AbstractTermPane.this.ohTermType + " " + PluralisationUtil.s("Termination", this.termsToDelete.length)))) {
                this.ok = true;
            }
        }
    }

    private static class OhTermEditDialog
    extends UDialog
    implements ActionListener {
        private AbstractTermPane _atp;
        private OhTermModel ohTerm;
        private PortModel ohPort;
        private boolean ospfDirty;
        private boolean farEndForeignDirty;
        private boolean farEndIpAddrDirty;
        private JButton okButton;
        private JButton cancelButton;
        private JComboBox gccRateComboBox;
        private JCheckBox donotAdvertiseOspfButton;
        private JCheckBox farEndForeign;
        private JTextField farEndIpAddr;

        protected OhTermEditDialog(AbstractTermPane abstractTermPane, Frame frame, OhTermModel ohTermModel) {
            super(frame, "", true);
            this._atp = abstractTermPane;
            this.ohTerm = ohTermModel;
            this.ospfDirty = false;
            this.farEndForeignDirty = false;
            this.farEndIpAddrDirty = false;
            this.ohPort = (PortModel)ohTermModel.getOpticalPortModel();
            Container container = this.getContentPane();
            if (container instanceof JPanel) {
                this.initContentPane((JPanel)container);
                this.pack();
            }
        }

        protected void initContentPane(JPanel jPanel, Object object) {
        }

        protected void initContentPane(JPanel jPanel) {
            Object object;
            this.setSize(new Dimension(300, 300));
            this.setTitle(entityCellRenderer.getString(this.ohPort, "slot ") + " - Edit " + this._atp.ohTermType + " Termination");
            PortModel portModel = AbstractTermPane.getProtectPort(this.ohPort, this._atp.db);
            if (portModel != null) {
                object = "Protect Port: " + entityCellRenderer.getString(portModel, "slot ");
                jPanel.add((Component)new JLabel((String)object), "North");
            }
            object = new JPanel();
            ((Container)object).setLayout(new BoxLayout((Container)object, 1));
            ((JComponent)object).setBorder(BorderFactory.createTitledBorder(this._atp.ohTermType));
            JPanel jPanel2 = null;
            if (this._atp.getOhTermType().equals(AbstractTermPane.GCC_TERM)) {
                jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
                jPanel2.add(new JLabel("  GCC Rate:"));
                this.gccRateComboBox = new JComboBox<Attribute>(this.getGccRateAttributes());
                jPanel2.add(this.gccRateComboBox);
                this.gccRateComboBox.setEnabled(false);
                ((Container)object).add(jPanel2);
            }
            jPanel2 = new JPanel(new FlowLayout(0, 5, 0));
            this.donotAdvertiseOspfButton = new JCheckBox("Disable OSPF on Link");
            jPanel2.add(this.donotAdvertiseOspfButton);
            this.donotAdvertiseOspfButton.addActionListener(this);
            ((Container)object).add(jPanel2);
            jPanel2 = new JPanel(new FlowLayout(0, 5, 0));
            this.farEndForeign = new JCheckBox("Far End is Foreign");
            jPanel2.add(this.farEndForeign);
            this.farEndForeign.addActionListener(this);
            jPanel2.add(new JLabel("Far End IP:"));
            this.farEndIpAddr = new JTextField(16);
            jPanel2.add(this.farEndIpAddr);
            this.farEndIpAddr.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    farEndIpAddrDirty = true;
                    okButton.setEnabled(true);
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    farEndIpAddrDirty = true;
                    okButton.setEnabled(true);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    farEndIpAddrDirty = true;
                    okButton.setEnabled(true);
                }
            });
            ((Container)object).add(jPanel2);
            jPanel.add((Component)object, "Center");
            jPanel2 = new JPanel(new FlowLayout(1, 5, 5));
            this.okButton = this.makeActionButton("OK");
            jPanel2.add(this.okButton);
            this.cancelButton = this.makeActionButton("Cancel");
            jPanel2.add(this.cancelButton);
            jPanel.add((Component)jPanel2, "South");
            this.okButton.setEnabled(false);
            try {
                this.donotAdvertiseOspfButton.setSelected(!this.ohTerm.isOspfEnable());
            }
            catch (Exception exception) {
                this._atp.db.fine("ohTerm.isOspfEnable() failed" + exception);
            }
            try {
                this.farEndForeign.setSelected(this.ohTerm.isFarEndForeign());
                this.farEndForeignDirty = false;
            }
            catch (Exception exception) {
                this._atp.db.fine("ohTerm.isFarEndForeign() failed " + exception);
            }
            this.farEndIpAddr.setEnabled(this.farEndForeign.isSelected());
            this.farEndIpAddr.setText(this.farEndIpAddr(this.ohTerm));
            this.farEndIpAddrDirty = false;
            if (this.gccRateComboBox != null) {
                try {
                    if (this.ohTerm.getChannelType() == 4) {
                        this.gccRateComboBox.setSelectedItem(this.getGccRateAttributes()[1]);
                    } else {
                        this.gccRateComboBox.setSelectedItem(this.getGccRateAttributes()[0]);
                    }
                }
                catch (Exception exception) {
                    this._atp.db.fine("ohPort.getChannelType() failed" + exception);
                }
            }
        }

        private String farEndIpAddr(OhTermModel ohTermModel) {
            String string = "";
            if (this.farEndForeign.isSelected() && (string = this._atp.getFarEndIpAddress(ohTermModel)).equals("")) {
                string = "0.0.0.0";
            }
            return string;
        }

        public void dispose() {
            this.ohTerm = null;
            this.ohPort = null;
            this._atp = null;
            super.dispose();
        }

        protected JButton makeActionButton(String string) {
            JButton jButton = new JButton(string);
            jButton.addActionListener(this);
            return jButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.donotAdvertiseOspfButton) {
                this.ospfDirty = true;
                this.okButton.setEnabled(true);
            } else if (object == this.farEndForeign) {
                this.farEndForeignDirty = true;
                this.farEndIpAddr.setEnabled(this.farEndForeign.isSelected());
                this.farEndIpAddr.setText(this.farEndIpAddr(this.ohTerm));
                this.okButton.setEnabled(true);
            } else if (object == this.okButton) {
                this.ok();
            } else if (object == this.cancelButton) {
                this.dispose();
            }
        }

        private String formatInternalSubnets() {
            String string;
            try {
                StringBuffer stringBuffer = new StringBuffer();
                NodeModelDelegate nodeModelDelegate = this._atp.connTableModel.getNodeModelDelegate();
                IpSubnet[] ipSubnetArray = nodeModelDelegate.getPlatform().getInternalSubnets(nodeModelDelegate);
                if (ipSubnetArray != null && ipSubnetArray.length > 0) {
                    stringBuffer.append(" (");
                    stringBuffer.append(ipSubnetArray[0]);
                    for (int i = 1; i < ipSubnetArray.length; ++i) {
                        stringBuffer.append(", ");
                        stringBuffer.append(ipSubnetArray[i]);
                    }
                    stringBuffer.append(")");
                }
                string = stringBuffer.toString();
            }
            catch (Exception exception) {
                string = "";
            }
            return string;
        }

        protected void ok() {
            try {
                if (this.ospfDirty) {
                    this.ohTerm.setOspfEnable(!this.donotAdvertiseOspfButton.isSelected());
                }
                if (this.farEndForeignDirty) {
                    this.ohTerm.setFarEndIsForeign(this.farEndForeign.isSelected());
                }
                if (this.farEndIpAddrDirty && this.farEndForeign.isSelected()) {
                    this.ohTerm.setFarEndIpAddress(this._atp.asIp(this.farEndIpAddr.getText()));
                }
                this.dispose();
            }
            catch (ConfigError configError) {
                ErrorMsg.displayError((Component)((Object)this), EMC.EID_TERM_FAR_END_IP_FAIL_PARAM_2, this._atp.ohTermType, this.formatInternalSubnets());
            }
            catch (Exception exception) {
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_TERM_TYPE_EDIT_FAIL_PARAM_1, this._atp.ohTermType, AnnotatedException.getString((Exception)exception));
            }
        }

        private Attribute[] getGccRateAttributes() {
            return ElementDefaults.getAttributeMap(this.ohTerm).getAttributeArray("declDwdmGccRate");
        }
    }

    protected class OhTermPaneRenderer
    extends DefaultTableCellRenderer {
        final JLabel checkedLabel;
        final JLabel emptyLabel;

        public OhTermPaneRenderer() {
            this.checkedLabel = new JLabel(AbstractTermPane.this.CK_IMG);
            this.emptyLabel = new JLabel("");
            this.checkedLabel.setOpaque(true);
            this.emptyLabel.setOpaque(true);
        }

        private JLabel getBooleanLabel(boolean bl, JTable jTable, boolean bl2) {
            JLabel jLabel;
            JLabel jLabel2 = jLabel = bl ? this.checkedLabel : this.emptyLabel;
            if (bl2) {
                jLabel.setBackground(jTable.getSelectionBackground());
                jLabel.setForeground(Color.white);
            } else {
                jLabel.setBackground(jTable.getBackground());
                jLabel.setForeground(Color.black);
            }
            return jLabel;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            int n3 = jTable.convertColumnIndexToModel(n2);
            switch (n3) {
                case 0: {
                    PortModel portModel = (PortModel)object;
                    if (portModel == null) break;
                    object = entityCellRenderer.getString(portModel, "slot ");
                    break;
                }
                case 1: 
                case 2: {
                    Boolean bl3 = (Boolean)object;
                    if (bl3 == null) break;
                    return this.getBooleanLabel(bl3, jTable, bl);
                }
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    protected class OhTermTableModel
    extends AbstractTableModel {
        public static final int PORT_INDEX = 0;
        public static final int OSPF_ADVERTISE_INDEX = 1;
        public static final int FAR_END_FOREIGN = 2;
        public static final int FAR_END_IP_ADDR = 3;
        public static final int SERVICE_STATE_INDEX = 4;
        public static final int RATE_INDEX = 5;
        public static final int PORT_COLUMN_WIDTH = 160;
        public static final int OSPF_ADVERTISE_COLUMN_WIDTH = 140;
        public static final int FAR_END_FOREIGN_COLUMN_WIDTH = 50;
        public static final int FAR_END_IP_ADDR_COLUMN_WIDTH = 110;
        public static final int SERVICE_STATE_COLUMN_WIDTH = 270;
        public static final int RATE_COLUMN_WIDTH = 80;
        public final String[] columnNames = new String[]{"Port", "OSPF Disabled on Link", "Foreign", "Foreign IP", "Port Service State", "GCC Rate"};

        protected OhTermTableModel() {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getRowCount() {
            return AbstractTermPane.this.tableDataList.size();
        }

        public Object getValueAt(int n, int n2) {
            if (AbstractTermPane.this.tableDataList != null && n < AbstractTermPane.this.tableDataList.size()) {
                OhTermModel ohTermModel = (OhTermModel)AbstractTermPane.this.tableDataList.get(n);
                PortModel portModel = null;
                try {
                    portModel = (PortModel)ohTermModel.getOpticalPortModel();
                }
                catch (NullPointerException nullPointerException) {
                    AbstractTermPane.this.db.fine("Null value in renderer");
                    return null;
                }
                switch (n2) {
                    case 0: {
                        return portModel;
                    }
                    case 1: {
                        try {
                            return new Boolean(!ohTermModel.isOspfEnable());
                        }
                        catch (AbstractCmsIOException abstractCmsIOException) {
                            return Boolean.FALSE;
                        }
                    }
                    case 2: {
                        try {
                            return new Boolean(ohTermModel.isFarEndForeign());
                        }
                        catch (AbstractCmsIOException abstractCmsIOException) {
                            return Boolean.FALSE;
                        }
                    }
                    case 3: {
                        return AbstractTermPane.this.getFarEndIpAddress(ohTermModel);
                    }
                    case 4: {
                        return this.getServiceState(portModel);
                    }
                    case 5: {
                        if (ohTermModel.getChannelType() == 0) {
                            return this.getAttributeKey("declDwdmGccRate", 0);
                        }
                        if (ohTermModel.getChannelType() != 4) break;
                        return this.getAttributeKey("declDwdmGccRate", 1);
                    }
                }
            }
            return null;
        }

        protected String getServiceState(PortModel portModel) {
            String string = "";
            String string2 = "";
            if (portModel != null) {
                try {
                    string = AbstractTermPane.this.terms.getTermForServiceState(portModel.getServiceStateType());
                }
                catch (NoSuchInterface noSuchInterface) {
                    AbstractTermPane.this.db.info("port.getServiceStateType() failed: " + (Object)((Object)noSuchInterface));
                }
                PortModel portModel2 = AbstractTermPane.getProtectPort(portModel, AbstractTermPane.this.db);
                if (portModel2 != null) {
                    try {
                        string2 = AbstractTermPane.this.terms.getTermForServiceState(portModel2.getServiceStateType());
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        AbstractTermPane.this.db.info("protectPort.getServiceStateType() failed: " + (Object)((Object)noSuchInterface));
                    }
                }
            }
            if (string2.length() > 0) {
                return "<html>" + string + "<em> (Working) </em> " + string2 + "<em> (Protect) </em></html>";
            }
            return string;
        }

        private String getAttributeKey(String string, int n) {
            Attribute attribute = ElementDefaults.getAttributeMap(AbstractTermPane.this.getUiModel()).getAttributeForVal(string, n);
            return attribute != null ? attribute.getKey() : null;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

