/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.IPlatform;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.sMfgData_2_01;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.FramingType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PluggableModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ServiceState;
import cerent.cms.model.SlotModel;
import cerent.cms.model.event.ElementAlarmStore;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CardTabbedViewFactory;
import cerent.cms.ui.ViewName;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardBehavior;
import cerent.cms.ui.shelf.CardPanel;
import cerent.cms.ui.shelf.ICardPainter;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class CardGraphic
extends JComponent
implements Icon,
ImageObserver,
ActionListener,
Observer {
    public static final int UNKNOWN = -1;
    public static final int NOT_PRESENT = 0;
    public static final int MISMATCH = 1;
    public static final int LOADING = 2;
    public static final int FAILED = 3;
    public static final int STANDBY = 4;
    public static final int ACTIVE = 5;
    public static final int DELETED = 6;
    protected static final int ERROR = 7;
    protected static final int PROVISIONED = 8;
    protected static final int CRITICAL = 9;
    protected static final int MAJOR = 10;
    protected static final int MINOR = 11;
    protected static final int OOS_MT = 12;
    protected ElementAlarmStore alarmStore;
    protected IAlarmStatus alarmStatus;
    protected eEqState eqState;
    protected EntityModel entityM;
    protected AbstractShelfLayout parent;
    protected CardBehavior cardBehavior;
    protected Color currentColor = Color.white;
    private int slotNo;
    private int nodeId;
    private TDMTerminology terms;
    private NodeModelDelegate nodeModel;
    private boolean disabled = false;
    protected static int DEFAULT_SLOTS_OCCUPIED = 1;
    protected int slotsOccupied = DEFAULT_SLOTS_OCCUPIED;
    private boolean MDEnabled;
    private boolean XCprovisioned;
    private boolean OSCprovisioned_s8;
    private boolean OSCprovisioned_s10;
    protected ICardPainter cardPainter;
    protected IPlatform pci;
    protected boolean eqLabelIsSet = false;
    protected SDebug db;

    public CardGraphic(IEntityModel iEntityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug) {
        this.nodeModel = (NodeModelDelegate)iEntityModel.getNodeModel();
        this.pci = this.nodeModel.getPlatform();
        this.terms = this.nodeModel.getTDMTerminology();
        this.db = sDebug;
        this.cardBehavior = this.pci.getCardBehavior(this.nodeModel, sDebug);
        this.entityM = (EntityModel)iEntityModel;
        this.parent = abstractShelfLayout;
        this.initialize();
    }

    public ICardPainter getCardPainter() {
        return this.cardPainter;
    }

    public String toString() {
        return this.getEqLabel();
    }

    public int getSlot() {
        int n = 0;
        try {
            return this.entityM.getSlot();
        }
        catch (Exception exception) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return n;
        }
    }

    public int getSlotsOccupied() {
        return this.slotsOccupied;
    }

    protected void setSlotsOccupied(int n) {
        if (this.slotsOccupied != n) {
            if (this.db.on()) {
                this.db.println("setSlotsOccupied=" + n);
            }
            this.slotsOccupied = n;
            if (this.cardPainter != null) {
                this.cardPainter.updateWidth();
                this.setSize(this.getIconWidth(), this.getIconHeight());
            }
        }
    }

    protected void initSlotsOccupied() {
    }

    public int getIconHeight() {
        return this.cardPainter.getCardHeight();
    }

    public int getIconWidth() {
        return this.cardPainter.getCardWidth();
    }

    public Dimension getDimension() {
        return this.cardPainter.getMainRectangle().getSize();
    }

    public boolean hasProvisionedCard() {
        boolean bl = false;
        try {
            return this.entityM instanceof ModuleModel && this.entityM.getParent() != null;
        }
        catch (CmsObjectNotExistException cmsObjectNotExistException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
            }
            return bl;
        }
    }

    public IEntityModel getModel() {
        return this.entityM;
    }

    public synchronized void refreshCard() {
        this.setCardColor();
        if (this.pci.is327() || this.pci.is310cl()) {
            this.initLabel();
        }
        this.repaint();
    }

    protected String getModeLabel() {
        return "";
    }

    protected void initLabel() {
        if (this.eqLabelIsSet) {
            return;
        }
        if (this.hasProvisionedCard()) {
            sMfgData_2_01 sMfgData_2_012 = ((PluggableModel)this.entityM).getMfgData();
            String string = sMfgData_2_012.name;
            if (string.equals("")) {
                return;
            }
            int n = this.getState();
            if (n == 5 || n == 4) {
                this.entityM.setEqLabel(string);
                this.eqLabelIsSet = true;
            }
        }
    }

    public String getEqLabel() {
        String string;
        block7: {
            string = "???";
            try {
                string = this.entityM.getEqLabel();
            }
            catch (Exception exception) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                return string;
            }
            try {
                if (this.getEqType() == 11) {
                    String string2;
                    int n = this.entityM.getSlot();
                    ArrayList arrayList = this.nodeModel.getMfgData();
                    if (n > 0 && (string2 = (String)arrayList.get(n - 1)) != null && string2.indexOf("AS") != -1) {
                        string = string + "AS";
                    }
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block7;
                this.db.println("Exception trying to determine OC48-AS: ");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    public int getEqType() {
        int n;
        try {
            n = this.entityM.getEqType();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            n = 0;
        }
        return n;
    }

    protected String getStateString() {
        if (this.eqState == null) {
            return "";
        }
        String string = ElementDefaults.eqStateToString(this.eqState);
        if (this.db.on()) {
            this.db.println("stateString=" + string);
        }
        return string;
    }

    protected String getAlarmProfileString() {
        try {
            return "Alarm Profile: " + this.entityM.getAlarmProfileName();
        }
        catch (Exception exception) {
            if (this.db.on()) {
                this.db.println("error retrieving alarm profile");
            }
            return "";
        }
    }

    protected String getAlarmStatusString() {
        String string = "";
        if (this.alarmStore == null) {
            if (this.db.on()) {
                this.db.println("alarm store is null");
            }
            return string;
        }
        if (this.getAlarmStatus() != null) {
            if (this.getAlarmStatus().critical() > 0) {
                string = "Critical Alarm";
            } else if (this.getAlarmStatus().major() > 0) {
                string = "Major Alarm";
            } else if (this.getAlarmStatus().minor() > 0) {
                string = "Minor Alarm";
            }
        }
        if (this.db.on()) {
            this.db.println("statusString=" + string);
        }
        return string;
    }

    protected String getExtraInfo() {
        return "";
    }

    protected static void appendString(StringBuffer stringBuffer, String string) {
        if (string != null && string.length() > 0) {
            stringBuffer.append(' ').append(string).append(',');
        }
    }

    protected IAlarmStatus getAlarmStatus() {
        if (this.alarmStatus == null && this.alarmStore != null) {
            this.alarmStatus = this.alarmStore.getAlarmStatus();
        }
        return this.alarmStatus;
    }

    public String getTooltipText(MouseEvent mouseEvent) {
        return this.getTooltipText(this.getEqLabel(), mouseEvent);
    }

    public String getTooltipText(String string, MouseEvent mouseEvent) {
        StringBuffer stringBuffer;
        block9: {
            stringBuffer = new StringBuffer("");
            try {
                stringBuffer.append(string);
                stringBuffer.append(this.getModeLabel());
                stringBuffer.append(" [");
                if (this.hasProvisionedCard()) {
                    if (this.entityM instanceof ModuleModel) {
                        stringBuffer.append(this.entityM.getSlot());
                    } else if (this.entityM instanceof PluggableModel) {
                        stringBuffer.append(((PluggableModel)this.entityM).getLocation());
                    } else {
                        stringBuffer.append(this.entityM.getPositionInParent());
                    }
                    stringBuffer.append("]: ");
                    CardGraphic.appendString(stringBuffer, this.getStateString());
                    ModuleModel moduleModel = (ModuleModel)this.entityM.getModuleModel();
                    if (moduleModel != null) {
                        CardGraphic.appendString(stringBuffer, moduleModel.getServiceSt().toString(this.terms));
                    }
                    CardGraphic.appendString(stringBuffer, this.getAlarmStatusString());
                    CardGraphic.appendString(stringBuffer, this.getAlarmProfileString());
                    CardGraphic.appendString(stringBuffer, this.getExtraInfo());
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                } else {
                    stringBuffer.append(this.entityM.getPositionInParent());
                    stringBuffer.append("]: ");
                    stringBuffer.append("Empty");
                }
            }
            catch (Exception exception) {
                this.db.println("Error in getToolTipText");
                if (!this.db.on) break block9;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return stringBuffer.toString();
    }

    private void setCardColor() {
        block25: {
            try {
                ServiceState serviceState;
                if (this.getEqType() == 95) {
                    this.setColor(8);
                    return;
                }
                if (this.entityM instanceof MfgEntityModel && (serviceState = (ServiceState)((MfgEntityModel)this.entityM).getServiceSt()).isFormOfMT()) {
                    this.setColor(12);
                    return;
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block25;
                this.db.println("Caught exception in setCardColor: " + exception);
            }
        }
        int n = this.getState();
        if (!this.hasProvisionedCard() || n == -1) {
            return;
        }
        try {
            switch (n) {
                case 0: 
                case 1: {
                    this.setColor(8);
                    break;
                }
                case 3: {
                    this.setColor(7);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    this.setColor(4);
                    break;
                }
                case 5: {
                    this.setColor(5);
                    break;
                }
                case 6: {
                    this.setColor(6);
                    return;
                }
            }
            if (this.getAlarmStatus() != null) {
                if (this.getAlarmStatus().getHighestSeverity() == 0) {
                    if (n == 0 || n == 1) {
                        this.setColor(8);
                    } else {
                        this.setColor(5);
                    }
                } else if (this.getAlarmStatus().critical() > 0) {
                    this.setColor(9);
                } else if (this.getAlarmStatus().major() > 0) {
                    this.setColor(10);
                } else if (this.getAlarmStatus().minor() > 0) {
                    this.setColor(11);
                }
            }
        }
        catch (Exception exception) {
            this.db.println("Error in setCardColor " + exception);
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    private void setColor(int n) {
        if (!this.hasProvisionedCard()) {
            return;
        }
        if (this.db.on()) {
            this.db.println("setColor: status=" + n);
        }
        switch (n) {
            case 4: 
            case 5: {
                this.currentColor = Color.white;
                break;
            }
            case 7: 
            case 9: {
                this.currentColor = ElementDefaults.CRITICAL_ALARM_COLOR;
                break;
            }
            case 8: {
                this.currentColor = ElementDefaults.IS_AINS_COLOR;
                break;
            }
            case 6: {
                this.currentColor = ElementDefaults.DELETED_COLOR;
                break;
            }
            case 10: {
                this.currentColor = ElementDefaults.MAJOR_ALARM_COLOR;
                break;
            }
            case 11: {
                this.currentColor = ElementDefaults.MINOR_ALARM_COLOR;
                break;
            }
            case 12: {
                this.currentColor = ElementDefaults.OOS_MT_COLOR;
            }
        }
    }

    public Color getCurrentColor() {
        return this.currentColor;
    }

    public synchronized int getState() {
        int n = -1;
        if (this.eqState == null) {
            return 0;
        }
        switch (this.eqState.value()) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 5: {
                n = 5;
                break;
            }
            case 6: {
                n = 6;
            }
        }
        return n;
    }

    private synchronized void setState() {
        try {
            if (this.entityM instanceof PluggableModel) {
                this.eqState = ((PluggableModel)this.entityM).getState();
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public void repaint() {
        if (this.parent != null) {
            this.parent.repaint();
        }
    }

    public void rightMouseClicked(Point point, CardPanel cardPanel) {
        JPopupMenu jPopupMenu = null;
        int n = this.getModel().getSlot();
        Object var5_5 = null;
        jPopupMenu = new JPopupMenu("Set Card Type");
        if (this.getModel() instanceof ModuleModel) {
            ModuleModel moduleModel;
            IEntityModel iEntityModel;
            block11: {
                iEntityModel = this.getModel();
                moduleModel = (ModuleModel)iEntityModel;
                boolean bl = FramingType.getFramingType((int)this.nodeModel.getFramingType()).isSonet();
                try {
                    if (!bl) {
                        String string = EntityModel.eqType2Name(this.terms, this.entityM.getEqType());
                        if (string.charAt(0) != cardPanel.getIcon().toString().charAt(0)) {
                            string = cardPanel.getIcon().toString();
                        }
                        jPopupMenu.add(new JMenuItem(string + " Card"));
                    } else {
                        jPopupMenu.add(new JMenuItem(EntityModel.eqType2Name(this.terms, this.entityM.getEqType()) + " Card"));
                    }
                    jPopupMenu.addSeparator();
                }
                catch (Exception exception) {
                    if (!this.db.on()) break block11;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            jPopupMenu.add(this.makeMenuAction("Open Card", CardTabbedViewFactory.isCardViewAvailable((ModuleModel)iEntityModel)));
            jPopupMenu.add(this.makeMenuAction("Delete Card", AbstractPane.isUserAuthorized(moduleModel, SecurityLevel.PROVISIONING) && moduleModel.isDeletable()));
            boolean bl = AbstractPane.isUserAuthorized(moduleModel, SecurityLevel.MAINTENANCE);
            jPopupMenu.addSeparator();
            if (CardBehavior.supportsGenericResetCard(this.pci, moduleModel.getEqType())) {
                jPopupMenu.add(this.makeMenuAction("Reset Card", bl && moduleModel.isResettable()));
            } else {
                jPopupMenu.add(this.makeMenuAction("Hard-reset Card", bl && moduleModel.isHardResettable()));
                jPopupMenu.add(this.makeMenuAction("Soft-reset Card", bl && moduleModel.isSoftResettable()));
            }
            this.addCustomMenuItems(jPopupMenu);
        } else {
            try {
                this.createPopup(jPopupMenu, this.getMapOfAllCards((SlotModel)this.entityM));
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_FAIL_BUILD_MENU);
            }
        }
        jPopupMenu.show(cardPanel, point.x, point.y);
    }

    protected void addCustomMenuItems(JPopupMenu jPopupMenu) {
    }

    protected JMenuItem makeMenuAction(String string, boolean bl) {
        JMenuItem jMenuItem = new JMenuItem(string);
        if (bl) {
            jMenuItem.addActionListener(this);
        } else {
            jMenuItem.setEnabled(false);
        }
        return jMenuItem;
    }

    public void openCard() {
        if (!this.isDisabled() && this.hasProvisionedCard() && CardTabbedViewFactory.isCardViewAvailable((ModuleModel)this.getModel())) {
            if (this.db.on()) {
                this.db.println("Opening card in slot " + this.slotNo);
            }
            this.parent.getViewController().tryJumpView(new ViewName(this.nodeId, this.slotNo));
        }
    }

    protected void setDisabled(boolean bl) {
        if (this.db.on()) {
            String string = bl ? "true" : "false";
            this.db.println("setting disabled to " + string);
        }
        this.disabled = bl;
    }

    protected boolean isDisabled() {
        return this.disabled;
    }

    public void dispose() {
        if (this.db.on()) {
            this.db.println("Called dispose");
        }
        if (this.entityM != null) {
            this.entityM.deleteObserver(this);
        }
        this.parent = null;
        if (this.alarmStore != null) {
            this.alarmStore.deleteAlarmStatusObserver(this);
        }
        this.db.dispose();
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer) {
            if (((Integer)object).equals(ModelUpdateType.CHANGED)) {
                if (this.db.on()) {
                    this.db.println("Received card change message");
                }
                this.eqLabelIsSet = false;
                this.setState();
                this.initSlotsOccupied();
                this.refreshCard();
            }
        } else if (object instanceof IAlarmStatus) {
            if (this.db.on()) {
                this.db.println("Received alarm status update");
            }
            this.refreshCard();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Open Card")) {
                this.openCard();
            } else if (string.equals("Delete Card")) {
                boolean bl = this.cardBehavior.deleteCard(this.parent, (ModuleModel)this.getModel());
                this.setDisabled(bl);
            } else if (string.equals("Reset Card")) {
                this.cardBehavior.resetCard(this.parent, (ModuleModel)this.getModel());
            } else if (string.equals("Hard-reset Card")) {
                this.cardBehavior.hardResetCard(this.parent, (ModuleModel)this.getModel());
            } else if (string.equals("Soft-reset Card")) {
                this.cardBehavior.softResetCard(this.parent, (ModuleModel)this.getModel());
            } else {
                this.cardBehavior.addCard(this.parent, (EntityModel)this.getModel(), string);
            }
        }
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        this.cardPainter.paintIcon(component, graphics, n, n2);
    }

    protected Map getMapOfAllCards(SlotModel slotModel) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Iterator<Object> iterator;
        Object object4;
        eEqType eEqType2;
        Object object5;
        HashMap hashMap = new HashMap(slotModel.getMapOfValidModules());
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(new CardComparator());
        Iterator iterator2 = hashMap.keySet().iterator();
        while (iterator2.hasNext()) {
            object5 = iterator2.next();
            if (object5 instanceof eEqType) {
                eEqType2 = (eEqType)object5;
                treeMap.put(EntityModel.eqType2Name(this.terms, eEqType2), null);
                continue;
            }
            eEqType2 = hashMap.get(object5);
            if (eEqType2 instanceof HashMap) {
                object4 = (Map)((Object)eEqType2);
                iterator = object4.keySet().iterator();
                while (iterator.hasNext()) {
                    object3 = iterator.next();
                    if (object3 instanceof eEqType) {
                        object2 = (eEqType)object3;
                        treeMap.put(EntityModel.eqType2Name(this.terms, (eEqType)object2), null);
                        continue;
                    }
                    object2 = (Set)object4.get(object3);
                    object = new TreeSet(new CardComparator());
                    Iterator iterator3 = object2.iterator();
                    while (iterator3.hasNext()) {
                        Object e = iterator3.next();
                        if (e instanceof eEqType) {
                            eEqType eEqType3 = (eEqType)e;
                            object.add(EntityModel.eqType2Name(this.terms, eEqType3));
                            continue;
                        }
                        object.add(e);
                    }
                    object4.put(object3, object);
                    treeMap.put((String)object5, object4);
                }
                continue;
            }
            object4 = (Set)hashMap.get(object5);
            iterator = new TreeSet(new CardComparator());
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                object = (eEqType)object2;
                iterator.add(EntityModel.eqType2Name(this.terms, (eEqType)object));
            }
            treeMap.put((String)object5, iterator);
        }
        if (this.db.on()) {
            this.db.println("getMapOfAllCards( " + slotModel.getSlot() + " )");
            iterator2 = treeMap.keySet().iterator();
            while (iterator2.hasNext()) {
                object5 = (String)iterator2.next();
                eEqType2 = treeMap.get(object5);
                if (eEqType2 != null) {
                    if (eEqType2 instanceof HashMap) {
                        object4 = (Map)((Object)eEqType2);
                        iterator = object4.keySet().iterator();
                        while (iterator.hasNext()) {
                            object3 = iterator.next();
                            if (object3 instanceof String) {
                                object2 = (String)object3;
                                object = hashMap.get(object2);
                                this.db.print((String)object2 + " ->");
                                this.db.print(" " + object);
                                continue;
                            }
                            this.db.print(object3 + " ->");
                            this.db.print(" " + object3);
                        }
                        continue;
                    }
                    object4 = (Set)((Object)eEqType2);
                    this.db.print(object5 + " ->");
                    iterator = object4.iterator();
                    while (iterator.hasNext()) {
                        this.db.print(" " + iterator.next());
                    }
                    this.db.println("");
                    continue;
                }
                this.db.println((String)object5);
            }
        }
        return treeMap;
    }

    private void initialize() {
        if (this.entityM != null) {
            this.entityM.addObserver(this);
            this.setState();
            this.slotNo = this.entityM.getSlot();
            this.nodeId = this.entityM.getNodeModelDelegate().getNodeId();
            this.initSlotsOccupied();
        } else {
            this.slotNo = 0;
            this.nodeId = 0;
        }
        if (this.hasProvisionedCard()) {
            ElementAlarmStore elementAlarmStore = (ElementAlarmStore)this.nodeModel.getElementAlarmStore();
            this.alarmStore = elementAlarmStore.getAlarmStore(this.slotNo);
            this.alarmStore.addAlarmStatusObserver(this);
        } else {
            this.alarmStore = null;
        }
        this.cardPainter = this.pci.getCardPainter(this);
        this.setSize(this.getIconWidth(), this.getIconHeight());
        try {
            this.refreshCard();
        }
        catch (Exception exception) {
            if (this.db.on()) {
                this.db.println("Error refreshing card in CardGraphic::initialize()" + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    protected void resetLabel(eEqState eEqState2) {
    }

    protected void createPopup(JPopupMenu jPopupMenu, Map map) {
        jPopupMenu.add(new NonSelectableMI("Add Card"));
        jPopupMenu.addSeparator();
        boolean bl = AbstractPane.isUserAuthorized((IModel)this.getModel(), SecurityLevel.PROVISIONING);
        this.XCprovisioned = this.IsXCProvisioned(this.pci.getXconASlot());
        if (!this.XCprovisioned) {
            this.XCprovisioned = this.IsXCProvisioned(this.pci.getXconBSlot());
        }
        if (!this.XCprovisioned) {
            this.OSCprovisioned_s8 = this.isOSCProvisioned(this.pci.getXconASlot());
        }
        if (!this.OSCprovisioned_s8) {
            this.OSCprovisioned_s10 = this.isOSCProvisioned(this.pci.getXconBSlot());
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            Iterator<Object> iterator2;
            Object object;
            Object object2;
            String string2 = (String)iterator.next();
            this.MDEnabled = true;
            Object v = map.get(string2);
            if (v instanceof HashMap) {
                object2 = new JMenu(string2);
                object = (Map)v;
                iterator2 = object.keySet().iterator();
                while (iterator2.hasNext()) {
                    Object object3;
                    Object object4;
                    Object object5;
                    string = (String)iterator2.next();
                    if (string.startsWith("MD")) {
                        this.MDEnabled = this.TestEmptySlot();
                    }
                    if (!string.startsWith("TOP")) {
                        if ((string.startsWith("EC") || string.startsWith("OC") || string.startsWith("ASAP") || string.startsWith("STM") || string.startsWith("DS")) && !this.XCprovisioned) continue;
                        object5 = new JMenu(string);
                        ((JMenu)object2).add((JMenuItem)object5);
                        object4 = (Set)object.get(string);
                        if (object4 != null && !object4.isEmpty()) {
                            object3 = object4.iterator();
                            while (object3.hasNext()) {
                                String string3 = (String)object3.next();
                                if (string2.startsWith("Eth") && !string3.startsWith("G1000")) {
                                    if (!this.XCprovisioned) continue;
                                    ((JMenu)object5).add(this.makeMenuAction(string3, bl));
                                    continue;
                                }
                                if (string.startsWith("MD") && !string3.startsWith("4MD") && !string3.equals("32 DMX")) {
                                    if (!this.MDEnabled) continue;
                                    ((JMenu)object5).add(this.makeMenuAction(string3, bl));
                                    continue;
                                }
                                ((JMenu)object5).add(this.makeMenuAction(string3, bl));
                            }
                            jPopupMenu.add((JMenuItem)object2);
                            continue;
                        }
                        ErrorMsg.displayError((Component)this, (EID)EMC.EID_MISSING_CARD_GROUP_PARAM_1, (Object)string);
                        continue;
                    }
                    if ((string.startsWith("EC") || string.startsWith("OC") || string.startsWith("ASAP") || string.startsWith("STM") || string.startsWith("DS")) && !this.XCprovisioned) continue;
                    object5 = (Set)object.get(string);
                    object4 = object5.iterator();
                    while (object4.hasNext()) {
                        object3 = (String)object4.next();
                        if (string.startsWith("Eth") && !((String)object3).startsWith("G1000") && this.XCprovisioned) {
                            ((JMenu)object2).add(this.makeMenuAction((String)object3, bl));
                        }
                        ((JMenu)object2).add(this.makeMenuAction((String)object3, bl));
                    }
                    jPopupMenu.add((JMenuItem)object2);
                }
                continue;
            }
            if (string2.startsWith("MD")) {
                this.MDEnabled = this.TestEmptySlot();
            }
            if ((object2 = (Set)map.get(string2)) != null && !object2.isEmpty()) {
                if ((string2.startsWith("EC") || string2.startsWith("OC") || string2.startsWith("ASAP") || string2.startsWith("STM") || string2.startsWith("DS")) && !this.XCprovisioned) continue;
                object = new JMenu(string2);
                iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    string = (String)iterator2.next();
                    if (string2.startsWith("Eth")) {
                        if (this.pci.is310cl()) {
                            if (!string.startsWith("ML-100T") && !string.startsWith("CE-100T")) continue;
                            ((JMenu)object).add(this.makeMenuAction(string, bl));
                            continue;
                        }
                        if (!string.startsWith("G1000") && !this.XCprovisioned) continue;
                        ((JMenu)object).add(this.makeMenuAction(string, bl));
                        continue;
                    }
                    if (string2.startsWith("MD") && !string.startsWith("4MD") && !string.equals("32 DMX")) {
                        if (!this.MDEnabled) continue;
                        ((JMenu)object).add(this.makeMenuAction(string, bl));
                        continue;
                    }
                    ((JMenu)object).add(this.makeMenuAction(string, bl));
                }
                jPopupMenu.add((JMenuItem)object);
                continue;
            }
            if (this.XCprovisioned) {
                if (string2.startsWith("OS")) continue;
                jPopupMenu.add(this.makeMenuAction(string2, bl));
                continue;
            }
            if (string2.startsWith("XC")) {
                if (this.OSCprovisioned_s8 || this.OSCprovisioned_s10) continue;
                jPopupMenu.add(this.makeMenuAction(string2, bl));
                continue;
            }
            if (string2.startsWith("EC") || string2.startsWith("OC") || string2.startsWith("ASAP") || string2.startsWith("STM") || string2.startsWith("FC") || string2.startsWith("DS")) continue;
            jPopupMenu.add(this.makeMenuAction(string2, bl));
        }
    }

    protected void ShowFinalMap(Map map) {
        if (this.db.on()) {
            this.db.println("ShowFinalMap");
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (k instanceof String) {
                String string = (String)k;
                Object v = map.get(string);
                if (!this.db.on()) continue;
                this.db.println("KEY = " + string + "   value = " + v);
                continue;
            }
            if (!this.db.on()) continue;
            this.db.println("KEY = " + k);
        }
    }

    private boolean TestEmptySlot() {
        int n = this.entityM.getSlot();
        if (n > 0 && n < 17) {
            IEntityModel iEntityModel = this.entityM.getNodeModelDelegate().getChassis();
            List list = iEntityModel.getChildren();
            EntityModel entityModel = null;
            if (list != null && list.size() > 0) {
                entityModel = (EntityModel)list.get(0);
            }
            List list2 = null;
            if (entityModel != null) {
                list2 = entityModel.getChildren();
            }
            EntityModel entityModel2 = null;
            if (list2 != null) {
                entityModel2 = (EntityModel)list2.get(n);
                List list3 = entityModel2.getChildren();
                if (list3.size() > 0) {
                    MfgEntityModel mfgEntityModel = (MfgEntityModel)((EntityModel)list3.get(0));
                    return mfgEntityModel.getState().value() == 6;
                }
                return n != 6;
            }
        }
        return false;
    }

    private boolean IsXCProvisioned(int n) {
        MfgEntityModel mfgEntityModel;
        boolean bl = false;
        IEntityModel iEntityModel = this.entityM.getNodeModelDelegate().getChassis();
        List list = iEntityModel.getChildren();
        List list2 = ((EntityModel)list.get(0)).getChildren();
        EntityModel entityModel = (EntityModel)list2.get(n - 1);
        if (entityModel.getChildren().size() > 0 && ((mfgEntityModel = (MfgEntityModel)entityModel.getChildren().get(0)).getEqType() == 3 || mfgEntityModel.getEqType() == 43 || mfgEntityModel.getEqType() == 59 || mfgEntityModel.getEqType() == 107 || mfgEntityModel.getEqType() == 84 || mfgEntityModel.getEqType() == 47 || mfgEntityModel.getEqType() == 91) && mfgEntityModel.getState().value() != 6) {
            bl = true;
        }
        return bl;
    }

    private boolean isOSCProvisioned(int n) {
        MfgEntityModel mfgEntityModel;
        boolean bl = false;
        IEntityModel iEntityModel = this.entityM.getNodeModelDelegate().getChassis();
        List list = iEntityModel.getChildren();
        List list2 = ((EntityModel)list.get(0)).getChildren();
        EntityModel entityModel = (EntityModel)list2.get(n - 1);
        if (entityModel.getChildren().size() > 0 && (mfgEntityModel = (MfgEntityModel)entityModel.getChildren().get(0)).getEqType() == 127 && mfgEntityModel.getState().value() != 6) {
            bl = true;
        }
        return bl;
    }

    public ElementAlarmStore getCardAlarmStore() {
        return this.alarmStore;
    }

    private class CardComparator
    implements Comparator {
        private CardComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof String) {
                if (object2 instanceof String) {
                    String string = (String)object;
                    String string2 = (String)object2;
                    if (string.startsWith("OC") && string2.startsWith("OC")) {
                        if (string.indexOf("_") != -1) {
                            string = string.replace('_', '.');
                        }
                        if (string2.indexOf("_") != -1) {
                            string2 = string2.replace('_', '.');
                        }
                        try {
                            Float f = new Float(string.substring(2));
                            Float f2 = new Float(string2.substring(2));
                            return f.compareTo(f2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return string.compareTo(string2);
                        }
                    }
                    return string.compareTo(string2);
                }
                return -1;
            }
            return 1;
        }

        public boolean equals(Object object) {
            return object == this;
        }
    }

    private class NonSelectableMI
    extends JMenuItem {
        public NonSelectableMI(String string) {
            super(string);
        }

        public void menuSelectionChanged(boolean bl) {
        }
    }
}

