/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.AbstractTermConnectionModel;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IEntityModel;
import cerent.cms.ui.shelf.AbstractTermCreationDialog;
import cerent.cms.ui.shelf.GccTermPane;
import cerent.util.TDMTerminology;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ListSelectionEvent;

public class GccTermCreationDialog
extends AbstractTermCreationDialog {
    private static final String TITLE = "Create GCC Terminations";
    private static final String TERMINATION_TYPE = "GCC";
    private JComboBox gccRateComboBox;

    public static GccTermCreationDialog instance(GccTermPane gccTermPane) {
        Frame frame = JOptionPane.getFrameForComponent((Component)((Object)gccTermPane));
        AbstractTermConnectionModel abstractTermConnectionModel = (AbstractTermConnectionModel)gccTermPane.getUiModel();
        return new GccTermCreationDialog(frame, TITLE, TERMINATION_TYPE, abstractTermConnectionModel);
    }

    private GccTermCreationDialog(Frame frame, String string, String string2, Object object) {
        super(frame, string, string2, object);
    }

    protected JPanel getButtonPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        TDMTerminology tDMTerminology = this.connTable.getNodeModelDelegate().getTDMTerminology();
        String string = AdminState.getAdminTermIS(tDMTerminology);
        String string2 = AdminState.getAdminTermDSBLD(tDMTerminology);
        String string3 = AdminState.getAdminTermAINS(tDMTerminology);
        String string4 = AdminState.getAdminTermMT(tDMTerminology);
        this.asIs = new JRadioButton("Leave unchanged", true);
        this.toIS = new JRadioButton("Set to '" + string + "'");
        this.OOStoAINS = new JRadioButton("Set '" + string2 + "' to '" + string3 + "'");
        this.OOStoMT = new JRadioButton("Set '" + string2 + "' to '" + string4 + "'");
        this.asIs.setEnabled(false);
        this.toIS.setEnabled(false);
        this.OOStoAINS.setEnabled(false);
        this.OOStoMT.setEnabled(false);
        this.adminStateGroup = new ButtonGroup();
        this.adminStateGroup.add(this.asIs);
        this.adminStateGroup.add(this.toIS);
        this.adminStateGroup.add(this.OOStoAINS);
        this.adminStateGroup.add(this.OOStoMT);
        jPanel3.setLayout(new GridLayout(2, 2));
        jPanel3.add(this.asIs);
        jPanel3.add(this.toIS);
        jPanel3.add(this.OOStoAINS);
        jPanel3.add(this.OOStoMT);
        jPanel3.setBorder(BorderFactory.createTitledBorder("Port Admin State"));
        jPanel2.setBorder(BorderFactory.createTitledBorder(TERMINATION_TYPE));
        JPanel jPanel5 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel5.add(new JLabel("GCC Rate:"));
        this.gccRateComboBox = new JComboBox<Attribute>(this.getGccRateAttributes());
        this.gccRateComboBox.setEnabled(false);
        jPanel5.add(this.gccRateComboBox);
        jPanel2.add(jPanel5);
        jPanel5 = new JPanel(new FlowLayout(0, 5, 5));
        this.donotAdvertiseOspfButton = new JCheckBox("Disable OSPF on Link");
        this.donotAdvertiseOspfButton.setEnabled(false);
        jPanel5.add(this.donotAdvertiseOspfButton);
        this.farEndForeign = new JCheckBox("Far End is Foreign");
        this.farEndForeign.setEnabled(false);
        jPanel5.add(this.farEndForeign);
        jPanel2.add(jPanel5);
        jPanel4.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel4.add(this.okButton);
        this.okButton.setEnabled(false);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel4.add(this.cancelButton);
        jPanel.add((Component)jPanel3, "North");
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel4, "South");
        return jPanel;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            boolean bl = this.termList.getSelectionModel().isSelectionEmpty();
            this.donotAdvertiseOspfButton.setEnabled(!bl);
            this.donotAdvertiseOspfButton.setSelected(false);
            this.farEndForeign.setEnabled(!bl);
            this.farEndForeign.setSelected(false);
            this.asIs.setEnabled(!bl);
            this.asIs.setSelected(true);
            this.toIS.setEnabled(!bl);
            this.OOStoAINS.setEnabled(!bl);
            this.OOStoMT.setEnabled(!bl);
            this.okButton.setEnabled(!bl);
        }
    }

    protected void createTermination(IEntityModel iEntityModel) throws Exception {
        this.connTable.createTermination(iEntityModel, new Object[]{new Boolean(!this.donotAdvertiseOspfButton.isSelected()), new Boolean(this.farEndForeign.isSelected()), ((Attribute)this.gccRateComboBox.getSelectedItem()).getValue()});
    }

    private Attribute[] getGccRateAttributes() {
        return ElementDefaults.getAttributeMap(this.connTable).getAttributeArray("declDwdmGccRate");
    }
}

