/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.Attribute;
import cerent.cms.model.Feature;
import cerent.cms.model.IEtherMacAddr;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.LcdIpSetting;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.util.InetUtil;
import cerent.util.KDebug;
import cerent.util.MacAddrFormat;
import cerent.util.SDebug;
import cerent.util.gui.SpinPropertyEditor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class IpAddrPanel
extends JPanel
implements ActionListener,
PropertyChangeListener,
DocumentListener {
    private static final Dimension tabSize = new Dimension(TabbedView.TABBED_VIEW_DIM.width - 200, 100);
    private JTextField ipAddrTF;
    private JTextField defRouterTF;
    private JLabel defRouterLB;
    private JTextField etherMacTF;
    private JLabel netmaskLB;
    private SpinPropertyEditor netmaskEdit;
    private JComboBox lcdIpSettingCB = null;
    private JCheckBox ctcIpSuppressedCB;
    private boolean mustReboot;
    short netmask;
    boolean userCtcIpDisplaySelection;
    boolean ctcIpDisplaySuppressed;
    boolean isNodeIP;
    int lcdIpSetting;
    int userLcdIpSetting;
    private NodeProvPane parent;
    IIpAddr ipAddr;
    IIpAddr defaultRouter;
    IEtherMacAddr etherMacAddr;
    private static final Attribute[] LCD_IP_SETTING_ATTRS = new Attribute[LcdIpSetting.LCD_IP_SETTING.length];
    protected static final SDebug db;

    public IpAddrPanel(NodeProvPane nodeProvPane, boolean bl) {
        this.parent = nodeProvPane;
        this.mustReboot = false;
        this.isNodeIP = bl;
        this.ctcIpSuppressedCB = null;
        this.init();
    }

    private void init() {
        if (db.on()) {
            db.println("init: start");
        }
        this.setPreferredSize(tabSize);
        this.setMaximumSize(tabSize);
        this.setLayout(new GridLayout(3, 1));
        this.getIpPanel();
        if (db.on()) {
            db.println("init: finish");
        }
    }

    protected void getIpPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jPanel.add(Box.createVerticalStrut(40));
        this.ipAddrTF = this.addTextPanel(jPanel, this.createLabel(" IP Address: "), 13, this);
        jPanel.add(Box.createHorizontalStrut(20));
        this.netmaskEdit = new SpinPropertyEditor(" Net/Subnet Mask Length: ", 1, 8, 30);
        if (this.parent.isUserAuthorized()) {
            this.netmaskEdit.addPropertyChangeListener(this);
        } else {
            this.netmaskEdit.setEnabled(false);
        }
        jPanel.add(this.netmaskEdit);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(new JLabel(" Mask: "));
        this.netmaskLB = new JLabel("255.255.255.252");
        this.netmaskLB.setMaximumSize(this.netmaskLB.getPreferredSize());
        jPanel.add(this.netmaskLB);
        this.add(jPanel);
        jPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.etherMacTF = this.addTextPanel(jPanel, this.createLabel(" MAC Address:"), 13, this);
        this.etherMacTF.setEditable(false);
        this.etherMacTF.setForeground(Color.gray);
        this.etherMacTF.setBackground(Color.white);
        jPanel.add(Box.createHorizontalStrut(20));
        this.defRouterLB = new JLabel(" Default Router: ");
        this.defRouterTF = this.addTextPanel(jPanel, this.defRouterLB, 13, this);
        jPanel.add(Box.createHorizontalStrut(5));
        this.add(jPanel);
        jPanel = new JPanel(new FlowLayout(0, 0, 0));
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.parent.getUiModel();
        if (nodeModelDelegate.provides(Feature.IDL_LCDIp)) {
            jPanel.add(new JLabel(" LCD IP Setting:"));
            jPanel.add(Box.createHorizontalStrut(20));
            this.lcdIpSettingCB = new JComboBox<Attribute>(LCD_IP_SETTING_ATTRS);
            jPanel.add(this.lcdIpSettingCB);
            this.lcdIpSettingCB.setEnabled(this.parent.isUserAuthorized());
            this.lcdIpSettingCB.addActionListener(this);
            jPanel.add(Box.createHorizontalStrut(15));
        }
        this.ctcIpSuppressedCB = new JCheckBox(" Suppress CTC IP Display");
        jPanel.add(this.ctcIpSuppressedCB);
        this.ctcIpSuppressedCB.setEnabled(this.parent.isUserAuthorized());
        this.ctcIpSuppressedCB.addActionListener(this);
        this.add(jPanel);
    }

    private JCheckBox addCheckBox(JPanel jPanel, String string, boolean bl, ActionListener actionListener) {
        JCheckBox jCheckBox = new JCheckBox(string);
        jCheckBox.setAlignmentX(0.0f);
        jCheckBox.setEnabled(bl);
        jCheckBox.addActionListener(actionListener);
        jPanel.add(jCheckBox);
        return jCheckBox;
    }

    private JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(95, 20));
        return jLabel;
    }

    public void setIpConfig(NodeModelDelegate nodeModelDelegate, IIpAddr iIpAddr, IIpAddr iIpAddr2, short s) {
        if (db.on()) {
            db.println("setting node IP config: start");
        }
        NodeModelDelegate nodeModelDelegate2 = nodeModelDelegate;
        boolean bl = nodeModelDelegate2.isSecureMode();
        this.ipAddr = iIpAddr;
        this.netmask = s;
        this.defaultRouter = iIpAddr2;
        this.userCtcIpDisplaySelection = this.ctcIpDisplaySuppressed = nodeModelDelegate2.getCtcIpDisplaySuppression(this.isNodeIP);
        if (!nodeModelDelegate2.allowIpDisplayed(this.isNodeIP)) {
            this.ipAddrTF.setText("");
        } else {
            this.ipAddrTF.setText(InetUtil.makeDottedString(this.ipAddr));
        }
        if (bl && this.isNodeIP) {
            this.defRouterLB.setVisible(false);
            this.defRouterTF.setVisible(false);
        } else {
            this.defRouterTF.setText(InetUtil.makeDottedString(this.defaultRouter));
        }
        this.netmaskEdit.setValue(String.valueOf(this.netmask));
        this.updateMaskLabel();
        if (nodeModelDelegate2.getPlatform().isPotentiallyLcdIpCapable()) {
            this.lcdIpSetting = nodeModelDelegate2.getLcdIpSetting(this.isNodeIP);
        }
        if (this.lcdIpSettingCB != null) {
            this.lcdIpSettingCB.setSelectedItem(IpAddrPanel.getLcdIpSettingAttr(this.lcdIpSetting));
        }
        if (this.ctcIpSuppressedCB != null) {
            this.ctcIpSuppressedCB.setSelected(this.ctcIpDisplaySuppressed);
        }
        if (db.on()) {
            db.println("refreshFromModel");
            db.println("lcdIpSetting: " + this.lcdIpSetting);
            db.println("ctcIpSetting: " + this.ctcIpDisplaySuppressed);
            db.println("refreshFromModel: finish");
        }
        this.etherMacAddr = this.isNodeIP ? nodeModelDelegate2.getNodeEtherMACAddress() : nodeModelDelegate2.getSecureEtherMACAddress();
        this.etherMacTF.getDocument().removeDocumentListener(this);
        this.etherMacTF.setText(MacAddrFormat.format(this.etherMacAddr.getAddr()));
        this.etherMacTF.getDocument().addDocumentListener(this);
        this.mustReboot = false;
    }

    public IIpAddr getIpAddr() {
        return this.ipAddr;
    }

    public IIpAddr getDefaultRouterAddr() {
        return this.defaultRouter;
    }

    public short getNetmaskPrefixLength() {
        return this.netmask;
    }

    public boolean getCtcIpSuppressed() {
        return this.ctcIpDisplaySuppressed;
    }

    public int getLcdIpSetting() {
        return this.lcdIpSetting;
    }

    public boolean mustReboot() {
        return this.mustReboot;
    }

    public boolean validatePanel() {
        if (!this.netmaskEdit.onValidate()) {
            this.netmaskEdit.requestEditorFocus();
            return false;
        }
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.parent.getUiModel();
        if (nodeModelDelegate.allowIpDisplayed(this.isNodeIP)) {
            this.ipAddr = InetUtil.makeIpAddr(this.ipAddrTF.getText());
        }
        if (!nodeModelDelegate.isSecureMode() || !this.isNodeIP) {
            this.defaultRouter = InetUtil.makeIpAddr(this.defRouterTF.getText());
        }
        boolean bl = false;
        try {
            this.netmask = Short.valueOf((String)this.netmaskEdit.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            db.finer("NumberFormatException in onValidate() " + numberFormatException);
        }
        this.ctcIpDisplaySuppressed = this.userCtcIpDisplaySelection;
        if (this.lcdIpSettingCB != null) {
            this.lcdIpSetting = this.userLcdIpSetting;
        }
        return true;
    }

    private void updateMaskLabel() {
        try {
            int n = Integer.parseInt((String)this.netmaskEdit.getValue());
            int n2 = InetUtil.makeNetMask(n);
            this.netmaskLB.setText(InetUtil.makeDottedString(n2));
        }
        catch (NumberFormatException numberFormatException) {
            db.finer("NumberFormatException in updateMaskLabel() " + numberFormatException);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.parent.setDirty();
        Object object = propertyChangeEvent.getSource();
        if (object == this.netmaskEdit) {
            this.mustReboot = true;
            this.updateMaskLabel();
        }
    }

    private JTextField addTextPanel(JPanel jPanel, JLabel jLabel, int n, DocumentListener documentListener) {
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        if (jLabel != null) {
            jPanel2.add(jLabel);
        }
        JTextField jTextField = new JTextField(n);
        jTextField.setMaximumSize(jTextField.getPreferredSize());
        jPanel2.add(jTextField);
        jPanel.add(jPanel2);
        if (this.parent.isUserAuthorized()) {
            jTextField.getDocument().addDocumentListener(this);
        } else {
            jTextField.setEditable(false);
        }
        return jTextField;
    }

    private void generalChanges(DocumentEvent documentEvent) {
        this.parent.setDirty();
        if (documentEvent.getDocument() != this.defRouterTF.getDocument()) {
            this.mustReboot = true;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.lcdIpSettingCB)) {
            this.userLcdIpSetting = ((Attribute)this.lcdIpSettingCB.getSelectedItem()).getIntValue();
            this.parent.setDirty();
        } else if (object.equals(this.ctcIpSuppressedCB)) {
            this.userCtcIpDisplaySelection = this.ctcIpSuppressedCB.isSelected();
            this.parent.setDirty();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.generalChanges(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.generalChanges(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.generalChanges(documentEvent);
    }

    private static Attribute getLcdIpSettingAttr(int n) {
        return 0 <= n && n < LCD_IP_SETTING_ATTRS.length ? LCD_IP_SETTING_ATTRS[n] : LCD_IP_SETTING_ATTRS[0];
    }

    static {
        for (int i = 0; i < LCD_IP_SETTING_ATTRS.length; ++i) {
            IpAddrPanel.LCD_IP_SETTING_ATTRS[i] = new Attribute(LcdIpSetting.LCD_IP_SETTING[i], i);
        }
        db = new SDebug((KDebug)AbstractShelfProvPane.db, "IpAddrPanel");
    }
}

