/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Optics.eRingDirection;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.cms.ui.shelf.OchsPwrMonitoringChartModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.BarChart;
import com.klg.jclass.chart.ChartDataModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class MaintPwrMonitoringPane
extends AbstractPane
implements ActionListener {
    private static final String REFRESH = "Refresh";
    private JButton refreshButton = new JButton("Refresh");
    private JLabel refreshLabel = new JLabel("");
    private boolean isGUIInited = false;
    private boolean isModelInited = false;
    private int wssSlotEW = 0;
    private int wssSlotWE = 0;
    private TabbedView parent;
    private NodeModelDelegate nodeModel;
    private static final SDebug db = new SDebug((KDebug)AbstractShelfProvPane.db, "MaintPwrMonitoringPane");
    private JSplitPane splitPane;
    private BarChart chartWE = null;
    private BarChart chartEW = null;
    private OchsPwrMonitoringChartModel chartDataModelEW = null;
    private OchsPwrMonitoringChartModel chartDataModelWE = null;
    private JPanel chartPaneEW = new JPanel(new BorderLayout());
    private JPanel chartPaneWE = new JPanel(new BorderLayout());

    public MaintPwrMonitoringPane(String string, TabbedView tabbedView) {
        this(string, tabbedView.getUiModel(), tabbedView);
    }

    public MaintPwrMonitoringPane(String string, IModel iModel, TabbedView tabbedView) {
        super(string, iModel, tabbedView);
        this.nodeModel = (NodeModelDelegate)this.uiModel;
    }

    private void initGUI() {
        if (db.on()) {
            db.println("initGUI()");
        }
        this.setLayout(new BorderLayout());
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.initButtonPanel();
        this.initChartsPanel();
        this.initCharts();
        this.isGUIInited = true;
    }

    protected void initButtonPanel() {
        if (db.on()) {
            db.println("initButtonPanel()");
        }
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.MaintDwdmPwrMonitoring);
        this.refreshButton.addActionListener(this);
        this.refreshButton.setEnabled(true);
        cSHelpButtonPane.addLeft(this.refreshButton);
        cSHelpButtonPane.addRight(this.refreshLabel);
        this.add(cSHelpButtonPane, "South");
    }

    protected void initModel() {
        if (db.on()) {
            db.println("initModel()");
        }
        int n = 0;
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        if ((this.nodeModel.getNodeType() == 2 || this.nodeModel.getNodeType() == 1) && this.nodeModel.getNodeOpticalType() == 12) {
            Object object;
            IEntityModel iEntityModel = this.nodeModel.getChassis();
            if (iEntityModel != null) {
                object = iEntityModel.getDescendantsOfClassType(1);
                IEntityModel iEntityModel2 = (IEntityModel)object.get(0);
                List list = iEntityModel2.getDescendantsOfClassType(6);
                Object[] objectArray = list.toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    try {
                        IModuleModel iModuleModel = (IModuleModel)objectArray[i];
                        if (iModuleModel.getEqType() != eEqType.WSS_32_CARD.value()) continue;
                        if (n < 2) {
                            nArray[n] = iModuleModel.getEntityIndex();
                            nArray2[n] = iModuleModel.getSlot();
                            if (db.on()) {
                                db.println("Found 32WSS slot: " + iModuleModel.getSlot() + " tIndex: " + nArray[n]);
                            }
                            ++n;
                            continue;
                        }
                        if (!db.on()) break;
                        db.println("To much 32WSS in the node");
                        break;
                    }
                    catch (ClassCastException classCastException) {
                        if (!db.on()) continue;
                        db.println("This module is not a IModuleModel: " + i + 1 + " " + classCastException);
                    }
                }
            }
            for (int i = 0; i < n; ++i) {
                try {
                    object = new OchsPwrMonitoringChartModel(this.nodeModel, nArray[i]);
                    ((OchsPwrMonitoringChartModel)((Object)object)).init();
                    if (((OchsPwrMonitoringChartModel)((Object)object)).getRingDirection() == eRingDirection.EAST_WEST.value()) {
                        this.chartDataModelEW = object;
                        this.wssSlotEW = nArray2[i];
                        if (!db.on()) continue;
                        db.println("initModel: model succesfully inited for ROADM site: EW");
                        continue;
                    }
                    this.chartDataModelWE = object;
                    this.wssSlotWE = nArray2[i];
                    if (!db.on()) continue;
                    db.println("initModel: model succesfully inited for ROADM site: WE");
                    continue;
                }
                catch (CTCUserException cTCUserException) {
                    if (!db.on()) continue;
                    db.println("CTCUserException initializing chart for " + nArray[i] + " :" + (Object)((Object)cTCUserException));
                    continue;
                }
                catch (Exception exception) {
                    if (!db.on()) continue;
                    db.println("Exception initializing chart for " + nArray[i] + " :" + exception);
                }
            }
            this.isModelInited = true;
        } else if (db.on()) {
            db.println("initModel: model NOT inited");
        }
    }

    private void initChartsPanel() {
        if (db.on()) {
            db.println("initChartsPanel: create the GUI containers");
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        this.splitPane = new JSplitPane(1, this.chartPaneEW, this.chartPaneWE);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
        jPanel.add((Component)this.splitPane, "Center");
        this.add(jPanel, "Center");
    }

    private void initCharts() {
        if (this.isModelInited) {
            if (db.on()) {
                db.println("initCharts: model inited, draw charts");
            }
            if (this.chartDataModelEW != null) {
                this.chartEW = this.setUpChart(eRingDirection.EAST_WEST.value());
                this.chartPaneEW.add((Component)this.chartEW.getComponentObj(), "Center");
                if (db.on()) {
                    db.println("initCharts: added EW chart to pane");
                }
            }
            if (this.chartDataModelWE != null) {
                this.chartWE = this.setUpChart(eRingDirection.WEST_EAST.value());
                this.chartPaneWE.add((Component)this.chartWE.getComponentObj(), "Center");
                if (db.on()) {
                    db.println("initCharts: added WE chart to pane");
                }
            } else {
                this.splitPane.setResizeWeight(1.0);
            }
            if (this.chartDataModelEW != null && this.chartDataModelWE != null) {
                this.splitPane.setResizeWeight(0.5);
                this.splitPane.setDividerLocation(0.5);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.refresh();
    }

    private BarChart setUpChart(int n) {
        String string;
        BarChart barChart = new BarChart();
        if (n == eRingDirection.WEST_EAST.value()) {
            barChart.setDataSource((ChartDataModel)this.chartDataModelWE);
            string = "W->E - slot" + this.wssSlotWE;
        } else {
            barChart.setDataSource((ChartDataModel)this.chartDataModelEW);
            string = "E->W - slot" + this.wssSlotEW;
        }
        barChart.setAutoLabel(true);
        barChart.setBarOverlap(100);
        barChart.setGridVisible(true);
        barChart.setYaxisTitle("dBm");
        barChart.setXaxisTitle("Channel");
        barChart.setOrigin(-25.0);
        barChart.setMin(-25.0);
        barChart.setHeader(string);
        Color color = new Color(187, 187, 240);
        barChart.setBackground(color);
        barChart.setLegendAnchor(34);
        barChart.setLegendOrientation(0);
        barChart.setLegendVisible(true);
        return barChart;
    }

    public void enteringPage() throws Exception {
        if (db.on()) {
            db.println("enteringPage()");
        }
        if (!this.isModelInited) {
            if (db.on()) {
                db.println("enteringPage: call initModel()");
            }
            this.initModel();
        }
        if (!this.isGUIInited) {
            if (db.on()) {
                db.println("enteringPage: call initGUI()");
            }
            this.initGUI();
        }
    }

    public void leavingPage() throws Exception {
        if (db.on()) {
            db.println("leavingPage()");
        }
    }

    public void refresh() {
        if (db.on()) {
            db.println("refresh()");
        }
        try {
            if (!this.isModelInited) {
                if (db.on()) {
                    db.println("refresh: call initModel(), initCharts()");
                }
                this.initModel();
                this.initCharts();
                this.validate();
            } else {
                if (db.on()) {
                    db.println("refresh: refreshPwrData()");
                }
                if (this.chartDataModelWE != null) {
                    this.chartDataModelWE.refreshPwrData();
                }
                if (this.chartDataModelEW != null) {
                    this.chartDataModelEW.refreshPwrData();
                }
            }
        }
        catch (CTCUserException cTCUserException) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)cTCUserException);
            }
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_REFRESH_PWR_MONIT);
        }
        this.refreshLabel.setText(this.getTimeStampString());
    }

    protected String getTimeStampString() {
        return "Refreshed: " + MaintPwrMonitoringPane.getFormattedDateTime();
    }

    public void destroy() {
        super.destroy();
        if (db.on()) {
            db.println("destroy()");
        }
        if (this.isModelInited) {
            if (db.on()) {
                db.println("destroy: disposing chart models");
            }
            this.chartDataModelWE = null;
            this.chartDataModelEW = null;
        }
    }
}

