/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.ui.shelf.MaintSpTreeRowObject;
import cerent.util.ComparisonUtil;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;

public class MaintSpTreeColumnRenderer
extends AbstractColumnRenderer {
    public static final int SPT_ID = 0;
    public static final int BRIDGE_ID = 1;
    public static final int TOPO_AGE = 2;
    public static final int TOPO_CHANGES = 3;
    public static final int DESIG_ROOT = 4;
    public static final int ROOT_COST = 5;
    public static final int ROOT_PORT = 6;
    public static final int MAX_AGE = 7;
    public static final int HELLO_TIME = 8;
    public static final int HOLD_TIME = 9;
    public static final int FORWARD_DELAY = 10;
    private JLabel label;
    private int mode;
    private boolean bgChecked = false;
    private static final EmptyBorder emptyBorder = new EmptyBorder(0, 5, 0, 2);

    public MaintSpTreeColumnRenderer(int n, String string, int n2, boolean bl, int n3) {
        super(string, n2, bl, n3);
        this.mode = n;
        this.label = new JLabel();
        this.label.setHorizontalAlignment(this.alignment);
        this.label.setOpaque(true);
        this.label.setBorder(emptyBorder);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        String string;
        if (!this.bgChecked) {
            this.label.setBackground(jTable.getBackground());
            this.bgChecked = true;
        }
        MaintSpTreeRowObject maintSpTreeRowObject = (MaintSpTreeRowObject)object;
        if (maintSpTreeRowObject.info == null) {
            this.label.setText("<null info>");
            return this.label;
        }
        switch (this.mode) {
            case 0: {
                string = Integer.toString(maintSpTreeRowObject.spTreeId);
                break;
            }
            case 1: {
                string = maintSpTreeRowObject.getPrintableBridgeId();
                break;
            }
            case 2: {
                string = Integer.toString(maintSpTreeRowObject.info.timeSinceTopologyChange);
                break;
            }
            case 3: {
                string = Integer.toString(maintSpTreeRowObject.info.topologyChanges);
                break;
            }
            case 4: {
                string = maintSpTreeRowObject.getPrintableDesignatedRoot();
                break;
            }
            case 5: {
                string = Integer.toString(maintSpTreeRowObject.info.rootCost);
                break;
            }
            case 6: {
                string = Integer.toString(maintSpTreeRowObject.info.rootPort);
                break;
            }
            case 7: {
                string = Integer.toString(maintSpTreeRowObject.info.maxAge);
                break;
            }
            case 8: {
                string = Integer.toString(maintSpTreeRowObject.info.helloTime);
                break;
            }
            case 9: {
                string = Integer.toString(maintSpTreeRowObject.info.holdTime);
                break;
            }
            case 10: {
                string = Integer.toString(maintSpTreeRowObject.info.forwardDelay);
                break;
            }
            default: {
                string = "???";
            }
        }
        this.label.setText(string);
        return this.label;
    }

    public static ColumnRenderer createColumnRenderer(int n) {
        String string = null;
        int n2 = 60;
        boolean bl = true;
        int n3 = 4;
        switch (n) {
            case 0: {
                n2 = 20;
                string = "#";
                n3 = 0;
                break;
            }
            case 1: {
                n2 = 120;
                string = "Bridge ID";
                break;
            }
            case 2: {
                string = "Topo Age";
                break;
            }
            case 3: {
                n2 = 100;
                string = "Topo Changes";
                break;
            }
            case 4: {
                n2 = 120;
                string = "Designated Root";
                break;
            }
            case 5: {
                string = "Root Cost";
                break;
            }
            case 6: {
                string = "Root Port";
                break;
            }
            case 7: {
                n2 = 120;
                string = "Max Age (sec)";
                break;
            }
            case 8: {
                n2 = 120;
                string = "Hello Time (sec)";
                break;
            }
            case 9: {
                n2 = 120;
                string = "Hold Time (sec)";
                break;
            }
            case 10: {
                n2 = 120;
                string = "Forward Delay (sec)";
            }
        }
        return new MaintSpTreeColumnRenderer(n, string, n2, bl, n3);
    }

    public int compareColumn(Object object, Object object2, int n) {
        int n2;
        MaintSpTreeRowObject maintSpTreeRowObject = (MaintSpTreeRowObject)object;
        MaintSpTreeRowObject maintSpTreeRowObject2 = (MaintSpTreeRowObject)object2;
        switch (this.mode) {
            case 0: {
                n2 = ComparisonUtil.compare(maintSpTreeRowObject.spTreeId, maintSpTreeRowObject2.spTreeId);
                break;
            }
            case 1: {
                n2 = maintSpTreeRowObject.bridgeIdCompare(maintSpTreeRowObject.info.bridgeId, maintSpTreeRowObject2.info.bridgeId);
                break;
            }
            case 2: {
                n2 = ComparisonUtil.compare(maintSpTreeRowObject.info.timeSinceTopologyChange, maintSpTreeRowObject2.info.timeSinceTopologyChange);
                break;
            }
            case 3: {
                n2 = ComparisonUtil.compare(maintSpTreeRowObject.info.topologyChanges, maintSpTreeRowObject2.info.topologyChanges);
                break;
            }
            case 4: {
                n2 = maintSpTreeRowObject.bridgeIdCompare(maintSpTreeRowObject.info.designatedRoot, maintSpTreeRowObject2.info.designatedRoot);
                break;
            }
            case 5: {
                n2 = ComparisonUtil.compare(maintSpTreeRowObject.info.rootCost, maintSpTreeRowObject2.info.rootCost);
                break;
            }
            case 6: {
                n2 = ComparisonUtil.compare(maintSpTreeRowObject.info.rootPort, maintSpTreeRowObject2.info.rootPort);
                break;
            }
            case 7: {
                n2 = ComparisonUtil.compare(maintSpTreeRowObject.info.maxAge, maintSpTreeRowObject2.info.maxAge);
                break;
            }
            case 8: {
                n2 = ComparisonUtil.compare(maintSpTreeRowObject.info.helloTime, maintSpTreeRowObject2.info.helloTime);
                break;
            }
            case 9: {
                n2 = ComparisonUtil.compare(maintSpTreeRowObject.info.holdTime, maintSpTreeRowObject2.info.holdTime);
                break;
            }
            case 10: {
                n2 = ComparisonUtil.compare(maintSpTreeRowObject.info.forwardDelay, maintSpTreeRowObject2.info.forwardDelay);
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }
}

