/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.AbstractTermConnectionModel;
import cerent.cms.model.AdminState;
import cerent.cms.model.Busy;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.shelf.AbstractTermCreationDialog;
import cerent.cms.ui.shelf.OscPane;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.TDMTerminology;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ListSelectionEvent;

public class OscTermCreationDialog
extends AbstractTermCreationDialog {
    private static final String TITLE = "Create OSC Terminations";

    public static OscTermCreationDialog instance(OscPane oscPane) {
        Frame frame = JOptionPane.getFrameForComponent((Component)((Object)oscPane));
        AbstractTermConnectionModel abstractTermConnectionModel = (AbstractTermConnectionModel)oscPane.getUiModel();
        return new OscTermCreationDialog(frame, TITLE, abstractTermConnectionModel);
    }

    private OscTermCreationDialog(Frame frame, String string, Object object) {
        super(frame, string, "OSC", object);
    }

    protected JPanel getButtonPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        TDMTerminology tDMTerminology = this.connTable.getNodeModelDelegate().getTDMTerminology();
        String string = AdminState.getAdminTermIS(tDMTerminology);
        String string2 = AdminState.getAdminTermDSBLD(tDMTerminology);
        String string3 = AdminState.getAdminTermMT(tDMTerminology);
        this.asIs = new JRadioButton("Leave unchanged");
        this.toIS = new JRadioButton("Set to '" + string + "'");
        this.OOStoMT = new JRadioButton("Set '" + string2 + "' to '" + string3 + "'");
        this.asIs.setEnabled(false);
        this.toIS.setEnabled(false);
        this.toIS.setSelected(true);
        this.OOStoMT.setEnabled(false);
        this.adminStateGroup = new ButtonGroup();
        this.adminStateGroup.add(this.asIs);
        this.adminStateGroup.add(this.toIS);
        this.adminStateGroup.add(this.OOStoMT);
        jPanel3.setLayout(new GridLayout(2, 2));
        jPanel3.add(this.asIs);
        jPanel3.add(this.toIS);
        jPanel3.add(this.OOStoMT);
        jPanel3.setBorder(BorderFactory.createTitledBorder("Port Admin State"));
        jPanel3.setEnabled(false);
        jPanel4.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel4.add(this.okButton);
        this.okButton.setEnabled(false);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel4.add(this.cancelButton);
        jPanel.add((Component)jPanel3, "North");
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel4, "South");
        return jPanel;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            boolean bl = this.termList.getSelectionModel().isSelectionEmpty();
            this.okButton.setEnabled(!bl);
        }
    }

    protected void ok() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            Object[] objectArray = this.termList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.connTable.createTermination((IEntityModel)objectArray[i], new Object[]{Boolean.TRUE, Boolean.FALSE});
                arrayList.add(objectArray[i]);
            }
            this.dispose();
        }
        catch (Busy busy) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_DWDM_RING_ASSIGNED);
        }
        catch (Exception exception) {
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_CREATE_OSC_TERM, this.getValidTermMsg(arrayList), AnnotatedException.getString((Exception)exception));
        }
    }

    private String getValidTermMsg(ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        if (arrayList.size() > 0) {
            stringBuffer.append("\n\nThe following Osc terminations were successful:");
            EntityCellRenderer entityCellRenderer = new EntityCellRenderer("slot ");
            for (int i = 0; i < arrayList.size(); ++i) {
                EntityModel entityModel = (EntityModel)arrayList.get(i);
                String string = entityCellRenderer.getString(entityModel, "slot ");
                stringBuffer.append("\n" + string);
            }
        }
        return stringBuffer.toString();
    }

    protected void createTermination(IEntityModel iEntityModel) throws Exception {
        if (iEntityModel == null) {
            throw new Exception("Wrong call");
        }
    }
}

