/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.EntityModel;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.PimModel;
import cerent.cms.model.PluggableModel;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.helper.PluggableHelper;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardView;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class PluggableSlotView
extends CardView
implements ActionListener {
    public static final int PPM_SLOT_WIDTH = 26;
    public static final int PPM_SLOT_HEIGHT = 26;
    protected String alarmProfileString = "";
    protected String statusString = "";
    protected PluggableModel pluggableCardModel = null;
    protected CardView pluggableCardView = null;
    protected static final SDebug db = new SDebug("PluggableSlotView");

    public PluggableSlotView(EntityModel entityModel) {
        super(entityModel);
        if (db.on()) {
            db.println("PluggableSlotView: " + entityModel.getEqLabel() + "\tNum of children: " + entityModel.getChildren());
        }
        this.addChildren();
        this.registerForLocalUpdates();
        this.updateStatus();
        this.setBorder(this.createCustomBorder());
        this.setBackground(Color.lightGray);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getModifiers() == 4) {
                    PluggableSlotView.this.showPopupMenu(mouseEvent.getPoint());
                }
            }
        });
    }

    protected void updateStatus() {
        block4: {
            if (this.model != null) {
                try {
                    this.alarmProfileString = this.model.getAlarmProfileName();
                    int n = -1;
                    if (this.model instanceof PpmModel || this.model instanceof PimModel) {
                        n = ((MfgEntityModel)this.model).getServiceSt().getType();
                    }
                    this.statusString = MfgEntityModel.getTDMTerminology(this.model).getTermForServiceState(n);
                }
                catch (Exception exception) {
                    if (!db.on()) break block4;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        this.setToolTipText();
    }

    protected void addPorts(boolean bl) {
    }

    protected void addChildren() {
    }

    protected void registerForLocalUpdates() {
        if (this.model != null) {
            this.model.addObserver(this);
            if (this.pluggableCardModel != null) {
                this.pluggableCardModel.addObserver(this);
            }
            if (db.on()) {
                db.println("PluggableSlotView: Registered parent: " + this.model + "\tChild: " + this.pluggableCardModel);
            }
        }
    }

    protected void deregisterFromLocalUpdates() {
        if (this.model != null) {
            this.model.deleteObserver(this);
            if (this.pluggableCardModel != null) {
                this.pluggableCardModel.deleteObserver(this);
            }
            if (db.on()) {
                db.println("PluggableSlotView: Deregistered parent: " + this.model + "\tChild: " + this.pluggableCardModel);
            }
        }
    }

    protected JLabel getLabel() {
        JLabel jLabel = new JLabel(PluggableHelper.getHierarchyNumString(((PluggableSlotModel)this.model).getHierarchyNums(), '-'));
        jLabel.setFont(new Font("Arial", 1, 10));
        jLabel.setHorizontalAlignment(0);
        jLabel = AbstractShelfLayout.formatLabel(jLabel);
        return jLabel;
    }

    protected Border createCustomBorder() {
        if (this.pci.is600()) {
            return BorderFactory.createLoweredBevelBorder();
        }
        return BorderFactory.createLineBorder(Color.black);
    }

    public void update(Observable observable, Object object) {
        if (this.model == null) {
            if (db.on()) {
                db.println("update: model is NULL, no update");
            }
            return;
        }
        if (observable instanceof EntityModel && this.model != null && this.model.getNodeModel().isInited() && object instanceof Integer) {
            Integer n = (Integer)object;
            if (n.equals(ModelUpdateType.ADDED) && observable == this.model) {
                SwingUtilities.invokeLater(new ReplaceCard());
                if (db.on()) {
                    db.println("PluggableSlotView: PIM card ADDED");
                }
            } else if (n.equals(ModelUpdateType.DELETED) && observable instanceof PluggableModel) {
                SwingUtilities.invokeLater(new ReplaceCard());
                if (db.on()) {
                    db.println("PluggableSlotView: PIM Card DELETED");
                }
            }
        }
    }

    public List getChildren() {
        ArrayList<CardView> arrayList = new ArrayList<CardView>();
        if (this.pluggableCardView != null) {
            arrayList.add(this.pluggableCardView);
        }
        return arrayList;
    }

    public void setToolTipText() {
        if (this.model == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.model.getEqLabel());
        stringBuffer.append(" [");
        stringBuffer.append(PluggableHelper.getHierarchyNumString(((PluggableSlotModel)this.model).getHierarchyNums(), '-'));
        stringBuffer.append("]");
        super.setToolTipText(stringBuffer.toString());
    }

    public boolean hasProvisionedCard() {
        boolean bl;
        block2: {
            bl = false;
            try {
                bl = this.model.getChildren().size() != 0;
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return bl;
    }

    protected void showPopupMenu(Point point) {
        boolean bl = AbstractPane.isUserAuthorized(this.model, SecurityLevel.PROVISIONING);
        if (this.isPopupMenuEnabled()) {
            PluggableModel pluggableModel = (PluggableModel)this.model.getParent();
            if (pluggableModel.getState() == eEqState.DELETED) {
                bl = false;
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(new NonSelectableMI(this.getMenuTitle()));
            jPopupMenu.addSeparator();
            eEqType[] eEqTypeArray = ((PluggableSlotModel)this.model).getPluggableTypeList();
            for (int i = 0; i < eEqTypeArray.length; ++i) {
                jPopupMenu.add(this.createMenuItem(EntityModel.eqType2Name(this.model.getNodeModel().getTDMTerminology(), eEqTypeArray[i].value()), bl));
            }
            jPopupMenu.show(this, point.x, point.y);
        }
    }

    protected boolean isPopupMenuEnabled() {
        return this.model.getChildren().size() == 0;
    }

    protected JMenuItem createMenuItem(String string, boolean bl) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setEnabled(bl);
        if (bl) {
            jMenuItem.addActionListener(this);
        }
        return jMenuItem;
    }

    protected String getMenuTitle() {
        return "Add";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.doActionEvent(actionEvent);
    }

    protected void doActionEvent(ActionEvent actionEvent) {
    }

    public Dimension getPreferredSize() {
        if (this.pci.is600()) {
            return new Dimension(36, 36);
        }
        return new Dimension(26, 26);
    }

    public void dispose() {
        this.localDispose();
        super.dispose();
    }

    protected void localDispose() {
        this.deregisterFromLocalUpdates();
        if (this.pluggableCardView != null) {
            this.pluggableCardView.dispose();
            this.pluggableCardView = null;
        }
        this.removeAll();
    }

    protected class NonSelectableMI
    extends JMenuItem {
        public NonSelectableMI(String string) {
            super(string);
        }

        public void menuSelectionChanged(boolean bl) {
        }
    }

    private class ReplaceCard
    implements Runnable {
        private ReplaceCard() {
        }

        public void run() {
            block2: {
                try {
                    PluggableSlotView.this.localDispose();
                    PluggableSlotView.this.addChildren();
                    PluggableSlotView.this.registerForLocalUpdates();
                }
                catch (Exception exception) {
                    if (!db.on()) break block2;
                    db.println("Error replacing PIM/PPM card: " + exception);
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            PluggableSlotView.this.revalidate();
            PluggableSlotView.this.repaint();
        }
    }
}

