/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ProxyPortError;
import cerent.cms.model.ProxyXlator;
import cerent.cms.ui.NodeProvPane;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class ProxySettingsPane
extends JPanel {
    private JCheckBox proxyNoneCB;
    private JRadioButton proxyEneRB;
    private JRadioButton proxyGneRB;
    private JRadioButton proxyPneRB;
    private JRadioButton dummyRB;
    private JTextField proxyPortTF;
    private int currentNodeProxyProfile;
    private DocumentListener proxyPortListener;
    private int proxyPortVal;
    private JLabel proxyStatusLabel;
    private boolean authorized;
    private boolean proxyIsDirty;
    private NodeProvPane parent;

    public ProxySettingsPane(boolean bl) {
        this.authorized = bl;
        this.proxyNoneCB = null;
        this.proxyEneRB = null;
        this.proxyGneRB = null;
        this.proxyPneRB = null;
        this.dummyRB = null;
        this.proxyStatusLabel = null;
        this.proxyPortTF = null;
        this.proxyPortListener = null;
        this.proxyPortVal = 0;
        this.proxyIsDirty = false;
    }

    public ProxySettingsPane(NodeProvPane nodeProvPane, boolean bl) {
        this(bl);
        this.parent = nodeProvPane;
    }

    public void init(NodeModelDelegate nodeModelDelegate) {
        this.createProxyPanel(nodeModelDelegate);
        this.setAlignmentX(0.0f);
    }

    private boolean validProxyPort(String string) {
        try {
            this.proxyPortVal = Integer.parseInt(string);
            return this.proxyPortVal > 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private void createProxyPanel(NodeModelDelegate nodeModelDelegate) {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new TitledBorder("Gateway Settings"));
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.proxyStatusLabel = new JLabel();
        jPanel.add(this.proxyStatusLabel);
        this.add(jPanel);
        jPanel = new JPanel(new FlowLayout(0, 0, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl;
                int n = ProxySettingsPane.this.getUserProxyProfile();
                boolean bl2 = bl = n != 0;
                if (bl) {
                    switch (n) {
                        case 3: {
                            ProxySettingsPane.this.proxyEneRB.setSelected(true);
                            break;
                        }
                        case 2: {
                            ProxySettingsPane.this.proxyGneRB.setSelected(true);
                            break;
                        }
                        case 1: {
                            ProxySettingsPane.this.proxyPneRB.setSelected(true);
                        }
                    }
                } else {
                    ProxySettingsPane.this.proxyEneRB.setSelected(false);
                    ProxySettingsPane.this.proxyGneRB.setSelected(false);
                    ProxySettingsPane.this.proxyPneRB.setSelected(false);
                    ProxySettingsPane.this.dummyRB.setSelected(true);
                }
                ProxySettingsPane.this.proxyEneRB.setEnabled(bl);
                ProxySettingsPane.this.proxyGneRB.setEnabled(bl);
                ProxySettingsPane.this.proxyPneRB.setEnabled(bl);
                ProxySettingsPane.this.proxyIsDirty = true;
                ProxySettingsPane.this.setDirty();
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProxySettingsPane.this.proxyIsDirty = true;
                ProxySettingsPane.this.setDirty();
            }
        };
        this.proxyNoneCB = this.addCheckBox(jPanel, "Enable SOCKS proxy on port:", this.authorized, actionListener);
        this.proxyPortListener = new ProxyPortListener();
        this.proxyPortTF = new JTextField(7);
        this.proxyPortTF.getDocument().addDocumentListener(this.proxyPortListener);
        this.proxyPortTF.setEnabled(false);
        jPanel.add(this.proxyPortTF);
        this.add(jPanel);
        this.proxyEneRB = this.addRadioButton(this, buttonGroup, "External Network Element (ENE)", this.authorized, actionListener2);
        this.proxyEneRB.setToolTipText(this.getProxyToolTip(nodeModelDelegate, 3));
        this.proxyGneRB = this.addRadioButton(this, buttonGroup, "Gateway Network Element (GNE)", this.authorized, actionListener2);
        this.proxyGneRB.setToolTipText(this.getProxyToolTip(nodeModelDelegate, 2));
        this.proxyPneRB = this.addRadioButton(this, buttonGroup, "SOCKS proxy only", this.authorized, actionListener2);
        this.proxyPneRB.setToolTipText(this.getProxyToolTip(nodeModelDelegate, 1));
        this.dummyRB = this.addRadioButton(this, buttonGroup, " ", this.authorized, actionListener2);
        this.dummyRB.setVisible(false);
    }

    private void setDirty() {
        if (this.parent != null) {
            this.parent.setDirty();
        }
    }

    private boolean proxyIsDirty() {
        return this.proxyIsDirty;
    }

    private String getProxyToolTip(NodeModelDelegate nodeModelDelegate, int n) {
        return "Enable: " + ProxyXlator.getProxyStatus(nodeModelDelegate, n);
    }

    private JTextField addTextPanel(JPanel jPanel, String string, int n, DocumentListener documentListener) {
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 0));
        if (string != null) {
            jPanel2.add(this.createLabel(string));
        }
        JTextField jTextField = new JTextField(n);
        jTextField.setMaximumSize(jTextField.getPreferredSize());
        jPanel2.add(jTextField);
        jPanel.add(jPanel2);
        if (this.authorized) {
            jTextField.getDocument().addDocumentListener(documentListener);
        } else {
            jTextField.setEditable(false);
        }
        return jTextField;
    }

    private JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(100, 20));
        return jLabel;
    }

    private JCheckBox addCheckBox(JPanel jPanel, String string, boolean bl, ActionListener actionListener) {
        JCheckBox jCheckBox = new JCheckBox(string);
        jCheckBox.setAlignmentX(0.0f);
        jCheckBox.setEnabled(bl);
        jCheckBox.addActionListener(actionListener);
        jPanel.add(jCheckBox);
        return jCheckBox;
    }

    private JRadioButton addRadioButton(JPanel jPanel, ButtonGroup buttonGroup, String string, boolean bl, ActionListener actionListener) {
        JRadioButton jRadioButton = new JRadioButton(string);
        jRadioButton.setAlignmentX(0.0f);
        jRadioButton.setEnabled(bl);
        jRadioButton.addActionListener(actionListener);
        jRadioButton.setSize(new Dimension(80, 20));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 0));
        jPanel2.add(jRadioButton);
        jPanel.add(jPanel2);
        buttonGroup.add(jRadioButton);
        return jRadioButton;
    }

    public int getUserProxyProfile() {
        int n = 0;
        if (this.proxyNoneCB.isSelected()) {
            n = this.proxyEneRB.isSelected() ? 3 : (this.proxyGneRB.isSelected() ? 2 : (this.proxyPneRB.isSelected() ? 1 : 2));
        }
        return n;
    }

    public int getCurrentNodeProxyProfile() {
        return this.currentNodeProxyProfile;
    }

    private String getProxyPortVal() {
        Document document = this.proxyPortTF.getDocument();
        try {
            return document.getText(0, document.getEndPosition().getOffset()).trim();
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    private void getProxy(NodeModelDelegate nodeModelDelegate, boolean bl) {
        this.currentNodeProxyProfile = ProxyXlator.getProxy(nodeModelDelegate);
        boolean bl2 = this.currentNodeProxyProfile != 0;
        boolean bl3 = nodeModelDelegate.isSecureMode();
        if (bl) {
            this.proxyNoneCB.setSelected(bl2);
            this.proxyEneRB.setEnabled(bl2);
            this.proxyGneRB.setEnabled(bl2);
            if (bl3) {
                this.proxyNoneCB.setEnabled(false);
                this.proxyPneRB.setEnabled(false);
            } else {
                this.proxyNoneCB.setEnabled(true);
                this.proxyPneRB.setEnabled(bl2);
            }
        } else if (!bl3) {
            this.proxyNoneCB.setSelected(true);
            this.proxyNoneCB.setEnabled(false);
            this.proxyPneRB.setEnabled(false);
            this.proxyEneRB.setEnabled(true);
            this.proxyGneRB.setEnabled(true);
        } else {
            this.proxyNoneCB.setSelected(bl2);
            this.proxyEneRB.setEnabled(bl2);
            this.proxyGneRB.setEnabled(bl2);
            this.proxyPneRB.setEnabled(bl2);
        }
        switch (this.currentNodeProxyProfile) {
            case 3: {
                this.proxyEneRB.setSelected(true);
                break;
            }
            case 2: {
                this.proxyGneRB.setSelected(true);
                break;
            }
            case 1: {
                this.proxyPneRB.setSelected(true);
                break;
            }
            default: {
                if (bl || bl3) break;
                this.proxyGneRB.setSelected(true);
            }
        }
        this.proxyPortVal = nodeModelDelegate.getProxyPort();
        this.proxyPortTF.getDocument().removeDocumentListener(this.proxyPortListener);
        this.proxyPortTF.setText(Integer.toString(this.proxyPortVal));
        this.proxyPortTF.getDocument().addDocumentListener(this.proxyPortListener);
        this.proxyStatusLabel.setText(" Current Settings: " + ProxyXlator.getProxyStatus(nodeModelDelegate));
    }

    public boolean validateProxySettings(NodeModelDelegate nodeModelDelegate) {
        String string = null;
        String string2 = null;
        if (!this.validProxyPort(this.getProxyPortVal())) {
            return false;
        }
        int n = ProxyXlator.getProxy(nodeModelDelegate);
        int n2 = this.getUserProxyProfile();
        String string3 = ProxyXlator.proxyStringToAlternateString(ProxyXlator.proxyToString(n));
        String string4 = ProxyXlator.proxyStringToAlternateString(ProxyXlator.proxyToString(n2));
        if (n != n2) {
            switch (n) {
                case 1: 
                case 2: 
                case 3: {
                    switch (n2) {
                        case 1: 
                        case 2: 
                        case 3: {
                            string = "Reconfigure as a " + string4 + "?";
                            string2 = "Reconfiguring this node as a " + string4 + " may cause a\n" + "temporary loss of connection.\n";
                            break;
                        }
                        case 0: {
                            string = "Remove " + string3 + " configuration?";
                            string2 = "Removing the " + string3 + " configuration may cause a\n" + "temporary loss of connection.\n";
                        }
                    }
                    break;
                }
                case 0: {
                    switch (n2) {
                        case 1: 
                        case 2: 
                        case 3: {
                            string = "Configure as a " + string4 + "?";
                            string2 = "Configuring this node as a " + string4 + " may cause a \n" + "temporary loss of connection.\n";
                        }
                    }
                }
            }
        }
        if (string2 != null) {
            return CerentDialog.yesNoDialog((Component)this, string2, string);
        }
        return true;
    }

    public void applyChanges(NodeModelDelegate nodeModelDelegate) {
        if (this.proxyIsDirty) {
            ProxyXlator.setProxy(nodeModelDelegate, this.getUserProxyProfile());
        }
        this.proxyIsDirty = false;
    }

    public void refresh(NodeModelDelegate nodeModelDelegate, boolean bl) {
        this.getProxy(nodeModelDelegate, bl);
        this.proxyIsDirty = false;
    }

    private class ProxyPortListener
    implements DocumentListener {
        private ProxyPortListener() {
        }

        protected void generalChanges(DocumentEvent documentEvent) {
            ProxySettingsPane.this.setDirty();
            try {
                String string = ProxySettingsPane.this.getProxyPortVal();
                if (!string.equals("") && !ProxySettingsPane.this.validProxyPort(string)) {
                    ErrorMsg.displayDetailed((Component)ProxySettingsPane.this, EMC.EID_INVALID_PROXY_PORT, new ProxyPortError("Proxy port must be an integer greater than zero").toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.generalChanges(documentEvent);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.generalChanges(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.generalChanges(documentEvent);
        }
    }
}

