/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.AdminState;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ui.DataSourceControl;
import cerent.cms.ui.shelf.ShelfInventoryPane;
import cerent.cms.ui.shelf.ShelfInventoryRowObject;
import cerent.util.BlockingModeController;
import cerent.util.IObservableManager;
import cerent.util.KDebug;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.row.AbstractRowDataSource;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class ShelfInventoryDataSource
extends AbstractRowDataSource
implements Observer,
DataSourceControl,
BlockingModeController {
    private INodeModel node;
    private List entities;
    private ShelfInventoryRowObject[] rowObjects;
    private ObservableManager observableManager;
    private static final int NEEDS_REFRESH = 1;
    private static final int NEEDS_RESET = 2;
    private static final SDebug db = new SDebug((KDebug)ShelfInventoryPane.db, "ShelfInventoryDataSource");

    public ShelfInventoryDataSource(INodeModel iNodeModel) {
        this.node = iNodeModel;
        this.observableManager = new ObservableManager(this, true);
        this.observableManager.setBlockingModeController(this);
    }

    public Object getObjectAtRow(int n) {
        try {
            return this.rowObjects != null ? this.rowObjects[n] : null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (db.on()) {
                db.println("getObjectAtRow " + n + " out of bounds");
            }
            return null;
        }
    }

    public int getRowCount() {
        return this.rowObjects != null ? this.rowObjects.length : 0;
    }

    public Collection getAllObjects() {
        return this.rowObjects != null ? Arrays.asList(this.rowObjects) : new ArrayList();
    }

    public void refreshFromModel(int n) throws Exception {
        if (n == -1 || n == 2) {
            this.resetFromNodeModel();
        }
        this.refreshFromModel();
    }

    private void resetFromNodeModel() {
        IEntityModel iEntityModel;
        IEntityTableModel iEntityTableModel;
        db.config("resetFromNodeModel invoked");
        this.observableManager.setObservable(null);
        List list = null;
        if (this.node != null && (iEntityTableModel = this.node.getEntityTable()) != null && (iEntityModel = iEntityTableModel.getChassis()) != null) {
            this.entities = iEntityModel.getMfgEntities();
            list = iEntityModel.getDescendantsOfClassType(2);
            this.observableManager.addObservable((Observable)((Object)((Model)iEntityModel)));
        }
        if (this.entities == null || this.entities.size() == 0) {
            if (ShelfInventoryDataSource.db.on) {
                db.println("Can't get mfgd entities!");
            }
        } else {
            if (ShelfInventoryDataSource.db.on) {
                db.println("resetFromNodeModel: " + this.entities.size() + " rows");
            }
            this.observableManager.addObservable((Observable[])this.entities.toArray(new Model[this.entities.size()]));
        }
        if (list == null || list.size() == 0) {
            if (ShelfInventoryDataSource.db.on) {
                db.println("Can't get slots!");
            }
        } else {
            if (ShelfInventoryDataSource.db.on) {
                db.println("resetFromNodeModel: " + list.size() + " slots");
            }
            this.observableManager.addObservable((Observable[])list.toArray(new Model[list.size()]));
        }
    }

    public void refreshFromModel() {
        db.config("refreshFromModel invoked");
        ShelfInventoryRowObject[] shelfInventoryRowObjectArray = new ShelfInventoryRowObject[this.entities.size()];
        for (int i = 0; i < this.entities.size(); ++i) {
            if (ShelfInventoryDataSource.db.on) {
                db.println(this.entities.get(i).toString());
            }
            shelfInventoryRowObjectArray[i] = new ShelfInventoryRowObject((MfgEntityModel)this.entities.get(i));
        }
        this.rowObjects = shelfInventoryRowObjectArray;
        this.fireDataSourceChanged();
    }

    public IObservableManager getObservableManager() {
        if (ShelfInventoryDataSource.db.on) {
            db.println("getObservableManager: state = " + this.observableManager.getBlockingModeControllerState());
        }
        return this.observableManager;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            ShelfInventoryRowObject shelfInventoryRowObject = this.rowObjects[i];
            if (shelfInventoryRowObject == null || !shelfInventoryRowObject.isDirty()) continue;
            return true;
        }
        return false;
    }

    public void applyToModel() throws Exception {
        for (int i = 0; i < this.rowObjects.length; ++i) {
            ShelfInventoryRowObject shelfInventoryRowObject = this.rowObjects[i];
            if (!shelfInventoryRowObject.isDirty()) continue;
            if (shelfInventoryRowObject.isDirty(0)) {
                shelfInventoryRowObject.entity.setInventoryCode(shelfInventoryRowObject.getUserCode());
                shelfInventoryRowObject.setDirty(0, false);
            }
            if (!shelfInventoryRowObject.isDirty(1)) continue;
            if (shelfInventoryRowObject.adminStateChanged()) {
                shelfInventoryRowObject.entity.setAdminState(shelfInventoryRowObject.getAdminState().getAdminStateEnum());
            }
            shelfInventoryRowObject.setDirty(1, false);
        }
    }

    public boolean validateData() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.rowObjects.length; ++i) {
            ShelfInventoryRowObject shelfInventoryRowObject = this.rowObjects[i];
            if (!shelfInventoryRowObject.isDirty(1) || !AdminState.isTransitionToOOS(shelfInventoryRowObject.getAdminState().getAdminStateEnum(), shelfInventoryRowObject.getAdminStateFromModel().getAdminStateEnum())) continue;
            stringBuffer.append("Action may be service affecting.").append('\n');
            break;
        }
        if (stringBuffer.length() != 0) {
            stringBuffer.append("Apply changes?");
            if (!CerentDialog.yesNoDialog((Component)this.getFrame(), (String)stringBuffer.toString(), (String)"Confirmation Dialog")) {
                return false;
            }
        }
        return true;
    }

    public void setDirty(boolean bl) {
    }

    public void disposeDataSource() {
        if (this.entities != null) {
            this.entities.clear();
        }
        this.rowObjects = null;
    }

    public void update(Observable observable, Object object) {
        int n;
        if (ShelfInventoryDataSource.db.on) {
            try {
                db.println("update: src = " + observable + ", evt = " + object);
            }
            catch (Exception exception) {
                db.warning("Attempted to access an EntityModel which no longer exists");
            }
        }
        if ((n = this.entities.indexOf(observable)) == -1 || object == ModelUpdateType.DELETED) {
            this.resetFromNodeModel();
        }
        this.refreshFromModel();
    }

    public int processBlockedEvent(Observable observable, Object object, int n) {
        int n2;
        if (ShelfInventoryDataSource.db.on) {
            db.println("processBlockedEvent: src " + observable + ", event = " + object + ", previousState = " + n);
        }
        if ((n2 = this.entities.indexOf(observable)) == -1 || object == ModelUpdateType.DELETED) {
            return 2;
        }
        if (n == 0) {
            return 1;
        }
        return n;
    }

    protected Frame getFrame() {
        return this.node.getUiToolkit().getApplicationFrame();
    }
}

