/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SecurityModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.HtmlLabelEditor;
import java.awt.Component;
import java.util.Observable;
import java.util.Observer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SppDisclaimerPane
extends NodeProvPane
implements DocumentListener {
    private HtmlLabelEditor editor;
    private SecurityModel secM;
    protected static final SDebug db = new SDebug((KDebug)AbstractShelfProvPane.db, "SppDisclaimerPane");

    public SppDisclaimerPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
    }

    private void init() {
        try {
            if (db.on()) {
                db.println("init: start");
            }
            this.setDefaultPrivilegeLevel(SecurityLevel.SUPERUSER);
            this.editor = new HtmlLabelEditor();
            this.editor.setEditable(this.isUserAuthorized());
            this.editor.addDocumentListener((DocumentListener)this);
            this.add((Component)this.editor);
            this.secM = (SecurityModel)((NodeModelDelegate)this.getUiModel()).getSecurityModel();
            if (this.secM != null) {
                this.secM.addObserver((Observer)((Object)this));
            }
            this.refreshFromModel();
            if (db.on()) {
                db.println("init: finish");
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("SppDesclaimerPane:update:from: " + observable.toString());
        }
        if (observable instanceof SecurityModel && object == ModelUpdateType.CHANGED) {
            if (this.editor == null || this.secM == null) {
                if (db.on()) {
                    db.println("SppDesclaimerPane:update:SecurityModel is null");
                }
                return;
            }
            SecurityLevel securityLevel = this.secM.getNodeModelDelegate().getSecurityLevel();
            this.editor.setEditable(securityLevel == SecurityLevel.SUPERUSER);
        }
    }

    public void destroy() {
        if (this.editor == null && this.secM != null) {
            this.secM.deleteObserver((Observer)((Object)this));
            this.secM = null;
        }
        super.destroy();
    }

    public void enteringPage() throws Exception {
        if (this.editor == null) {
            this.init();
        }
        super.enteringPage();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    public void applyChangesToModel() throws Exception {
        if (db.on()) {
            db.println("applyChangesToModel: start");
        }
        String string = this.editor.getText();
        if (db.on()) {
            db.println("set disclaimer text to: \"" + string + "\"");
        }
        this.secM.setLegalDisclaimer(string);
        if (db.on()) {
            db.println("applyChangesToModel: finish");
        }
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshFromModel: start");
        }
        String string = this.secM.getLegalDisclaimer();
        if (db.on()) {
            db.println("get disclaimer text: \"" + string + "\"");
        }
        this.editor.setText(string);
        if (db.on()) {
            db.println("refreshFromModel: finish");
        }
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.SppDisclaimerPane;
    }
}

