/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Common.sTime;
import cerent.cms.idl.Common.sTimeZone;
import cerent.cms.model.Attribute;
import cerent.cms.model.ConfigError;
import cerent.cms.model.CtcTimeZone;
import cerent.cms.model.CtcTimeZoneFactory;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.IPosition;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.Position;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.util.BuildInfo;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.IpSubnet;
import cerent.util.KDebug;
import cerent.util.PluralisationUtil;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.CoordinatePropertyEditor;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class SppGeneralPane
extends NodeProvPane
implements ActionListener,
PropertyChangeListener,
DocumentListener {
    private static final int MAX_NAME_LENGTH = 64;
    private static final int MAX_CONTACT_LENGTH = 255;
    private static final int MAX_DESCRIPTION_LENGTH = 255;
    private static final int MAX_TL1_NAME_LENGTH = 20;
    private static final int MAX_OPER_ID_LENGTH = 9;
    private static final int MAX_OPER_SI_LENGTH = 118;
    private static final String TL1_TID_CHARS = "-\"\\";
    private JTextField nameTF;
    private JTextField contactTF;
    private JTextField operatorTF;
    private JTextArea locDescTF;
    private JTextArea opSpecInfoTA;
    private JCheckBox useSntpCB;
    private JTextField dateTF;
    private JTextField timeTF;
    private JTextField sntpHostTF;
    private JComboBox timezoneCB;
    private JCheckBox useDSTCB;
    private JLabel sysDescLB;
    private CoordinatePropertyEditor latEdit;
    private CoordinatePropertyEditor longEdit;
    private JCheckBox sdpAisvInsertionCB;
    private JComboBox sdpBerCB;
    private JLabel dateLbl;
    private boolean nameDirty;
    private boolean contactDirty;
    private boolean locationDirty;
    private boolean latLongDirty;
    private boolean opIdDirty;
    private boolean opSIDirty;
    private boolean sntpHostDirty;
    private boolean timeDirty;
    private boolean timezoneDirty;
    private boolean useDSTDirty;
    private boolean operFieldsAvailable;
    private boolean sdpAisvInsertionDirty;
    private boolean sdpBerDirty;
    static final SimpleDateFormat timeFmt = new SimpleDateFormat("H:mm:ss");
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static final SDebug db = new SDebug((KDebug)AbstractShelfProvPane.db, "SppGeneralPane");
    private CtcTimeZoneFactory tzFactory;
    private CtcTimeZone currentTz;
    private boolean hasProvPrivilege = false;
    static final int[] mDays = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public SppGeneralPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.SppGeneralPane;
    }

    private void init() {
        db.info("init: start");
        this.setDefaultPrivilegeLevel(SecurityLevel.SUPERUSER);
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel();
        this.hasProvPrivilege = nodeModelDelegate.isSecureMode() ? this.isUserAuthorized(SecurityLevel.SUPERUSER) : this.isUserAuthorized(SecurityLevel.PROVISIONING);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        UScrollPane uScrollPane = new UScrollPane((Component)jPanel);
        this.add((Component)uScrollPane);
        jPanel.add(this.createInfoPanel());
        jPanel.add(this.createLocationPanel());
        this.operFieldsAvailable = false;
        jPanel.add(this.createTimePanel());
        if (this.pci.isConfigurableSDPSupported()) {
            jPanel.add(this.createSdpProvisioningPanel());
        } else {
            this.sdpAisvInsertionCB = null;
            this.sdpBerCB = null;
        }
        jPanel.add(this.createSysDescPanel());
        this.registerWithModel();
        db.info("init: finish");
    }

    private JPanel createInfoPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 5));
        jPanel.setBorder(BorderFactory.createTitledBorder("General"));
        this.nameTF = this.addTextPanel(jPanel, "Node Name: ", 13, this.isUserAuthorized());
        jPanel.add(Box.createHorizontalStrut(45));
        this.contactTF = this.addTextPanel(jPanel, "Contact: ", 13, this.isUserAuthorized());
        return jPanel;
    }

    private JPanel createLocationPanel() {
        JPanel jPanel = SppGeneralPane.createVerticalPanel("Location");
        jPanel.setLayout(new BorderLayout(0, 0));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 5));
        this.latEdit = new CoordinatePropertyEditor("", CoordinatePropertyEditor.LATITUDE);
        this.longEdit = new CoordinatePropertyEditor("", CoordinatePropertyEditor.LONGITUDE);
        jPanel2.add(this.createAttributePanel("Latitude: ", this.latEdit));
        jPanel2.add(Box.createHorizontalStrut(46));
        jPanel2.add(this.createAttributePanel("Longitude: ", this.longEdit));
        if (this.isUserAuthorized()) {
            this.latEdit.addPropertyChangeListener(this);
            this.longEdit.addPropertyChangeListener(this);
        } else {
            this.latEdit.setEnabled(false);
            this.longEdit.setEnabled(false);
        }
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel3.add(this.createLabel("Description: "));
        this.locDescTF = new JTextArea(2, 43);
        this.locDescTF.setLineWrap(true);
        this.locDescTF.setWrapStyleWord(true);
        if (this.isUserAuthorized()) {
            this.locDescTF.getDocument().addDocumentListener(this);
        } else {
            this.locDescTF.setEnabled(false);
        }
        UScrollPane uScrollPane = new UScrollPane((Component)this.locDescTF, 20, 31);
        jPanel3.add((Component)uScrollPane);
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    private JPanel createTimePanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 5));
        jPanel.setBorder(BorderFactory.createTitledBorder("Time"));
        Dimension dimension = new Dimension(500, 140);
        jPanel.setPreferredSize(dimension);
        jPanel.setMinimumSize(dimension);
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.add(Box.createHorizontalStrut(5));
        this.useSntpCB = new JCheckBox("Use NTP/SNTP Server:");
        jPanel2.add(this.useSntpCB);
        jPanel2.add(Box.createHorizontalStrut(20));
        this.sntpHostTF = this.addTextPanel(jPanel2, null, 13, this.hasProvPrivilege);
        this.sntpHostTF.setName("NTP/SNTP Server");
        jPanel2.add(Box.createHorizontalStrut(40));
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.add(Box.createHorizontalStrut(7));
        String string = Preferences.instance().getProperty("ctc", "dateFormat", "MM/DD/YY");
        this.dateTF = string.equals("MM/DD/YY") ? this.addTextPanel(jPanel2, "Date (M/D/Y): ", 13, this.hasProvPrivilege) : this.addTextPanel(jPanel2, "Date (D/M/Y): ", 13, this.hasProvPrivilege);
        for (int i = 0; i < jPanel2.getComponentCount(); ++i) {
            if (!(jPanel2.getComponent(i) instanceof JLabel)) continue;
            this.dateLbl = (JLabel)jPanel2.getComponent(i);
        }
        jPanel2.add(Box.createHorizontalStrut(58));
        this.timeTF = this.addTextPanel(jPanel2, "Time (H:M:S): ", 13, this.hasProvPrivilege);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel();
        this.timezoneCB = new JComboBox();
        this.tzFactory = nodeModelDelegate.getCtcTimeZoneFactory();
        for (int i = 0; i < this.tzFactory.getNumberofTimeZones(); ++i) {
            CtcTimeZone ctcTimeZone = this.tzFactory.getCtcTimeZone(i);
            this.timezoneCB.addItem(ctcTimeZone);
        }
        jPanel2.add(Box.createHorizontalStrut(7));
        jPanel2.add(this.createLabel("Time Zone: "));
        Dimension dimension2 = new Dimension(435, 20);
        this.timezoneCB.setPreferredSize(dimension2);
        this.timezoneCB.setMinimumSize(dimension2);
        this.timezoneCB.setMaximumSize(dimension2);
        jPanel2.add(this.timezoneCB);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.add(Box.createHorizontalStrut(5));
        this.useDSTCB = new JCheckBox("Use Daylight Saving Time");
        jPanel2.add(this.useDSTCB);
        jPanel2.add(Box.createHorizontalStrut(350));
        this.currentTz = this.getCurrentTimeZone();
        this.timezoneCB.setSelectedItem(this.currentTz);
        if (this.timezoneCB.getSelectedItem() == null) {
            this.timezoneCB.setSelectedItem(this.tzFactory.getCtcTimeZoneFromID("America/Los_Angeles"));
            db.fine("SppGeneralPane: init timezone to PST\n");
        }
        db.fine("SppGeneralPane: init std tz set to " + ((CtcTimeZone)this.timezoneCB.getSelectedItem()).getStandTzName() + "\n" + "SppGeneralPane: init dst tz set to " + ((CtcTimeZone)this.timezoneCB.getSelectedItem()).getDstTzName() + "\n");
        this.updateUseDSTcontrol(this.currentTz);
        jPanel.add(jPanel2);
        if (this.hasProvPrivilege) {
            this.useSntpCB.addActionListener(this);
            this.dateTF.addActionListener(this);
            this.timeTF.addActionListener(this);
            this.timezoneCB.addActionListener(this);
            this.useDSTCB.addActionListener(this);
        }
        this.useSntpCB.setEnabled(this.isUserAuthorized(SecurityLevel.SUPERUSER));
        this.dateTF.setEnabled(this.hasProvPrivilege);
        this.timeTF.setEnabled(this.hasProvPrivilege);
        this.timezoneCB.setEnabled(this.hasProvPrivilege);
        return jPanel;
    }

    private Attribute[] getAttributeArray(String string) {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel();
        return ElementDefaults.getAttributeMap(nodeModelDelegate).getAttributeArray("SYSTEM." + string);
    }

    private Attribute getAttributeFor(String string, int n) {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel();
        return ElementDefaults.getAttributeMap(nodeModelDelegate).getAttributeForVal("SYSTEM." + string, n);
    }

    private JPanel createSdpProvisioningPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 3));
        jPanel.setBorder(BorderFactory.createTitledBorder("AIS-V Insertion On STS-1 Signal Degrade - Path"));
        this.sdpAisvInsertionCB = new JCheckBox("Insert AIS-V on STS-1 SD-P");
        jPanel.add(this.sdpAisvInsertionCB);
        jPanel.add(Box.createHorizontalStrut(10));
        jPanel.add(this.createLabel("SD-P BER: "));
        this.sdpBerCB = new JComboBox<Attribute>(this.getAttributeArray("declareSdBerLevel"));
        jPanel.add(this.sdpBerCB);
        this.sdpBerCB.setEditable(false);
        jPanel.add(Box.createHorizontalGlue());
        if (this.isUserAuthorized()) {
            this.sdpAisvInsertionCB.addActionListener(this);
            this.sdpBerCB.addActionListener(this);
        }
        return jPanel;
    }

    private JPanel createSysDescPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 3));
        jPanel.add(new JLabel("System Description: "));
        this.sysDescLB = new JLabel();
        jPanel.add(this.sysDescLB);
        return jPanel;
    }

    private JPanel createOperatorPanel() {
        JPanel jPanel = SppGeneralPane.createVerticalPanel("Operator Info");
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel.add((Component)jPanel2, "North");
        this.operatorTF = this.addTextPanel(jPanel2, "Operator Id: ", 20, this.hasProvPrivilege);
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 5));
        JLabel jLabel = this.createLabel("Operator Specific Info: ");
        jLabel.setToolTipText("Operator Specific Information");
        jPanel3.add(jLabel);
        Dimension dimension = new Dimension(433, 40);
        this.opSpecInfoTA = new JTextArea();
        this.opSpecInfoTA.setPreferredSize(dimension);
        this.opSpecInfoTA.setMaximumSize(dimension);
        this.opSpecInfoTA.setMinimumSize(dimension);
        this.opSpecInfoTA.setLineWrap(true);
        this.opSpecInfoTA.setWrapStyleWord(true);
        this.opSpecInfoTA.getDocument().addDocumentListener(this);
        jPanel3.add((Component)new UScrollPane((Component)this.opSpecInfoTA));
        jPanel.add((Component)jPanel3, "Center");
        return jPanel;
    }

    private JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(90, 20));
        return jLabel;
    }

    private JPanel createAttributePanel(String string, JComponent jComponent) {
        Dimension dimension = new Dimension(140, 40);
        jComponent.setPreferredSize(dimension);
        jComponent.setMinimumSize(dimension);
        jComponent.setMaximumSize(dimension);
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 0));
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        JLabel jLabel = this.createLabel(string);
        jPanel2.add(jLabel);
        jPanel2.add(Box.createHorizontalStrut(2));
        jPanel.add(jPanel2);
        jPanel.add(jComponent);
        return jPanel;
    }

    private JTextField addTextPanel(JPanel jPanel, String string, int n, boolean bl) {
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        if (string != null) {
            jPanel.add(this.createLabel(string));
        }
        JTextField jTextField = new JTextField(n);
        jTextField.setPreferredSize(new Dimension(n, 20));
        jTextField.setMaximumSize(new Dimension(n, 20));
        jTextField.setMinimumSize(new Dimension(n, 20));
        jPanel.add(jTextField);
        if (bl) {
            jTextField.getDocument().addDocumentListener(this);
        } else {
            jTextField.setEditable(false);
        }
        return jTextField;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.documentModified(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.documentModified(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.documentModified(documentEvent);
    }

    private void documentModified(DocumentEvent documentEvent) {
        this.setDirty();
        Document document = documentEvent.getDocument();
        if (document == this.nameTF.getDocument()) {
            this.nameDirty = true;
        } else if (document == this.contactTF.getDocument()) {
            this.contactDirty = true;
        } else if (document == this.locDescTF.getDocument()) {
            this.locationDirty = true;
        } else if (document == this.sntpHostTF.getDocument()) {
            this.sntpHostDirty = true;
            this.timeDirty = true;
        } else if (this.operFieldsAvailable && document == this.operatorTF.getDocument()) {
            this.opIdDirty = true;
        } else if (this.operFieldsAvailable && document == this.opSpecInfoTA.getDocument()) {
            this.opSIDirty = true;
        } else if (document == this.dateTF.getDocument() || document == this.timeTF.getDocument()) {
            this.timeDirty = true;
        }
    }

    private void adornSdp() {
        this.sdpAisvInsertionCB.setEnabled(this.isUserAuthorized());
        if (this.sdpAisvInsertionCB.isEnabled()) {
            this.sdpAisvInsertionCB.setToolTipText("");
            if (this.sdpAisvInsertionCB.isSelected()) {
                this.sdpBerCB.setEnabled(true);
                this.sdpBerCB.setToolTipText("");
            } else {
                this.sdpBerCB.setEnabled(false);
                this.sdpBerCB.setToolTipText("Provisionable only if AIS-V is inserted");
            }
        } else {
            String string = "Provisioning limited to superusers";
            this.sdpAisvInsertionCB.setToolTipText(string);
            this.sdpBerCB.setEnabled(false);
            this.sdpBerCB.setToolTipText(string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == null) {
            db.severe("Null actionPerformed source!");
            return;
        }
        if (object == this.useSntpCB && this.hasProvPrivilege) {
            boolean bl = this.useSntpCB.isSelected();
            db.info("itemStateChanged: " + bl);
            this.sntpHostTF.setEnabled(bl);
            this.dateTF.setEnabled(!bl);
            this.timeTF.setEnabled(!bl);
        } else if (object == this.timezoneCB) {
            this.timezoneDirty = true;
            this.updateUseDSTcontrol((CtcTimeZone)this.timezoneCB.getSelectedItem());
        } else if (object == this.useDSTCB) {
            this.useDSTDirty = true;
        } else if (object == this.dateTF || object == this.timeTF) {
            this.timeDirty = true;
        } else if (object == this.sdpAisvInsertionCB) {
            this.adornSdp();
            this.sdpAisvInsertionDirty = true;
        } else if (object == this.sdpBerCB) {
            this.sdpBerDirty = true;
        }
        this.setDirty();
    }

    public void applyChangesToModel() throws Exception {
        Object object;
        String string;
        boolean bl;
        db.info("applyChangesToModel: start");
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel();
        String string2 = this.nameTF.getText();
        String string3 = this.contactTF.getText();
        String string4 = this.locDescTF.getText();
        String string5 = this.operFieldsAvailable ? this.operatorTF.getText() : "";
        String string6 = this.operFieldsAvailable ? this.opSpecInfoTA.getText() : "";
        String string7 = (String)this.latEdit.getValueEx();
        String string8 = (String)this.longEdit.getValueEx();
        String string9 = this.sntpHostTF.getText();
        boolean bl2 = false;
        short s = -1;
        if (this.sdpAisvInsertionDirty || this.sdpBerDirty) {
            bl2 = this.sdpAisvInsertionCB.isSelected();
            s = ((Attribute)this.sdpBerCB.getSelectedItem()).getValue().shortValue();
        }
        if (bl = this.useSntpCB.isSelected()) {
            if (this.sntpHostDirty && (string9.equals(InetUtil.makeDottedString(nodeModelDelegate.getSntpHost())) || !CerentDialog.yesNoDialog((Component)((Object)this), (String)"Changing the NTP/SNTP server may change the time enough to\ninvalidate the node's performance monitoring counters.\n\nMake the change anyway?", (String)"Change NTP/SNTP Server?"))) {
                this.sntpHostDirty = false;
            }
        } else if (this.timeDirty && !CerentDialog.yesNoDialog((Component)((Object)this), (String)"Changing the time significantly may invalidate\nthe node's performance monitoring counters.\n\nMake the change anyway?", (String)"Change Node Time?")) {
            this.timeDirty = false;
        }
        if (bl2 && this.sdpAisvInsertionDirty && !CerentDialog.yesNoDialog((Component)((Object)this), (String)(string = "CAUTION: Enabling this check box will cause\nAIS-Vs to be inserted on some VT1.5 circuits,\n\nwhen the STS-1 SD-P BER threshold is crossed.\n\nNon-tunneled UPSR and unprotected links will be affected.\nTunneled, 1+1, and BLSR links will not be affected.\n\nAIS-V will cause a traffic switch.\nIf any switches cannot be performed, or\nif any circuits are not protected, traffic will be lost.\n\nEnable AIS-V insertion?"), (String)"AIS-V Insertion on STS-1 SD-P")) {
            this.sdpAisvInsertionDirty = false;
            this.sdpBerDirty = false;
        }
        boolean bl3 = false;
        if (this.nameDirty) {
            db.fine("applyChangesToModel: setting name");
            nodeModelDelegate.setName(this.nameTF.getText());
            bl3 = true;
        }
        if (this.contactDirty) {
            db.fine("applyChangesToModel: setting contact");
            nodeModelDelegate.setContact(string3);
            bl3 = true;
        }
        if (this.locationDirty) {
            db.fine("applyChangesToModel: setting positionDesc");
            nodeModelDelegate.setPositionDescription(string4);
            bl3 = true;
        }
        if (this.opIdDirty) {
            db.fine("applyChangesToModel: setting operatorId");
            nodeModelDelegate.setOperatorId(string5);
            bl3 = true;
        }
        if (this.opSIDirty) {
            db.fine("applyChangesToModel: setting operatorSpecInfo");
            nodeModelDelegate.setOperatorSpecInfo(string6);
            bl3 = true;
        }
        if (this.latLongDirty) {
            db.fine("applyChangesToModel: setting position");
            nodeModelDelegate.setPosition(new Position(string7, string8, ""));
            bl3 = true;
        }
        if (this.timezoneDirty || this.useDSTDirty) {
            db.fine("applyChangesToModel: setting timezone");
            object = (CtcTimeZone)this.timezoneCB.getSelectedItem();
            nodeModelDelegate.setTimeZone((CtcTimeZone)object, this.useDSTCB.isSelected());
            nodeModelDelegate.setCtcTimeZone((CtcTimeZone)object);
            this.currentTz = object;
            bl3 = true;
        }
        if (this.sdpAisvInsertionDirty) {
            db.fine("applyChangesToModel: setting sdpAisvInsertion");
            nodeModelDelegate.setAisvOnSdp(bl2);
            bl3 = true;
        }
        if (this.sdpBerDirty) {
            db.fine("applyChangesToModel: setting sdpBer");
            nodeModelDelegate.setAisvOnSdpBerLevel(s);
            bl3 = true;
        }
        if (bl) {
            if (this.sntpHostDirty) {
                object = InetUtil.makeIpAddr(string9);
                db.fine("applyChangesToModel: setting NTP/SNTP host");
                try {
                    nodeModelDelegate.setSntpHost((IIpAddr)object);
                    bl3 = true;
                }
                catch (ConfigError configError) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_SNTP_INVALID_HOST_PARAM_1, (Object)this.formatInternalSubnets());
                }
            }
        } else {
            if (InetUtil.makeIpV4(nodeModelDelegate.getSntpHost()) != 0) {
                db.fine("applyChangesToModel: clearing NTP/SNTP host");
                nodeModelDelegate.setSntpHost(InetUtil.makeIpAddr(0));
            }
            object = nodeModelDelegate.getTimeZone();
            if (this.timeDirty) {
                db.fine("applyChangesToModel: setting time");
                try {
                    sTime sTime2 = this.parseTime(this.dateTF.getText(), this.timeTF.getText(), (sTimeZone)object);
                    nodeModelDelegate.setTime(sTime2);
                    bl3 = true;
                    this.refreshFromModel();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Date or time entered is not valid");
                }
            }
        }
        if (!bl3) {
            db.info("applyChangesToModel: set nothing!");
            this.refresh();
        }
        db.info("applyChangesToModel: finish");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void enteringPage() throws Exception {
        Preferences.instance().addPropertyChangeListener((PropertyChangeListener)this);
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            if (this.nameTF == null) {
                this.init();
            }
            super.enteringPage();
            Object var2_1 = null;
            if (this.uiToolkit == null) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.uiToolkit == null) throw throwable;
            this.uiToolkit.setCursor(0);
            throw throwable;
        }
        this.uiToolkit.setCursor(0);
    }

    public void leavingPage() throws Exception {
        Preferences.instance().removePropertyChangeListener((PropertyChangeListener)this);
        super.leavingPage();
    }

    public void refreshFromModel() throws Exception {
        db.info("refreshFromModel: start");
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel();
        if (nodeModelDelegate == null) {
            db.severe("Node Model is null in SppGeneralPane::refresh()");
            return;
        }
        this.nameTF.setText(nodeModelDelegate.getName());
        this.contactTF.setText(nodeModelDelegate.getContact());
        this.locDescTF.setText(nodeModelDelegate.getPositionDescription());
        if (this.operFieldsAvailable) {
            this.operatorTF.setText(nodeModelDelegate.getOperatorId());
            this.opSpecInfoTA.setText(nodeModelDelegate.getOperatorSpecInfo());
        }
        IPosition iPosition = nodeModelDelegate.getPosition();
        this.latEdit.setValue(iPosition.getLatitude());
        this.longEdit.setValue(iPosition.getLongitude());
        int n = InetUtil.makeIpV4(nodeModelDelegate.getSntpHost());
        this.useSntpCB.setSelected(n == 0);
        this.useSntpCB.setSelected(n != 0);
        boolean bl = true;
        if (nodeModelDelegate.getPlatform().isSecureModeSupported() && nodeModelDelegate.isSecureMode()) {
            bl = this.isUserAuthorized(SecurityLevel.SUPERUSER);
        }
        if (bl) {
            this.sntpHostTF.setText(n != 0 ? InetUtil.makeDottedString(n) : "");
        }
        boolean bl2 = this.useSntpCB.isSelected();
        this.sntpHostTF.setEnabled(bl2);
        this.dateTF.setEnabled(!bl2);
        this.timeTF.setEnabled(!bl2);
        sTime sTime2 = nodeModelDelegate.getTime();
        CtcTimeZone ctcTimeZone = this.getCurrentTimeZone();
        this.timezoneCB.setSelectedItem(ctcTimeZone);
        timeFmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.setDateLabel();
        StringBuffer stringBuffer = new StringBuffer(16);
        Date date = new Date(1000 * (sTime2.hour * 60 * 60 + sTime2.minute * 60 + sTime2.second));
        stringBuffer.append(timeFmt.format(date));
        stringBuffer.append(" ");
        stringBuffer.append(ctcTimeZone.getDisplayName(sTime2.dstInEffect, 0, Locale.getDefault()));
        this.timeTF.setText(stringBuffer.toString());
        this.updateUseDSTcontrol(ctcTimeZone);
        if (this.sdpAisvInsertionCB != null && this.sdpBerCB != null) {
            this.sdpAisvInsertionCB.setSelected(nodeModelDelegate.getAisvOnSdp());
            this.sdpBerCB.setSelectedItem(this.getAttributeFor("declareSdBerLevel", nodeModelDelegate.getAisvOnSdpBerLevel()));
            this.adornSdp();
        }
        this.sysDescLB.setText(BuildInfo.sanitize(nodeModelDelegate.getSystemDescription()));
        this.contactDirty = false;
        this.nameDirty = false;
        this.latLongDirty = false;
        this.locationDirty = false;
        this.opSIDirty = false;
        this.opIdDirty = false;
        this.useDSTDirty = false;
        this.timezoneDirty = false;
        this.timeDirty = false;
        this.sntpHostDirty = false;
        this.sdpBerDirty = false;
        this.sdpAisvInsertionDirty = false;
        db.info("refreshFromModel: finish");
    }

    private sTime parseTime(String string, String string2, sTimeZone sTimeZone2) {
        sTime sTime2 = new sTime();
        short[] sArray = this.parseShorts(string, '/', 3);
        String string3 = Preferences.instance().getProperty("ctc", "dateFormat", "MM/DD/YY");
        if (string3.equals("MM/DD/YY")) {
            sTime2.month = sArray[0];
            sTime2.day = sArray[1];
            sTime2.year = sArray[2];
        } else {
            sTime2.day = sArray[0];
            sTime2.month = sArray[1];
            sTime2.year = sArray[2];
        }
        if (sTime2.year >= 0 && sTime2.year <= 69) {
            sTime2.year = (short)(sTime2.year + 2000);
        }
        if (sTime2.year >= 70 && sTime2.year <= 99) {
            sTime2.year = (short)(sTime2.year + 1900);
        }
        if (sTime2.year < 1970 || sTime2.year > 2037) {
            throw new IllegalArgumentException("year is invalid\n(year must be between 1970-2037) ");
        }
        if (sTime2.month < 1 || sTime2.month > 12) {
            throw new IllegalArgumentException("month is invalid");
        }
        if (sTime2.day < 1 || sTime2.day > SppGeneralPane.monthDays(sTime2.month, sTime2.year)) {
            throw new IllegalArgumentException("day is invalid");
        }
        short[] sArray2 = this.parseShorts(string2, ':', 3);
        sTime2.hour = sArray2[0];
        sTime2.minute = sArray2[1];
        sTime2.second = sArray2[2];
        if (sTime2.hour < 0 || sTime2.hour > 23) {
            throw new IllegalArgumentException("hour is invalid");
        }
        if (sTime2.minute < 0 || sTime2.minute > 59) {
            throw new IllegalArgumentException("minute is invalid");
        }
        if (sTime2.second < 0 || sTime2.second > 59) {
            throw new IllegalArgumentException("second is invalid");
        }
        CtcTimeZone ctcTimeZone = (CtcTimeZone)this.timezoneCB.getSelectedItem();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(sArray[2], sArray[0] - 1, sArray[1], sArray2[0], sArray2[1], sArray2[2]);
        gregorianCalendar.setTimeZone(ctcTimeZone);
        if (this.useDSTCB.isSelected()) {
            if (ctcTimeZone.inDaylightTime(gregorianCalendar.getTime())) {
                sTime2.dstInEffect = true;
            }
        } else {
            sTime2.dstInEffect = false;
        }
        return sTime2;
    }

    private boolean guessMyTimeZone(sTime sTime2, sTimeZone sTimeZone2) {
        if (sTimeZone2.standardTzName.equals(sTimeZone2.dstTzName)) {
            return false;
        }
        return sTime2.month >= 4 && sTime2.month <= 10;
    }

    private static int monthDays(int n, int n2) {
        return mDays[n - 1] + (n == 2 && n2 % 4 == 0 ? 1 : 0);
    }

    private short[] parseShorts(String string, char c, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f" + c);
        short[] sArray = new short[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens() && n2 != n) {
            sArray[n2++] = Short.parseShort(stringTokenizer.nextToken());
        }
        return sArray;
    }

    private String parseTzFromStr(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f");
        String[] stringArray = new String[2];
        int n = 0;
        while (stringTokenizer.hasMoreTokens() && n < 2) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        if (n > 1) {
            return stringArray[1];
        }
        return "";
    }

    public boolean onValidate() {
        String string;
        boolean bl = true;
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel();
        boolean bl2 = nodeModelDelegate.getFramingTypeObj().isSonet();
        if (this.contactDirty && (string = this.contactTF.getText()).length() > 255) {
            ErrorMsg.displayError((Component)((Object)this), EMC.EID_CONTACT_LENGTH_PARAM_2, string, new Integer(255).toString());
            bl = false;
        }
        if (this.locationDirty && (string = this.locDescTF.getText()).length() > 255) {
            ErrorMsg.displayError((Component)((Object)this), EMC.EID_LOCATION_LENGTH_PARAM_2, string, new Integer(255).toString());
            bl = false;
        }
        if (this.opIdDirty && (string = this.operatorTF.getText()).length() > 9) {
            ErrorMsg.displayError((Component)((Object)this), EMC.EID_OPERATOR_ID_LENGTH_PARAM_2, string, new Integer(9).toString());
            bl = false;
        }
        if (this.opSIDirty && (string = this.opSpecInfoTA.getText()).length() > 118) {
            ErrorMsg.displayError((Component)((Object)this), EMC.EID_OPERATOR_SPECIFIC_INFO_LENGTH_PARAM_2, string, new Integer(118).toString());
            bl = false;
        }
        if (this.nameDirty) {
            string = this.nameTF.getText();
            if (string.equals("")) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_EMPTY_NODE_NAME);
                bl = false;
            }
            if (string.length() > 64) {
                ErrorMsg.displayError((Component)((Object)this), EMC.EID_NODE_NAME_LENGTH_PARAM_2, string, new Integer(64).toString());
                bl = false;
            }
            if (bl && string.length() > 20 && !CerentDialog.yesNoDialog((Component)((Object)this), (String)"The name specified is more than 20 characters long.\nThis node will not be visible to the GNE for TL1 access. \n\nDo you wish to continue?", (String)"Invalid TL1 Node Name")) {
                bl = false;
            }
            if (bl) {
                char[] cArray = string.toCharArray();
                for (int i = 0; i < cArray.length; ++i) {
                    char c = cArray[i];
                    if (Character.isWhitespace(c)) {
                        if (CerentDialog.yesNoDialog((Component)((Object)this), (String)("The name '" + string + "' must be quoted in TL1 " + "since it contains spaces.\n\n" + "OK to continue?"), (String)"Special TL1 Node Name")) break;
                        bl = false;
                        break;
                    }
                    if (!Character.isLetterOrDigit(c) && c != '-') {
                        if (CerentDialog.yesNoDialog((Component)((Object)this), (String)("The name '" + string + "' must be quoted in TL1 " + "since it contains special " + "characters.\n\n" + "OK to continue?"), (String)"Special TL1 Node Name")) break;
                        bl = false;
                        break;
                    }
                    if (i == 0 || Character.isLetter(c) || cArray[i - 1] != '-') continue;
                    if (CerentDialog.yesNoDialog((Component)((Object)this), (String)("The name '" + string + "' must be quoted in TL1 " + "since a non-letter " + "appears after a hyphen.\n\n" + "OK to continue?"), (String)"Special TL1 Node Name")) break;
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }

    private void setDateLabel() {
        String string = Preferences.instance().getProperty("ctc", "dateFormat", "MM/DD/YY");
        sTime sTime2 = ((NodeModelDelegate)this.getUiModel()).getTime();
        if (string.equals("MM/DD/YY")) {
            this.dateLbl.setText("Date (M/D/Y): ");
            this.dateTF.setText(sTime2.month + "/" + sTime2.day + "/" + sTime2.year);
        } else {
            this.dateLbl.setText("Date (D/M/Y): ");
            this.dateTF.setText(sTime2.day + "/" + sTime2.month + "/" + sTime2.year);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        Object object = propertyChangeEvent.getSource();
        if (object instanceof CoordinatePropertyEditor) {
            this.latLongDirty = true;
            this.setDirty();
        }
        if ((string = propertyChangeEvent.getPropertyName()) != null && string.equals("dateFormat")) {
            boolean bl = this.isProvPaneDirty();
            try {
                this.setDateLabel();
                this.timeDirty = false;
                if (!bl) {
                    this.resetDirty();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void destroy() {
        if (this.latEdit != null) {
            this.latEdit.removePropertyChangeListener(this);
        }
        if (this.longEdit != null) {
            this.longEdit.removePropertyChangeListener(this);
        }
        super.destroy();
    }

    private void updateUseDSTcontrol(CtcTimeZone ctcTimeZone) {
        boolean bl = !ctcTimeZone.getDstTzAbbreviation().equals(ctcTimeZone.getStandTzAbbreviation());
        boolean bl2 = this.isUserAuthorized(SecurityLevel.PROVISIONING);
        if (bl) {
            if (ctcTimeZone.isDSTDisabled() && !ctcTimeZone.useDaylightTime()) {
                this.useDSTCB.setSelected(false);
                this.useDSTCB.setEnabled(bl2);
            } else if (ctcTimeZone.isDSTDisabled() && ctcTimeZone.useDaylightTime()) {
                this.useDSTCB.setSelected(false);
                this.useDSTCB.setEnabled(bl2);
            } else {
                this.useDSTCB.setSelected(ctcTimeZone.useDaylightTime());
                this.useDSTCB.setEnabled(ctcTimeZone.useDaylightTime() && bl2);
            }
        } else {
            this.useDSTCB.setSelected(false);
            this.useDSTCB.setEnabled(false);
        }
    }

    private CtcTimeZone getCurrentTimeZone() {
        String string;
        CtcTimeZone ctcTimeZone = null;
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel();
        sTimeZone sTimeZone2 = nodeModelDelegate.getTimeZone();
        ctcTimeZone = sTimeZone2 != null ? ((string = sTimeZone2.timeZoneID) != null && !string.equals("unknown") ? this.tzFactory.getCtcTimeZoneFromID(string) : this.tzFactory.getCtcTimeZoneFromAbbrev(sTimeZone2.standardTzName)) : this.tzFactory.getCtcTimeZoneFromAbbrev("PST");
        ctcTimeZone.DisableDST(sTimeZone2.standardTzName.equals(sTimeZone2.dstTzName));
        return ctcTimeZone;
    }

    private String formatInternalSubnets() {
        String string;
        block5: {
            string = " ";
            try {
                StringBuffer stringBuffer = new StringBuffer();
                NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel();
                if (nodeModelDelegate != null) {
                    IpSubnet[] ipSubnetArray = nodeModelDelegate.getPlatform().getInternalSubnets(nodeModelDelegate);
                    if (ipSubnetArray != null && ipSubnetArray.length > 0) {
                        stringBuffer.append(" IP ");
                        stringBuffer.append(PluralisationUtil.s("address", ipSubnetArray.length));
                        stringBuffer.append(" (");
                        stringBuffer.append(ipSubnetArray[0]);
                        for (int i = 1; i < ipSubnetArray.length; ++i) {
                            stringBuffer.append(", ");
                            stringBuffer.append(ipSubnetArray[i]);
                        }
                        stringBuffer.append(") ");
                        stringBuffer.append(PluralisationUtil.s("is", ipSubnetArray.length));
                        stringBuffer.append(" reserved for internal communication");
                    }
                    string = stringBuffer.toString();
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block5;
                db.println("error getting internal subnets");
            }
        }
        return string;
    }
}

