/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.If.eLoopback;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.IAdminTableAccess;
import cerent.cms.ui.sonet.TdmTableModel;
import cerent.util.SDebug;
import java.util.Map;

public class TdmLineMaintTableModel
extends TdmTableModel
implements IAdminTableAccess {
    private AdminState[] adminState = null;
    private IServiceState[] serviceState = null;
    private Attribute[] loopbackVal = null;
    protected Boolean[] facLoopAis = null;
    protected Boolean[] termLoopAis = null;
    protected boolean[][] isDirty;
    public static final int LINENUMBER_INDEX = 0;
    public static final int ADMIN_STATE_INDEX = 1;
    public static final int SERVICE_STATE_INDEX = 2;
    public static final int LOOPBACK_INDEX = 3;
    public static final int FACILITY_AIS_INDEX = 4;
    public static final int TERMINAL_AIS_INDEX = 5;
    public static final String[] columnNames = new String[]{"Port ", "Admin State", "Service State", "Loopback Type", "Send AIS on Facility Loopback", "Send AIS on Terminal Loopback"};
    protected EntityCellRenderer myPortRenderer;
    private Map loopbackMap;
    private static final SDebug db = new SDebug("TdmLineMaintTableModel");
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Object;

    public TdmLineMaintTableModel(INodeModel iNodeModel, TdmLineModel[] tdmLineModelArray) {
        super(iNodeModel);
        this.model = tdmLineModelArray;
        this.myPortRenderer = new EntityCellRenderer();
        this.loopbackMap = ((NodeModelDelegate)iNodeModel).getPlatform().getLoopbackAttributeMap();
        this.init();
    }

    protected void init() {
        this.numLines = this.model.length;
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.loopbackVal = new Attribute[this.numLines];
        this.adminState = new AdminState[this.numLines];
        this.serviceState = new IServiceState[this.numLines];
        this.facLoopAis = new Boolean[this.numLines];
        this.termLoopAis = new Boolean[this.numLines];
        this.resetDirtyBits();
    }

    public AttributeMaps getAttributeMap() {
        return ElementDefaults.getAttributeMap((IModel)this.node);
    }

    public AdminState getAdminState(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.adminState[n] == null) {
            eAdminState eAdminState2 = this.model[n].getAdminStateEnum();
            this.adminState[n] = AdminState.enumToAdminState(eAdminState2);
        }
        return this.adminState[n];
    }

    private IServiceState getServiceState(int n) throws NoSuchInterface {
        if (this.serviceState[n] == null) {
            sServiceState sServiceState2 = this.model[n].getServiceState();
            this.serviceState[n] = ServiceStateFactory.getServiceState(sServiceState2);
        }
        return this.serviceState[n];
    }

    private Attribute getLoopback(int n) throws NoSuchInterface, WrongInterfaceType {
        if (AdminState.admitsLoopback(this.getAdminState(n).getAdminStateEnum())) {
            if (this.loopbackVal[n] == null) {
                eLoopback eLoopback2 = this.model[n].getLoopback();
                this.loopbackVal[n] = (Attribute)this.loopbackMap.get(new Integer(eLoopback2.value()));
            }
        } else {
            this.loopbackVal[n] = (Attribute)this.loopbackMap.get(new Integer(0));
        }
        return this.loopbackVal[n];
    }

    public Boolean getFacLoopbackAis(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.facLoopAis[n] == null) {
            this.facLoopAis[n] = new Boolean(this.model[n].getFacLoopbackAis());
        }
        return this.facLoopAis[n];
    }

    public Boolean getTermLoopbackAis(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.termLoopAis[n] == null) {
            this.termLoopAis[n] = new Boolean(this.model[n].getTermLoopbackAis());
        }
        return this.termLoopAis[n];
    }

    protected Attribute getAttributeFor(String string, int n) {
        return this.getAttributeMap().getAttributeForVal("SONET." + string, n);
    }

    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value " + n + " " + n2);
        }
        switch (n2) {
            case 1: {
                if (((AdminState)object).equals(this.adminState[n])) {
                    return;
                }
                this.adminState[n] = (AdminState)object;
                this.isDirty[n][1] = true;
                break;
            }
            case 3: {
                this.loopbackVal[n] = (Attribute)object;
                this.isDirty[n][3] = true;
                break;
            }
            case 4: {
                if (this.facLoopAis[n] == (Boolean)object) {
                    return;
                }
                this.facLoopAis[n] = (Boolean)object;
                this.isDirty[n][4] = true;
                break;
            }
            case 5: {
                if (this.termLoopAis[n] == (Boolean)object) {
                    return;
                }
                this.termLoopAis[n] = (Boolean)object;
                this.isDirty[n][5] = true;
                break;
            }
        }
        this.fireTableRowsUpdated(n, n);
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 4: 
            case 5: {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = TdmLineMaintTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = TdmLineMaintTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public eAdminState getAdminStateFor(int n) throws NoSuchInterface, WrongInterfaceType {
        return this.getAdminState(n).getAdminStateEnum();
    }

    public eLoopback getLoopbackValFor(int n) throws NoSuchInterface, WrongInterfaceType {
        return eLoopback.from_int(this.getLoopback(n).getIntValue());
    }

    public boolean isCellEditable(int n, int n2) {
        block9: {
            if (this.model != null && this.numLines > 0 && n < this.numLines && n2 != 2) {
                try {
                    if (AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.MAINTENANCE) && !this.model[0].getModuleModel().isProtectModule()) {
                        if (n2 == 3) {
                            try {
                                return AdminState.admitsLoopback(this.getAdminStateFor(n));
                            }
                            catch (Exception exception) {
                                return false;
                            }
                        }
                        if (n2 == 4) {
                            return this.canEditDownstreamAis(n);
                        }
                        if (n2 == 5) {
                            return this.canEditTermLoopbackAis(n);
                        }
                        return n2 > 0;
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    db.println("Caught AbstractCmsNoSuchEntity in isCellEditable");
                    if (!db.on()) break block9;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        return false;
    }

    protected boolean canEditDownstreamAis(int n) {
        try {
            return this.getLoopbackValFor(n) == eLoopback.NO_LOOPBACK || this.model[n].getLoopback() == eLoopback.NO_LOOPBACK;
        }
        catch (Exception exception) {
            db.severe("Exception in TdmLineMaintTableModel.canEditDownstreamAis " + exception);
            return false;
        }
    }

    protected boolean canEditTermLoopbackAis(int n) {
        boolean bl = false;
        try {
            bl = this.canEditDownstreamAis(n) && this.model[0].getModuleModel().supportsTermLoopbackAis(this.model[n].getPortModel());
        }
        catch (Exception exception) {
            db.severe("Exception in TdmLineMaintTableModel.canEditTermLoopbackAis " + exception);
        }
        return bl;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        IPortModel iPortModel = this.model[n].getPortModel();
        return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
    }

    public Object getValueAt(int n, int n2) {
        Object object;
        block10: {
            object = null;
            try {
                switch (n2) {
                    case 0: {
                        object = this.getPortDescriptionFor(n);
                        break;
                    }
                    case 1: {
                        object = this.getAdminState(n).toString(this.getTerms());
                        break;
                    }
                    case 2: {
                        object = this.getServiceState(n).toString(this.getTerms());
                        break;
                    }
                    case 3: {
                        object = this.getLoopback(n);
                        break;
                    }
                    case 4: {
                        object = this.getFacLoopbackAis(n);
                        break;
                    }
                    case 5: {
                        object = this.getTermLoopbackAis(n);
                    }
                }
            }
            catch (Exception exception) {
                db.println("Caught Exception in getValueAt");
                if (!db.on()) break block10;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return object;
    }

    public void refreshLineFromModel(int n) {
        this.adminState[n] = null;
        this.serviceState[n] = null;
        this.loopbackVal[n] = null;
        this.facLoopAis[n] = null;
        this.termLoopAis[n] = null;
        this.resetRowDirtyBits(n);
        this.fireTableRowsUpdated(n, n);
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.adminState[i] = null;
            this.serviceState[i] = null;
            this.loopbackVal[i] = null;
            this.facLoopAis[i] = null;
            this.termLoopAis[i] = null;
            this.resetRowDirtyBits(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    public boolean isAdminStateDirty(int n) {
        return this.isDirty[n][1];
    }

    private void resetRowDirtyBits(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetRowDirtyBits(i);
        }
    }

    public boolean isLoopbackDirty(int n) {
        boolean bl;
        block3: {
            bl = false;
            try {
                if (this.isRowDirty(n) && this.getLoopbackValFor(n) != this.model[n].getLoopback()) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                db.println("Error in getting Loopback");
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return bl;
    }

    public void refreshMyLines(TdmLineModel[] tdmLineModelArray) {
        this.model = tdmLineModelArray;
        this.init();
        this.fireTableDataChanged();
        if (db.on()) {
            db.println("Refreshing the table lines...");
            db.println("New models = " + this.model);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

