/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.If.eLoopback;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.INodeModel;
import cerent.cms.model.LoopbackActive;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.sonet.TdmLineMaintTableModel;
import cerent.util.AnnotatedException;
import cerent.util.EnumStrings;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.CustomComboBoxModel;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class TdmLineMaintenancePane
extends NodeProvPane
implements TableModelListener {
    protected TdmLineMaintTableModel dataModel = null;
    protected TdmLineModel[] lineModels = null;
    protected Runnable updateThread = null;
    protected LoopbackSelectionEditor myLoopbackEditor;
    private ObservableManager _obsMgr = null;
    private static final SDebug db = new SDebug("TdmLineMaintenancePane");
    static /* synthetic */ Class class$cerent$cms$idl$If$eLoopback;

    public TdmLineMaintenancePane(String string, TabbedView tabbedView, TdmLineModel[] tdmLineModelArray) {
        super(string, tabbedView);
        this.lineModels = tdmLineModelArray;
        this.dataModel = new TdmLineMaintTableModel(this.getUiModel().getNodeModel(), this.lineModels);
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        uScrollPane.setPreferredSize(new Dimension(200, 150));
        TableColumn tableColumn = this.table.getColumn(TdmLineMaintTableModel.columnNames[0]);
        tableColumn.setPreferredWidth(150);
        tableColumn = this.table.getColumn(TdmLineMaintTableModel.columnNames[1]);
        AdminState[] adminStateArray = AdminState.getDefaultAdminStates(AdminState.isANSI(this.getUiModel().getNodeModel().getFramingType()));
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(adminStateArray)));
        tableColumn = this.table.getColumn(TdmLineMaintTableModel.columnNames[3]);
        CustomComboBoxModel customComboBoxModel = new CustomComboBoxModel();
        Object[] objectArray = this.pci.getLoopbackAttributeMap().values().toArray(new Attribute[0]);
        customComboBoxModel.setElements(objectArray);
        this.myLoopbackEditor = new LoopbackSelectionEditor(customComboBoxModel);
        tableColumn.setCellEditor(this.myLoopbackEditor);
        tableColumn.sizeWidthToFit();
        tableColumn = this.table.getColumn(TdmLineMaintTableModel.columnNames[4]);
        tableColumn.setMinWidth(125);
        tableColumn = this.table.getColumn(TdmLineMaintTableModel.columnNames[5]);
        tableColumn.setMinWidth(125);
        this.maybeRemoveLoopbackAisColumn();
        this.add((Component)uScrollPane);
        if (this.pci.is600()) {
            this.table.setSelectionMode(0);
        }
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.registerWithModel();
    }

    protected void maybeRemoveLoopbackAisColumn() {
        if (!((ModuleModel)this.getUiModel()).supportsLoopbackAis()) {
            TableColumn tableColumn = this.table.getColumn(TdmLineMaintTableModel.columnNames[4]);
            this.table.removeColumn(tableColumn);
            tableColumn = this.table.getColumn(TdmLineMaintTableModel.columnNames[5]);
            this.table.removeColumn(tableColumn);
        }
    }

    private JComboBox getComboBoxFor(AdminState[] adminStateArray) {
        JComboBox<AdminState> jComboBox = new JComboBox<AdminState>(adminStateArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected Attribute[] getAttributeArray(Class clazz) {
        return this.dataModel.getAttributeMap().getAttributeArray("SONET." + clazz.getName());
    }

    protected String[] getLoopbackStrings() {
        return EnumStrings.getStrings((Class)(class$cerent$cms$idl$If$eLoopback == null ? (class$cerent$cms$idl$If$eLoopback = TdmLineMaintenancePane.class$("cerent.cms.idl.If.eLoopback")) : class$cerent$cms$idl$If$eLoopback));
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    private boolean verifyApplyChangesToModel() throws Exception {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        for (n = 0; n < this.lineModels.length; ++n) {
            if (!this.dataModel.isRowDirty(n)) continue;
            if (!bl && AdminState.isTransitionToOOS(this.dataModel.getAdminStateFor(n), this.lineModels[n].getAdminStateEnum())) {
                bl = true;
                if (bl3 && bl2 && bl4) break;
            }
            if (this.dataModel.getLoopbackValFor(n) == eLoopback.LINE_LOOPBACK) {
                if (this.lineModels[n].getLoopback() == eLoopback.LINE_LOOPBACK) continue;
                bl3 = true;
                if (!bl || !bl2 || !bl4) continue;
                break;
            }
            if (this.dataModel.getLoopbackValFor(n) == eLoopback.PAYLOAD_LOOPBACK) {
                if (this.lineModels[n].getLoopback() == eLoopback.PAYLOAD_LOOPBACK) continue;
                bl4 = true;
                if (!bl || !bl2 || !bl3) continue;
                break;
            }
            if (this.dataModel.getLoopbackValFor(n) == eLoopback.NO_LOOPBACK || !this.lineModels[n].getLoopback().equals(eLoopback.NO_LOOPBACK)) continue;
            bl2 = true;
            if (bl && bl3 && bl4) break;
        }
        n = 0;
        if (AdminState.needRemoveLoopback(this.dataModel, this.lineModels)) {
            n = 1;
        }
        if (bl || bl3 || bl2 || bl4 || n != 0) {
            boolean bl6 = bl3 || bl2 || bl4;
            String string = AdminState.getBaseOosWarning(this.terms) + "\n";
            String string2 = "Some lines are being placed in Facility (Line) loopback.\nChanging to Facility (Line) loopback may cause a timing loop\nif line is used as timing reference by far-end node.\n";
            String string3 = "Some lines are being placed in Terminal (Inward) loopback.\n";
            String string4 = "Some lines are being placed in Payload loopback.\n";
            bl5 = CerentDialog.yesNoDialog((Component)((Object)this), (String)((bl ? string : "") + (bl2 ? string3 : "") + (bl4 ? string4 : "") + (n != 0 ? "Some lines will be removed from loopback since their new state does not allow loopback.\n" : "") + (bl3 ? string2 : "") + (bl ? this.getSeverityWarningMsg(bl6) : this.getApplyString())), (String)"Confirmation Dialog");
        }
        return bl5;
    }

    private String getSeverityWarningMsg(boolean bl) {
        String string;
        try {
            String string2 = AdminState.getSevWarningMsg(this.dataModel, this.lineModels, bl);
            string = string2 + "\n\n" + this.getApplyString(false);
        }
        catch (Exception exception) {
            string = "\n" + this.getApplyString();
        }
        return string;
    }

    protected void applyInterdependentChangesToModel(int n) throws Exception {
        if (db.on()) {
            db.println("Setting Loopback for " + (n + 1) + " To " + this.dataModel.getLoopbackValFor(n).value());
        }
        if (AdminState.admitsLoopback(this.dataModel.getAdminStateFor(n)) && this.dataModel.isLoopbackDirty(n)) {
            if (this.lineModels[n].getAdminStateEnum() != eAdminState.ADMIN_OOS_MT) {
                this.lineModels[n].setAdminState(this.dataModel.getAdminStateFor(n));
            }
            this.applyLoopbackAisChanges(n);
        } else if (AdminState.admitsLoopback(this.lineModels[n].getAdminStateEnum()) && this.dataModel.isLoopbackDirty(n)) {
            this.applyLoopbackAisChanges(n);
            this.lineModels[n].setAdminState(this.dataModel.getAdminStateFor(n));
        } else {
            this.lineModels[n].setAdminState(this.dataModel.getAdminStateFor(n));
            this.applyAisChanges(n);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void applyLoopbackAisChanges(int n) throws Exception {
        if (!this.dataModel.isDirty(n, 4)) {
            if (!this.dataModel.isDirty(n, 5)) {
                this.lineModels[n].setLoopback(this.dataModel.getLoopbackValFor(n));
                return;
            }
        }
        if (this.dataModel.getLoopbackValFor(n) == eLoopback.NO_LOOPBACK) {
            this.lineModels[n].setLoopback(this.dataModel.getLoopbackValFor(n));
            this.applyAisChanges(n);
            return;
        }
        this.applyAisChanges(n);
        this.lineModels[n].setLoopback(this.dataModel.getLoopbackValFor(n));
    }

    protected void applyAisChanges(int n) throws Exception {
        if (this.dataModel.isDirty(n, 4)) {
            this.lineModels[n].setFacLoopbackAis(this.dataModel.getFacLoopbackAis(n));
        }
        if (this.dataModel.isDirty(n, 5)) {
            this.lineModels[n].setTermLoopbackAis(this.dataModel.getTermLoopbackAis(n));
        }
    }

    public void applyChangesToModel() throws Exception {
        int n = 0;
        try {
            if (!this.verifyApplyChangesToModel()) {
                return;
            }
            for (n = 0; n < this.lineModels.length; ++n) {
                if (!this.dataModel.isRowDirty(n)) continue;
                this.applyInterdependentChangesToModel(n);
            }
            this.dataModel.resetDirtyBits();
            this.setDirty(false);
        }
        catch (LoopbackActive loopbackActive) {
            throw new AnnotatedException("Error applying changes to row " + (n + 1) + ".\nA cross connect loopback already exists.", (Exception)((Object)loopbackActive));
        }
        catch (Exception exception) {
            this.dataModel.refreshFromModel();
            throw new AnnotatedException("Error applying changes to row " + (n + 1), exception);
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.lineModels == null) {
            return;
        }
        for (int i = 0; i < this.lineModels.length; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            this.setDirty();
            return;
        }
        this.resetDirty();
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        this.getObsMgr().setPassing(true);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    protected void registerWithModel() {
        super.registerWithModel();
        this.getObsMgr().setObservable((Observable[])this.lineModels);
    }

    protected ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    public void leavingPage() throws Exception {
        this.getObsMgr().setPassing(false);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    public void dispose() {
        if (this._obsMgr != null) {
            this._obsMgr.removeObservable((Observable[])this.lineModels);
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.dispose();
    }

    protected void changeMessage(Observable observable, Object object) {
        if (db.on()) {
            db.println("Got an Update Message for " + observable);
        }
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                TdmLineMaintenancePane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else {
            db.println("changeMessage cannot find Model " + observable);
        }
    }

    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    public void removeAttribute(List list, int n) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (attribute.getIntValue() != n) continue;
            iterator.remove();
        }
    }

    protected List filterLoopbackStates(List arrayList) {
        ArrayList arrayList2 = arrayList;
        if (this.pci.is600()) {
            ArrayList arrayList3 = new ArrayList(arrayList);
            switch (((ModuleModel)this.getUiModel()).getEqType()) {
                case 146: {
                    this.removeAttribute(arrayList3, 3);
                    break;
                }
                case 87: {
                    this.removeAttribute(arrayList3, 1);
                    this.removeAttribute(arrayList3, 3);
                    break;
                }
                case 86: {
                    this.removeAttribute(arrayList3, 1);
                    this.removeAttribute(arrayList3, 2);
                }
            }
            arrayList2 = arrayList3;
        }
        return arrayList2;
    }

    protected TdmLineMaintTableModel createDataModel(INodeModel iNodeModel, TdmLineModel[] tdmLineModelArray) {
        return new TdmLineMaintTableModel(iNodeModel, tdmLineModelArray);
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.TdmLineMaintenancePane;
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof OcnLineUpdate) {
            if (db.on()) {
                db.println("Received OcnLineUpdate...");
            }
            this.lineModels = (TdmLineModel[])((OcnLineUpdate)object).getModels();
            this.getObsMgr().setObservable((Observable[])this.lineModels);
            this.dataModel.refreshMyLines(this.lineModels);
        } else if (db.on()) {
            db.println("refreshMyLines received " + object);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class LoopbackSelectionEditor
    extends DefaultCellEditor {
        private CustomComboBoxModel myComboModel;
        private List myInitialLoopbackStates;

        public LoopbackSelectionEditor(CustomComboBoxModel customComboBoxModel) {
            super(new JComboBox(customComboBoxModel));
            this.myComboModel = customComboBoxModel;
            this.myInitialLoopbackStates = customComboBoxModel.getElements();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            List list = TdmLineMaintenancePane.this.filterLoopbackStates(this.myInitialLoopbackStates);
            this.myComboModel.setElements(list);
            this.delegate.setValue(object);
            return this.editorComponent;
        }
    }
}

