/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.AbstractLoNum;
import cerent.util.HoLoFactory;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SONETTDMTerminology;
import cerent.util.SdhAu3LoNum;
import cerent.util.SdhAu4LoNum;
import cerent.util.SonetHoNum;
import cerent.util.SonetLoNum;

public class HoLoHelper {
    public static final int VT = 0;
    public static final int VC3 = 1;
    public static final int TUG3 = 2;
    public static final int TUG2 = 3;
    public static final int VC11 = 4;
    public static final int VC12 = 5;
    public static String[] LoNumStrings = new String[]{"VT ", "VC3 ", "TUG3 ", "TUG2 ", "VC11 ", "VC12 "};
    public static String[] LoNumShortStrings = new String[]{"V ", "vc3-", "tug3-", "tug2-", "vc11-", "vc12-"};
    public static String sdhAu4HoLongString = "VC4";
    public static String sdhAu4HoShortString = "vc4-";
    public static String sdhAu3HoLongString = "VC3";
    public static String sdhAu3HoShortString = "vc3-";

    public static String getDisplay(IHoNum iHoNum, boolean bl) {
        String string = null;
        if (iHoNum != null) {
            if (iHoNum.getFramingType() == 0) {
                string = HoLoHelper.getSonetHoString(iHoNum, bl);
            } else if (iHoNum.getFramingType() == 1) {
                string = HoLoHelper.getSdhAu4HoString(iHoNum, bl);
            } else if (iHoNum.getFramingType() == 2) {
                string = HoLoHelper.getSdhAu3HoString(iHoNum, bl);
            }
        }
        return string;
    }

    public static String getDisplay(IHoNum iHoNum, boolean bl, int n) {
        if (iHoNum.getFramingType() == n) {
            return HoLoHelper.getDisplay(iHoNum, bl);
        }
        return HoLoHelper.getDisplay(HoLoFactory.idlSts2HoNum(n, iHoNum.getIdlHoNum()), bl);
    }

    public static String getDisplay(ILoNum iLoNum, String string, boolean bl) {
        String string2 = null;
        if (iLoNum != null) {
            switch (iLoNum.getFramingType()) {
                case 0: {
                    string2 = HoLoHelper.getSonetLoString(iLoNum, bl);
                    break;
                }
                case 1: {
                    string2 = HoLoHelper.getSdhAu4LoString(iLoNum, string, bl);
                    break;
                }
                case 2: {
                    string2 = HoLoHelper.getSdhAu3LoString(iLoNum, string, bl);
                }
            }
        }
        return string2;
    }

    public static String getSlashSeparatedDisplay(IHoLoNum iHoLoNum) {
        StringBuffer stringBuffer = new StringBuffer();
        IHoNum iHoNum = iHoLoNum.getHoNum();
        ILoNum iLoNum = iHoLoNum.getLoNum();
        return HoLoHelper.getSlashSeparatedDisplay(iHoNum, iLoNum);
    }

    public static String getSlashSeparatedDisplay(IHoNum iHoNum, ILoNum iLoNum) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "/";
        boolean bl = true;
        if (iHoNum != null) {
            stringBuffer.append(HoLoHelper.getDisplay(iHoNum, bl));
        }
        stringBuffer.append(string);
        if (iLoNum != null) {
            stringBuffer.append(HoLoHelper.getDisplay(iLoNum, string, bl));
        }
        return stringBuffer.toString();
    }

    public static String getColonSeparatedDisplay(IHoLoNum iHoLoNum) {
        StringBuffer stringBuffer = new StringBuffer();
        IHoNum iHoNum = iHoLoNum.getHoNum();
        ILoNum iLoNum = iHoLoNum.getLoNum();
        String string = ":";
        boolean bl = false;
        if (iHoNum != null) {
            stringBuffer.append(HoLoHelper.getDisplay(iHoNum, bl));
        }
        stringBuffer.append(string);
        if (iLoNum != null) {
            stringBuffer.append(HoLoHelper.getDisplay(iLoNum, string, bl));
        }
        return stringBuffer.toString();
    }

    public static String getCommaSeparatedDisplay(IHoLoNum iHoLoNum) {
        StringBuffer stringBuffer = new StringBuffer();
        IHoNum iHoNum = iHoLoNum.getHoNum();
        ILoNum iLoNum = iHoLoNum.getLoNum();
        String string = ",";
        boolean bl = false;
        if (iHoNum != null) {
            stringBuffer.append(HoLoHelper.getDisplay(iHoNum, bl));
        }
        stringBuffer.append(string);
        if (iLoNum != null) {
            stringBuffer.append(HoLoHelper.getDisplay(iLoNum, string, bl));
        }
        return stringBuffer.toString();
    }

    protected static String getSonetHoString(IHoNum iHoNum, boolean bl) {
        String string = " ";
        StringBuffer stringBuffer = new StringBuffer();
        if (iHoNum != null) {
            SONETTDMTerminology sONETTDMTerminology = SONETTDMTerminology.instance();
            String string2 = ((SonetHoNum)iHoNum).toString();
            String string3 = sONETTDMTerminology.getGeneralTerms(0);
            if (bl) {
                stringBuffer.append(string3.charAt(0));
            } else {
                stringBuffer.append(string3);
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    protected static String getSdhAu4HoString(IHoNum iHoNum, boolean bl) {
        String string = " ";
        StringBuffer stringBuffer = new StringBuffer();
        if (iHoNum != null) {
            String string2 = iHoNum.toString();
            if (bl) {
                stringBuffer.append(sdhAu4HoShortString);
            } else {
                stringBuffer.append(sdhAu4HoLongString);
                stringBuffer.append(string);
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    protected static String getSdhAu3HoString(IHoNum iHoNum, boolean bl) {
        String string = " ";
        StringBuffer stringBuffer = new StringBuffer();
        if (iHoNum != null) {
            if (bl) {
                stringBuffer.append(sdhAu3HoShortString);
            } else {
                stringBuffer.append(sdhAu3HoLongString);
                stringBuffer.append(string);
            }
            String string2 = iHoNum.toString();
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    protected static String getSonetLoString(ILoNum iLoNum, boolean bl) {
        String string = " ";
        StringBuffer stringBuffer = new StringBuffer();
        if (iLoNum != null) {
            SonetLoNum sonetLoNum = (SonetLoNum)iLoNum;
            if (bl) {
                stringBuffer.append(LoNumStrings[0].charAt(0));
            } else {
                stringBuffer.append(LoNumStrings[0]);
            }
            stringBuffer.append(sonetLoNum.getGroupNum() + "-" + sonetLoNum.getNumInGroup());
        }
        return stringBuffer.toString();
    }

    protected static String getSdhAu4LoString(ILoNum iLoNum, String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = bl ? LoNumShortStrings : LoNumStrings;
        if (iLoNum != null) {
            SdhAu4LoNum sdhAu4LoNum = (SdhAu4LoNum)iLoNum;
            if (sdhAu4LoNum.isVc3Num()) {
                stringBuffer.append(stringArray[1]);
                stringBuffer.append(sdhAu4LoNum.getVc3());
            } else {
                stringBuffer.append(stringArray[2]);
                stringBuffer.append(sdhAu4LoNum.getVc3());
                stringBuffer.append(string);
                stringBuffer.append(stringArray[3]);
                stringBuffer.append(sdhAu4LoNum.getTug2());
                stringBuffer.append(string);
                if (sdhAu4LoNum.isVc11Num()) {
                    stringBuffer.append(stringArray[4]);
                    stringBuffer.append(sdhAu4LoNum.getVc11());
                } else {
                    stringBuffer.append(stringArray[5]);
                    stringBuffer.append(sdhAu4LoNum.getVc12());
                }
            }
        }
        return stringBuffer.toString();
    }

    protected static String getSdhAu3LoString(ILoNum iLoNum, String string, boolean bl) {
        return null;
    }

    protected static int NumOfGroups(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = SonetLoNum.NumOfGroups();
                break;
            }
            case 1: {
                n2 = SdhAu4LoNum.NumOfGroups();
                break;
            }
            case 2: {
                n2 = SdhAu3LoNum.NumOfGroups();
            }
        }
        return n2;
    }

    public static short getGroupNum(int n, short s) {
        int n2 = HoLoHelper.NumOfGroups(n);
        return (short)AbstractLoNum.GetGroupNum((int)s, (int)n2);
    }

    public static short getNumInGroup(int n, short s) {
        int n2 = HoLoHelper.NumOfGroups(n);
        return (short)AbstractLoNum.GetNumInGroup((int)s, (int)n2);
    }

    public static short getFlatNum(int n, short s, short s2) {
        int n2 = HoLoHelper.NumOfGroups(n);
        return (short)AbstractLoNum.GetLoVal((int)s, (int)s2, (int)n2);
    }
}

