/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.cms.model.IIpAddr;
import cerent.cms.model.IIpConfig;
import cerent.cms.model.ISecureIpConfig;
import cerent.cms.model.IpAddr;
import cerent.cms.model.IpConfigError;
import java.util.StringTokenizer;

public class InetUtil {
    private InetUtil() {
    }

    public static String regEx() {
        return "([0-9]{1,3}\\.){3}[0-9]{1,3}";
    }

    public static int makeNetMask(int n) {
        return n == 0 ? 0 : -1 << 32 - n;
    }

    public static String makeDottedString(IIpAddr iIpAddr) {
        return InetUtil.makeDottedString(InetUtil.makeIpV4(iIpAddr));
    }

    public static String makeDottedString(int n) {
        String string = (n >> 24 & 0xFF) + "." + (n >> 16 & 0xFF) + "." + (n >> 8 & 0xFF) + "." + (n & 0xFF);
        return string;
    }

    public static int parseDottedString(String string) {
        int n = 0;
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            if (++n3 > 4) {
                throw new NumberFormatException("parseDottedString: too many .'s");
            }
            n = Integer.parseInt(stringTokenizer.nextToken());
            if (n < 0 || n > 255) {
                throw new NumberFormatException("parseDottedString: byte out of range: " + n);
            }
            n2 = (n2 << 8) + n;
        }
        if (n3 < 4) {
            throw new NumberFormatException("parseDottedString: Incomplete IP address, all four bytes required");
        }
        return n2;
    }

    public static IIpAddr makeIpAddr(String string) {
        return InetUtil.makeIpAddr(InetUtil.parseDottedString(string));
    }

    public static IIpAddr makeIpAddr(int n) {
        int n2;
        byte[] byArray = new byte[16];
        for (n2 = 15; n2 >= 12; --n2) {
            byArray[n2] = (byte)(n & 0xFF);
            n >>= 8;
        }
        for (n2 = 0; n2 < 12; ++n2) {
            byArray[n2] = 0;
        }
        IpAddr ipAddr = new IpAddr(byArray);
        return ipAddr;
    }

    public static int makeIpV4(IIpAddr iIpAddr) {
        return iIpAddr.getAddr()[12] << 24 | iIpAddr.getAddr()[13] << 16 & 0xFF0000 | iIpAddr.getAddr()[14] << 8 & 0xFF00 | iIpAddr.getAddr()[15] & 0xFF;
    }

    public static void validateIpConfig(ISecureIpConfig iSecureIpConfig, IIpConfig iIpConfig, String string) throws IpConfigError {
        IIpAddr iIpAddr = iIpConfig.getIpAddress();
        IIpAddr iIpAddr2 = iSecureIpConfig.getIpAddress();
        IIpAddr iIpAddr3 = iIpConfig.getDefaultRouter();
        int n = InetUtil.makeNetMask(iIpConfig.getNetMaskPrefixLength());
        int n2 = InetUtil.makeNetMask(iSecureIpConfig.getNetMaskPrefixLength());
        InetUtil.validateConfig(iIpAddr2, iIpAddr3, n2, string);
        InetUtil.checkForSameSubnet(iIpAddr2, n2, iIpAddr, n);
    }

    public static void checkForSameSubnet(IIpAddr iIpAddr, int n, IIpAddr iIpAddr2, int n2) throws IpConfigError {
        int n3;
        int n4 = InetUtil.makeIpV4(iIpAddr2);
        if ((n4 & n2) == ((n3 = InetUtil.makeIpV4(iIpAddr)) & n)) {
            throw new IpConfigError("The IP address for the TCC LAN port must not be on the same \nsubnet as the IP address for the backplane LAN port");
        }
    }

    public static void validateIpConfig(IIpConfig iIpConfig, String string) throws IpConfigError {
        IIpAddr iIpAddr = iIpConfig.getIpAddress();
        IIpAddr iIpAddr2 = iIpConfig.getDefaultRouter();
        int n = InetUtil.makeNetMask(iIpConfig.getNetMaskPrefixLength());
        InetUtil.validateConfig(iIpAddr, iIpAddr2, n, string);
    }

    public static void validateConfig(IIpAddr iIpAddr, IIpAddr iIpAddr2, int n, String string) throws IpConfigError {
        int n2;
        int n3 = InetUtil.makeIpV4(iIpAddr);
        int n4 = 0;
        if (iIpAddr2 != null) {
            n4 = InetUtil.makeIpV4(iIpAddr2);
        }
        if (n3 == 0) {
            throw new IpConfigError("IP address must not be all zeroes");
        }
        if (n3 >>> 31 == 0) {
            n2 = 0;
        } else if (n3 >>> 30 == 2) {
            n2 = 1;
        } else if (n3 >>> 29 == 6) {
            n2 = 2;
        } else {
            throw new IpConfigError("IP address must be of class A, B or C");
        }
        int[] nArray = new int[]{InetUtil.makeNetMask(8), InetUtil.makeNetMask(16), InetUtil.makeNetMask(24)};
        InetUtil.checkAllZerosOrOnes(n3, "IP address", Math.min(n, nArray[n2]), "Network");
        InetUtil.checkAllZerosOrOnes(n3, "IP address", ~n, string);
        if (n4 != 0) {
            if ((n3 & n) != (n4 & n)) {
                throw new IpConfigError("Default router and IP address must be on the same subnet.  \nDefault router can be set to 0.0.0.0 if not needed");
            }
            InetUtil.checkAllZerosOrOnes(n4, "default router", ~n, string);
        }
    }

    private static void checkAllZerosOrOnes(int n, String string, int n2, String string2) throws IpConfigError {
        int n3 = n & n2;
        if (n3 == 0) {
            throw new IpConfigError(string2 + " part of " + string + " must not be all-zeros");
        }
        if (n3 == n2) {
            throw new IpConfigError(string2 + " part of " + string + " must not be all-ones");
        }
    }
}

