/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.cms.model.ICircuitType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IPortModel;
import cerent.util.KDebug;
import java.util.ArrayList;

public class PathTraceUtil {
    private static KDebug db = new KDebug("PathTraceUtil");
    public static final int CONVERT_TO_TEXT = 0;
    public static final int CONVERT_TO_HEX = 1;
    public static final int LO_CIRCUIT = 0;
    public static final int HO_CIRCUIT = 1;
    public static final int HO_N_LO_CIRCUIT = 3;

    public static boolean supportsJ1PathTrace(IEntityModel iEntityModel, int n) {
        boolean bl = false;
        try {
            IModuleModel iModuleModel = iEntityModel.getModuleModel();
            if (iModuleModel != null) {
                int n2;
                int n3 = iModuleModel.getEqType();
                int n4 = n2 = iEntityModel instanceof IPortModel ? iEntityModel.getEqType() : 0;
                bl = n == 3 ? PathTraceUtil.supportsJ1PathTrace((IEntityModel)iModuleModel, n3, n2, 1) || PathTraceUtil.supportsJ1PathTrace((IEntityModel)iModuleModel, n3, n2, 0) : PathTraceUtil.supportsJ1PathTrace((IEntityModel)iModuleModel, n3, n2, n);
            }
        }
        catch (Exception exception) {
            KDebug.printStackTrace((Throwable)exception);
        }
        return bl;
    }

    private static boolean supportsJ1PathTrace(IEntityModel iEntityModel, int n, int n2, int n3) {
        boolean bl = false;
        if (db.on()) {
            db.println("CardType = " + n + "\nPortType = " + n2 + "\nCircuit Type = " + n3);
        }
        if (n3 == 1) {
            if (n == 60 || n == 86 || n == 87 || n == 85 || n == 9 || n == 106 || n == 8 || n == 145 || n == 57 || n == 58 || n == 66 || n == 67 || n == 185 || n == 4 || n == 5 || n == 12 || n == 13 || n == 62 || n == 113 || n == 102 || n == 103 || n == 187 || n == 163 || n == 164 || n == 108 || n == 109 || n == 143 || n == 157 || n == 146) {
                bl = true;
            } else if (n == 11) {
                String string;
                ArrayList arrayList = iEntityModel.getNodeModel().getMfgData();
                int n4 = iEntityModel.getSlot();
                if (n4 > 0 && (string = (String)arrayList.get(n4 - 1)) != null && string.indexOf("AS") != -1) {
                    bl = true;
                }
            } else if (n == 47) {
                bl = n2 == 34;
            }
        } else if (n3 == 0) {
            bl = n == 65 || n == 66 || n == 67 || n == 102 || n == 103 || n == 143;
        }
        return bl;
    }

    public static boolean supportsJ1PathTrace(IEntityModel iEntityModel) {
        return PathTraceUtil.supportsJ1PathTrace(iEntityModel, 3);
    }

    public static boolean supportsJ1PathTrace(IEntityModel iEntityModel, ICircuitType iCircuitType) {
        if (iCircuitType == null) {
            return PathTraceUtil.supportsJ1PathTrace(iEntityModel, 3);
        }
        if (iCircuitType.isHoCircuitType()) {
            return PathTraceUtil.supportsJ1PathTrace(iEntityModel, 1);
        }
        return PathTraceUtil.supportsJ1PathTrace(iEntityModel, 0);
    }

    public static boolean supportsJ2PathTrace(IEntityModel iEntityModel) {
        boolean bl = false;
        try {
            int n;
            IModuleModel iModuleModel = iEntityModel.getModuleModel();
            if (iModuleModel != null && ((n = iModuleModel.getEqType()) == 108 || n == 109 || n == 163 || n == 187 || n == 145)) {
                bl = true;
            }
        }
        catch (Exception exception) {
            KDebug.printStackTrace((Throwable)exception);
        }
        return bl;
    }

    public static boolean supportsC2Mismatch(IInterfaceModel iInterfaceModel) {
        boolean bl = false;
        try {
            IModuleModel iModuleModel = iInterfaceModel.getPortModel().getModuleModel();
            if (iModuleModel != null) {
                int n;
                int n2 = iModuleModel.getEqType();
                bl = n2 == 113 ? (n = iInterfaceModel.getPortModel().getPayloadType()) == 15 || n == 16 : n2 == 108 || n2 == 109;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static boolean allowsNullExpTrace(IEntityModel iEntityModel) {
        boolean bl = true;
        IModuleModel iModuleModel = iEntityModel.getModuleModel();
        if (iModuleModel != null) {
            int n = iModuleModel.getEqType();
            if (n == 145) {
                bl = false;
            } else if (n == 157) {
                int n2 = iEntityModel instanceof IPortModel ? iEntityModel.getEqType() : 0;
                bl = n2 != 34 && n2 != 32 && n2 != 31;
            }
        }
        return bl;
    }

    public static String charFromByte(char c, boolean bl) {
        int n = c & 0xFF;
        if (bl) {
            return " " + (char)n + " ";
        }
        return String.valueOf((char)n);
    }

    public static String hexFromByte(char c) {
        int n = c & 0xFF;
        String string = Integer.toHexString(n);
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string + " ";
    }

    public static String bytesToString(char[] cArray, int n) {
        char[] cArray2 = cArray;
        String string = new String(cArray2);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        if (n == 0) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c < ' ' || c >= '\u0080') continue;
                stringBuffer2.append(PathTraceUtil.charFromByte(c, false));
            }
            return stringBuffer2.toString();
        }
        for (int i = 0; i < string.length(); ++i) {
            char c;
            if (i % 16 == 0) {
                stringBuffer2.append(PathTraceUtil.hexFromByte((char)i) + ": ");
                if (n == 1) {
                    stringBuffer.append("     ");
                }
            }
            if ((c = string.charAt(i)) > ' ' && c < '\u0080') {
                stringBuffer2.append(PathTraceUtil.charFromByte(c, true));
                stringBuffer.append(PathTraceUtil.hexFromByte(c));
            } else {
                stringBuffer2.append(PathTraceUtil.charFromByte(' ', true));
                stringBuffer.append(PathTraceUtil.hexFromByte(c));
            }
            if ((i + 1) % 16 != 0 && i + 1 != string.length()) continue;
            stringBuffer2.append("\n");
            stringBuffer.append("\n");
            stringBuffer3.append(stringBuffer2);
            stringBuffer3.append(stringBuffer);
            stringBuffer2 = new StringBuffer();
            stringBuffer = new StringBuffer();
        }
        stringBuffer3.append(stringBuffer2);
        stringBuffer3.append(stringBuffer);
        return stringBuffer3.toString();
    }

    public static String bytesToSimpleString(char[] cArray, int n) {
        int n2;
        if (cArray == null) {
            return null;
        }
        String string = new String(cArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n2 = string.length();
        int n4 = n2 - 1;
        while (n4 >= 0 && string.charAt(n4) == '\u0000') {
            n3 = n4--;
        }
        if (n == 0) {
            for (n4 = 0; n4 < n3; ++n4) {
                int n5 = string.charAt(n4) & 0xFF;
                char c = n5 < 32 || n5 > 127 ? (char)'.' : (char)((char)n5);
                stringBuffer.append(c);
            }
        } else {
            for (n4 = 0; n4 < n3; ++n4) {
                stringBuffer.append(PathTraceUtil.hexFromByte(string.charAt(n4)));
            }
        }
        return stringBuffer.toString();
    }
}

