/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.gui.CheckableItem;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class CheckableList
extends JList {
    public CheckableList() {
        this.setSelectionMode(0);
        this.setCellRenderer(new CheckListRenderer());
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = CheckableList.this.locationToIndex(mouseEvent.getPoint());
                try {
                    CheckableItem checkableItem = (CheckableItem)CheckableList.this.getModel().getElementAt(n);
                    checkableItem.setSelected(!checkableItem.isSelected());
                    Rectangle rectangle = CheckableList.this.getCellBounds(n, n);
                    CheckableList.this.repaint(rectangle);
                    CheckableList.this.fireSelectionEvent(n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void fireSelectionEvent(int n) {
        this.fireSelectionValueChanged(n, n, false);
    }

    class CheckListRenderer
    extends JCheckBox
    implements ListCellRenderer {
        public CheckListRenderer() {
            this.setBackground(UIManager.getColor("List.textBackground"));
            this.setForeground(UIManager.getColor("List.textForeground"));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setEnabled(jList.isEnabled() && ((CheckableItem)object).isEnabled());
            this.setSelected(((CheckableItem)object).isSelected());
            this.setFont(jList.getFont());
            this.setText(object.toString());
            return this;
        }
    }
}

