/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class MacAddrDocument
extends PlainDocument {
    public static String INIT_STRING = "XX-XX-XX-XX-XX-XX";
    private static int SEP1 = 2;
    private static int SEP2 = 5;
    private static int SEP3 = 8;
    private static int SEP4 = 11;
    private static int SEP5 = 14;
    private static String HEX_STRING = "abcdefABCDEF0123456789";
    public static String MAC_STRING = "MAC";
    public static String NEW_STRING = "NEW";
    private JTextComponent textComponent;
    private int newOffset;

    public MacAddrDocument(JTextComponent jTextComponent) {
        this.textComponent = jTextComponent;
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (attributeSet != null && attributeSet.containsAttribute(MAC_STRING, NEW_STRING)) {
            this.clearText();
            super.insertString(this.newOffset, string, attributeSet);
            return;
        }
        if (string.equals(INIT_STRING)) {
            super.insertString(n, string, attributeSet);
            return;
        }
        if (!this.parseHex(string)) {
            return;
        }
        this.newOffset = n;
        if (this.atSeparator(n)) {
            ++this.newOffset;
            this.textComponent.setCaretPosition(this.newOffset);
        }
        super.remove(this.newOffset, 1);
        super.insertString(this.newOffset, string, attributeSet);
    }

    public void clearText() throws BadLocationException {
        this.newOffset = 0;
        super.remove(0, this.getLength());
    }

    public void remove(int n, int n2) throws BadLocationException {
        if (this.atSeparator(n)) {
            this.textComponent.setCaretPosition(n - 1);
        } else {
            this.textComponent.setCaretPosition(n);
        }
    }

    private boolean atSeparator(int n) {
        return n == SEP1 || n == SEP2 || n == SEP3 || n == SEP4 || n == SEP5;
    }

    private boolean parseHex(String string) {
        boolean bl = true;
        if (string != null) {
            for (int i = 0; bl && i < string.length(); ++i) {
                char c = string.charAt(i);
                if (-1 != HEX_STRING.indexOf(c)) continue;
                bl = false;
            }
        }
        return bl;
    }
}

