/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.ior;

import java.io.IOException;

public class CdrReader {
    private boolean _littleEndian;
    private byte[] _buffer;
    private int _offset;

    public CdrReader(boolean bl, byte[] byArray) {
        this._littleEndian = bl;
        this._buffer = byArray;
        this._offset = 0;
    }

    public boolean endian() {
        return this._littleEndian;
    }

    public void endian(boolean bl) {
        this._littleEndian = bl;
    }

    public boolean eof() {
        return this._offset >= this._buffer.length;
    }

    public int getByte() {
        return this._buffer[this._offset++] & 0xFF;
    }

    public byte[] getBytes() throws IOException {
        int n = this.getInt();
        byte[] byArray = new byte[n];
        System.arraycopy(this._buffer, this._offset, byArray, 0, n);
        this._offset += n;
        return byArray;
    }

    public int getShort() throws IOException {
        int n;
        this.align(2);
        if (this._littleEndian) {
            n = this.getByte();
            n |= this.getByte() << 8;
        } else {
            n = this.getByte() << 8;
            n |= this.getByte();
        }
        return n;
    }

    public int getInt() throws IOException {
        int n;
        this.align(4);
        if (this._littleEndian) {
            n = this.getByte();
            n |= this.getByte() << 8;
            n |= this.getByte() << 16;
            n |= this.getByte() << 24;
        } else {
            n = this.getByte() << 24;
            n |= this.getByte() << 16;
            n |= this.getByte() << 8;
            n |= this.getByte();
        }
        return n;
    }

    public long getLong() throws IOException {
        long l;
        this.align(8);
        if (this._littleEndian) {
            l = this.getByte();
            l |= (long)(this.getByte() << 8);
            l |= (long)(this.getByte() << 16);
            l |= (long)(this.getByte() << 24);
            l |= (long)(this.getByte() << 32);
            l |= (long)(this.getByte() << 40);
            l |= (long)(this.getByte() << 48);
            l |= (long)(this.getByte() << 56);
        } else {
            l = this.getByte() << 56;
            l |= (long)(this.getByte() << 48);
            l |= (long)(this.getByte() << 40);
            l |= (long)(this.getByte() << 32);
            l |= (long)(this.getByte() << 24);
            l |= (long)(this.getByte() << 16);
            l |= (long)(this.getByte() << 8);
            l |= (long)this.getByte();
        }
        return l;
    }

    public float getFloat() throws IOException {
        return Float.intBitsToFloat(this.getInt());
    }

    public double getDouble() throws IOException {
        return Double.longBitsToDouble(this.getLong());
    }

    public boolean getBoolean() throws IOException {
        int n = this.getByte();
        switch (n) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new IOException("Illegal boolean value " + n);
    }

    public String getString() throws IOException {
        char c;
        char c2 = this.getInt() - 1;
        StringBuffer stringBuffer = new StringBuffer(c2);
        for (c = '\u0000'; c < c2; ++c) {
            stringBuffer.append((char)this.getByte());
        }
        c = (char)this.getByte();
        if (c != '\u0000') {
            throw new IOException("Illegal string null terminator " + c);
        }
        return stringBuffer.toString();
    }

    private void align(int n) throws IOException {
        while (this._offset % n != 0) {
            this.getByte();
        }
    }
}

