/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.ior;

import cerent.util.ior.CdrReader;
import cerent.util.ior.CdrWriter;
import cerent.util.ior.IopProfile;
import cerent.util.ior.MultiComponentProfile;
import java.io.IOException;
import java.io.PrintStream;

public class IiopProfile
implements IopProfile {
    private int _major;
    private int _minor;
    private String _host;
    private int _port;
    private byte[] _objectKey;
    private MultiComponentProfile _components;

    public IiopProfile(CdrReader cdrReader) throws IOException {
        this._major = cdrReader.getByte();
        this._minor = cdrReader.getByte();
        this._host = cdrReader.getString();
        this._port = cdrReader.getShort();
        this._objectKey = cdrReader.getBytes();
        this._components = (this._minor > 0 || this._major > 1) && !cdrReader.eof() ? new MultiComponentProfile(cdrReader) : null;
    }

    public CdrWriter write(CdrWriter cdrWriter) {
        cdrWriter.putByte(this._major);
        cdrWriter.putByte(this._minor);
        cdrWriter.putString(this._host);
        cdrWriter.putShort(this._port);
        cdrWriter.putBytes(this._objectKey);
        if ((this._minor > 0 || this._major > 1) && this._components != null) {
            this._components.write(cdrWriter);
        }
        return cdrWriter;
    }

    public void print(PrintStream printStream, String string) {
        printStream.println(string + "major: " + this._major);
        printStream.println(string + "minor: " + this._minor);
        printStream.println(string + "host: " + this._host);
        printStream.println(string + "port: " + this._port);
        printStream.print(string + "key: ");
        for (int i = 0; i < this._objectKey.length; ++i) {
            printStream.print(this.asChar(this._objectKey[i]));
        }
        printStream.println();
        if ((this._minor > 0 || this._major > 1) && this._components != null) {
            this._components.print(printStream, string + "  ");
        } else {
            printStream.println(string + "no components");
        }
    }

    public int major() {
        return this._major;
    }

    public void major(int n) {
        this._major = n;
    }

    public int minor() {
        return this._minor;
    }

    public void minor(int n) {
        this._minor = n;
    }

    public String host() {
        return this._host;
    }

    public void host(String string) {
        this._host = string;
    }

    public int port() {
        return this._port;
    }

    public void port(int n) {
        this._port = n;
    }

    public byte[] objectKey() {
        return this._objectKey;
    }

    public void objectKey(byte[] byArray) {
        this._objectKey = byArray;
    }

    public MultiComponentProfile components() {
        return this._components;
    }

    public void components(MultiComponentProfile multiComponentProfile) {
        this._components = multiComponentProfile;
    }

    private String asChar(byte by) {
        String string = by < 0 ? "\\M" + this.asChar((byte)(by + 128)) : (by < 32 ? "\\C" + (char)(by + 64) : (by == 92 ? "\\" : (by < 127 ? "" + (char)by : "\\C?")));
        return string;
    }
}

