/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc454.ui;

import cerent.cms.model.Ds3xmModuleModel;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.L2scModuleModel;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.AbstractCardViewPanel;
import cerent.cms.ui.CardViewController;
import cerent.cms.ui.ml2.ML2CardView;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.AiciCardView;
import cerent.cms.ui.shelf.CardView;
import cerent.cms.ui.shelf.DwdmCardView;
import cerent.cms.ui.shelf.G1000CardView;
import cerent.cms.ui.shelf.MuxDmuxCardView;
import cerent.cms.ui.shelf.OadmCardView;
import cerent.cms.ui.shelf.OscCardView;
import cerent.cms.ui.shelf.Wss32CardView;
import cerent.util.SDebug;
import cerent.util.gui.MultiLineLabelUI;
import com.cisco.ctc454.ui.shelf.Ds3Ec1CardView;
import com.cisco.ctc454.ui.shelf.Ds3xm12CardView;
import javax.swing.JLabel;
import javax.swing.plaf.LabelUI;

public class CardViewPanel
extends AbstractCardViewPanel {
    private static final SDebug db = new SDebug("CardViewPanel");

    public CardViewPanel(ModuleModel moduleModel, CardViewController cardViewController) {
        super(moduleModel, cardViewController);
    }

    protected void initPanel() {
        this.cardName = this.model.getEqLabel();
        JLabel jLabel = AbstractShelfLayout.formatLabel(new JLabel(this.cardName));
        this.add(jLabel, 0, 1, 2, 1);
        this.setupCardView();
        this.add(this.cardView, 1, 2, 1, -1);
        if (this.model.getEqType() == 145 && ((Ds3xmModuleModel)this.model).isOneForNProtectModule()) {
            JLabel jLabel2 = new JLabel(" \nThe DS3XM-12 1:N protect card will assume the port configuration of the working card it protects.");
            jLabel2.setUI((LabelUI)new MultiLineLabelUI());
            jLabel2 = AbstractShelfLayout.formatLabel(jLabel2);
            this.add(jLabel2, 0, 3, 2, 0);
        }
    }

    protected void setupCardView() {
        int n = this.model.getEqType();
        if (n == 97) {
            this.cardView = new AiciCardView(this.model);
        } else if (n == 102 || n == 103) {
            if (this.model instanceof L2scModuleModel) {
                L2scModuleModel l2scModuleModel = (L2scModuleModel)this.model;
                this.cardView = new ML2CardView(l2scModuleModel, l2scModuleModel.getL2scEtherPorts(), l2scModuleModel.getL2scPosPorts());
            }
        } else if (n == 62) {
            this.cardView = new G1000CardView(this.model);
        } else if (n == 187) {
            if (this.model instanceof ML2ModuleModel) {
                ML2ModuleModel mL2ModuleModel = (ML2ModuleModel)this.model;
                this.cardView = new ML2CardView(mL2ModuleModel, mL2ModuleModel.getEtherPortModels(), mL2ModuleModel.getPosPortModels(), mL2ModuleModel.isInMapperMode());
            }
        } else {
            this.cardView = n == 134 || n == 135 || n == 136 || n == 137 || n == 138 || n == 129 || n == 130 || n == 196 || n == 133 ? new OadmCardView(this.model) : (n == 131 || n == 192 || n == 132 ? new MuxDmuxCardView(this.model) : (n == 191 ? new Wss32CardView(this.model) : (n == 127 || n == 128 ? new OscCardView(this.model) : (this.model instanceof DwdmModuleModel ? new DwdmCardView(this.model) : (n == 185 ? new Ds3Ec1CardView(this.model) : (n == 145 ? new Ds3xm12CardView(this.model) : new CardView(this.model)))))));
        }
        if (db.on()) {
            db.println("setupCardView cardView is " + this.cardView);
        }
    }
}

