/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455.model;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.AbstractSlotPolicy;
import cerent.cms.model.EntityModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SlotModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SlotPolicy
extends AbstractSlotPolicy {
    private NodeModelDelegate _node;

    public SlotPolicy(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate);
        this._node = nodeModelDelegate;
    }

    protected void initSlotMap() {
        this.addCardToMap(this.DSN_GROUP, eEqType.E1_LINE_CARD);
        this.addCardToMap(this.DSN_GROUP, eEqType.E1_42_LINE_CARD);
        this.addCardToMap(this.DSN_GROUP, eEqType.E3_LINE_CARD);
        this.addCardToMap(this.DSN_GROUP, eEqType.DS3I_LINE_CARD);
        this.addCardToMap(this.ETH_GROUP, eEqType.EPOS_100_LINE_CARD);
        this.addCardToMap(this.ETH_GROUP, eEqType.EPOS_1000_LINE_CARD);
        this.addCardToMap(this.ETH_GROUP, eEqType.G1000_LINE_CARD);
        this.addCardToMap(this.ETH_GROUP, eEqType.L2SC_100_LINE_CARD);
        this.addCardToMap(this.ETH_GROUP, eEqType.L2SC_GIG_LINE_CARD);
        this.addCardToMap(this.OCN_GROUP, eEqType.OC3_LINE_CARD);
        this.addCardToMap(this.OCN_GROUP, eEqType.OC12_LINE_CARD);
        this.addCardToMap(this.OCN_GROUP, eEqType.OC48_LINE_CARD);
        this.addCardToMap(this.OCN_GROUP, eEqType.STM1E_12_LINE_CARD);
        this.addMenuToMap(this.DWDM_FAMILY, this.WDM_GROUP);
        this.addCardToMap(this.DWDM_FAMILY, this.WDM_GROUP, eEqType.TXP_MR_2_5G_LINE_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.WDM_GROUP, eEqType.TXPP_MR_2_5G_LINE_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.WDM_GROUP, eEqType.TXP_MR_10G_LINE_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.WDM_GROUP, eEqType.TXP_MR_10E_LINE_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.WDM_GROUP, eEqType.MXP_2_5G_10G_LINE_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.WDM_GROUP, eEqType.MXP_2_5G_10E_LINE_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.WDM_GROUP, eEqType.MXP_MR_2_5G_LINE_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.WDM_GROUP, eEqType.MXPP_MR_2_5G_LINE_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.OADM_GROUP, eEqType.AD_1C_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.OADM_GROUP, eEqType.AD_2C_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.OADM_GROUP, eEqType.AD_4C_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.OADM_GROUP, eEqType.AD_1B_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.OADM_GROUP, eEqType.AD_4B_CARD);
        this.addCardToMap(this.DWDM_FAMILY, "TOP_LEVEL", eEqType.OSC_CSM_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.AMPLI_GROUP, eEqType.OPT_PRE);
        this.addCardToMap(this.DWDM_FAMILY, this.AMPLI_GROUP, eEqType.OPT_BST);
        this.addCardToMap(this.DWDM_FAMILY, this.AMPLI_GROUP, eEqType.OPT_BST_E);
        this.addMenuToMap(this.DWDM_FAMILY, this.MD_GROUP);
        this.addCardToMap(this.DWDM_FAMILY, this.MD_GROUP, eEqType.MUX32_O_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.MD_GROUP, eEqType.DMX32_O_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.MD_GROUP, eEqType.MUX_DMX4_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.MD_GROUP, eEqType.DMX32_R_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.MD_GROUP, eEqType.WSS_32_CARD);
    }

    public Map getMapOfValidModules(SlotModel slotModel) {
        HashMap hashMap = new HashMap();
        switch (slotModel.getEqType()) {
            case 24: {
                hashMap.put(eEqType.AICI_CARD, null);
                break;
            }
            case 22: {
                hashMap.put(eEqType.TCC_CARD, null);
                break;
            }
            case 21: {
                hashMap.putAll(this.getIoSlotEqMap(slotModel));
                break;
            }
            case 23: {
                if (this.hasEqType(slotModel, eEqType.XC192_CARD)) {
                    hashMap.put(eEqType.XC192_CARD, null);
                    break;
                }
                if (this.hasEqType(slotModel, eEqType.XCVXL_CARD)) {
                    hashMap.put(eEqType.XCVXL_CARD, null);
                    break;
                }
                if (this.hasEqType(slotModel, eEqType.XCVXL25G_CARD)) {
                    hashMap.put(eEqType.XCVXL25G_CARD, null);
                    break;
                }
                if (this.hasEqType(slotModel, eEqType.OC192_LINE_CARD)) {
                    hashMap.put(eEqType.XC192_CARD, null);
                    hashMap.put(eEqType.XCVXL_CARD, null);
                    break;
                }
                hashMap.put(eEqType.XC192_CARD, null);
                hashMap.put(eEqType.XCVXL25G_CARD, null);
                hashMap.put(eEqType.XCVXL_CARD, null);
                hashMap.put(eEqType.OSCM_CARD, null);
                break;
            }
            default: {
                hashMap.put(eEqType.INVALID, null);
            }
        }
        return hashMap;
    }

    private boolean isOkToCheckOC192() {
        EntityModel entityModel = (EntityModel)this._node.getEntityTableModel().getChassis();
        if (entityModel == null) {
            return false;
        }
        return entityModel.getDescendantsOfType(eEqType.XCVXL25G_CARD).size() <= 0;
    }

    public List getListOfValidUpgradeType(SlotModel slotModel, int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Map map = this.getMapOfValidModules(slotModel);
        if (n == 10) {
            if (this.eqTypeInMap(map, eEqType.OC12_4_LINE_CARD)) {
                arrayList.add(new Integer(85));
            }
            if (this.eqTypeInMap(map, eEqType.OC48_LINE_CARD)) {
                arrayList.add(new Integer(11));
            }
            if (this.isOkToCheckOC192() && this.eqTypeInMap(map, eEqType.OC192_LINE_CARD)) {
                arrayList.add(new Integer(60));
            }
        } else if (n == 11 && this.isOkToCheckOC192() && this.isHighSpeedSlot(slotModel.getSlot()) && this.eqTypeInMap(map, eEqType.OC192_LINE_CARD)) {
            arrayList.add(new Integer(60));
        }
        return arrayList;
    }

    public List getListOfValidChangeType(SlotModel slotModel, eEqType eEqType2) {
        ArrayList arrayList = new ArrayList();
        if (eEqType2 == eEqType.OC12_LINE_CARD || eEqType2 == eEqType.OC12_4_LINE_CARD || eEqType2 == eEqType.OC3_8_LINE_CARD || eEqType2 == eEqType.OC3_LINE_CARD || eEqType2 == eEqType.OC48_LINE_CARD || eEqType2 == eEqType.OC192_LINE_CARD) {
            Map map = this.getMapOfValidModules(slotModel);
            if (eEqType2 == eEqType.OC3_8_LINE_CARD) {
                this.addToChangeTypeList(map, eEqType.OC3_LINE_CARD, eEqType2, arrayList);
            } else if (eEqType2 == eEqType.OC3_LINE_CARD) {
                this.addToChangeTypeList(map, eEqType.OC3_8_LINE_CARD, eEqType2, arrayList);
            } else if (eEqType2 == eEqType.OC12_4_LINE_CARD) {
                this.addToChangeTypeList(map, eEqType.OC12_LINE_CARD, eEqType2, arrayList);
            } else if (eEqType2 == eEqType.OC12_LINE_CARD) {
                this.addToChangeTypeList(map, eEqType.OC12_4_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.OC48_LINE_CARD, eEqType2, arrayList);
                if (this.isOkToCheckOC192()) {
                    this.addToChangeTypeList(map, eEqType.OC192_LINE_CARD, eEqType2, arrayList);
                }
            } else {
                this.addToChangeTypeList(map, eEqType.OC12_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.OC48_LINE_CARD, eEqType2, arrayList);
                if (this.isOkToCheckOC192()) {
                    this.addToChangeTypeList(map, eEqType.OC192_LINE_CARD, eEqType2, arrayList);
                }
            }
        }
        return arrayList;
    }

    private Map getIoSlotEqMap(SlotModel slotModel) {
        int n = slotModel.getSlot();
        if (this.isLowSpeedSlot(n)) {
            return this.getLowSpeedSlotModuleMap(slotModel);
        }
        if (this.isLowSpeedProtectSlot(n)) {
            return this.getLowSpeedProtectSlotModuleMap(slotModel);
        }
        if (this.isHighSpeedSlot(n)) {
            return this.getHighSpeedSlotModuleMap(slotModel);
        }
        HashMap<eEqType, Object> hashMap = new HashMap<eEqType, Object>();
        hashMap.put(eEqType.INVALID, null);
        return hashMap;
    }

    private Map getLowSpeedSlotModuleMap(SlotModel slotModel) {
        Map map = this.deepCopyMap(this.slotMap);
        Set set = this.getSetForMenu(this.OCN_GROUP, map);
        if (set != null) {
            set.add(eEqType.OC3_8_LINE_CARD);
            set.add(eEqType.OC12_4_LINE_CARD);
        } else {
            String string = this.getFamilyMenu(this.OCN_GROUP, map);
            this.addCard(string, this.OCN_GROUP, eEqType.OC3_8_LINE_CARD, map);
            this.addCard(string, this.OCN_GROUP, eEqType.OC12_4_LINE_CARD, map);
            this.addCard(string, this.OCN_GROUP, eEqType.OC48_LINE_CARD, map);
            this.addCard(string, this.OCN_GROUP, eEqType.OC3_LINE_CARD, map);
            this.addCard(string, this.OCN_GROUP, eEqType.OC12_LINE_CARD, map);
            this.addCard(string, this.OCN_GROUP, eEqType.STM1E_12_LINE_CARD, map);
        }
        map.put(eEqType.FCMR_LINE_CARD, null);
        return map;
    }

    private Map getLowSpeedProtectSlotModuleMap(SlotModel slotModel) {
        Map map = this.deepCopyMap(this.getLowSpeedSlotModuleMap(slotModel));
        Set set = this.getSetForMenu(this.DSN_GROUP, map);
        if (set != null) {
            set.remove(eEqType.E1_LINE_CARD);
            set.remove(eEqType.DS3I_LINE_CARD);
            set.add(eEqType.E1N_LINE_CARD);
            set.add(eEqType.DS3IN_LINE_CARD);
        } else {
            String string = this.getFamilyMenu(this.DSN_GROUP, map);
            this.addCard(string, this.DSN_GROUP, eEqType.E1N_LINE_CARD, map);
            this.addCard(string, this.DSN_GROUP, eEqType.DS3IN_LINE_CARD, map);
            this.addCard(string, this.DSN_GROUP, eEqType.E1_42_LINE_CARD, map);
            this.addCard(string, this.DSN_GROUP, eEqType.E3_LINE_CARD, map);
        }
        return map;
    }

    private Map getHighSpeedSlotModuleMap(SlotModel slotModel) {
        Map map = this.deepCopyMap(this.slotMap);
        Set set = this.getSetForMenu(this.DSN_GROUP, map);
        String string = null;
        int n = slotModel.getSlot();
        if (this.isHighSpeedElectricalSlot(n)) {
            if (set != null) {
                set.remove(eEqType.E1_42_LINE_CARD);
            } else {
                string = this.getFamilyMenu(this.DSN_GROUP, map);
                this.addCard(string, this.DSN_GROUP, eEqType.E1_LINE_CARD, map);
                this.addCard(string, this.DSN_GROUP, eEqType.E3_LINE_CARD, map);
                this.addCard(string, this.DSN_GROUP, eEqType.DS3I_LINE_CARD, map);
            }
        } else if (set != null) {
            map.remove(this.DSN_GROUP);
        } else {
            string = this.getFamilyMenu(this.DSN_GROUP, map);
        }
        set = this.getSetForMenu(this.OCN_GROUP, map);
        if (set != null) {
            set.remove(eEqType.STM1E_12_LINE_CARD);
            EntityModel entityModel = (EntityModel)slotModel.getNodeModelDelegate().getEntityTableModel().getChassis();
            if (entityModel.getDescendantsOfType(eEqType.XC192_CARD).size() > 0 || entityModel.getDescendantsOfType(eEqType.XCVXL_CARD).size() > 0) {
                set.add(eEqType.OC192_LINE_CARD);
            }
        } else {
            string = this.getFamilyMenu(this.DSN_GROUP, map);
            this.addCard(string, this.OCN_GROUP, eEqType.OC192_LINE_CARD, map);
            this.addCard(string, this.OCN_GROUP, eEqType.OC3_LINE_CARD, map);
            this.addCard(string, this.OCN_GROUP, eEqType.OC12_LINE_CARD, map);
            this.addCard(string, this.OCN_GROUP, eEqType.OC48_LINE_CARD, map);
        }
        map.put(eEqType.FCMR_LINE_CARD, null);
        return map;
    }

    public boolean needDs1Ifs(int n) {
        return n == 83 || n == 64 || n == 108 || n == 109 || n == 65 || n == 66 || n == 67;
    }

    private boolean isHighSpeedElectricalSlot(int n) {
        boolean bl = false;
        switch (n) {
            case 5: 
            case 13: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static boolean isComboPort(int n) {
        return false;
    }
}

