/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455.ui.shelf;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.eQualityLevel;
import cerent.cms.idl.Ds123Media.eLineCoding;
import cerent.cms.idl.Ds123Media.eLineType;
import cerent.cms.idl.Synchronization.eBits;
import cerent.cms.idl.Synchronization.eBitsLBO;
import cerent.cms.idl.Synchronization.eCableType;
import cerent.cms.idl.Synchronization.eSaBit;
import cerent.cms.idl.Synchronization.sBitsConfig;
import cerent.cms.model.Attribute;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractBitsProvPane;
import cerent.cms.ui.shelf.AbstractSppTimingBitsPane;
import java.awt.event.ActionEvent;
import javax.swing.JComboBox;

public abstract class AbstractSdhBitsProvPane
extends AbstractBitsProvPane {
    private static final String[] bitsChoices = new String[]{"E1", "2Mhz"};
    protected static final String[] codingChoices = new String[]{"HDB3", "AMI"};
    protected static final String[] framingChoices = new String[]{"Unframed", "FAS", "FAS+CAS", "FAS+CRC", "FAS+CAS+CRC"};
    protected static final eLineType[] framingValue = new eLineType[]{eLineType.E1_UNFRAME, eLineType.E1_FRAME, eLineType.E1_MF, eLineType.E1_CRC, eLineType.E1_CRCMF};
    protected static final String[] sabitChoices = new String[]{"4", "5", "6", "7", "8"};

    public AbstractSdhBitsProvPane(String string, TabbedView tabbedView, AbstractSppTimingBitsPane abstractSppTimingBitsPane, eBits eBits2) {
        super(string, tabbedView, abstractSppTimingBitsPane, eBits2);
    }

    protected abstract String[] getStateChoices();

    protected abstract eAdminState getAdminStateFromSelection(int var1);

    protected abstract eLineCoding getCodingFromSelection(int var1);

    protected abstract eLineType getFramingFromSelection(int var1, int var2);

    protected abstract int getFramingIndex(eLineType var1);

    public String[] getBitsInChoices() {
        return bitsChoices;
    }

    public String[] getBitsOutChoices() {
        return bitsChoices;
    }

    protected String[] getCodingChoices() {
        return codingChoices;
    }

    protected String[] getFramingChoices() {
        return framingChoices;
    }

    public Attribute[] getQualityChoices() {
        return attrMap.getAttributeArray("timingSdhSsmQuality");
    }

    private Attribute getQualityAttribute(int n) {
        return attrMap.getAttributeForVal("timingSdhSsmQuality", n);
    }

    public JComboBox createBitsInSabit() {
        this.sabitBitsInCB = new JComboBox<String>(sabitChoices);
        this.sabitBitsInCB.setName("Sa Bit");
        this.sabitBitsInCB.addActionListener(this);
        this.enableComponent(this.sabitBitsInCB);
        return this.sabitBitsInCB;
    }

    public JComboBox createBitsOutSabit() {
        this.sabitBitsOutCB = new JComboBox<String>(sabitChoices);
        this.sabitBitsOutCB.setName("Sa Bit");
        this.sabitBitsOutCB.addActionListener(this);
        this.enableComponent(this.sabitBitsOutCB);
        return this.sabitBitsOutCB;
    }

    public void updateBitsInValues() {
        if (this.parent.isBits2M(0)) {
            this.codingBitsInCB.setSelectedIndex(1);
            this.framingBitsInCB.setSelectedIndex(0);
            this.ssmEnabledBitsInCB.setSelected(false);
        }
        super.updateBitsInValues();
    }

    public void updateBitsOutValues() {
        this.codingBitsOutCB.setSelectedIndex(this.codingBitsInCB.getSelectedIndex());
        this.framingBitsOutCB.setSelectedIndex(this.framingBitsInCB.getSelectedIndex());
        super.updateBitsOutValues();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object == this.framingBitsInCB) {
            if (this.isSyncMsgFraming(0)) {
                this.enableComponent(this.sabitBitsInCB);
            } else {
                this.sabitBitsInCB.setEnabled(false);
            }
        } else if (object == this.sabitBitsInCB) {
            this.sabitBitsOutCB.setSelectedIndex(this.sabitBitsInCB.getSelectedIndex());
        }
    }

    public void applyChangesToModel() throws Exception {
        sBitsConfig sBitsConfig2 = new sBitsConfig();
        if (db.on()) {
            db.println("eneter ASBPP applyChangesToModel");
        }
        sBitsConfig2.facilityType = this.parent.getFacilityTypeSelection(this.parent.getBitsInFacilityType());
        sBitsConfig2.adminState = this.getAdminStateFromSelection(this.stateBitsInCB.getSelectedIndex());
        sBitsConfig2.coding = this.getCodingFromSelection(this.codingBitsInCB.getSelectedIndex());
        sBitsConfig2.framing = this.getFramingFromSelection(0, this.framingBitsInCB.getSelectedIndex());
        sBitsConfig2.syncMessageIn = this.ssmEnabledBitsInCB.isSelected();
        sBitsConfig2.assumedQuality = this.pci.showAdminSSM() ? this.getQualitySelection((Attribute)this.adminSsmBitsInCB.getSelectedItem()) : eQualityLevel.STU_SDH;
        sBitsConfig2.saBit = eSaBit.from_int(this.sabitBitsInCB.getSelectedIndex());
        sBitsConfig2.facilityTypeBitsOut = this.parent.getFacilityTypeSelection(this.parent.getBitsOutFacilityType());
        if (this.pci.isBitsOutStateProvisionable()) {
            sBitsConfig2.adminStateBitsOut = this.getAdminStateFromSelection(this.stateBitsOutCB.getSelectedIndex());
        }
        sBitsConfig2.codingBitsOut = this.getCodingFromSelection(this.codingBitsOutCB.getSelectedIndex());
        sBitsConfig2.framingBitsOut = this.getFramingFromSelection(1, this.framingBitsOutCB.getSelectedIndex());
        sBitsConfig2.aisThreshold = this.pci.isAISThresholdProvisionable() ? this.getQualitySelection((Attribute)this.qualityCB.getSelectedItem()) : eQualityLevel.STU_SDH;
        sBitsConfig2.cableSelection = eCableType.PAUSE_75_OHM;
        sBitsConfig2.bitsLBO = eBitsLBO.BITS_LBO_0_133_FEET;
        this.dumpData(sBitsConfig2);
        ((NodeModelDelegate)this.getUiModel()).getSynchronizationModel().setBitsConfig(this.bitsPort, sBitsConfig2);
        if (db.on()) {
            db.println("leave ASBPP applyChangesToModel");
        }
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("enter ASBPP refreshFromModel (bitsPort=" + this.bitsPort.value() + ")");
        }
        sBitsConfig sBitsConfig2 = null;
        sBitsConfig2 = ((NodeModelDelegate)this.getUiModel()).getSynchronizationModel().getBitsConfig(this.bitsPort);
        this.dumpData(sBitsConfig2);
        this.stateBitsInCB.setSelectedIndex(this.getAdminStateIndex(sBitsConfig2.adminState));
        this.codingBitsInCB.setSelectedIndex(this.getCodingIndex(sBitsConfig2.coding));
        this.framingBitsInCB.setSelectedIndex(this.getFramingIndex(sBitsConfig2.framing));
        this.ssmEnabledBitsInCB.setSelected(sBitsConfig2.syncMessageIn);
        if (this.pci.showAdminSSM()) {
            this.adminSsmBitsInCB.setSelectedItem(this.getQualityAttribute(sBitsConfig2.assumedQuality.value()));
        }
        this.sabitBitsInCB.setSelectedIndex(sBitsConfig2.saBit.value());
        if (this.pci.isBitsOutStateProvisionable()) {
            this.stateBitsOutCB.setSelectedIndex(this.getAdminStateIndex(sBitsConfig2.adminStateBitsOut));
        }
        this.codingBitsOutCB.setSelectedIndex(this.getCodingIndex(sBitsConfig2.codingBitsOut));
        this.framingBitsOutCB.setSelectedIndex(this.getFramingIndex(sBitsConfig2.framingBitsOut));
        if (this.pci.isAISThresholdProvisionable()) {
            this.qualityCB.setSelectedItem(this.getQualityAttribute(sBitsConfig2.aisThreshold.value()));
        }
        this.sabitBitsOutCB.setSelectedIndex(sBitsConfig2.saBit.value());
        this.enableBitsInComponents();
        this.enableBitsOutComponents();
        if (db.on()) {
            db.println("leave ASBPP refreshFromModel");
        }
    }

    public void enableBitsInComponents() {
        super.enableBitsInComponents();
        if (this.parent.isBits2M(0)) {
            this.sabitBitsInCB.setEnabled(false);
        } else if (this.isSyncMsgFraming(0)) {
            this.enableComponent(this.sabitBitsInCB);
        } else {
            this.sabitBitsInCB.setEnabled(false);
        }
    }

    public void enableBitsOutComponents() {
        super.enableBitsOutComponents();
        this.sabitBitsOutCB.setEnabled(false);
    }

    protected boolean isSyncMsgFraming(int n) {
        if (n == 0) {
            return this.framingBitsInCB.getSelectedIndex() >= 3;
        }
        return this.framingBitsOutCB.getSelectedIndex() >= 3;
    }
}

