/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455.ui.stm1e;

import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.SoakTimeCellEditor;
import com.cisco.ctc455.ui.stm1e.STM1ELineTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.EventObject;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class STM1ELineProvPane
extends NodeProvPane
implements TableModelListener {
    protected STM1ELineTableModel dataModel = null;
    protected TdmModuleModel eqpmtModel = null;
    protected TdmLineModel[] lineModels = null;
    protected int numLines = 0;
    protected INodeModel node = null;
    private static final SDebug db = new SDebug("STM1ELineProvPane");
    static /* synthetic */ Class class$cerent$cms$idl$Common$eAdminState;

    public STM1ELineProvPane(String string, TabbedView tabbedView, TdmLineModel[] tdmLineModelArray) {
        super(string, tabbedView);
        this.node = tabbedView.getUiModel().getNodeModel();
        JScrollPane jScrollPane = null;
        this.lineModels = tdmLineModelArray;
        this.numLines = tdmLineModelArray.length;
        this.dataModel = this.getDataModel();
        this.dataModel.addTableModelListener(this);
        this.table = new JTable(this.dataModel);
        jScrollPane = new JScrollPane(this.table);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(false);
        TableColumn tableColumn = this.table.getColumn(STM1ELineTableModel.columnNames[5]);
        tableColumn.setCellEditor(new PJMonitorCellEditor());
        tableColumn.setCellRenderer(new SonetMonitorCellRenderer());
        this.prepareColumns();
        this.registerWithModel();
        this.add(jScrollPane, "Center");
    }

    public boolean hasSubTabs() {
        return false;
    }

    public void applyChangesToModel() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.dataModel.adminStateChangedToFormOfOOS() && this.pci.isPortOOSserviceAfecting()) {
            stringBuffer.append(AdminState.getBaseOosWarning(this.terms)).append('\n');
        }
        if (this.dataModel.needRemoveLoopback()) {
            stringBuffer.append("Some lines will be removed from loopback since their new state does not allow loopback.").append('\n');
        }
        if (stringBuffer.length() != 0) {
            stringBuffer.append("Service may be affected.\n\nApply changes?");
            if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Confirmation Dialog")) {
                return;
            }
        }
        this.dataModel.applyChanges();
        this.resetDirty();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    protected STM1ELineTableModel getDataModel() {
        return new STM1ELineTableModel(this.node, this.lineModels);
    }

    protected void registerWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
    }

    protected void setAttrCellEditor(int n, String string) {
        TableColumn tableColumn = this.table.getColumn(STM1ELineTableModel.columnNames[n]);
        try {
            Attribute[] attributeArray = this.getAttributeArray(string);
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
            tableColumn.setPreferredWidth(tableColumn.getWidth());
        }
        catch (NoSuchElementException noSuchElementException) {
            if (db.on()) {
                db.println("Warning: cannot find attributes for " + string);
            }
            this.table.removeColumn(tableColumn);
        }
    }

    public Attribute[] getAttributeArray(String string) throws NoSuchElementException {
        Attribute[] attributeArray = ElementDefaults.getAttributeMap((IModel)this.node).getAttributeArray(string);
        if (attributeArray == null) {
            throw new NoSuchElementException();
        }
        return attributeArray;
    }

    private JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                STM1ELineProvPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In refreshLine changeMessage cannot find Model " + observable);
        }
    }

    protected void prepareColumns() {
        TableColumn tableColumn = null;
        Object var2_2 = null;
        tableColumn = this.table.getColumn(STM1ELineTableModel.columnNames[0]);
        tableColumn.setPreferredWidth(5);
        this.setAttrCellEditor(2, "declareSfBerLevel");
        this.setAttrCellEditor(3, "declareSdBerLevel");
        this.setAttrCellEditor(4, "SONET." + (class$cerent$cms$idl$Common$eAdminState == null ? (class$cerent$cms$idl$Common$eAdminState = STM1ELineProvPane.class$("cerent.cms.idl.Common.eAdminState")) : class$cerent$cms$idl$Common$eAdminState).getName());
        SoakTimeCellEditor soakTimeCellEditor = new SoakTimeCellEditor();
        tableColumn = this.table.getColumn(STM1ELineTableModel.columnNames[6]);
        tableColumn.setCellEditor(soakTimeCellEditor);
        tableColumn.setMinWidth(soakTimeCellEditor.getPreferredWidth() + 10);
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.STM1E12LineProvPane;
    }

    private int getNumHo(int n) {
        int n2 = 0;
        try {
            n2 = this.lineModels[n].numHo();
        }
        catch (Exception exception) {
            db.println("Caught exception in getPJMonitorCombo");
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_NBR_HOS_FOR_LINE);
        }
        if (db.on()) {
            db.println("Num Ho = " + n2);
        }
        return n2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PJMonitorListCellRenderer
    extends DefaultListCellRenderer {
        PJMonitorListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2 = object;
            if (object instanceof Integer && (Integer)object == 0) {
                object2 = "Off";
            }
            return super.getListCellRendererComponent((JList<?>)jList, object2, n, bl, bl2);
        }
    }

    class SonetMonitorCellRenderer
    extends DefaultTableCellRenderer {
        SonetMonitorCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2 = object;
            if (object instanceof Integer && (Integer)object == 0) {
                object2 = "Off";
            }
            return super.getTableCellRendererComponent(jTable, object2, bl, bl2, n, n2);
        }
    }

    class PJMonitorCellEditor
    extends DefaultCellEditor {
        public PJMonitorCellEditor() {
            super(new JComboBox());
            this.delegate = new DefaultCellEditor.EditorDelegate(this, STM1ELineProvPane.this){
                private final /* synthetic */ STM1ELineProvPane val$this$0;
                private final /* synthetic */ PJMonitorCellEditor this$1;
                {
                    this.this$1 = pJMonitorCellEditor;
                    this.val$this$0 = sTM1ELineProvPane;
                }

                public void setValue(Object object) {
                    ((JComboBox)PJMonitorCellEditor.access$000(this.this$1)).setSelectedItem(object);
                }

                public Object getCellEditorValue() {
                    return ((JComboBox)PJMonitorCellEditor.access$100(this.this$1)).getSelectedItem();
                }

                public boolean shouldSelectCell(EventObject eventObject) {
                    if (eventObject instanceof MouseEvent) {
                        MouseEvent mouseEvent = (MouseEvent)eventObject;
                        return mouseEvent.getID() != 506;
                    }
                    return true;
                }

                public boolean stopCellEditing() {
                    if (((JComboBox)PJMonitorCellEditor.access$200(this.this$1)).isEditable()) {
                        ((JComboBox)PJMonitorCellEditor.access$300(this.this$1)).actionPerformed(new ActionEvent(this.this$1, 0, ""));
                    }
                    return super.stopCellEditing();
                }
            };
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.editorComponent = this.getEditorComponent(n);
            this.delegate.setValue(object);
            return this.editorComponent;
        }

        public JComboBox getEditorComponent(int n) {
            JComboBox<Object> jComboBox = new JComboBox<Object>();
            int n2 = STM1ELineProvPane.this.getNumHo(n);
            for (int i = 0; i <= n2; ++i) {
                jComboBox.addItem(new Integer(i));
            }
            jComboBox.setRenderer(new PJMonitorListCellRenderer());
            jComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
            jComboBox.addActionListener(this.delegate);
            return jComboBox;
        }

        static /* synthetic */ JComponent access$000(PJMonitorCellEditor pJMonitorCellEditor) {
            return pJMonitorCellEditor.editorComponent;
        }

        static /* synthetic */ JComponent access$100(PJMonitorCellEditor pJMonitorCellEditor) {
            return pJMonitorCellEditor.editorComponent;
        }

        static /* synthetic */ JComponent access$200(PJMonitorCellEditor pJMonitorCellEditor) {
            return pJMonitorCellEditor.editorComponent;
        }

        static /* synthetic */ JComponent access$300(PJMonitorCellEditor pJMonitorCellEditor) {
            return pJMonitorCellEditor.editorComponent;
        }
    }
}

