/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455.ui.stm1e;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.util.AbstractHoNum;
import cerent.util.SDebug;
import cerent.util.gui.SoakTimePropertyEditor;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class STM1ELineTableModel
extends AbstractTableModel {
    protected TdmLineModel[] lineModel = null;
    protected INodeModel node = null;
    private int numLines = 0;
    private boolean dirty = false;
    public static final String[] columnNames = new String[]{"Port", "Port Name", "SF BER", "SD BER", "Status", "PJVC4Mon#", "AINS Soak"};
    public static final String[] statusStrings = new String[]{"In Service", "Out of Service"};
    public static final int LINENUMBER_INDEX = 0;
    public static final int PORTNAME_INDEX = 1;
    public static final int SFBER_INDEX = 2;
    public static final int SDBER_INDEX = 3;
    public static final int STATUS_INDEX = 4;
    public static final int STSMONITOR_INDEX = 5;
    public static final int AINS_INDEX = 6;
    public static final int OUT_OF_SERVICE = 1;
    public static final int IN_SERVICE = 0;
    private Attribute[] sfBerLevel;
    private Attribute[] sdBerLevel;
    private Attribute[] status;
    private String sdString;
    private String sfString;
    private boolean[][] isDirty;
    private String[] portName;
    private Integer[] stsMonitor;
    private int[] soakTime;
    private static final SDebug db = new SDebug("STM1E12LineTableModel");
    static /* synthetic */ Class class$java$lang$Object;

    public STM1ELineTableModel(INodeModel iNodeModel, TdmLineModel[] tdmLineModelArray) {
        this.lineModel = tdmLineModelArray;
        this.node = iNodeModel;
        this.numLines = tdmLineModelArray.length;
        this.sfBerLevel = new Attribute[this.numLines];
        this.sdBerLevel = new Attribute[this.numLines];
        this.status = new Attribute[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.portName = new String[this.numLines];
        this.stsMonitor = new Integer[this.numLines];
        this.soakTime = new int[this.numLines];
        this.sdString = "declareSdBerLevel";
        this.sfString = "declareSfBerLevel";
        this.resetDirtyBits();
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return new Integer(n + 1);
                }
                case 1: {
                    return this.getPortNameIndex(n);
                }
                case 2: {
                    return this.getSfBerLevelIndex(n);
                }
                case 3: {
                    return this.getSdBerLevelIndex(n);
                }
                case 4: {
                    return this.getAdminState(n);
                }
                case 5: {
                    return this.getStsMonitor(n);
                }
                case 6: {
                    return this.getSoakTimeFromModel(n);
                }
            }
            return null;
        }
        catch (Exception exception) {
            System.err.println("STM1ELineTableModel: error in getValueAt" + exception);
            return null;
        }
    }

    private Attribute getSfBerLevelIndex(int n) throws AbstractCmsIOException {
        try {
            if (this.sfBerLevel[n] == null) {
                this.sfBerLevel[n] = ElementDefaults.getAttributeMap((IModel)this.node).getAttributeForVal(this.sfString, (int)this.lineModel[n].getSfBerLevel());
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            db.println("Error in getSfBerLevelIndex " + (Object)((Object)noSuchInterface));
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            db.println("Error in getSfBerLevelIndex " + (Object)((Object)wrongInterfaceType));
        }
        return this.sfBerLevel[n];
    }

    private Attribute getSdBerLevelIndex(int n) throws AbstractCmsIOException {
        try {
            if (this.sdBerLevel[n] == null) {
                this.sdBerLevel[n] = ElementDefaults.getAttributeMap((IModel)this.node).getAttributeForVal(this.sdString, (int)this.lineModel[n].getSdBerLevel());
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            db.println("Error in getSdBerLevelIndex " + (Object)((Object)noSuchInterface));
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            db.println("Error in getSdBerLevelIndex " + (Object)((Object)wrongInterfaceType));
        }
        return this.sdBerLevel[n];
    }

    private Attribute getAdminState(int n) throws NoSuchInterface {
        if (this.status[n] == null) {
            eAdminState eAdminState2 = this.lineModel[n].getAdminStateEnum();
            this.status[n] = this.getAttributeFor("SONET." + eAdminState2.getClass().getName(), eAdminState2.value());
        }
        return this.status[n];
    }

    private Integer getStsMonitor(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.stsMonitor[n] == null) {
            short s = this.lineModel[n].getPointerMonitorStsNumber();
            this.stsMonitor[n] = new Integer(AbstractHoNum.StsNum2Vc4((int)s));
        }
        return this.stsMonitor[n];
    }

    private String getSoakTimeFromModel(int n) throws NoSuchInterface {
        if (this.soakTime[n] == -1) {
            this.soakTime[n] = this.lineModel[n].getSoakTime();
        }
        return SoakTimePropertyEditor.toStringHHMM(this.soakTime[n]);
    }

    private Attribute getAttributeFor(String string, int n) {
        return ElementDefaults.getAttributeMap((IModel)this.node).getAttributeForVal(string, n);
    }

    private String getPortNameIndex(int n) throws AbstractCmsIOException {
        try {
            if (this.portName[n] == null) {
                this.portName[n] = this.lineModel[n].getAlias();
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            db.println("Error in getPortNameIndex " + (Object)((Object)noSuchInterface));
        }
        return this.portName[n];
    }

    private int getSoakTime(int n) {
        return this.soakTime[n];
    }

    public Class getColumnClass(int n) {
        switch (n) {
            default: 
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = STM1ELineTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.lineModel != null && this.numLines > 0) {
            boolean bl = AbstractPane.isUserAuthorized(this.lineModel[0], SecurityLevel.PROVISIONING);
            try {
                if (bl && !this.lineModel[0].getModuleModel().isProtectModule()) {
                    return n2 > 0;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.println("Caught exception in isCellEditable");
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                return false;
            }
        }
        return false;
    }

    public void setValueAt(Object object, int n, int n2) {
        try {
            switch (n2) {
                case 1: {
                    this.portName[n] = (String)object;
                    break;
                }
                case 2: {
                    this.sfBerLevel[n] = (Attribute)object;
                    break;
                }
                case 3: {
                    this.sdBerLevel[n] = (Attribute)object;
                    break;
                }
                case 4: {
                    this.status[n] = (Attribute)object;
                    break;
                }
                case 5: {
                    this.stsMonitor[n] = (Integer)object;
                    break;
                }
                case 6: {
                    int n3 = this.soakTime[n];
                    try {
                        n3 = SoakTimePropertyEditor.toIntValue((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        db.fine("Number Format Exception on " + (String)object);
                    }
                    if (this.soakTime[n] == n3) {
                        return;
                    }
                    this.soakTime[n] = n3;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (ClassCastException classCastException) {
            return;
        }
        this.dirty = true;
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    public String[] getStatusStrings() {
        return statusStrings;
    }

    private int getIndexOf(Object object, Object[] objectArray) {
        List<Object> list = Arrays.asList(objectArray);
        return list.indexOf(object);
    }

    public void applyChanges() throws Exception {
        try {
            for (int i = 0; i < this.numLines; ++i) {
                if (this.isDirty(i, 2)) {
                    this.lineModel[i].setSfBerLevel((short)this.getSfBerLevel(i));
                }
                if (this.isDirty(i, 3)) {
                    this.lineModel[i].setSdBerLevel((short)this.getSdBerLevel(i));
                }
                if (this.isDirty(i, 1)) {
                    this.lineModel[i].setAlias(this.getPortName(i));
                }
                if (this.isDirty(i, 4)) {
                    if (db.on()) {
                        db.fine("setting line to admin state " + TdmLineModel.getTDMTerminology(this.lineModel[i]).getTermForAdminState(this.getAdminStateFor(i).value()));
                    }
                    this.lineModel[i].setAdminStateNoLpbk(this.getAdminStateFor(i));
                }
                if (this.isDirty(i, 5)) {
                    if (db.on()) {
                        db.println("Setting STS Monitor ");
                    }
                    short s = (short)AbstractHoNum.Vc4Num2Sts((int)this.getStsMonitor(i));
                    this.lineModel[i].setLinePointerMonitorStsNumber(s);
                }
                if (!this.isDirty(i, 6)) continue;
                if (db.on()) {
                    db.println("setting line soakTime " + this.getSoakTime(i));
                }
                this.lineModel[i].setSoakTime(this.getSoakTime(i));
            }
            this.dirty = false;
            this.resetDirtyBits();
        }
        catch (Exception exception) {
            db.println("Error in applyChanges " + exception);
        }
    }

    protected eAdminState getAdminStateFor(int n) {
        return eAdminState.from_int(this.status[n].getIntValue());
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private int getSfBerLevel(int n) throws AbstractCmsIOException {
        return this.sfBerLevel[n].getIntValue();
    }

    private int getSdBerLevel(int n) throws AbstractCmsIOException {
        return this.sdBerLevel[n].getIntValue();
    }

    private String getPortName(int n) throws AbstractCmsIOException {
        return this.portName[n];
    }

    protected boolean needRemoveLoopback() throws NoSuchInterface {
        for (int i = 0; i < this.numLines; ++i) {
            int n = 0;
            try {
                n = this.lineModel[i].getLoopbackAsInt();
            }
            catch (Exception exception) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                throw new NoSuchInterface(exception.getMessage());
            }
            if (!this.isDirty[i][4] || n == 0 || AdminState.admitsLoopback(this.getAdminStateFor(i))) continue;
            return true;
        }
        return false;
    }

    boolean adminStateChangedToFormOfOOS() throws NoSuchInterface {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isDirty[i][4] || !AdminState.isFormOfOOS(this.getAdminStateFor(i)) || AdminState.isFormOfOOS(this.lineModel[i].getAdminStateEnum())) continue;
            return true;
        }
        return false;
    }

    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetLineCache(n);
        this.fireTableRowsUpdated(n, n);
    }

    protected void resetLineCache(int n) {
        this.sfBerLevel[n] = null;
        this.sdBerLevel[n] = null;
        this.status[n] = null;
        this.stsMonitor[n] = null;
        this.soakTime[n] = -1;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    private void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

