/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.asap;

import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.EntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.PimModel;
import cerent.cms.model.PluggableModel;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.model.event.StoreObservable;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.ppm.PpmCardView;
import cerent.cms.ui.ppm.PpmSlotView;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import com.cisco.ctc600.ui.shelf.CardBehavior600;
import com.cisco.ctc600.ui.shelf.CardView600;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Observable;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PimCardView
extends CardView600
implements ActionListener {
    protected CardBehavior600 cardBehavior;
    private PpmSlotView[] ppmSlotViews = null;
    protected String alarmProfileString = "";
    protected String statusString = "";
    protected static final SDebug db = new SDebug("PimCardView");
    static /* synthetic */ Class class$cerent$cms$idl$Equipment$eEqType;

    public PimCardView(EntityModel entityModel) {
        super(entityModel);
        this.cardBehavior = (CardBehavior600)this.pci.getCardBehavior(entityModel.getNodeModelDelegate(), db);
        this.setLayout(new GridBagLayout());
        this.addChildren();
        this.updateStatus();
        this.update(this.cardAlarmStore.getAlarmStatusObservable(), this.getAlarmStatus());
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getModifiers() == 4) {
                    PimCardView.this.showPopupMenu(mouseEvent.getPoint());
                }
            }
        });
    }

    protected void addPorts(boolean bl) {
    }

    protected void addChildren() {
        block4: {
            try {
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.ipadx = 2;
                gridBagConstraints.ipady = 0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                List list = this.model.getChildren();
                this.ppmSlotViews = new PpmSlotView[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    EntityModel entityModel = (EntityModel)list.get(i);
                    if (entityModel == null) continue;
                    PluggableSlotModel pluggableSlotModel = null;
                    if (entityModel instanceof PluggableSlotModel) {
                        pluggableSlotModel = (PluggableSlotModel)entityModel;
                        this.ppmSlotViews[i] = new PpmSlotView(pluggableSlotModel);
                        gridBagConstraints.gridy = i + 1;
                        this.add((Component)this.ppmSlotViews[i], gridBagConstraints);
                        continue;
                    }
                    if (!db.on()) continue;
                    db.println("Entity is NOT PluggableSlotModel");
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("PimCardView:createChildren:Exception");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.repaint();
    }

    protected void updateStatus() {
        block4: {
            if (this.model != null) {
                try {
                    this.alarmProfileString = this.model.getAlarmProfileName();
                    int n = -1;
                    if (this.model instanceof PimModel) {
                        n = ((PimModel)this.model).getServiceSt().getType();
                    }
                    this.statusString = PimModel.getTDMTerminology(this.model).getTermForServiceState(n);
                }
                catch (Exception exception) {
                    if (!db.on()) break block4;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        this.setToolTipText();
    }

    public void update(Observable observable, Object object) {
        Object[] objectArray;
        if (observable instanceof StoreObservable && object instanceof Object[] && (objectArray = (Object[])object)[0] == ModelUpdateType.DELETED) {
            return;
        }
        if (object == ModelUpdateType.DELETED) {
            return;
        }
        super.update(observable, this.getAlarmStatus());
        if (db.on()) {
            db.println("PIMCard:update PIM with " + this.getAlarmStatus());
        }
    }

    public void setToolTipText() {
        if (this.model == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.model.getEqLabel());
        stringBuffer.append(" [");
        stringBuffer.append(((PluggableModel)this.model).getLocation());
        stringBuffer.append("]: ");
        stringBuffer.append(this.statusString);
        stringBuffer.append(", Alarm Profile: ");
        stringBuffer.append(this.alarmProfileString);
        super.setToolTipText(stringBuffer.toString());
    }

    public IAlarmStatus getAlarmStatus() {
        IAlarmStatus iAlarmStatus = this.cardAlarmStore.getEntityAlarmStatus(this.model);
        if (iAlarmStatus == null) {
            iAlarmStatus = new AlarmStatus();
        }
        if (this.ppmSlotViews == null) {
            return iAlarmStatus;
        }
        int n = iAlarmStatus.getHighestSeverity();
        for (int i = 0; i < this.ppmSlotViews.length; ++i) {
            int n2;
            PpmCardView ppmCardView;
            List list;
            if (this.ppmSlotViews[i] == null || (list = this.ppmSlotViews[i].getChildren()).size() <= 0 || (ppmCardView = (PpmCardView)list.get(0)) == null || ppmCardView.getAlarmStatus() == null || (n2 = ppmCardView.getAlarmStatus().getHighestSeverity()) <= n) continue;
            iAlarmStatus = ppmCardView.getAlarmStatus();
        }
        return iAlarmStatus;
    }

    public void paintIcon(Graphics graphics) {
    }

    private void showPopupMenu(Point point) {
        boolean bl = AbstractPane.isUserAuthorized(this.model, SecurityLevel.PROVISIONING);
        if (this.getState() == eEqState.DELETED) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(new NonSelectableMI("Add Card"));
            jPopupMenu.addSeparator();
            PluggableSlotModel pluggableSlotModel = (PluggableSlotModel)this.model.getParent();
            eEqType[] eEqTypeArray = pluggableSlotModel.getPluggableTypeList();
            for (int i = 0; i < eEqTypeArray.length; ++i) {
                String string = EnumStrings.getString((Class)(class$cerent$cms$idl$Equipment$eEqType == null ? PimCardView.class$("cerent.cms.idl.Equipment.eEqType") : class$cerent$cms$idl$Equipment$eEqType), (int)eEqTypeArray[i].value());
                jPopupMenu.add(this.createMenuItem(string, bl));
            }
            jPopupMenu.show(this, point.x, point.y);
        } else {
            JPopupMenu jPopupMenu = new JPopupMenu();
            INodeModel iNodeModel = this.model.getNodeModel();
            TDMTerminology tDMTerminology = iNodeModel.getTDMTerminology();
            String string = EntityModel.eqType2Name(tDMTerminology, this.model.getEqType());
            jPopupMenu.add(new NonSelectableMI(string + " Card"));
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.createMenuItem("Delete Card", bl));
            JMenuItem jMenuItem = jPopupMenu.add(this.createMenuItem("Hard-reset Card", AbstractPane.isUserAuthorized(this.model, SecurityLevel.MAINTENANCE) && ((PluggableModel)this.model).isHardResettable()));
            jPopupMenu.show(this, point.x, point.y);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            String string = actionEvent.getActionCommand();
            if (this.getState() == eEqState.DELETED) {
                String string2 = string;
                this.cardBehavior.addCard(this, (PluggableSlotModel)this.model.getParent(), string2);
            } else if (string.equals("Delete Card")) {
                this.cardBehavior.deleteCard(this, (PimModel)this.model);
            } else if (string.equals("Hard-reset Card")) {
                this.cardBehavior.hardResetPim(this, (PimModel)this.model);
            }
        }
    }

    protected JMenuItem createMenuItem(String string, boolean bl) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setEnabled(bl);
        if (bl) {
            jMenuItem.addActionListener(this);
        }
        return jMenuItem;
    }

    public Dimension getPreferredSize() {
        return new Dimension(78, 176);
    }

    public void dispose() {
        if (this.ppmSlotViews != null) {
            for (int i = 0; i < this.ppmSlotViews.length; ++i) {
                if (this.ppmSlotViews[i] == null) continue;
                this.ppmSlotViews[i].dispose();
                this.ppmSlotViews[i] = null;
            }
        }
        this.ppmSlotViews = null;
        super.dispose();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class NonSelectableMI
    extends JMenuItem {
        public NonSelectableMI(String string) {
            super(string);
        }

        public void menuSelectionChanged(boolean bl) {
        }
    }
}

